@extends('backend.layouts.app')
@section('title', "My Leaves")

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-5 col-5">
                <h4 class="card-title mb-0">
                    My Leaves
                </h4>
            </div>
            <div class="col-sm-7 col-7">
                <div class="btn-toolbar float-right" role="toolbar" aria-label="" style="margin-top: 20px;float: right;">
                    <a href="{{ route('admin.my-leaves.apply') }}" class="btn btn-success ml-1"><i class="fas fa-plus-circle"></i> Apply For Leave</a>
                </div>
            </div>
            <!--col-->
        </div>
        <!--row-->
        <!--row-->
        <div class="row mt-3">
            <div class="col">
                <h4>YEAR: {{$year}} &nbsp;&nbsp;Total Leaves: <strong>{{$total_leaves}}</strong></h4>
                <br />
                <table class="table">
                    <thead>
                        <tr>
                            <th>Leave Date</th>
                            <th>Leave Type</th>
                            <th>No. of Days</th>
                            <th>Status</th>
                            <th>Reason</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($my_leaves as $leave)
                        <tr>
                            <td>{{date("d-M-Y",strtotime($leave->leave_date))}}</td>
                            <td>{{$leave->type}}</td>
                            <td>{{$leave->days}} @if($leave->when != 'full_day') {{ucfirst(str_replace("_", " ", $leave->when))}} @endif</td>
                            <td>{!!$leave->approved ? "<span class='badge badge-success'>Approved</span>" : "<span class='badge badge-danger'>Pending Approval</span>" !!}</td>
                            <td>{{$leave->reason}}</td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection