@extends('backend.layouts.app')
@section('title', 'Settings - Tax')

@section('content')
<div class="row">
    <div class="col" style="margin-bottom:10px;">
        <h4 style="">Settings</h4>
    </div>
</div>

<div class="card">
    <div class="card-body pt-3">
        <div class="row">
            <div class="col-2">
                <ul class="nav flex-column nav-tabs nav-tabs-bordered">
                    {!!get_settings_tabs('tax_rates-settings')!!}
                </ul>
            </div>

            <div class="col-10">
                <div class="tab-content pt-4">
                    <div class="tab-pane fade active show" id="">
                        <div class="row">
                            <div class="col-md-12">
                                <h4>Taxes</h4>
                            </div>
                            <div class="col-12 my-3">
                                <div>
                                    <h4><b>Tax Status</b></h4>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" name="enabled_taxes" value="1" id="enabled_taxes" @if(get_site_config('enabled_taxes') == 1) checked @endif>
                                        <label for="enabled_taxes" class="form-check-label">Enable Taxes</label>
                                    </div>

                                    <h4 class="mt-4"><b>Tax Type</b></h4>
                                    <div class="form-check">
                                        <input type="radio" class="form-check-input" name="exclusive" value="1" id="exclusive" @if(get_site_config('tax_exclusive') == 1) checked @endif>
                                        <label for="exclusive" class="form-check-label">Exclusive (<span>Tax Rate is Added On The Product Price</span>)</label>
                                    </div>
                                    <div class="form-check mt-2">
                                        <input class="form-check-input" type="radio" name="inclusive" value="1" id="inclusive" @if(get_site_config('tax_inclusive') == 1) checked @endif>
                                        <label for="inclusive" class="form-check-label">Inclusive (<span>Product Price Already Include The Tax</span>)</label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row mt-3">
                            <div class="col-sm-9">
                                <h4>Tax Rules</h4>
                            </div>
                            <div class="col-sm-3">
                                <div class="btn-toolbar float-right" role="toolbar" aria-label="New Visa Service Type" style="float: right;">
                                    <button class="btn btn-primary btn-sm ml-1" data-bs-toggle="modal" data-bs-target="#create_modal" title="Add New Visa Service Type"><i class="bi bi-plus-circle"></i> New Rule</button>
                                </div>
                            </div>
                            <div class="col">
                                <div class="table-responsive">
                                    <table class="table eductrl-datatable">
                                        <thead>
                                            <tr>
                                                <th>Tax</th>
                                                <th>Display Name</th>
                                                <th>Tax Rate</th>
                                                <th>Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($tax_rates as $tax_rate)
                                            <tr>
                                                <td>{{ $tax_rate->name}}</td>
                                                <td>{{ $tax_rate->display_name}}</td>
                                                <td>{{ $tax_rate->tax_rate}} %</td>
                                                <td style="min-width: 90px">
                                                    <a href="javascript:void(0);" class="btn blue-action btn-sm edit_row" data-bs-toggle="modal" data-bs-target="#edit_modal" data-id="{{$tax_rate->id}}" data-name="{{$tax_rate->name}}" data-display_name="{{$tax_rate->display_name}}" data-country="{{$tax_rate->country}}" data-state="{{$tax_rate->state}}" data-tax_rate="{{$tax_rate->tax_rate}}" data-action_url="{{route('admin.settings.tax_rates.edit', $tax_rate->id)}}"><i class="fas fa-edit"></i></a>
                                                    <a href="{{route('admin.settings.tax_rates.delete', $tax_rate->id)}}" data-method="delete" data-trans-button-cancel="Cancel" data-trans-button-confirm="Delete" data-trans-title="Are you sure want to delete this Tax?" class="btn btn-danger btn-sm" class="btn btn-primary"><i class="fa fa-trash"></i></a>
                                                </td>
                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

{{-- Create Tax --}}
<div class="modal fade" tabindex="-1" id="create_modal" role="dialog">
    <div class="modal-dialog" role="document">
        <form action="{{route('admin.settings.tax.rates.save')}}" method="post" enctype="multipart/form-data">
            @csrf
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">New Tax Rule</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="row mt-4">
                    <div class="col-sm-11 col-md-11 m-auto">
                        <div class="form-group">
                            <label class="required-field"><b>Name</b></label>
                            <input type="text" class="form-control" name="name" placeholder="Name" maxlength="100" required>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-11 col-md-11 m-auto">
                        <div class="form-group">
                            <label class="required-field"><b>Display Name</b></label>
                            <input type="text" name="display_name" class="form-control" value="" placeholder="Display Name" maxlength="50" required id="">
                            <p style="margin-top: -11px !important; font-size: 12px !important;">This is displayed to Clients & in Invoices</p>
                        </div>
                    </div>
                </div>
                <div class="row" style="margin-top: -10px !important;">
                    <div class="col-sm-12 col-md-11 m-auto">
                        <div class="form-group">
                            <label class="col-form-label"><b>Country</b></label>
                            <select class="form-select" id="country" name="country">
                                <option value="0">All Countries</option>
                                @foreach ($country_list as $key => $value)
                                <option value="{{ $key }}" @if(Request::old('country') == $key) selected @endif>{{ $value }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-sm-12 col-md-11 m-auto">
                        <div class="form-group">
                            <label class="col-form-label"><b>State</b></label>
                            <div class="form-group">
                                <select class="form-control form-select" name="state" id="state-dd">
                                    <option value="0">All States</option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-11 col-md-11 m-auto">
                        <div class="form-group">
                            <label class="required-field"><b>Tax Rate (%)</b></label>
                            <input type="number" min="0.01" max="100" step="0.01" name="tax_rates" class="form-control" value="" placeholder="Tax Rate (%)" required id="tax_rates">
                        </div>
                    </div>
                </div>
                <div class="text-center">
                    <button type="submit" class="btn btn-primary btn-sm">Save</button>
                </div>
            </div>
        </form>
    </div>
</div>

{{-- Edit Tax --}}
<div class="modal fade" tabindex="-1" id="edit_modal" role="dialog">
    <div class="modal-dialog" role="document">
        <form method="post" action="" id="edit_tax_rates_form">
            @method('PATCH')
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                @csrf
                <input type="hidden" name="tax_id" value="" id="edit_tax_id">
                <div class="row mt-4">
                    <div class="col-sm-11 col-md-11 m-auto">
                        <div class="form-group mb-3">
                            <label class="required-field"><b>Name</b></label>
                            <input type="text" id="edit_name" class="form-control" name="name" maxlength="200" required>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-11 col-md-11 m-auto">
                        <div class="form-group">
                            <label class="required-field"><b>Display Name</b></label>
                            <input type="text" name="display_name" class="form-control" value="" placeholder="Display Name" maxlength="50" required id="edit_display_name">
                            <p style="margin-top: -11px !important; font-size: 12px !important;">This is displayed to Clients & in Invoices</p>
                        </div>
                    </div>
                </div>
                <div class="row" style="margin-top: -10px !important;">
                    <div class="col-sm-12 col-md-11 m-auto">
                        <div class="form-group">
                            <label class="col-form-label"><b>Country</b></label>
                            <select class="form-select" id="edit_country" name="country">
                                <option value="0">All Countries</option>
                                @foreach ($country_list as $key => $value)
                                <option value="{{ $key }}" @if(Request::old('country') == $key) selected @endif>{{ $value }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-sm-12 col-md-11 m-auto">
                        <div class="form-group">
                            <label class="col-form-label"><b>State</b></label>
                            <div class="form-group">
                                <select class="form-control form-select" name="state" id="edit_state_dd">
                                    <option value="0">All States</option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-11 col-md-11 m-auto">
                        <div class="form-group">
                            <label class="required-field"><b>Tax Rate (%)</b></label>
                            <input type="number" min="0.01" max="100" step="0.01" name="tax_rates" id="edit_tax_rates" class="form-control" value="" placeholder="Tax Rate (%)" required id="tax_rates">
                        </div>
                    </div>
                </div>
                <div class="text-center">
                    <button type="submit" class="btn btn-primary btn-sm">Save</button>
                </div>
            </div>
        </form>
    </div>
</div>
@endsection

@push('after-scripts')
<script>
    $(document).ready(function() {
        var edit_country = "";
        var edit_state_dd = "";

        $('#country').on('change', function () {
            var idCountry = this.value;
            $("#state-dd").html('');
            $.ajax({
                url: "{{url('api/fetch-states')}}",
                type: "POST",
                data: {
                    country_id: idCountry,
                    _token: '{{csrf_token()}}'
                },
                dataType: 'json',
                success: function (result) {
                    $('#state-dd').html('<option value="0">All State</option>');
                    $.each(result.states, function (key, value) {
                        $("#state-dd").append('<option value="'+ value.id + '">' + value.name + '</option>');
                    });
                }
            });   
        });

        $('.edit_row').click(function() {
            $('#edit_tax_id').val($(this).data('id'));
            $('#edit_name').val($(this).data('name'));
            $('#edit_display_name').val($(this).data('display_name'));
            $('#edit_tax_rates').val($(this).data('tax_rate'));
            $('#edit_tax_rates_form').attr('action', $(this).data('action_url'));
            
            $('#edit_country').val($(this).data('country'));
            edit_country = $(this).data('country');
            edit_state_dd = $(this).data('state');
            $('#edit_country').trigger('change');
        });

        $('#edit_country').on('change', function () {
            var idCountry = edit_country;
            $("#edit_state_dd").html('');
            $.ajax({
                url: "{{url('api/fetch-states')}}",
                type: "POST",
                data: {
                    country_id: idCountry,
                    _token: '{{csrf_token()}}'
                },
                dataType: 'json',
                success: function (result) {
                    $('#edit_state_dd').html('<option value="0">All State</option>');
                    $.each(result.states, function (key, value) {
                        if(value.id == edit_state_dd){
                            var selectedState = "selected='selected'";
                        }else{
                            var selectedState = "";
                        }
                        $("#edit_state_dd").append('<option '+selectedState+' value="'+ value.id + '">' + value.name + '</option>');
                    });
                }
            });   
        });

        $('#enabled_taxes').change(function(){
            if($('#enabled_taxes').prop('checked')){
                enabled_taxes = 1;
            } else{
                enabled_taxes = 0;
            }

            $.ajax({
                url: "{{route('admin.settings.save.tax-info')}}",
                type: "POST",
                data: {
                    enabled_taxes: enabled_taxes,
                    _token: '{{csrf_token()}}'
                },
                context: this,
                success: function (result) {
                    if(result.success){
                        swal.fire({
                            title: result.message,
                            icon: "success",
                            button: "ok",
                        });
                        setTimeout(function(){
                            window.location.replace('{{ route("admin.settings.tax-index") }}');
                        }, 2000);
                    }
                }
            }); 
        });

        $('#exclusive').change(function(){
            if($('#exclusive').prop('checked')){
                $('#inclusive').prop('checked', false);
                exclusive = 1;
                inclusive = 0;
            } else{
                exclusive = 0;
            }

            $.ajax({
                url: "{{route('admin.settings.save.tax-info')}}",
                type: "POST",
                data: {
                    exclusive: exclusive,
                    inclusive: inclusive,
                    _token: '{{csrf_token()}}'
                },
                context: this,
                success: function (result) {
                    if(result.success){
                        swal.fire({
                            title: result.message,
                            icon: "success",
                            button: "ok",
                        });
                        setTimeout(function(){
                            window.location.replace('{{ route("admin.settings.tax-index") }}');
                        }, 1000);
                    }
                }
            }); 
        });

        $('#inclusive').change(function(){
            if($('#inclusive').prop('checked')){
                $('#exclusive').prop('checked', false);
                inclusive = 1;
                exclusive = 0;
            } else{
                inclusive = 0;
            }

            $.ajax({
                url: "{{route('admin.settings.save.tax-info')}}",
                type: "POST",
                data: {
                    inclusive: inclusive,
                    exclusive: exclusive,
                    _token: '{{csrf_token()}}'
                },
                context: this,
                success: function (result) {
                    if(result.success){
                        swal.fire({
                            title: result.message,
                            icon: "success",
                            button: "ok",
                        });
                        setTimeout(function(){
                            window.location.replace('{{ route("admin.settings.tax-index") }}');
                        }, 1000);
                    }
                }
            }); 
        });
    });
</script>
@endpush