
@extends('backend.layouts.app')

@push('after-styles')
<link rel="stylesheet" href="{{ asset('assets/plugins/html5-editor/bootstrap-wysihtml5.css') }} " />
@endpush
@push('after-scripts')
    <script src="{{ asset('assets/plugins/html5-editor/wysihtml5-0.3.0.js') }}"></script>
    <script src="{{ asset('assets/plugins/html5-editor/bootstrap-wysihtml5.js') }}"></script>
    <script>
    $(document).ready(function() {
        $('.textarea_editor').wysihtml5();
    });
    </script>
@endpush

@section('title', "Create Support Ticket")

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-10 col-10">
                <h4 class="card-title mb-0">
                    New {{_label('backend_support_ticket')}}
                </h4>
            </div><!--col-->
            <div class="col-sm-2 col-2" style="margin-top:20px;text-align: right;">
                <button type="cancel" name="back" class="btn btn-primary btn-sm " value="Back" onclick="document.location ='{{ route('admin.ticketlist') }}'" title="Back"> <i class="fa fa-reply" aria-hidden="true"></i> </button>
             </div>
        </div><!--row-->    

        <div class="row mt-4">
            <div class="col-md-8">


                    {{ html()->modelForm($logged_in_user, 'POST', route('admin.createticket'))->class('form-horizontal')->attribute('enctype', 'multipart/form-data')->open() }}
                    @method('PATCH')
                    <div style="margin-top:10px;">
                        <div class="form-group" style="margin-top: 10px;">
                            <label class="required-field">Subject</label>
                            <input tyle="text" placeholder="Subject" name="subject" class="form-control" maxlength="100" required>
                        </div>
                        <div class="form-group" style="margin-top: 10px;">
                            <label class="required-field">User: </label> <br>
                            @if(empty($user))
                                <select class="form-select select2_ajax" name="user" required></select>
                            @else
                                {{get_user_full_name_by_id($user->id)}} | {{$user->email}}
                                <input type="hidden" name="user" value="{{$user->id}}">
                            @endif

                                {{--
                            <select name="user" class="form-select" required>
                                <option value="">Select User</option>
                                @foreach($users as $user)
                                <option value="{{ $user['id'] }}">{{ $user['name'] }}</option>
                                @endforeach
                            </select>
                            --}}
                        </div>                        
                        <div class="form-group" style="margin-top: 10px;">
                            <label class="required-field">Message</label>
                            <textarea name='message' class="textarea_editor form-control" placeholder="Message" rows="7" required></textarea>
                        </div>
                        <div class="form-group" style="margin-top: 10px;">
                            <label>Attachments</label>
                            <br /><br><input type="file" id="attachment" multiple name="files[]" class="form-control" accept=".doc,.docx,.pdf,.jpg,.jpeg,.png,.gif,.zip" max="10">
                            <small>Note: Single File size limit is {{env('SUPPPORT_TICKETS_ATTACHMENT_MAX_SIZE')}}MB</small> <br>
                            <small>Note: Only 5 Files can be Uploaded</small>
                            {{-- <br /><br><input name="file1" type="file"> --}}
                            {{-- <br /><input name="file2" type="file">
                            <br /><input name="file3" type="file">
                            <br /><input name="file4" type="file"> --}}
                            <br /><strong class="small">Allowed File Types: .pdf, .docx, .doc, .jpg, .jpeg, .gif, .png</strong>
                        </div>
                        {{-- <div class="form-group" style="margin-top: 10px;">
                            <label>Attachments</label>
                            <br /><br><input name="file1" type="file">
                            <br /><br><input name="file2" type="file">
                            <br /><br><input name="file3" type="file">
                            <br /><br><input name="file4" type="file">
                            <br /><br><strong class="small">Allowed File Types: .pdf, .docx, .doc, .jpg, .jpeg, .gif, .png</strong>
                        </div> --}}

                        <div class="form-group" style="text-align: center;margin-top:50px;">
                            {{ form_submit("Submit") }}
                        </div>
                        {{ html()->closeModelForm() }}  
                    </div>
                
                
                
            </div><!--col-->
        </div><!--row-->
    </div>
</div>
@endsection

@push ('after-scripts')
<script>
    $(document).ready(function() {
        $("#attachment").on("change", function() {
            if ($("#attachment")[0].files.length > 5) {
                $("#attachment").val("");
                alert("You can select maximum 5 files");
            } 
        });
        $('.select2_ajax').select2({
        minimumInputLength: 3,
        ajax: {
            url: '{{ route("admin.searchUser") }}',
            type: "POST",
            dataType: 'json',
            data: function(params) {
                return {
                    q: params.term, // search term
                    _token: '{{csrf_token()}}'
                };
            },
        },
        });        
    });
</script>
@endpush
