@extends('backend.layouts.app')

@section('title', "Support Tickets")

@section('content')
<div class="card">
    <div class="card-body" style="padding-left: 0px !important; padding-right: 0px !important;">
        <div class="row" style="padding-left: 20px !important; padding-right: 20px !important;">
            <div class="col-sm-5 col-10">
                <h4 class="card-title mb-0">
                    {{_label('backend_support_tickets')}}
                    <small class="text-muted">Customer Support</small>
                </h4>
            </div>
            <!--col-->
            <div class="col-sm-7 col-2">
                <div class="btn-toolbar float-right" role="toolbar" aria-label="" style="margin-top: 20px;float: right;">
                    <button id="filter_toggle" class="btn btn-outline-primary btn-sm" style="margin-right:10px;" title="Filters"><i class="bi bi-funnel-fill"></i></button>
                    <a href="{{ route('admin.newticket') }}" class="btn btn-primary btn-sm ml-1" data-toggle="tooltip" title="Create New Ticket"><i class="bi bi-plus-circle"></i> Create</a>
                </div>
                <!--btn-toolbar-->
            </div>
        </div>
        <!--row-->

        <div id="filters" class="filterBox" style="display:none">
            <div class="row mt-4">
                <div class="col-md-3 col-sm-12">
                    {{-- <div class="row mb-3"> --}}
                        <!-- <label class="col-sm-3 col-form-label" style="font-size:15px;">Search</label> -->
                        <div class="col-sm-12">
                            <select class="form-select" id='status_search'>
                            <option value="">Search</option>
                            @foreach($status_list as $key=>$status_data)
                            <option value="{{$key}}" {{($filters['status'] == $key)? 'selected' : ''}}>{{$status_data}}</option>
                            @endforeach
                            </select>
                        </div>
                    {{-- </div> --}}
                </div>
                @if(!\Auth::user()->can('view assigned data only'))
                <div class="col-sm-12 col-md-3">
                    <select class="form-select" name="assigned_to" id="assigned_to">
                        <option value="">Select Staff</option>
                        @foreach($staff as $stf)
                        <option {{($filters['assigned_to'] == $stf->id)? 'selected' : ''}} value="{{$stf->id}}">{{$stf->first_name.' '.$stf->last_name}}</option>
                        @endforeach
                    </select>
                </div>
                @endif
                <div class="col-sm-12 col-md-3">
                    <select class="form-select" id="branch" name="branch">
                        <option value="all" @if($current_branch == 'all') selected="selected" @endif>All Branch</option>
                        @foreach($branch as $id => $name)
                        <option value="{{ $id }}" @if($current_branch == $id) selected="selected" @endif>{{ $name }}</option>
                        @endforeach
                    </select>
                </div>         
                <div class="col-md-3 col-sm-12">
                    <button onclick="javascript:searchTable();" class=" btn btn-primary btn-sm">Filter</button>
                    <button onclick="javascript:clearTable();" class=" btn btn-primary btn-sm">Clear</button>
                </div>
            </div>
            <div class="row">
                <div class="col-sm-12 col-md-4">
                    <input type="checkbox" name="mytickets" id="mytickets" value="1" @if($filters['my_data'] == '1') checked @endif> My Tickets Only
                </div>
            </div>        
        </div>        

        <div class="row mt-4">
            <div class="col">
                <div class="table-responsive">
                    <table class="table" id="ticket_list">
                        <thead>
                            <tr>
                                <th style="width:40%;">Ticket</th>
                                <th>Assigned To</th> 
                                <th>Branch</th>                               
                                <th>Status</th>                                
                                <th>Submitter</th>
                                <th>Last Reply</th>
                                <th>Created</th>
                                <th>Assigned To</th>
                            </tr>
                        </thead>

                    </table>
                </div>
            </div>
            <!--col-->
        </div>
        <!--row-->
        <div class="row">
        </div>
        <!--row-->
    </div>
</div>
@endsection

@push ('after-scripts')

<script type="text/javascript">
    $(document).ready(function() {
        loadData();
        $('#mytickets').change(function() {
            $("#ticket_list").dataTable().fnDestroy();
            loadData();
        });        

        $('#filter_toggle').on('click', function() {
            $('#filters').toggle();
        });
    });


    function loadData() {
        $('#ticket_list').DataTable({
            "dom": '<"row px-3"<"col-md-3 text-start"l><"col-md-5 text-start"f><"col-md-4 text-end"B>>rt<"ps-3"i><"pe-3"p>',            
            processing: true,
            serverSide: true,
            "ajax": {
                "url": "{{route('admin.ajaxticketlist')}}",
                "dataType": "json",
                "type": "post",
                data: {
                    '_token': $('meta[name="csrf-token"]').attr('content'),
                    'status': $('#status_search').val(),
                    'assigned_to': $('#assigned_to').val(),
                    'branch': $('#branch').val(),
                    'mytickets': $('#mytickets:checked').val()
                },
            },
            language: {
                searchPlaceholder: "Search Ticket ID, Subject..."
            },
            autoWidth: true,
            responsive: true,
            lengthMenu: [25, 50, 100],
            'order': [
                [5, 'desc']
            ],
            columns: [{
                    data: 'subject'
                },
                {
                    data: 'assigned_to',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'branch'
                },
                {
                    data: 'status'
                },
                {
                    data: 'username',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'updated_at'
                },
                {
                    data: 'created_at'
                },
                {
                    data: 'assigned_to_name',
                    orderable: false,
                    searchable: false,
                    visible: false
                },
            ],
            @if(isset($search) && strlen($search))
            "search": {
                "search": "{{$search}}"
            },
            @endif
            "buttons": [{
                    extend: 'excel',
                    text: '<i class="ri-file-excel-2-line export-btn-size"  data-toggle="tooltip" data-placement="top" title="Excel"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [0, 2, 3, 4, 5, 6]
                    }
                },
                {
                    extend: 'pdf',
                    text: '<i class="bi bi-file-earmark-pdf"  data-toggle="tooltip" data-placement="top" title="Pdf"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [0, 2, 3, 4, 5, 6]
                    }
                },
                {
                    extend: 'print',
                    text: '<i class="bi bi-printer"  data-toggle="tooltip" data-placement="top" title="Print"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [0, 2, 3, 4, 5, 6]
                    }
                },
                {
                    extend: 'copy',
                    text: '<i class="ri-file-copy-2-line export-btn-size" data-toggle="tooltip" data-placement="top" title="Copy"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [0, 2, 3, 4, 5, 6]
                    }
                },
                {
                    extend: 'csv',
                    text: '<i class="ri-file-excel-line export-btn-size" data-toggle="tooltip" data-placement="top" title="Csv"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [0, 2, 3, 4, 5, 6]
                    }
                },
            ]            

        });
    }


    function searchTable() {
        $("#ticket_list").dataTable().fnDestroy();
        loadData();
    }

    function clearTable() {
        // $('#status_search').val('new_customer_reply');
        $('#status_search').val('');
        $('#assigned_to').val('');
        $('#branch').val('all');
        $("#ticket_list").dataTable().fnDestroy();
        loadData();
    }

    function changeStaff(staff_id, ticket_id) {
        $.ajax({
            url: "tickets/assign-staff/" + staff_id + "/" + ticket_id,
            method: "GET",
            success: function(data) {
                alert(data);
            }
        });
    }    

</script>
@endpush