@extends('backend.layouts.app')

@push('after-styles')
<link rel="stylesheet" href="{{ asset('assets/plugins/html5-editor/bootstrap-wysihtml5.css') }} " />
@endpush
@push('after-scripts')
<script src="{{ asset('assets/plugins/html5-editor/wysihtml5-0.3.0.js') }}"></script>
<script src="{{ asset('assets/plugins/html5-editor/bootstrap-wysihtml5.js') }}"></script>
<script>
    $(document).ready(function() {
        $('.textarea_editor').wysihtml5();
    });
</script>
@endpush

@section('title', "Support Ticket")

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-10 col-10">
                <h4 class="card-title mb-0">
                    #{{ $ticket->ticket_id }} {{ $ticket->subject }}
                </h4>
            </div>
            <!--col-->
            <div class="col-sm-2 col-2" style="margin-top:20px;text-align: right;">
                <button type="cancel" name="back" class="btn btn-primary btn-sm " value="Back" onclick="document.location ='{{ route('admin.ticketlist') }}'" title="Back"> <i class="fa fa-reply" aria-hidden="true"></i> </button>
            </div>
        </div>
        <!--row-->

        <div class="row mt-4">
            <div class="col">

                @if($ticket->status == 'new')
                <span class="alert alert-danger" style="font-size: 1.3em;padding:10px;">New</span>
                @elseif($ticket->status == 'customer_reply')
                <span class="alert alert-warning" style="font-size: 1.3em;padding:10px;">User Reply</span>
                @elseif($ticket->status == 'staff_reply')
                <span class="alert alert-success" style="font-size: 1.3em;padding:10px;">Answered</span>
                @elseif($ticket->status == 'inprogress')
                <span class="alert alert-info" style="font-size: 1.3em;padding:10px;">In Progress</span>
                @else
                <span class="alert alert-default" style="font-size: 1.3em;padding:10px;">Closed</span>
                @endif

                &nbsp;&nbsp;<strong>Created On:</strong> {{ date('d M Y',strtotime($ticket->created_at)) }}
                &nbsp;&nbsp;<strong>Last Update:</strong> @if($ticket->updated_at) {{ date('d M Y, h:i A',strtotime($ticket->updated_at)) }} @endif

                @if($ticket->status != 'closed')

                <div style="float: right">
                    Change Status To:
                    <a href="<?php echo route('admin.inprogressticket', $ticket->ticket_id); ?>" onclick="if (confirm('Change Status to Inprogress?')) {
                                return true;
                            } else {
                                event.stopPropagation();
                                event.preventDefault();
                            }
                            ;">Inprogress</a> |
                    <a href="<?php echo route('admin.closeticket', $ticket->ticket_id); ?>" onclick="if (confirm('Close this ticket?')) {
                                return true;
                            } else {
                                event.stopPropagation();
                                event.preventDefault();
                            }
                            ;">Closed</a>
                </div>
                <br /><br /><strong>Assigned To:</strong> {{get_user_full_name_by_id($ticket->assigned_to)}}
                {{ html()->modelForm($logged_in_user, 'POST', route('admin.replyticket'))->class('form-horizontal')->attribute('enctype', 'multipart/form-data')->open() }}
                @method('PATCH')
                <div style="margin-top:10px;">
                    <input type='hidden' name='ticket_id' value='{{ $ticket->ticket_id }}'>
                    <div class="form-group">
                        <label>Reply</label>
                        <textarea name='message' class="textarea_editor form-control" rows="7" required></textarea>
                    </div>
                    <div class="form-group">
                        <label>Attachments</label>
                        <br /><br><input type="file" id="attachment" multiple name="files[]" class="form-control" accept=".doc,.docx,.pdf,.jpg,.jpeg,.png,.gif,.zip" max="10">
                        <small>Note: Single File size limit is {{env('SUPPPORT_TICKETS_ATTACHMENT_MAX_SIZE')}}MB</small> <br>
                        <small>Note: Only 5 Files can be Uploaded</small>
                        {{-- <br /><br><input name="file1" type="file"> --}}
                        {{-- <br /><input name="file2" type="file">
                        <br /><input name="file3" type="file">
                        <br /><input name="file4" type="file"> --}}
                        <br /><strong class="small">Allowed File Types: .pdf, .docx, .doc, .jpg, .jpeg, .gif, .png</strong>
                    </div>

                    <div class="form-group" style="text-align: center">
                        {{ form_submit("Submit Reply") }}
                    </div>
                    {{ html()->closeModelForm() }}
                </div>
                <hr>
                @endif

                <div class="profiletimeline">

                    @foreach($messages as $message)
                    <div class="sl-item">
                        <div class="sl-left">
                            @if($message['reply_by'] == 'user')
                            <img src="../../assets/images/users/you.jpg" alt="You" class="img-circle" />
                            @else
                            <img src="../../assets/images/users/support.jpg" alt="Support" class="img-circle" />
                            @endif
                        </div>
                        <div class="sl-right">
                            <div>
                                @if($message['reply_by'] == 'staff')
                                <span class="text-primary">{{ $message['staff_name'] }}</span>
                                @else
                                <span class="text-primary">{{ $user_name }} </span>
                                @endif
                                <span class="sl-date text-primary">{{ date('d M Y, h:i A',strtotime($message['timestamp'])) }}</span>
                                <p>
                                    {!! $message['message'] !!}
                                </p>

                                @if(isset($message['all_attachment']))
                                    @php $all_attachments = explode("|", $message['all_attachment']) @endphp
                                    <p>
                                        <span class="text-warning">Attachments:</span><br />
                                        @foreach ($all_attachments as $attachments)
                                            @if($attachments)
                                                <i class="fas fa-download"></i> 
                                                <a href="<?php echo url('storage/tickets/' . $attachments); ?>" target="_blank">{{ substr($attachments, 8) }}</a>
                                                <br />
                                            @endif
                                        @endforeach
                                    </p>
                                @endif
                            </div>
                        </div>
                    </div>
                    <hr>
                    @endforeach
                </div>



            </div>
            <!--col-->
        </div>
        <!--row-->
    </div>
</div>
@endsection