@extends('backend.layouts.app')

@section('title', "Student Resources Category")

@section('content')

<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-5 col-5">
                <h4 class="card-title mb-0"> 
                    Student Resources Category 
                </h4>
            </div>
            <div class="col-sm-7 col-7">
                <div class="btn-toolbar float-right" role="toolbar" style="margin-top: 20px;float: right;">
                    <a href="{{ route('admin.upload.create') }}" class="btn btn-primary btn-sm ml-1" data-toggle="tooltip" title="Add New Category"><i class="bi bi-plus-circle"></i> Create Category</a>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col">
                <div class="table-responsive">
                    <table class="table table-striped" id="batch_data"> 
                        <thead>
                            <tr>
                                <th class="select_data">Category</th>
                                <th class="select_data" data-orderable="false">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($categories as $category)
                                <tr>
                                    <td>{{$category->category}}</td>
                                    <td>
                                        <a href="{{route("admin.edit.category", $category->id)}}" class="btn btn-sm mx-2 btn-primary"><i class="fas fa-edit"></i> Edit</a>
                                        <form class="d-inline-block" style="display: inline;" method="post" id="uploadCategoryDelete_{{$category->id}}" action="{{route('admin.upload.category.delete')}}">
                                            @csrf
                                            <input type="hidden" name="application_id" value="{{$category->id}}">
                                            <button type="button" data-appl_id={{$category->id}}  class="btn btn-sm btn-outline-danger deleteBtn" style="border: 1px solid red" ><i class='fas fa-trash-alt'></i></button></td>
                                        </form>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>                       
                    </table>
                </div>
            </div> 
        </div>
    </div>
</div>

@endsection


@push('after-scripts')

<script>
    $('.deleteBtn').on("click", function() {
        let btn = $(this);
        let appl_id = btn.data("appl_id");
        Swal.fire({
            title: "Are you sure you want to delete this Category?",
            html: "<h6 class='text-danger'>This action cannot be undone!</h6>",
            icon: "warning",
            showCancelButton: true,
            confirmButtonColor: "#DD6B55",
            confirmButtonText: "Yes",
        }).then((result) => {
            if (result.value) {
                $('#uploadCategoryDelete_'+appl_id).submit();
            } 
        });
    });

</script>

@endpush