@extends('backend.layouts.app')
@section('title', "File Upload")

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-5 col-5">
                <h4 class="card-title mb-0">
                    Student Resources
                </h4>
            </div><!--col-->
            <div class="col-sm-7 col-7">
                <div class="btn-toolbar float-right" role="toolbar" aria-label="New Course Info Page" style="margin-top: 20px;float: right;">
                    <a href="{{ route('admin.upload.create') }}" class="btn btn-primary btn-sm ml-1" data-toggle="tooltip" title="Add New Category"><i class="bi bi-plus-circle"></i> Create Category</a>
                    <a href="{{ route('admin.show.category') }}" class="btn btn-primary btn-sm ml-1 ms-2" data-toggle="tooltip" title="All Categories"><i class="fa fa-list"></i> Categories</a>
                </div><!--btn-toolbar-->
            </div><!--col-->            
        </div><!--row--> 

        <div class="row mt-3">
            <div class="col-12 rounded border" style="background-color: rgb(250, 250, 250)">
                <h3 class="my-3">Add New Resource</h3>
                {{ html()->form('POST', route('admin.upload.uploaddoc'))->class('form-horizontal')->attribute('enctype', 'multipart/form-data')->open() }}

                <div class="row">
                    <div class="col-sm-12 col-md-5">      
                        <div class="form-group mb-3">
                            <label class="required-field">Title</label>
                            <input type="text" class="form-control" placeholder="Title" name="title" required/>
                        </div> 
                    </div>  
                </div>
                <div class="row">
                    <div class="col-sm-12 col-md-5">      
                        <div class="form-group mb-3">
                            <label class="required-field">Category</label>
                            <select class="form-select"  id="category" name="category" required="required">
                                <option value="">Select Category</option> 
                                @foreach($categorys as $category)
                                    <option value="{{ $category->id }}">{{ $category->category }}</option>
                                @endforeach   
                            </select>
                        </div> 
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-12 col-md-8">
                        <div class="form-group mb-3">
                            <label class="required-field">Document</label>
                            <input type="file" name="file" accept=".pdf, .docs, .doc, .txt, .jpg, .jpeg, .zip, mp4" /><br>
                            <span class="form-text">Maximum size of file : {{get_php_max_upload_size_kb() / 1024}} MB</span> <br>
                            <span class="form-text">Allowed File Types: .pdf, .docs, .doc, .txt, .jpg, .jpeg, .zip, mp4</span>
                        </div>        
                    </div>
                    <div class="col-sm-12 col-md-5">
                        <button type="submit" class="btn btn-primary btn-sm" name="submit"><i class="fas fa-upload"></i> Upload</button>
                    </div>
                </div> 
                <div class="row">
                    <div class="col-12">
                        <p>Notes: Documents uploaded here are visible to all students from <b>Student Menu > Resources</b></p>
                    </div>
                </div>
                {{ html()->form()->close() }}
            </div>
        </div>

        <div class="row mt-4">
            <div class="col-12">
                <h3 class="mt-3" >All Student Resources</h3>
                <div class="table-responsive" style="border: 1px solid rgb(244, 240, 240); border-radius: 6px;">
                    <table class="table table-striped bg-none mb-0">
                        <thead class="tableHeading">
                            <tr>
                                <th>Title</th>
                                <th>Category</th>
                                <th>File URL</th>   
                                <th style="min-width: 178px !important;">Actions</th>
                            </tr> 
                        </thead>
                        <tbody>
                            @if(count($pages))
                                @foreach($pages as $page)
                                    <tr>  
                                        <td>{{ $page->title }}</td>
                                        <!-- <td>{{ url('storage/' .$page->filename) }} -->
                                        <td>{{ $page->category }}</td>
                                        <td>    
                                            <input class="form-control" type="text" value="{{ url('storage/' .$page->filename) }}" id="{{$page->id}}" >
                                            <button class="btn btn-copy btn-primary btn-sm" onclick="copyText('{{$page->id}}')"><i class="far fa-copy"></i> Copy Link</button>
                                        </td>
                                        <td>                              
                                        <a href="{{ url('/storage/'.$page->filename)}}">
                                        <!--<a href="{{ url('/../storage/app/public/uploads'.$page->filename)}}">-->
                                            <!--<a href="{{ url('storage/'.$page->filename)}}">-->

                                        <button type="button" class="btn btn-primary btn-sm"><i class="fas fa-download"></i> Download             
                                        </button>
                                        </a>
                                        <a href="{{ route('admin.upload.deletedoc',$page->id)}}"
                                                    data-method="delete"
                                                    data-trans-button-cancel="Cancel"
                                                    data-trans-button-confirm="Delete"
                                                    data-trans-title="Are you sure?"
                                                    class="btn btn-danger btn-sm" class="btn btn-primary btn-sm"><i class="fas fa-trash"></i> Delete</a>
                                        </td>         
                                    </tr>
                                    <script>
                                        function copyText(id) { 
                                            var copyGfGText  = document.getElementById(id);
                                            copyGfGText.select();
                                            document.execCommand("copy");
                                            // alert("Copied the text: " + copyGfGText.value);
                                            Swal.fire({
                                                title: "Copied the text: " +copyGfGText.value,
                                                icon: "success",
                                            });
                                        }
                                    </script>
                                @endforeach
                            @else
                                <tr>
                                    <td colspan="4" class="text-center">No Record Found</td>
                                </tr>
                            @endif
                        </tbody>
                    </table>
                </div>
            </div><!--col-->
        </div><!--row-->
    </div>
</div>
@endsection 

@push('after-scripts')
<script>
    addDeleteForms();
</script>
@endpush
