<div class="row">
    <div class="col">
        <div class="">
            <form action="{{route('admin.service-application.add-activity')}}" method="post">
            @csrf
            <input type="hidden" name="appl_id" value="{{$services_application->id}}">
            <div class="row m-b-10">
                <div class="col-sm-12 col-md-3" style="margin-bottom: 5px;">
                    <label>Activity to be done</label>
                    <div class="input-group">
                        <input name="activity" type="text" autocomplete="off" class="form-control" required>
                    </div>
                </div>
                <div class="col-sm-12 col-md-3" style="margin-bottom: 5px;">
                    <label>Deadline Date</label>
                    <div class="input-group">
                        <input name="deadline" type="text" autocomplete="off" class="form-control mydatepicker" required>
                    </div>
                </div>
                <div class="col-md-3" style="margin-top: 20px;">
                    <input type="submit" class="btn btn-primary btn-sm" name="submit" value="Add" />
                </div>
            </div>
            </form>
        </div>
    </div>
</div>
<div class="row">
    <div class="col-md-8">
        <h4>Reminders List</h4>
        <table class="table table-hover">
            <thead>
                <tr>
                    <td style="width:20%;"><b>Activity</b></td>
                    <td  style="width: 10%;"><b>Deadline</b></td>
                    <td style="width: 5%; text-align:center;"><b>Done?</b></td>
                    <td style="text-align:center;"><b>Action</b></td>
                </tr>
            </thead>
            <tbody>
                @if(count($reminders))
                @foreach($reminders as $reminder)
                <tr>
                    <td>
                        {{$reminder->activity}}
                    </td>
                    <td>
                        {{date('d M Y',strtotime($reminder->deadline))}}
                    </td>
                    <td style="width: 5%; text-align:center;">
                        <input type="checkbox" @if($reminder->done) checked @endif class="form-check-input mark_done" data-id="{{$reminder->id}}" style="scale: 1.2;margin: 12px;" value="1">
                    </td>
                    <td style="width: 8%; text-align:center;">
                        <button style="padding: 4px 8px;" data-appl_id="{{$services_application->id}}" data-id="{{$reminder->id}}" class="btn btn-outline-danger me-1 del-rem-btn"><i class="fa fa-trash"></i></button>
                    </td>
                </tr>
                @endforeach
                @else
                <tr>
                    <td colspan="4">
                        No Reminders.
                    </td>
                </tr>
                @endif
            </tbody>
        </table>
    </div>
</div>
@push('after-styles')
<link href="{{ asset('assets/plugins/toast-master/css/jquery.toast.css') }}" rel="stylesheet">
<link href="{{ asset('assets/plugins/sweetalert/sweetalert.css') }}" rel="stylesheet" type="text/css">
<style>
</style>
@endpush
@push('after-scripts')
<script src="{{ asset('assets/plugins/toast-master/js/jquery.toast.js') }}"></script>
<script src="{{ asset('assets/plugins/sweetalert/sweetalert.min.js') }}"></script>
<script type="text/javascript">

    $(document).ready(function () {
        $('.mydatepicker').datetimepicker({
            timepicker: false,
            format: 'd-m-Y',
            scrollInput: false,
            minDate: new Date()
        });
    });

$(".mark_done").on("click", function() {
    var id = $(this).data('id');
    var action = markType = "";
    if($(this).is(":checked")){
        action = 1;
        markType = "Mark as Done?";
    }else{
        action = 0;
        markType = "Mark as Not Done?";
    }
    swal({   
            title: markType,      
            type: "warning",   
            showCancelButton: true,   
            confirmButtonColor: "#DD6B55",   
            confirmButtonText: "Yes!",   
            closeOnConfirm: true 
        }, function(){   
            $.ajax({
                    url: "{{route('admin.application.activity-done')}}",
                    type: "POST",
                    data: {
                        id: id,
                        action: action,
                        _token: '{{csrf_token()}}'
                    },
                    context: this,
                    success: function (result) {
                        $.toast({
                        heading: 'Success',
                        text: result.message,
                        position: 'top-right',
                        loaderBg:'#ff6849',
                        icon: 'success',
                        hideAfter: 2000, 
                        stack: 6
                      });
                        //location.reload();
                    }
                }); 
        });
            
    });

 $(".del-rem-btn").on("click", function() {
    var id = $(this).data('id');
    var appl_id = $(this).data('appl_id');
    swal({   
            title: "Are you sure?",   
            text: "Do you want to delete?",   
            type: "warning",   
            showCancelButton: true,   
            confirmButtonColor: "#DD6B55",   
            confirmButtonText: "Yes, delete it!",   
            closeOnConfirm: true 
        }, function(){   
            $.ajax({
                    url: "{{route('admin.application.delete-activity')}}",
                    type: "POST",
                    data: {
                        id: id,
                        appl_id: appl_id,
                        _token: '{{csrf_token()}}'
                    },
                    context: this,
                    success: function (result) {
                        $.toast({
                        heading: 'Success',
                        text: result.message,
                        position: 'top-right',
                        loaderBg:'#ff6849',
                        icon: 'success',
                        hideAfter: 2000, 
                        stack: 6
                      });
                        location.reload();
                    }
                }); 
        });
            
    });




</script>
@endpush