@extends('backend.layouts.app')

@section('title', "Additional Services Management")

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-9 col-9">
                <h4 class="card-title mb-0">
                    Service Request #{{$services_application->appl_id}}
                    <small class="text-muted"></small>
                </h4>
            </div>
            <div class="col-sm-3 col-3 pull-right">
                <div class="btn-toolbar" role="toolbar" aria-label="" style="margin-top: 20px;float: right;">
                    <button type="cancel" name="back" class="btn btn-primary btn-sm " value="Back" onclick="document.location ='{{ route('admin.service-visa.list') }}'" title="Back"> <i class="fa fa-reply" aria-hidden="true"></i> </button>
                </div>
            </div>
        </div>
        <ul class="nav nav-tabs" id="myTab" role="tablist">
            <li class="nav-item" role="presentation">
                <button style="font-weight:bold;" class="nav-link active" id="application-tab" data-bs-toggle="tab" data-bs-target="#appilcation" type="button" role="tab" aria-controls="appilcation" aria-selected="true"><i class="bx bxs-id-card"></i> Application</button>
            </li>
            <li class="nav-item" role="presentation">
                <button style="font-weight:bold;" class="nav-link" id="profile-tab" data-bs-toggle="tab" data-bs-target="#profile" type="button" role="tab" aria-controls="profile" aria-selected="false"><i class="bx bxs-user-circle"></i> Profile</button>
            </li>
            <li class="nav-item" role="presentation">
                <button style="font-weight:bold;" class="nav-link" id="docs-tab" data-bs-toggle="tab" data-bs-target="#docs" type="button" role="tab" aria-controls="docs" aria-selected="false"><i class="bx bxs-user-circle"></i> Documents</button>
            </li>
            <li class="nav-item" role="presentation">
                <button style="font-weight:bold;" class="nav-link" id="reminders-tab" data-bs-toggle="tab" data-bs-target="#reminders" type="button" role="tab" aria-controls="reminders" aria-selected="false"><i class="fas fa-bell"></i> Reminders ({{count($reminders)}})</button>
            </li>
        </ul>
        <div class="tab-content" id="myTabContent">
            <div class="tab-pane fade show active" id="appilcation" role="tabpanel" aria-labelledby="appilcation-tab"> 
                <div class="row mt-0">
                    <div class="col-sm-12 col-md-6">
                        <h4>{{ get_services($services_application->service_id) }}</h4>
                        <p>Country: @if($services_application->country){{ get_country_name($services_application->country) }}@else -- @endif</p>
                        @if($services_application->description)<p>{{ $services_application->description }}</p> @endif
                        {{-- <p>Date: <strong class="badge badge-success">{{ get_date_formated($services_application->created_at)}}</strong><br></p> --}}

                        <p><a target="_blank" href="{{route('admin.auth.user.show', $student->id)}}">{{ get_user_full_name_by_id($student->id) }}</a> <br>{{$student->email}} <br>@if($student->dialcode)+{{$student->dialcode}}-@endif{{$student->mobile}}</p>
                        <p>Current Status: <strong class="badge" style="font-size: 13px; background-color:{{get_service_application_status_color($services_application->status,$services_application->service_id)}};">{{ $services_application->status}}</strong></p>
                    </div>
                    @if(!auth()->user()->isAgent())
                    <div class="col-md-6 col-sm-12">
                        <a href="#" title="Assigned Staff" class="text-reset pb-3" style="margin-bottom: 0px !important; float: right!important;">
                            <i class="ri-user-2-fill menu-icon" style="font-size: 16px !important;vertical-align: sub;"></i>
                            {!!($services_application->assigned_to) ? "<span class='text-primary'>".get_user_full_name_by_id($services_application->assigned_to)."</span>" : '<span class="text-danger">--</span>'!!}
                        </a>
                        <form method="post" action="{{route('admin.service-visa.update-notes')}}">
                            @csrf
                            <input type="hidden" name="id" value="{{$services_application->id}}">
                            <textarea class="form-control" name="notes" maxlength="500" placeholder="Notes" style="height: 120px;">{!!$services_application->notes!!}</textarea>
                            <button class="btn btn-primary btn-sm">Save</button>
                        </form>
                    </div>
                    @endif
                </div>
                <hr> 
                <div class="row">
                    <div class="col-md-6">
                        @if(auth()->user()->isAgent())
                            <h4 class="timeline-title">Send Message to Staff</h4>
                        @else
                            <h4 class="timeline-title">Send Message to Student/Agent</h4>
                        @endif
                        <form action="{{route('admin.service-visa.visa-services-message.send')}}" method="POST" enctype="multipart/form-data">
                            @csrf
                            <input type="hidden" name="app_id" value="{{$services_application->id}}">
                            <ul class="list-unstyled">
                                <li class="bg-white mb-3">
                                    <div class="form-outline">
                                        <textarea class="form-control" id="message" name="message" required rows="4"></textarea>
                                        <!-- <label class="form-label" for="textAreaExample2">Message</label> -->
                                    </div>
                                </li>
                                @if(!auth()->user()->isAgent())
                                <li>
                                    <div class="row">
                                        <div class="form-group">
                                        <div class="col-sm-12 col-md-12">
                                                <select class="form-control select2_ajax" name="notify_staff[]" data-placeholder="@if(!auth()->user()->isAgent()) Select staff and agent to notify @else Select staff to notify @endif" multiple></select>
                                            </div>
                                        </div>
                                    </div>
                                </li>
                                @endif
                                <li>
                                    <div class="row">
                                        <div class="col-md-6">
                                            Attach files:
                                            <input type="file" name="attachment[]" id="attachment" accept=".doc,.jpeg,.jpg,.pdf,.docx,.png,application/msword,application/vnd.openxmlformats-officedocument.wordprocessingml.document" data-max="4" multiple>
                                            <p class="text-danger m-0" id="fileErr"></p>
                                        </div>
                                    </div>
                                </li>
                                <li>
                                    <div class="row mt-2">
                                        <div class="col-md-4 mx-auto">
                                            <input type="submit" id="sendMsg" class="btn btn-primary btn-sm btn-rounded float-end" value="Send Message">
                                        </div>
                                    </div>
                                </li>
                            </ul>
                        </form>
                    </div>

                    @if(!auth()->user()->isAgent())
                    <div class="col-md-6">
                        <h4 class="timeline-title">Update Service Status</h4>
                        <br>
                        Current Status: <strong class="badge" style="font-size: 13px; background-color:{{get_service_application_status_color($services_application->status,$services_application->service_id)}};">{{ $services_application->status}}</strong>
                        <br />
                        <br />
                        {{ html()->form('POST', route('admin.service-visa.status.update'))->id('statusUpdate')->class('form-horizontal')->attribute('enctype', 'multipart/form-data')->open() }}
                        <input type="hidden" name="id" value="{{$services_application->id}}">
                        <label>Change Status to</label>
                         <select class="form-control form-select" name="status" required>
                            <option value="">Select</option>
                            @foreach($statuses as $status)
                            <option value="{{$status->status_name}}">{{$status->status_name}}</option>
                            @endforeach
                        </select>
                        <div class="mt-2" style="text-align: center;">
                            <input type="submit" class="btn btn-primary btn-sm" name="submit" value="Update" />
                        </div>
                    </div>
                    @endif
                </div>
                <div class="row">
                    <hr>
                </div>
                <div class="row mt-4">
                    <div class="col-md-6">
                        <h4 class="mb-3">Message History</h4>
                        @if(count($app_messages)>0)
                        <div class="card" style="max-height: 400px;overflow-y: auto;">
                            <div class="card-body" style="padding-top: 15px;">
                            @foreach($app_messages as $msgs)
                                <ul class="list-unstyled">
                                    <li class="justify-content-between mb-4">
                                        <div>
                                            @if($msgs->staff_id)
                                            <p class="fw-bold mb-0">{{get_user_full_name_by_id($msgs->staff_id)}}</p>
                                            @else
                                            <p class="fw-bold mb-0">{{get_user_full_name_by_id($msgs->user_id)}}</p>
                                            @endif
                                            <p class="mb-0 text-muted"><small>{{ date("d-M-Y h:i A", strtotime($msgs->created_at))}}</small></p>
                                            <div class="p-2 mb-1 rounded-3" style="background-color: #f5f6f7;">
                                                <span style="font-size: 15px;">{!!nl2br($msgs->message)!!}</span>
                                                @if($msgs->attachment_1)
                                                <p class="m-0 mt-1 small"><a style="color: #0d6efd!important;" href="<?php echo url('storage/' . $msgs->attachment_1) ?>" target="_blank">{{substr($msgs->attachment_1, strpos($msgs->attachment_1, "/") + 1)}}</a></p>
                                                @endif
                                                @if($msgs->attachment_2)
                                                <p class="m-0 small"><a style="color: #0d6efd!important;" href="<?php echo url('storage/' . $msgs->attachment_2) ?>" target="_blank">{{substr($msgs->attachment_2, strpos($msgs->attachment_2, "/") + 1)}}</a></p>
                                                @endif
                                                @if($msgs->attachment_3)
                                                <p class="m-0 small"><a style="color: #0d6efd!important;" href="<?php echo url('storage/' . $msgs->attachment_3) ?>" target="_blank">{{substr($msgs->attachment_3, strpos($msgs->attachment_3, "/") + 1)}}</a></p>
                                                @endif
                                                @if($msgs->attachment_4)
                                                <p class="m-0 small"><a style="color: #0d6efd!important;" href="<?php echo url('storage/' . $msgs->attachment_4) ?>" target="_blank">{{substr($msgs->attachment_4, strpos($msgs->attachment_4, "/") + 1)}}</a></p>
                                                @endif
                                                @if($msgs->notified_staff)
                                                <hr>
                                                <p class="mb-1"><small>Tagged:</small> 
                                                    <?php $tagged_staff = explode(',',$msgs->notified_staff); ?>
                                                    @foreach($tagged_staff as $tagged)
                                                    <a href="#" class="badge badge-primary">{{get_user_full_name_by_id($tagged)}}</a>
                                                    @endforeach
                                                </p>
                                                @endif
                                            </div>
                                        </div>
                                    </li>
                                </ul>
                            @endforeach
                            </div>
                        </div>
                        @else
                            No messages found!
                        @endif
                    </div>

                    <div class="col-md-6">
                        <h4 class="mb-3">Service Activity</h4>
                        @if(count($visaServicesActivity))
                        <div class="card" style="max-height: 400px;overflow-y: auto;">
                            <div class="card-body" style="padding-top: 15px;">
                                    @foreach($visaServicesActivity as $activity)
                                        <span>{{date('d M Y, g:ia', strtotime($activity->created_at))}}, <b>{{get_user_full_name_by_id($activity->staff)}}</b></span><br>
                                        <p>{{$activity->detail}}</p>
                                        @if(!$loop->last)
                                            <hr>
                                        @endif
                                    @endforeach
                                </div>
                            </div>
                        @else
                            <p>No Activity Found</p>
                        @endif
                    </div>
                </div>
            </div>
        {{-- </div> --}}

            <div class="tab-pane fade" id="profile" role="tabpanel" aria-labelledby="profile-tab">
                @include('backend.applications.profile')
            </div>
            <div class="tab-pane fade" id="docs" role="tabpanel" aria-labelledby="docs-tab">
                @include('backend.applications.docs')
            </div>
            <div class="tab-pane fade" id="reminders" role="tabpanel" aria-labelledby="reminders-tab">
                @include('backend.visa-and-services.reminders')
            </div>
        </div>
    </div>
</div>
</div>
@endsection

@push('after-styles')
<style>
.title_lines {
    position: relative;
    font-size: 18px;
    z-index: 1;
    overflow: hidden;
    text-align: center;
    color: #000;
    font-family: arial;
}
.title_lines:before, .title_lines:after {
    position: absolute;
    top: 51%;
    overflow: hidden;
    width: 48%;
    height: 1.5px;
    content: '\a0';
    background-color: #cccccc;
    margin-left: 2%;
}
.title_lines:before {
    margin-left: -50%;
    text-align: right;
}
</style>
@endpush
@push ('after-scripts')
<script>
    $(document).ready(function() {
        $('.select2_ajax').select2({
            minimumInputLength: 3,
            // placeholder: "Select staff to notify",
            ajax: {
                url: '{{ route("admin.search.staff") }}',
                type: "POST",
                dataType: 'json',
                data: function(params) {
                    return {
                        q: params.term, // search term
                        _token: '{{csrf_token()}}'
                    };
                },
            },
        });
    });
    
    const btn = document.querySelector('input[id=sendMsg]');
    document.querySelector('form').addEventListener('change', function(ev) {
        if (ev.target.type == 'file') {
            // I collect the inps here to allow for dynamic pages (varying number of inputs):
            const inps = [...document.querySelectorAll('input[type=file]')];
            btn.disabled = inps.some(inp => {
                // check whether the condition has been violated at least once
                if (inp.files.length > inp.dataset.max) { // show warning for first violation
                    console.log(`You are only allowed to upload a maximum of ${inp.dataset.max} files for ${inp.name}!`);
                    $('#fileErr').text(`You are only allowed to upload a maximum of ${inp.dataset.max} files`);
                    return true;
                } else {
                    $('#fileErr').text(``);
                }
            })
        }
    });

    $('input[name="offer_letter_result"]').change(function () {
        if($("#unconditional,#conditional").is(':checked')) {
            $('input[name="offer_file"]').attr('required', true);
        } else {
            $('input[name="offer_file"]').removeAttr('required');
        }
    });

    $('input[name="i20_status"]').change(function () {
        if($("#i20_rec").is(':checked')) {
            $('input[name="i20_file"]').attr('required', true);
        } else {
            $('input[name="i20_file"]').removeAttr('required');
        }
    });

    $('input[name="coe_status"]').change(function () {
        if($("#coe_rec").is(':checked')) {
            $('input[name="coe_file"]').attr('required', true);
        } else {
            $('input[name="coe_file"]').removeAttr('required');
        }
    });

    $('input[name="cas_status"]').change(function () {
        if($("#cas_rec").is(':checked')) {
            $('input[name="cas_file"]').attr('required', true);
        } else {
            $('input[name="cas_file"]').removeAttr('required');
        }
    });

    $('input[name="tution_fee_paid"]').change(function () {
        if($("#tu_fee_no").is(':checked')) {
            $('input[name="tution_fee_paid_deadline"]').attr('required', true);
        } else {
            $('input[name="tution_fee_paid_deadline"]').removeAttr('required');
        }
    });

</script>
@endpush