@extends('backend.layouts.app')

@section('title', "Additional Services")

{{-- @section('toprightmenu')
<div class="btn-group" role="group" aria-label="Button group" style="float: right;">
    <div class="dropdown">
        <a class="btn btn-primary btn-sm dropdown-toggle" href="#" role="button" id="breadcrumb-dropdown-1" data-bs-toggle="dropdown" aria-expanded="true">Visa Applications</a>
        <div class="dropdown-menu dropdown-menu-end dropdown-menu-arrow" data-popper-placement="bottom-end" aria-labelledby="breadcrumb-dropdown-1">
            <a class="dropdown-item" href="{{ route('admin.visa.applications') }}">All Visa Applications</a>
            <a class="dropdown-item" href="{{ route('admin.deleted.visaApplication') }}">Deleted Visa Applications</a>
        </div>
    </div>
</div>
@endsection --}}

@section('content')
<div class="card">
    <div class="card">
        <div class="card-body" style="padding-left: 0px !important; padding-right: 0px !important;">
            <div class="row" style="padding-left: 20px !important; padding-right: 20px !important;">
                <div class="col-sm-5 col-9">
                    <h4 class="card-title mb-0">
                    Additional Services
                    <small class="text-muted"></small>
                    </h4>
                </div>
                <div class="col-sm-7 col-3">
                    <div class="btn-toolbar float-right" role="toolbar" aria-label="" style="margin-top: 20px;float: right;">
                        <button id="filter_toggle" class="btn btn-outline-primary btn-sm" title="Filters"><i class="bi bi-funnel-fill"></i></button>
                    </div>
                </div>
            </div>

        <div id="filters" class="mb-3 filterBox" style="display:none">
            <div class="row mt-2">
                <div class="col-md-3">
                     <div class="form-group">
                        <label for="" style="font-weight: normal !important;">Select Service</label>
                        <select class="form-control form-select" id="service_id" name="service_id" >
                            <option value="">Select</option>
                            @foreach(get_services_data() as $service)
                                <option @if(old('service_id') == $service->id) selected @endif value="{{$service->id}}">{{$service->service_name}}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <!-- <div class="col-md-3">
                    <div class="form-group">
                        <label for="">Select Status</label>
                        <select class="form-control form-select" id="status" name="status">
                            <option value="">Select</option>
                            @foreach(get_services_status_data() as $key => $serviceStatus)
                                <option @if(old('status') == $key) selected @endif value="{{$key}}">{{$serviceStatus}}</option>
                            @endforeach
                        </select>
                    </div>
                </div> -->
                 <div class="col-md-3">
                    <label for="" style="font-weight: normal !important;">Select Status</label>
                    <select class="form-select" id='service_status'>
                    </select>
                </div>
                <div class="col-sm-12 col-md-3">
                    <label for="" style="font-weight: normal !important;">Country</label>
                    <select class="form-select select2" style="width: 100%" id='country_search'>
                        <option value=''>Country</option>
                        @foreach($country_list as $each_country)
                        <option value="{{$each_country->id}}">{{$each_country->title_en}}</option>
                        @endforeach
                    </select>
                </div>
                @if(!\Auth::user()->can('view assigned data only'))
                    <div class="col-sm-12 col-md-3">
                        <label for="" style="font-weight: normal !important;">Assigned To</label>
                        <select class="form-select" name="assigned_to" id="assigned_to">
                            <option value="">Assigned To</option>
                            <option value="NULL">Unassigned</option>
                            @foreach($staff as $stf)
                            <option value="{{$stf->id}}">{{$stf->first_name.' '.$stf->last_name}}</option>
                            @endforeach
                        </select>
                    </div>
                @endif
                <div class="col-sm-12 col-md-3">
                    <label for="created_date" style="font-weight: normal !important;">Created Date</label>
                    <input type="text" autocomplete="off" class="form-control" id="created_date" name="created_date" placeholder="Created Date">
                </div>

                {{-- <div class="row mt-2 mb-3"> --}}
                    <div class="col-md-2 pt-0 pt-md-4">
                        <button onclick="javascript:searchTable();" class=" btn btn-primary btn-sm">Filter</button>
                        <button onclick="javascript:clearTable();" class=" btn btn-primary btn-sm">Clear</button>
                    </div>
                {{-- </div> --}}
            </div>
        </div>

        <div class="row">
            <div class="col">
                <div class="table-responsive">
                    <table class="table" id="visa_application_tbl">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th style="min-width: 100px">Date Created</th>
                                <th>Status</th>
                                <th>{{_label('backend_student')}}</th>
                                <th>Service</th>
                                <th>Country</th>
                                <th style="min-width: 115px">Description</th>
                                <th>Assigned to</th>
                                <th>Actions</th>
                                <th></th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push ('after-scripts')
<script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
<script src="{{ asset('assets/plugins/toast-master/js/jquery.toast.js') }}"></script>

<script type="text/javascript">
    $(document).ready(function() {
        $(".select2serv").select2({
            placeholder: "Select Service Status",
        });
        loadData();

        $('#filter_toggle').on('click', function() {
            $('#filters').toggle();
        });
        $('#service_id').on('change', function() {
            var service_id = this.value;
            $("#service_status").html('');
            $.ajax({
                url: "{{route('admin.service-and-visa.fetchStatus')}}",
                type: "POST",
                data: {
                    service_id: service_id,
                    _token: '{{csrf_token()}}'
                },
                dataType: 'json',
                success: function(result) {
                    $('#service_status').html('<option value="">Select Status</option>');
                    if(Array.isArray(result.status)){
                        $.each(result.status, function(key, value) {
                            $("#service_status").append('<option value="' + value.status_name + '">' + value.status_name + '</option>');
                        });
                    }
                }
            });
        });
    });

    var start = moment().subtract(29, 'days');
    var end = moment();
    $('#created_date').daterangepicker({
        "showDropdowns": true,
        "showWeekNumbers": true,
        "showISOWeekNumbers": true,
        autoUpdateInput: false,
        locale: {
            format: 'DD-MM-YYYY',
            "separator": " to ",
        },
        "ranges": {
            'Today': [moment(), moment()],
            'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
            'Last 7 Days': [moment().subtract(6, 'days'), moment()],
            'This Month': [moment().startOf('month'), moment().endOf('month')],
            'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
            },
        "alwaysShowCalendars": true,
    });
    $('#created_date').on('apply.daterangepicker', function(ev, picker) {
        $(this).val(picker.startDate.format('DD-MM-YYYY') + ' to ' + picker.endDate.format('DD-MM-YYYY'));
    });
    $('#created_date').on('cancel.daterangepicker', function(ev, picker) {
        $(this).val('');
    });

    function loadData() {
        $('#visa_application_tbl').DataTable({
            "dom": '<"row px-3"<"col-md-3 text-start"l><"col-md-5 text-start"f><"col-md-4 text-end"B>>rt<"ps-3"i><"pe-3"p>',
            processing: true,
            serverSide: true,
            "language": {
                searchPlaceholder: "Search..."
            },
            "lengthMenu": [10, 25, 50, 100],
            "order": [9, "desc"],
            "ajax": {
                "url": "{{route('admin.service-visa.ajaxapplicationdata')}}",
                "dataType": "json",
                "type": "post",
                data: {
                    '_token': $('meta[name="csrf-token"]').attr('content'),
                    'country': $('#country_search').val(),
                    'service_id': $('#service_id').val(),
                    'assigned_to': $('#assigned_to').val(),
                    'status': $('#service_status').val(),
                    'created_date': $('#created_date').val(),
                },
            },
            "drawCallback": function(settings) {
                addDeleteForms();
            },
            autoWidth: true,
            responsive: true,
            columns: [{
                    data: 'id',
                    orderable: false,
                },
                {
                    data: 'date',
                    // orderable: false,
                },
                {
                    data: 'status',
                    orderable: false,
                },
                {
                    data: 'name'
                },
                {
                    data: 'services',
                    orderable: false,
                },
                {
                    data: 'country'
                },
                {
                    data: 'details',
                    orderable: false,
                },
                {
                    data: 'assigned_to',
                    orderable: false,
                    //searchable: false,
                },
                {
                    data: 'action2',
                    orderable: false,
                },
                {
                    data: 'created_at',
                    visible: false,
                }
            ],
            "buttons": [{
                    extend: 'excel',
                    text: '<i class="ri-file-excel-2-line export-btn-size" ></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [1, 2, 3, 4, 5, 6, 7]
                    }
                },
                {
                    extend: 'pdf',
                    text: '<i class="bi bi-file-earmark-pdf"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [1, 2, 3, 4, 5, 6, 7]
                    }
                },
                {
                    extend: 'print',
                    text: '<i class="bi bi-printer"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [1, 2, 3, 4, 5, 6, 7]
                    }
                },
                {
                    extend: 'copy',
                    text: '<i class="ri-file-copy-2-line export-btn-size"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [1, 2, 3, 4, 5, 6, 7]
                    }
                },
                {
                    extend: 'csv',
                    text: '<i class="ri-file-excel-line export-btn-size"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [1, 2, 3, 4, 5, 6, 7]
                    }
                },
            ]
        });
    }

    function searchTable() {
        $("#visa_application_tbl").dataTable().fnDestroy();
        loadData();
    }

    function clearTable() {
        $('#country_search').val('');
        $("#country_search").val('').trigger('change');
        // $('#intake').val('');
        $('#service_id').val('');
        $('#assigned_to').val('');
        $('#service_status').val('');
        $('#created_date').val(''); 
        $("#visa_application_tbl").dataTable().fnDestroy();
        loadData();
    }

</script>
@endpush
@push ('after-styles')
<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
<style>
    .select2-container .select2-selection--single {
        height: 33px !important;
    }
</style>
@endpush