@extends('backend.layouts.app')
@section('title', "Visa and Application - Assign Staff")
@section('content')

<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-10 col-10">
                <h4 class="card-title mb-0">
                    Visa and Service - Assign Staff
                </h4><br>
            </div>
            <div class="col-sm-2 col-2" style="margin-top:20px;text-align: right;">
                <button type="cancel" name="back" class="btn btn-primary btn-sm" value="Back" onclick="document.location ='{{ route('admin.service-visa.list') }}'" title="Back"> <i class="fa fa-reply" aria-hidden="true"></i> </button>
            </div>
        </div>
        {{ html()->form('POST', route('admin.service-visa.assignstaff.store'))->class('form-horizontal')->attribute('enctype', 'multipart/form-data')->open() }}

        <input type="hidden" name="id" value="{{$serviceApplication->id}}">
        <div class="row mb-2">
            <div class="col-sm-12 col-md-6">
                @if($serviceApplication->appl_id)<span class="col-form-label"><b>ID: </b>{{$serviceApplication->appl_id}}</span><br>@endif
                @if($serviceApplication->service_id)<span class="col-form-label"><b>Service: </b>{{get_services($serviceApplication->service_id)}}</span><br>@endif
                @if($serviceApplication->country)<span class="col-form-label"><b>Country: </b>{{get_country_name($serviceApplication->country)}}@endif
            </div>
        </div>
        <div class="row">
            <div class="col-sm-12 col-md-6">
                <span class=""><b>User Name: </b>{{ $userdata->first_name }} {{$userdata->last_name }}</span><br>
                <span><b>User Email: </b>{{ $userdata->email }}</span>
                </div>
            </div>
        </div>

        <div class="row mb-2 mx-2">
            <div class="col-sm-12 col-md-4">
                <label class="col-form-label"><b>Assign To</b></label>
                <div class="">
                    <select class="form-select" id='staff' name="staff">
                        <option value=''>Select</option>
                             @foreach($staff as $stf)
                                <option value="{{$stf->id}}" {{($serviceApplication->assigned_to == $stf->id) ? 'selected' : ''}}>{{$stf->first_name . ' ' . $stf->last_name}}</option>
                            @endforeach
                    </select>
                </div>
            </div>
        </div>
            
        <div class="row mx-2 mb-3">
            <div class="col-sm-12 col-md-8">
                <div class="form-group mb-0 clearfix">
                    {{ form_submit("Save") }}
                    <button type="button" class="btn btn-secondary btn-sm" name="cancel" value="Cancel" onclick="document.location ='{{ route('admin.service-visa.list') }}'">Cancel</button>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
