@extends('backend.layouts.app')

@section('title', 'Settings: Visa Letter Types')

@section('content')
<div class="row">
    <div class="col" style="margin-bottom:10px;">
        <h4 style="">Visa Letter Types</h4>
    </div>
</div>
<div class="row">
    <div class="col-xl-12">

        <div class="card">
            <div class="card-body pt-3">
                <!-- Bordered Tabs -->

                <div class="row">
                    <div class="col-2">
                        <ul class="nav flex-column nav-tabs nav-tabs-bordered">
                            {!!get_settings_tabs('visa-letter-type')!!}
                        </ul>
                    </div>

                    <div class="col-10">
                        <div class="tab-content pt-4">
                            <div class="tab-pane fade active show" id="">
                                <div class="row">
                                    <div class="col-sm-9">
                                        <h4>Visa Letter Types</h4>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="btn-toolbar float-right" role="toolbar" aria-label="New Visa Letter Type" style="float: right;">
                                            <button class="btn btn-success btn-sm ml-1" data-bs-toggle="modal" data-bs-target="#create_modal" title="Add New Visa Letter Type"><i class="bi bi-plus-circle"></i></button>
                                        </div>
                                    </div>
                                </div>
                                <div class="row mt-2">
                                    <div class="col">
                                        <div class="table-responsive">
                                            <table class="table eductrl-datatable">
                                                <thead>
                                                    <tr>
                                                        <th>Title</th>
                                                        <th>Visa Type</th>
                                                        <th>Fees</th>
                                                        <th>Status</th>
                                                        <th>Display Order</th>
                                                        <th>Actions</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($types as $type)
                                                    <tr>
                                                        <td>{{ $type->title }}</td>
                                                        <td>{{ $type->service_type }}</td>
                                                        <td>{{config('app.currency_symbol')}}{{ $type->fees }}</td>
                                                        <td>{!! $type->status ? "<span class='badge badge-success'>Enabled</span>" : "<span class='badge badge-danger'>Disabled</span>" !!}</td>
                                                        <td>{{ $type->display_order }}</td>
                                                        <td>
                                                            <a href="javascript:void(0);" class="btn btn-primary btn-sm edit_row" data-bs-toggle="modal" data-bs-target="#edit_modal" data-id="{{$type->id}}" data-title="{{$type->title}}" data-service_type_id="{{$type->service_type_id}}" data-fees="{{$type->fees}}" data-display_order="{{$type->display_order}}" data-status="{{$type->status}}" data-action_url="{{route('admin.visa-letter-type.update', $type->id)}}">Edit</a>
                                                            <a href="{{ route('admin.visa-letter-type.destroy',$type->id)}}" data-method="delete" data-trans-button-cancel="Cancel" data-trans-button-confirm="Delete" data-trans-title="Are you sure?" class="btn btn-danger btn-sm" class="btn btn-primary"><i class="fa fa-trash"></i></a>
                                                        </td>
                                                    </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>

                                        </div>
                                    </div><!-- End Bordered Tabs -->

                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal" tabindex="-1" id="create_modal" role="dialog">
    <div class="modal-dialog" role="document">
        <form method="post" action="{{route('admin.visa-letter-type.store')}}" id="add_visa-letter-type">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Add New Visa Letter Type</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    @csrf
                    <div class="form-group">
                        <label>Visa Letter Type</label>
                        <input type="text" name="title" class="form-control" placeholder="Title" required>
                    </div>
                    <div class="form-group">
                        <select class="form-control form-select" name="service_type" required>
                            <option value="">Service Type</option>
                            @foreach($categories as $category)
                            <option value="{{$category->id}}">{{$category->title}}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group">
                        <label>Fees ({{config('app.currency_symbol')}})</label>
                        <input type="number" name="fees" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label>Display Order</label>
                        <input type="text" name="display_order" class="form-control" value="1" required>
                    </div>
                    <div class="form-group">
                        <select class="form-control form-select" name="status">
                            <option value="1">Enabled</option>
                            <option value="0">Disabled</option>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Add</button>
                </div>
            </div>
        </form>
    </div>
</div>


<div class="modal" tabindex="-1" id="edit_modal" role="dialog">
    <div class="modal-dialog" role="document">
        <form method="post" action="" id="edit_visa-letter-type">
            @method('PATCH')
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Edit Visa Letter Type</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    @csrf
                    <div class="form-group">
                        <label>Visa Letter Type</label>
                        <input type="text" name="title" id="edit_title" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <select class="form-control form-select" id="edit_service_type" name="service_type" required>
                            <option value="">Service Type</option>
                            @foreach($categories as $category)
                            <option value="{{$category->id}}">{{$category->title}}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group">
                        <label>Fees ({{config('app.currency_symbol')}})</label>
                        <input type="number" name="fees" id="edit_fees" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label>Display Order</label>
                        <input type="text" name="display_order" id="edit_display_order" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <select class="form-control form-select" id="edit_status" name="status">
                            <option value="1">Enabled</option>
                            <option value="0">Disabled</option>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Save</button>
                </div>
            </div>
        </form>
    </div>
</div>
@endsection

@push('after-scripts')
<script>
    $(document).ready(function() {
        $('.edit_row').click(function() {
            $('#edit_title').val($(this).data('title'));
            $("#edit_service_type").val($(this).data('service_type_id')).change();
            $('#edit_fees').val($(this).data('fees'));
            $('#edit_display_order').val($(this).data('display_order'));
            $("#edit_status").val($(this).data('status')).change();
            $('#edit_visa-letter-type').attr('action', $(this).data('action_url'));
        });
    });
</script>
@endpush