@extends('backend.layouts.app')

@section('title', 'Webinar & Events')

@section('content')
<div class="container">
    <div class="row">
        <div class="col-12">
            <div id="registration-message" class="alert alert-success d-none text-center mb-4 rounded-pill">
            🎉 You are registered!
        </div>

        <div class="col-12 mb-3" style="margin-top: -30px;">
            <h4 class="card-title mb-0"> 
                Upcoming Webinars & Events 
            </h4>
        </div>

        @if(count($pages))
        <div class="row row-cols-1 row-cols-md-2 g-4">
            @foreach($pages as $page)
            <div class="col">
                <div class="card card-sm h-100">
                    @if($page->image)
                    <img src="{{ asset('storage/' . $page->image) }}" class="card-img-top webinar-image" alt="Webinar Image">
                    @endif

                    <div class="card-body d-flex flex-column">
                        <h6 class="card-title text-center">{{ $page->topic }}</h6>
                        @php
                            $maxLength = 100;
                            $description = $page->description ?? '';
                            $shortDesc = \Illuminate\Support\Str::limit($description, $maxLength);
                        @endphp

                        {{-- <p class="description-text mb-2">
                            @if(strlen(strip_tags($description)) > $maxLength)
                                <span class="short-text">{{ $shortDesc }}</span>
                                <span class="full-text d-none">{{ $description }}</span>
                                <a href="#" class="toggle-description">Read more</a>
                            @else
                                <span>{{ $description }}</span>
                            @endif
                        </p> --}}
                        @if($description)
                            <p class="description-text mb-2">
                                <strong>📝 Description:</strong>
                                @if(strlen(strip_tags($description)) > $maxLength)
                                    <span class="short-text">{{ $shortDesc }}</span>
                                    <span class="full-text d-none">{{ $description }}</span>
                                    <a href="#" class="toggle-description">Read more</a>
                                @else
                                    <span>{{ $description }}</span>
                                @endif
                            </p>
                        @endif

                        {{-- <p class="text-muted mb-1"><strong>📍 Venue:</strong> {{ $page->venue ?? 'Online' }}</p> --}}
                        <p class="mb-1"><strong>📍 Venue:</strong> <span class="text-muted">{{ $page->venue ?? 'Online' }}</span></p>

                        {{-- @if($page->link)
                        <p class="text-muted mb-1" style="word-break: break-all;">
                            <strong>🔗 Link:</strong> <a href="{{ $page->link }}" target="_blank" class="text-decoration-none">{{ \Illuminate\Support\Str::limit($page->link, 40) }}</a>
                        </p>
                        @endif --}}
                    @if(auth()->user()->isAgent() && !empty($page->public_slug))
                        <p class="text-muted mb-1" style="word-break: break-all;">
                            <strong class="strong-bold">🔗 Public Link:</strong>
                            <input type="text" id="link-{{ $page->id }}" class="form-control form-control-sm d-inline-block w-auto" 
                                value="{{ url('webinar/' . $page->public_slug) }}" readonly style="width: 70%;">
                            <button onclick="copyLink({{ $page->id }})" class="btn btn-outline-secondary btn-sm">
                                Copy
                            </button>
                        </p>
                    @endif
                </div>

                    <div class="card-footer d-flex justify-content-between align-items-center">
                        <div>
                            <div class="text-muted">{{ date('d-m-Y', strtotime($page->date)) }}</div>
                            <div class="text-muted small">{{ date('h:i A', strtotime($page->date)) }}</div>
                        </div>

                        @if(in_array($page->id, $registeredWebinarIds ?? []))
                            <button class="btn btn-success btn-sm" disabled>
                                <i class="bi bi-check-circle me-1"></i> Registered
                            </button>
                        @else
                            <button class="btn btn-outline-primary btn-sm register-btn" data-id="{{ $page->id }}" onclick="registerWebinar(this)">
                                <i class="bi bi-plus-circle me-1"></i> Register
                            </button>
                        @endif
                    </div>
                </div>
            </div>
            @endforeach
        </div>
        @else
        <div class="alert alert-info text-center mt-4">
            No upcoming webinars found.
        </div>
        @endif
        </div>
    </div>
</div>
@endsection

@push('after-scripts')
<meta name="csrf-token" content="{{ csrf_token() }}">

<script src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script>
<script>
    axios.defaults.headers.common['X-CSRF-TOKEN'] = document.querySelector('meta[name="csrf-token"]').getAttribute('content');

    function registerWebinar(button) {
        const webinarId = button.getAttribute('data-id');
        button.disabled = true;

        axios.post("{{ route('admin.agent.webinar.register') }}", {
            webinar_id: webinarId
        })
        .then(response => {
            if (response.data.success) {
                button.classList.remove('btn-outline-primary');
                button.classList.add('btn-success');
                button.innerHTML = '<i class="bi bi-check-circle me-1"></i> Registered';

                const msg = document.getElementById('registration-message');
                if (msg && msg.classList.contains('d-none')) {
                    msg.classList.remove('d-none');
                }
            } else {
                alert("⚠️ " + response.data.message);
                button.disabled = false;
            }
        })
        .catch(error => {
            console.error(error);
            alert("❌ Error: " + (error.response?.data?.message || error.message));
            button.disabled = false;
        });
    }

    function copyLink(id) {
        const input = document.getElementById("link-" + id);
        input.select();
        input.setSelectionRange(0, 99999); // for mobile devices
        document.execCommand("copy");
        alert("Webinar link copied!");
    }

    document.addEventListener('DOMContentLoaded', () => {
        document.querySelectorAll('.toggle-description').forEach(link => {
            link.addEventListener('click', function(e) {
                e.preventDefault();
                const parent = this.closest('.description-text');
                const shortText = parent.querySelector('.short-text');
                const fullText = parent.querySelector('.full-text');

                if (fullText.classList.contains('d-none')) {
                    shortText.classList.add('d-none');
                    fullText.classList.remove('d-none');
                    this.textContent = 'Show less';
                } else {
                    shortText.classList.remove('d-none');
                    fullText.classList.add('d-none');
                    this.textContent = 'Read more';
                }
            });
        });
    });
</script>
@endpush

@push('after-styles')
<style>
    .webinar-image {
        height: 200px;
        width: 100%;
        object-fit: cover;
    }
</style>
@endpush