@extends('backend.layouts.app')
@section('title', "Add Webinar")
@section('content') 
<style>                            
    .error{color:#FF0000;}
</style>  

<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-10 col-10">
                <h4 class="card-title mb-0">
                    Add New Webinar/Event
                </h4><br>
            </div><!--col-->
            <div class="col-sm-2 col-2" style="margin-top:20px;text-align: right;">
                <button type="cancel" name="back" class="btn btn-sm btn-primary " value="Back" onclick="document.location ='{{ route('admin.webinar.index') }}'" title="Back">  <i class="fa fa-reply" aria-hidden="true"></i></button>
            </div>
        </div>       

        {{ html()->form('POST', route('admin.webinar.store'))->class('form-horizontal')->attribute('enctype', 'multipart/form-data')->open() }}

        <div class="form-group row mb-3">
            <div class="col-sm-8">       
            </div> 
        </div>
        <div class="form-group row mb-3">
            <div class="col-sm-8">       
            </div> 
        </div>

        <div class="form-group row mb-3">
            <label  class="col-sm-3 col-form-label">Topic<span class="error">*</span></label>
            <div class="col-sm-6">       
                <input type="text"  class="form-control" name="topic" value="{{ Request::old('topic') }}"  required>  
            </div> 
        </div> 

        <div class="form-group row mb-3">
            <label  class="col-sm-3 col-form-label">Banner<span class="error">*</span></label>
            <div class="col-sm-6">  
                <input type="file" name="image" class='form-control'maxlength="50"  value="" required/> 
            </div> 
        </div> 

        <div class="form-group row mb-3">
            <label  class="col-sm-3 col-form-label">Date<span class="error">*</span></label>
            <div class="col-sm-6"> 
                <input type="text" id="webinardatetimepicker" autocomplete="off" class="form-control" name="date" required/>
            </div> 
        </div> 

        <div class="form-group row mb-3">
            <label  class="col-sm-3 col-form-label">Mode/Venue<span class="error">*</span></label>
            <div class="col-sm-6">       
                <input type="text"  class="form-control" name="venue" value="{{ Request::old('venue') }}" required>  
            </div> 
        </div>

        <div class="form-group row mb-3">
            <label for="target_user_type" class="col-sm-3 col-form-label">Audience Type<span class="error">*</span></label>
            <div class="col-sm-6">
                <div class="input-group">
                    <select name="target_user_type" id="target_user_type" class="form-select" required>
                        <option value="" disabled selected>-- Select Audience Type --</option>
                        <option value="student" {{ old('target_user_type') == 'student' ? 'selected' : '' }}>Student</option>
                        <option value="agent" {{ old('target_user_type') == 'agent' ? 'selected' : '' }}>Agent</option>
                        <option value="student_agent" {{ old('target_user_type') == 'student_agent' ? 'selected' : '' }}>Student/Agent</option>
                    </select>
                </div>
            </div>
        </div>

        <div class="form-group row mb-3">
            <label for="notify_email" class="col-sm-3 col-form-label">Add Email</label>
            <div class="col-sm-6">
                <textarea class="form-control" id="notify_email" name="notify_email" id="notify_email" cols="30" rows="2" placeholder="Enter multiple email addresses to notify, separated by commas."></textarea>
            </div>
        </div>

        <div class="form-group row mb-3">
            <label  class="col-sm-3 col-form-label">Webinar Link</label>
            <div class="col-sm-6">       
                <input type="text"  class="form-control" name="link" value="{{ Request::old('link') }}"> 
            </div> 
        </div>

        <div class="form-group row mb-3">
            <label for="address" class="col-sm-3 col-form-label">Description</label>
            <div class="col-sm-6">   
                <textarea id="description" class="textarea_editor form-control" name ="description" value="{{ Request::old('description') }}" rows="5"></textarea>
            </div> 
        </div>

        <center>
            <div class="row" style="margin-top:50px;">
                <div class="col">
                    <div class="form-group mb-0 clearfix">
                        {{ form_submit("Submit") }}
                    </div>
                </div>  
            </div>
        </center>
        </form>
    </div>  
</div>
@endsection

@push('after-styles') 
<link href="{{ asset('assets/plugins/bootstrap-material-datetimepicker/css/bootstrap-material-datetimepicker.css')}}" rel="stylesheet"> 
@endpush 

@push('after-scripts')  
<script src="{{asset('assets/plugins/moment/moment.js')}}"></script>
<script src="{{asset('assets/plugins/bootstrap-material-datetimepicker/js/bootstrap-material-datetimepicker.js')}}"></script>
<script>
    // $('#datetime').bootstrapMaterialDatePicker({format: 'YYYY-MM-DD HH:mm:ss', minDate: new Date()});
    $('#webinardatetimepicker').datetimepicker({
        timepicker: true,
        format: 'd-m-Y H:i',
        formatTime: 'g:i A',
        step: 15,
    });
</script> 
@endpush