@extends('backend.layouts.app')

@section('title', "Webinar & Events")

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-5 col-5">
                <h4 class="card-title mb-0"> 
                    Webinar & Events  
                </h4>
            </div><!--col-->

            <div class="col-sm-7 col-7">
                <div class="btn-toolbar float-right" role="toolbar" style="margin-top: 20px;float: right;">
                    <a href="{{ route('admin.webinar.create') }}" class="btn btn-primary btn-sm ml-1" data-toggle="tooltip" title="Add New"><i class="bi bi-plus-circle"></i> Create</a>
                </div><!--btn-toolbar-->
            </div><!--col--> 
        </div><!--row--> 
        
        <div class="row mt-4">
            <div class="col">
                <div class="table-responsive" style="border: 1px solid rgb(244, 240, 240); border-radius: 6px;">
                    <table class="table table-striped bg-none mb-0">
                        <thead class="tableHeading">
                            <tr>
                                <th style="width:25%;">Topic</th>                                
                                <th>Date</th>
                                <th>Venue</th>
                                <th>Audience Type</th>
                                <th>Enrolled Users</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @if(count($pages))
                                @foreach($pages as $page)
                                <tr>
                                    <td>{{$page->topic}}</td>
                                    {{-- <td>{{get_date_time_formated($page->date)}}</td>  --}}
                                    <td>{{date("d-m-Y h:i A", strtotime($page->date))}}</td> 
                                    <td>{{$page->venue}}</td>    
                                    <td>{{
                                        $page->target_user_type === 'student_agent'
                                            ? 'Student / Agent'
                                            : ucfirst($page->target_user_type ?? 'N/A')
                                    }}</td>
                                    <td>{{get_student_count_for_webinar($page->id)}}</td>   
                                    <td>
                                        <div class="" aria-label="User Actions">
                                            <a style="height"  href="{{route('admin.webinar.view',$page->id)}}" data-placement="top" title="View" class="btn btn-outline-info"><i class="ri-eye-fill"></i></a>
                                            <a style="height" href="{{route('admin.webinar.edit',$page->id)}}" data-toggle="tooltip" data-placement="top" title="Edit" class="btn btn-outline-primary"><i class="bx bx-edit"></i></a>             
                                            <a style="height"  href="{{route('admin.webinar.details', [$page->id, $page->target_user_type])}}" data-toggle="tooltip" data-placement="top" title="Users" class="btn btn-outline-success"><i class="ri-team-fill"></i></a>
                                            <a style="height" href="{{route('admin.webinar.destroy',$page->id)}}"  class="btn btn-outline-danger" data-toggle="tooltip" data-placement="top" title="Delete" 
                                                data-method="delete"
                                                data-trans-button-cancel="Cancel"
                                                data-trans-button-confirm="Delete"
                                                data-trans-title="Are you sure you want to do this?"
                                                class="dropdown-item"><i class="bx bxs-trash" aria-hidden="true"></i>
                                            </a> 
                                        </div>

                                    </td>
                                </tr>
                                @endforeach
                            @else
                                <tr>
                                    <td class="text-center" colspan="6">No data available in table</td>
                                </tr>
                            @endif
                        </tbody>
                    </table>
                </div>
            </div> 
        </div>    
        <div class="row">
            <div class="col-6">
                <div class="float-left">

                </div>
            </div><!--col-->

            <div class="col-6">
                <div class="float-right">
                </div>
            </div><!--col-->
        </div><!--row-->
    </div><!--card-body-->
</div><!--card-->
@endsection
@push('after-scripts')
<script>
    addDeleteForms();
</script>
@endpush