@extends('backend.layouts.app')
@section('title', "Edit Webinar")
@section('content') 
<style>                            
    .error{color:#FF0000;}
</style>  
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-10">
                <h4 class="card-title mb-0">
                    Edit Webinar/Event
                </h4><br>
            </div><!--col-->
            <div class="col-sm-2 col-2" style="margin-top:20px;text-align: right;">
                <button type="cancel" name="back" class="btn btn-sm btn-primary " value="Back" onclick="document.location ='{{ route('admin.webinar.index') }}'" title="Back">  <i class="fa fa-reply" aria-hidden="true"></i></button>
            </div>
        </div><!--row--> 

        {{ html()->form('POST', route('admin.webinar.update', $page->id))->class('form-horizontal')->attribute('enctype', 'multipart/form-data')->open() }}

        <div class="form-group row mb-3">
            <label  class="col-sm-3 col-form-label">Topic<span class="error">*</span></label>
            <div class="col-sm-6">       
                <input type="text"  class="form-control" name="topic" value="{{$page->topic}}"  required>  
            </div> 
        </div>   

        <div class="form-group row mb-3">
            <label  class="col-sm-3 col-form-label">Banner<span class="error">*</span></label>
            <div class="col-sm-6">     
                <img src="{{asset('/storage/'.$page->image)}}" width="300">
                <input type="file" name="image" class='form-control'maxlength="50"  value="{{$page->image}}"/> 
            </div> 
        </div> 


        <div class="form-group row mb-3">
            <label  class="col-sm-3 col-form-label">Date<span class="error">*</span></label>
            <div class="col-sm-6"> 
                <input type="text" id="webinardatetimepicker" class="form-control" name="date" value="{{ $page->date }}" required/>
            </div> 
        </div>

        <div class="form-group row mb-3">
            <label  class="col-sm-3 col-form-label">Mode/Venue<span class="error">*</span></label>
            <div class="col-sm-6">       
                <input type="text"  class="form-control" name="venue" value="{{$page->venue}}" required>  
            </div> 
        </div>

        <div class="form-group row mb-3">
            <label for="target_user_type" class="col-sm-3 col-form-label">Audience Type<span class="error">*</span></label>
            <div class="col-sm-6">
                <div class="input-group">
                    <select name="target_user_type" id="target_user_type" class="form-select" required>
                    <option value="" {{ empty($page->target_user_type) ? 'selected' : '' }}>-- Select Audience Type --</option>
                        <option value="student" {{ old('target_user_type', $page->target_user_type) == 'student' ? 'selected' : '' }}>Student</option>
                        <option value="agent" {{ old('target_user_type', $page->target_user_type) == 'agent' ? 'selected' : '' }}>Agent</option>
                        <option value="student_agent" {{ old('target_user_type', $page->target_user_type) == 'student_agent' ? 'selected' : '' }}> Student/Agent</option>
                    </select>
                </div>
            </div>
        </div>

        <div class="form-group row mb-3">
            <label  class="col-sm-3 col-form-label">Webinar Link</label>
            <div class="col-sm-6">       
                <input type="text"  class="form-control" name="link" value="{{$page->link}}"> 
            </div> 
        </div>

        <div class="form-group row mb-3">
            <label for="address" class="col-sm-3 col-form-label">Description</label>
            <div class="col-sm-6">   
                <textarea id="description" class="textarea_editor form-control" name ="description" value="{{$page->description}}" rows="5">{{$page->description}}</textarea>
            </div> 
        </div> 

        <center>
            <div class="row" style="margin-top: 50px;">
                <div class="col">
                    <div class="form-group mb-1 clearfix">
                        {{ form_submit("Update") }}
                        <button type="button" class="btn btn-primary btn-sm" name="cancel" value="Cancel" onclick="document.location ='{{ route('admin.webinar.index') }}'">Cancel</button>
                    </div>  
                </div>
            </div>
        </center>
        </form>
    </div>  
</div>
@endsection

@push('after-styles') 
<link href="{{ asset('assets/plugins/bootstrap-material-datetimepicker/css/bootstrap-material-datetimepicker.css')}}" rel="stylesheet">
@endpush 

@push('after-scripts')   
<script src="{{asset('assets/plugins/moment/moment.js')}}"></script>
<script src="{{ asset('assets/plugins/bootstrap-material-datetimepicker/js/bootstrap-material-datetimepicker.js')}}"></script>
<script>
    // $('#datetime').bootstrapMaterialDatePicker({format: 'YYYY-MM-DD HH:mm:ss'});
    $('#webinardatetimepicker').datetimepicker({
        timepicker: true,
        format: 'd-m-Y H:i',
        formatTime: 'g:i A',
        step: 15,
    });
</script> 
@endpush