@extends('backend.layouts.app')

@section('title', "Webinar Registered Users")

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-10 col-10">
                <h4 class="card-title mb-0">
                    Webinar: {{ $webinar->topic }}
                </h4>
                <h6>Registered {{ucwords(str_replace("_", " ", $webinarType))}}</h6>
            </div>
            <div class="col-sm-2 col-2" style="margin-top:20px;text-align: right;">
                <button type="button" class="btn btn-sm btn-primary" onclick="document.location ='{{ route('admin.webinar.index') }}'" title="Back">
                    <i class="fa fa-reply" aria-hidden="true"></i>
                </button>
            </div>
        </div>

        <div class="row mt-4">
            <div class="col">
                <div class="table-responsive">
                    <table class="table eductrl-datatable">
                        <thead>
                            <tr> 
                                <th>{{ucwords(str_replace("_", " ", $webinarType))}} Name</th>
                                <th>Email</th>
                                <th>Phone</th>
                                <th>Type</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($data as $datas)
                            <tr>
                                <td>
                                    <a href="{{ route('admin.auth.user.show', $datas->id) }}" target="_blank">
                                        <i class="fa fa-user"></i> <b>{{ ucwords($datas->first_name) }} {{ ucwords($datas->last_name) }}</b>
                                    </a>
                                </td>
                                <td><i class="fa fa-envelope"></i> {{ $datas->email }}</td>
                                <td>+{{ $datas->dialcode }}-{{ $datas->mobile }}</td>
                                <td><span class="badge badge-success">{{ $datas->type }}</span></td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div> 
        </div>    
        <div class="row">
            <div class="col-6">
                <div class="float-left">

                </div>
            </div><!--col-->

            <div class="col-6">
                <div class="float-right">
                </div>
            </div><!--col-->
        </div><!--row-->
    </div><!--card-body-->
</div><!--card-->
@endsection
