@extends('backend.layouts.app')
@section('title', "View Page")
@section('content') 

<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-10 col-10">
                <h4 class="card-title mb-0">
                    Webinar Details
                </h4><br>
            </div><!--col--> 
            <div class="col-sm-2 col-2" style="margin-top:20px;text-align: right;">
               <button type="cancel" name="back" class="btn btn-sm btn-primary " value="Back" onclick="document.location ='{{ route('admin.webinar.index') }}'" title="Back">  <i class="fa fa-reply" aria-hidden="true"></i></button>
            </div>

        </div><!--row-->     

        <div class="form-group row">
            <label  class="col-sm-3 col-form-label">Topic</label>
            <div class="col-sm-6">
                <label value="{{$webinars->topic}}">{{$webinars->topic}}</label>
            </div>
        </div> 

        <div class="form-group row">
            <label  class="col-sm-3 col-form-label">Image</label>
            <div class="col-sm-6">       
                <label name="image" value="{{ $webinars->image}}"> <img src="{{asset('/storage/'.$webinars->image)}}" width="500">
                </label>  
            </div> 
        </div> 

        <div class="form-group row">
            <label  class="col-sm-3 col-form-label">Date</label>
            <div class="col-sm-6">       
                <label name="date" value="{{ $webinars->date}}">{{ $webinars->date}}</label>  
            </div> 
        </div> 

        <div class="form-group row">
            <label  class="col-sm-3 col-form-label">Venue</label>
            <div class="col-sm-6">
                <label value="{{$webinars->venue}}">{{$webinars->venue}}</label>
            </div>
        </div>
        <div class="form-group row">
            <label  class="col-sm-3 col-form-label">Copy Webinar Link</label>
            <div class="col-9">
                <p class="text-muted mb-1" style="word-break: break-all;">
                    <input type="text" id="link-{{$webinars->id}}" class="form-control form-control-sm d-inline-block w-auto" 
                        value="{{ url('webinar/' . $webinars->public_slug) }}" readonly style="width: 75% !important;">
                    <button onclick="copyLink({{ $webinars->id }})" class="btn btn-outline-primary btn-sm">Copy</button>
                </p>
            </div>
        </div>

        <div class="form-group row">
            <label class="col-sm-3 col-form-label">Audience Type</label>
            <div class="col-sm-6">
                <label>
                    @if($webinars->target_user_type === 'student_agent')
                        Student / Agent
                    @else
                        {{ ucfirst($webinars->target_user_type) }}
                    @endif
                </label>
            </div>
        </div>

        <div class="form-group row">
            <label  class="col-sm-3 col-form-label">Webinar Link</label>
            <div class="col-sm-6">
                <label value="{{$webinars->link}}">{{$webinars->link}}</label>
            </div>
        </div>

        <div class="form-group row">
            <label  class="col-sm-3 col-form-label">Description</label>
            <div class="col-sm-6">
                <label value="{{$webinars->description}}">{{$webinars->description}}</label>
            </div>
        </div>
        <div class="form-group row">
            <label  class="col-sm-3 col-form-label">Notified Email</label>
            <div class="col-sm-6">
                <label value="{{$webinars->notify_email}}">{{$webinars->notify_email ? $webinars->notify_email : "--"}}</label>
            </div>
        </div>
        </form>
    </div>  
</div>
@endsection

@push('after-scripts')
<script>
    function copyLink(id) {
        const input = document.getElementById("link-" + id);
        input.select();
        input.setSelectionRange(0, 99999); // for mobile devices
        document.execCommand("copy");
        alert("Webinar link copied!");
    }
</script>
@endpush