@extends('backend.layouts.app')

@section('title', "Edit Whatsapp Template")

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-5">
                <h4 class="card-title mb-0">
                    Edit Whatsapp Template
                </h4>
            </div><!--col-->
        </div><!--row-->    

        <div class="row mt-4">
            <div class="col-md-8">
                {{ html()->form('POST', route('admin.whatsapptemplates.update', $template->hook))->class('form-horizontal')->attribute('enctype', 'multipart/form-data')->open() }}
                @method('PATCH')
                <div style="margin-top:10px;">
                    <div class="form-group mb-3">
                        <label>Whatsapp Template:</label>
                        {{ $template->hook }}
                    </div> 

                    @if(get_site_config('whatsapp_provider')=='whatsapp_cloud_api' )
                    <div class="row">
                        <div class="col-lg-6">
                            <div class="form-group mb-3">
                                <label for="media_type">Media Type (optional)</label>
                                <select name="media_type" id="media_type" class="form-control form-select">
                                    <option value="">-- Select Type --</option>
                                    <option value="image" {{ $template->media_type=='image'?'selected':'' }}>Image</option>
                                    <option value="video" {{ $template->media_type=='video'?'selected':'' }}>Video</option>
                                    <option value="document" {{ $template->media_type=='document'?'selected':'' }}>Document</option>
                                </select>
                            </div>
                        </div>

                        <div class="col-lg-6">
                            <div class="form-group mb-3">
                                <label for="media_file">Upload File (optional)</label>
                                <input type="file" name="media_file" id="media_file" class="form-control">
                                <small class="form-text text-muted">Upload a new file to replace existing media.</small>
                            </div>

                            @if($template->media_file)
                            <div class="form-group mb-3">
                                <label>Existing Media:</label><br>
                                @if($template->media_type == 'image')
                                    <img src="{{ asset('storage').'/'.$template->media_file }}" style="max-width:150px;">
                                @endif
                                @if($template->media_type == 'video')
                                    <video src="{{ asset('storage').'/'.$template->media_file }}" controls style="max-width:150px;"></video>
                                @endif
                                 @if($template->media_type == 'document')
                                    <a style="color: #0d6efd;" href="{{ asset('storage').'/'.$template->media_file }}" target="_blank">View Document</a>
                                @endif
                            </div>
                            @endif
                        </div>
                    </div>
                    @endif
      
                    <div class=" mb-3" style="width:80vw;">

                        <div class="row">
                            <div class="col-8">
                                <div class="form-group mb-4">
                                    <label>Message</label>
                                    <textarea name='message' id="message" rows="5" class="form-control" required>{!! $template->message !!}</textarea>
                                    <p><strong>Notes:</strong>
                                    <br />Max 1024 characters
                                    <br />Variable that you can use in the above message are: 
                                    <?php
                                    if(strlen($template->variables)) {
                                        $variables = "{{".$template->variables."}}";
                                        $variables = str_replace(",", "}}, {{", $variables);
                                        echo $variables;
                                    }
                                    ?>
                                    </p>
                                </div>
                            </div>
                            <div class="col-4">
                                <div class="container">
                                    <div class="">
                                        <div class=" text-start ">
                                            <label>Rephrase Message using AI <img class="mb-4 ms-1" src="{{asset('assets/backend/img/creative.png')}}"></label>
                                        </div>
                                        <div class="mt-2">
                                            <!-- Tone selection and rephrase button -->
                                            <div class="form-group  row">
                                                <div class="col-md-8">
                                                    <select name="tone" id="tone"
                                                        class="form-control form-select">
                                                        <option value="Neutral">Neutral Tone</option>
                                                            <option value="Professional">Professional Tone</option>
                                                        <!-- Additional tone options can go here -->
                                                    </select>
                                                </div>
                                                <div class="col-md-4">
                                                    <div class="btn btn-primary btn-block"
                                                        onclick="getRephrasedMessage()">
                                                        Rephrase</div>

                                                </div>
                                            </div>

                                            <!-- Message area for loading or error messages -->
                                            <div class="form-group">
                                                <small id="buffer" class="form-text text-muted"
                                                    style="display: none;">Please
                                                    wait...</small>
                                                <div class="alert" id="response-alert" style="display: none;"></div>
                                            </div>

                                            <!-- Rephrased message textarea -->
                                            <div class="form-group" id="rephrasedContainer" style="display: none;">
                                                <label class="font-weight-bold">Rephrased Message</label>
                                                <textarea class="form-control" style="background-color: rgb(255, 255, 255)" id="rephrasedMessage" name="rephrasedMessage" rows="10" readonly></textarea>

                                                <!-- Copy button -->
                                                <div class="text-start">
                                                    <div class="btn btn-sm" onclick="copyText()">
                                                        <i class="fas fa-copy"></i> Copy
                                                    </div>
                                                </div>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>                 
                    
                    <div class="form-group mb-3">
                        <label>Whatsapp message template on Whatsapp API provider must be as below. For Aisensy use variables as @{{1}} @{{2}} @{{3}} ...</label>
                        <p id="sample_text" style="background:#efefef; border: 1px solid #ced4da; min-height:80px; padding:8px; white-space:pre-line; border-radius:4px;"></p>
                    </div>
                    <div class="row">
                        <div class="col-md-12 mt-4">
                            <p>* On Whatsapp API provider portal, you can add emojis to the above message content.<br>You can also attach media files to the message.
                                You can refer the API provider documentation for making text bold. Ex: Put asterisks (*) at the start and end of the phrase (Text) to make text bold. Underscores for Italics (_Text_). Tilde for Strikethrough (strikethroughText).</p>
                                <p style="color:red;">* Use the template languages as "English" for your template</p>
                               <p>* The actual message sent is, as defined in the API provider portal.
                            </p>
                        </div>
                    </div>
                    <div class="form-group" style="text-align: center;margin-top:10px;">
                        {{ form_submit("Save") }}
                        <a href="{{route('admin.whatsapptemplates')}}" class="btn btn-secondary btn-sm" title="Cancel">  Cancel
                        </a>                            
                    </div>
                    {{ html()->form()->close() }}  
                </div>
            </div>
        </div>
        
       
    </div>
</div>
@endsection     
@push('after-scripts')
<script>
    $(document).ready(function () {
        getMessage();
      $('#message').on('keyup', function() {
        getMessage();
      });

      function getMessage(){
            var msg = $('#message').val();
            var re = /#(\S+)#/g, match, matches = [];
            while (match = re.exec(msg)) {
                matches.push(match[0]);
                msg = msg.replace(match[0], "@{{"+matches.length+"}}");
            }
            $('#sample_text').text(msg);
        }

        $('#media_type').on('change', function () {
            if ($(this).val()) {
                $('#media_file').attr('required', true);
            } else {
                $('#media_file').removeAttr('required');
            }
        });
    });

    const alertDiv = document.getElementById('response-alert');
        const rephraseDiv = document.getElementById('rephrasedContainer');
        const rephraseMessage = document.getElementById('rephrasedMessage');
        const buffer = document.getElementById('buffer');
        const tone = document.getElementById('tone');

        function getRephrasedMessage() {
            buffer.style.display = 'block';
            rephraseDiv.style.display = 'none';
            alertDiv.style.display = 'none';
            $.ajax({
                url: "{{ route('admin.ai_rephrase.openapi.call') }}",
                type: "POST",
                data: {
                    message: document.getElementById('message').value,
                    tone: tone.value,
                    _token: '{{ csrf_token() }}'
                },
                dataType: 'json',
                success: function(response) {
                    if (response.status === 'success') {
                        buffer.style.display = 'none';
                        rephraseMessage.value = response.rephrased_message;
                        rephraseDiv.style.display = 'block';
                    } else if (response.status === 'failed') {
                        buffer.style.display = 'none';
                        alertDiv.innerHTML = response.message; // Set the message
                        alertDiv.className =
                            'alert alert-danger'; // Add Bootstrap success class
                        alertDiv.style.display = 'block'; // Show the alert

                    } else {
                        alertDiv.innerHTML =
                            "There was an issue saving your data. Please try again."; // Set the message
                        alertDiv.className =
                            'alert alert-warning'; // Add Bootstrap success class
                        alertDiv.style.display = 'block'; // Show the alert

                    }
                },
                error: function(xhr) {
                    if (xhr.status === 422) { // Laravel validation error
                        const errors = xhr.responseJSON.errors;
                        let errorMessage = '\n';
                        for (const field in errors) {
                            errorMessage += `${errors[field][0]}\n`;
                        }
                        alert(errorMessage);
                    } else {
                        alert("An error occurred. Please try again.");
                    }
                }
            });
        }

        function copyText() {
            var textarea = $("#rephrasedMessage")[0];

            // Select the text field
            textarea.select();
            textarea.setSelectionRange(0, 99999); // For mobile devices

            // Copy the text inside the text area
            document.execCommand("copy");

            // Alert or display a success message
            alertDiv.innerHTML = "Message copied to clipboard!"; // Set the message
            alertDiv.className =
                'alert alert-success'; // Add Bootstrap success class
            alertDiv.style.display = 'block'; // Show the alert

        }
  </script>
@endpush   
