@extends('backend.layouts.app')
@section('title', "Add New Zone")
@section('content')
<div class="card">
  <div class="card-body">
    <div class="row">
      <div class="col-sm-10 col-10">
        <h4 class="card-title mb-0">
          Add New Zone
        </h4>
      </div>
      <!--col-->
      <div class="col-sm-2 col-2" style="margin-top:20px;text-align: right;">
        <a href="{{ route('admin.zones') }}" class="btn btn-sm btn-primary" title="Back"> <i class="fa fa-reply" aria-hidden="true"></i> </a>
      </div>
    </div>
    <!--row-->

    <div class="row mt-4">
      <div class="col-md-12">
        <form action="{{route('admin.zone.save-zone')}}" method="POST">
          @csrf
          <div class="form-group row">
            <label for="exampleInputUsername2" class="col-sm-2 col-form-label"><strong>Name</strong> <span style="color: red;"> *</span> </label>
            <div class="col-sm-10 col-md-6">
              <input type="text" class="form-control  form-width" name="zonename" id="exampleInputUsername2" value="{{ old('zonename') }}" placeholder="Enter Name" required>
            </div>
          </div>

          <div class="form-group row">
            <label for="country-type" class="col-sm-2 col-form-label"><strong>Type</strong> <span style="color: red;"> *</span> </label>
            <div class="col-sm-10 col-md-6">
              <select class="form-control form-select" id="country-type" name="country-type" required>
                <option value="">Select</option>
                <option value="single">Single Country</option>
                <option value="multiple">Multiple Countries</option>
              </select>
            </div>
          </div>

          <div class="form-group row d-none" id="multiple">

            <div class="col-md-2"></div>
            <div class="col-md-6">
            <select class="form-control select2" data-placeholder="Select country" id="mul_country" multiple="multiple" name="country[]" style="width:100%;">
              @foreach ($items as $key => $value)
              <option value="{{ $key }}">{{ $value }}</option>
              @endforeach
            </select>
            {{-- <select class="form-control multiselectt" id="mul_country" multiple="multiple" name="country[]" style="height: 250px;overflow-y: scroll;">
                                <option value="">Select country</option>
                                    @foreach ($items as $key => $value)
                                      <option value="{{ $key }}" >{{ $value }}</option>
            @endforeach
            </select> --}}
            </div>
          </div>

          <div id="single" class="d-none">
            <div class="form-group row">
              <div class="col-md-2"></div>
              <div class="col-sm-12 col-md-4">
                <select class="form-control select2" data-placeholder="Select country" id="country-dd" name="single_country" style="width:100%;height: 250px;overflow-y: scroll;">
                  <option value="">Select country</option>
                  @foreach ($items as $key => $value)
                  <option value="{{ $key }}">{{ $value }}</option>
                  @endforeach
                </select>
              </div>

              <div id="state" class="col-sm-12 col-md-6 d-none">
                <select class="form-control select2" data-placeholder="Select State" id="state-dd" multiple="multiple" name="states[]" style="width:100%;">
                </select>
              </div>

              <div id="coun_error" class="mt-5" style="display:none;text-align: center;">
                <b class="alert alert-danger" style="color: red;"> Country and State Feild is Required.</b>
              </div>
            </div>
          </div>

          <div class="col-lg-6 col-sm-12 mt-5">
            <button class="btn btn-primary" onclick="return validateform()" type="submit">Create </button>
            <a href="{{ route('admin.zones') }}" class="btn btn-outline-secondary" type="submit">Cancel</a>
          </div>

      </div>
    </div>


    </form>
  </div>
</div>
<!--col-->
</div>
<!--row-->
</div>
</div>
@endsection
@push ('after-styles')
<style>


</style>

{{-- <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-multiselect/0.9.13/css/bootstrap-multiselect.css" type="text/css"/>
<style type="text/css">
    .multiselect{
        border: 1px solid #bdb9b9;
    }
</style> --}}
@endpush
@push ('after-scripts')
{{-- <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-multiselect/0.9.13/js/bootstrap-multiselect.js"></script> --}}
<script type="text/javascript">
  // $(document).ready(function() {
  //   $('.multiselectt').multiselect({ buttonWidth: '400px' }); 
  // }); 

  $('#country-dd').on('change', function() {
    var idCountry = this.value;
    $.ajax({
      url: "{{route('fetchState')}}",
      type: "POST",
      data: {
        country_id: idCountry,
        _token: '{{csrf_token()}}'
      },
      dataType: 'json',
      success: function(result) {
        $('#state').removeClass('d-none');
        // $('#state-dd').html('<option value="">Select State</option>');
        $.each(result.states, function(key, value) {
          $("#state-dd").append('<option value="' + value.id + '">' + value.name + '</option>');
        });
        //  $('.multiselect1').multiselect({ buttonWidth: '400px' });
        // $('#city-dd').html('<option value="">Select City</option>');
      }
    });
  });

  $('#country-type').on('change', function() {
    var type = $('#country-type').val();
    if (type == 'single') {
      $('#single').removeClass('d-none');
      $('#multiple').addClass('d-none');
    } else if (type == 'multiple') {
      $('#multiple').removeClass('d-none');
      $('#single').addClass('d-none');
    }
  });


  function validateform() {
    var val = $('#country-type').val();
    //alert(val);
    if (val == "single") {
      var coun = $('#country-dd').val();
      var state = $('#state-dd').val();
      if (coun == '' || state == null) {
        $("#coun_error").show();
        return false;
      }
    } else if (val == "multiple") {
      // alert($('#mul_country').val()); 
      var mul_country = $('#mul_country').val();
      if (mul_country == null) {
        $("#mul_country_error").show();
        return false;
      }

    }
    return true;
  }
</script>
@endpush