@extends('backend.layouts.app')
@push('after-styles')
<link rel="stylesheet" href="{{ asset('assets/plugins/html5-editor/bootstrap-wysihtml5.css') }} " />
@endpush
@push('after-scripts')
    <script src="{{ asset('assets/plugins/html5-editor/wysihtml5-0.3.0.js') }}"></script>
    <script src="{{ asset('assets/plugins/html5-editor/bootstrap-wysihtml5.js') }}"></script>
    <script>
    $(document).ready(function() {
        $('.textarea_editor').wysihtml5();
    });
    </script>
@endpush
@section('title', "View Zone")

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-10">
                <h4 class="card-title mb-0">
                    View Zone
                </h4>
            </div>
            <div class="col-2">
              <!-- <button class="btn btn-primary" onclick="return validateform()"  type="submit">Create </button> -->
              <a href="{{ route('admin.zones') }}" class="btn btn-primary mt-3 float-end " type="submit"><i class="fa fa-reply" aria-hidden="true"></i> </a>
          </div>
            <!--/.col-->
        </div>
      
        <!--/.row-->
        <div class="tab-content mt-3" id="myTabContent">
            <form action="" method="POST">
                @csrf          
                <div class="form-group row">
                  <label for="exampleInputUsername2" class="col-sm-2 col-form-label"><strong>Name</strong>  </label>
                  <div class="col-sm-10">
                    <input type="text" class="form-control  form-width" name="zonename" id="exampleInputUsername2" value="{{ $details->zone_name }}" placeholder="Enter Name"  required disabled>
                  </div>
                </div>

                <div class="form-group row">
                  <label for="country-type" class="col-sm-2 col-form-label"><strong>Country Type</strong>  </label>
                  <div class="col-sm-10">
                  <select class="form-control  form-width" id="country-type" name="country-type"
                   required disabled>
                           <option value="">Select Country Type</option>
                           <option value="single" <?php if($type=="single"){ ?> selected <?php }?> >Single Country Type</option>
                           <option value="multiple" <?php if($type=="multiple"){ ?> selected <?php }?> >Multiple Countries Type</option>
                    </select>
                  </div>
                </div>

                <?php if($type == "multiple"){
                  ?>
                  <div class="form-group row">
                    <label for="country-type" class="col-sm-2 col-form-label"><strong>States</strong>  </label>
                    <div class="col-sm-10">
                        <div class=" form-control  form-width" style="background: #e9ecef;">
                      <?php
                      foreach ($counts as $state) {
                        ?>
                        {{$state->title_en}},
                      <?php }
                   
                    ?>
                      </div>
                    </div>
                </div>
                <?php }else{?>
                <div class="form-group row">
                  <label for="country-type" class="col-sm-2 col-form-label"><strong>Country</strong>  </label>
                  <div class="col-sm-10">
                  <select class="form-control  form-width" id="country-type" name="country-type"
                   required disabled>
                          <option>{{$cun_name->title_en}}</option> 
                    </select>
                  </div>
                </div>
                <div class="form-group row">
                  <label for="country-type" class="col-sm-2 col-form-label"><strong>States</strong>  </label>
                  <div class="col-sm-10">
                      <div class=" form-control  form-width" style="background: #e9ecef;">
                    <?php
                    foreach ($states as $state) {
                      ?>
                      {{$state}},
                    <?php }
                 
                  ?>
                    </div>
                  </div>
                </div>
                  <?php  } ?>
                </div>
                </div>
                
              </form>
        </div>
    </div>
</div>
@endsection

@push('after-styles')
<style type="text/css">
    /* .wrapper {
  width: 100%;
  height: 100%;
}
.drop {
  width: 96%;
  height: 96%;
  border: 3px divashed #DADFE3;
  border-radius: 15px;
  overflow: hidden;
  text-align: center;
  background: white;
  -webkit-transition: all 0.5s ease-out;
  -moz-transition: all 0.5s ease-out;
  transition: all 0.5s ease-out;
  margin: auto;
  position: absolute;
  top: 0;
  left: 0;
  bottom: 0;
  right: 0;

}
.drop .cont {
  width: 500px;
  height: 170px;
  color: #8E99A5;
  -webkit-transition: all 0.5s ease-out;
  -moz-transition: all 0.5s ease-out;
  transition: all 0.5s ease-out;
  margin: auto;
  position: absolute;
  top: 0;
  left: 0;
  bottom: 0;
  right: 0;
} */
/* .drop .cont i {
  font-size: 400%;
  color: #8E99A5;
  position: relative;
}
.drop .cont .tit {
  font-size: 400%;
  text-transform: uppercase;
}
.drop .cont .desc {
  color: #A4AEBB;
}
.drop .cont .browse {
  margin: 10px 25%;
  color: white;
  padding: 8px 16px;
  border-radius: 5px;
  background: #09f;
}
.drop input {
  width: 100%;
  height: 100%;
  cursor: pointer;
  background: red;
  opacity: 0;
  margin: auto;
  position: inherit;
  top: 0;
  left: 0;
  bottom: 0;
  right: 0;
} */

/* #list {
  width: 100%;
  text-align: left;
  position: absolute;
  left: 0;
  top: 0;
}
#list .thumb {
  height: 75px;
  border: 1px solid #323a44;
  margin: 10px 5px 0 0;
} */
</style>
@endpush

@push ('after-scripts')
<script type="text/javascript">
    var drop = $("input");
drop.on('dragenter', function (e) {
  $(".drop").css({
    "border": "4px dashed #09f",
    "background": "rgba(0, 153, 255, .05)"
  });
  $(".cont").css({
    "color": "#09f"
  });
}).on('dragleave dragend mouseout drop', function (e) {
  $(".drop").css({
    "border": "3px dashed #DADFE3",
    "background": "transparent"
  });
  $(".cont").css({
    "color": "#8E99A5"
  });
});



function handleFileSelect(evt) {
  var files = evt.target.files; // FileList object

  // Loop through the FileList and render image files as thumbnails.
  for (var i = 0, f; f = files[i]; i++) {

    // Only process image files.
    if (!f.type.match('image.*')) {
      continue;
    }

    var reader = new FileReader();

    // Closure to capture the file information.
    reader.onload = (function(theFile) {
      return function(e) {
        // Render thumbnail.
        var span = document.createElement('span');
        span.innerHTML = ['<img class="thumb" src="', e.target.result,
                          '" title="', escape(theFile.name), '"/>'].join('');
        document.getElementById('list').insertBefore(span, null);
      };
    })(f);

    // Read in the image file as a data URL.
    reader.readAsDataURL(f);
  }
}
$('#files').change(handleFileSelect);
</script>

<script type="text/javascript">
$(document).ready(function() {

       var type = $('#type').val();
        if(type == "physical"){
            $('#physical').css('display','block');
        }else{
            $('#physical').css('display','none');
        }
    $('#type').on('change',function(){
        var type = $('#type').val();
        if(type == "physical"){
            $('#physical').css('display','block');
        }else{
            $('#physical').css('display','none');
        }
    });


});
</script>

<script type="text/javascript">
    $('#short_desc').keyup(function() {
      var head_text_length = $('#short_desc').val().length;
      var text_remaining = 500 - head_text_length;
      $('#brief_desc_count').html(head_text_length + ' / ' + 500);
    });

</script>
@endpush
