@extends('frontend.layouts.app')

@if($article_det->meta_title)
@section('title'){{$article_det->meta_title}}@endsection
@endif
@if($article_det->meta_description)
@section('meta_description'){{$article_det->meta_description}}@endsection
@endif

@section('public_content')

@if($article_det->module_type == 'coaching' || $article_det->module_type == 'courses' || $article_det->module_type == 'country')
<div class="row page-titles"> 
    <div class="col-12 text-center mt-4"> 
        <h1 class="display-4 text-themecolor">{{$article_det->title}}</h1> 
    </div>

    {{-- <div class="col-md-6 align-self-center offset-md-3 m-t-30">
        <div class="form-group">
            <div class="input-group" style="padding-left:30px">
                <select class="form-control search-query" id="select2-search">
                    <option value="">Search</option>
                    @foreach($list_det as $data)
                    <option value="{{$data->title}}">{{$data->title}}</option>
                    @endforeach
                </select>
            </div>
        </div>
    </div> --}}
</div>

<div class="container-fluid">
    <div class="row eductrl-editor-content ck-content">
        <p>{!! $article_det->intro !!}</p>
    </div>
</div>
<div class="container-fluid m-t-30 course-content-width">
    <div class="row row-cols-1 row-cols-md-2 row-cols-lg-4 g-4" style="margin-bottom: 50px;">
        @foreach($list_det as $data)
        <div class="col-md-3 mb-4 module-container">
            @php
                $link = '';
                if($article_det->module_type == 'coaching')
                $link = route('frontend.view-course',$data->id);
                elseif($article_det->module_type == 'courses')
                $link = route('frontend.view-online-course',$data->id);
                else
                $link = route('frontend.view-country',$data->id);
            @endphp
            <div class="card shadow-lg h-350"> 
                <div class="card-body p-2 rounded" style="background-image: linear-gradient(135deg, rgba(49, 49, 49,0.07) 0%, rgba(49, 49, 49,0.07) 12.5%,rgba(76, 76, 76,0.07) 12.5%, rgba(76, 76, 76,0.07) 25%,rgba(102, 102, 102,0.07) 25%, rgba(102, 102, 102,0.07) 37.5%,rgba(129, 129, 129,0.07) 37.5%, rgba(129, 129, 129,0.07) 50%,rgba(155, 155, 155,0.07) 50%, rgba(155, 155, 155,0.07) 62.5%,rgba(182, 182, 182,0.07) 62.5%, rgba(182, 182, 182,0.07) 75%,rgba(208, 208, 208,0.07) 75%, rgba(208, 208, 208,0.07) 87.5%,rgba(235, 235, 235,0.07) 87.5%, rgba(235, 235, 235,0.07) 100%),linear-gradient(45deg, rgba(5, 5, 5,0.07) 0%, rgba(5, 5, 5,0.07) 12.5%,rgba(39, 39, 39,0.07) 12.5%, rgba(39, 39, 39,0.07) 25%,rgba(73, 73, 73,0.07) 25%, rgba(73, 73, 73,0.07) 37.5%,rgba(107, 107, 107,0.07) 37.5%, rgba(107, 107, 107,0.07) 50%,rgba(141, 141, 141,0.07) 50%, rgba(141, 141, 141,0.07) 62.5%,rgba(175, 175, 175,0.07) 62.5%, rgba(175, 175, 175,0.07) 75%,rgba(209, 209, 209,0.07) 75%, rgba(209, 209, 209,0.07) 87.5%,rgba(243, 243, 243,0.07) 87.5%, rgba(243, 243, 243,0.07) 100%),linear-gradient(90deg, #b6e7ff,#dcfbff);">
                    <a href="{!!$link!!}" style="text-decoration: none; color: inherit;">
                        <div class="el-card-item">
                            <div class="el-card-avatar el-overlay-1">
                                <img src="{!! $data->image ? asset('storage/'.$data->image) : asset('assets/images/page/study.jpg') !!}" 
                                class="card-img-top img-fluid img-hover-zoom" alt="" 
                                style="object-fit: cover;"> <!-- Increase image height -->
                                <div class="el-overlay"></div>
                                <br>
                                <h3 class="display-4" align="center" style="font-size: 18px">{{$data->title}}</h3>
                            </div>
                        </div>
                    </a>
                </div>
            </div>
        </div>
        @endforeach
    </div>
</div>


@elseif($article_det->module_type == 'webinar_events')
<div class="container-fluid m-t-30">
    <div class="row eductrl-editor-content ck-content">
        <p class="m-t-10">{!! $article_det->intro !!}</p>
    </div>
</div>
@elseif($article_det->module_type == 'demo_classes')
<div class="container-fluid m-t-30">
    <div class="row eductrl-editor-content ck-content">
        <p class="m-t-10">{!! $article_det->intro !!}</p>
    </div>
</div>
@else
<div class="container-fluid m-t-30">
    <div class="row eductrl-editor-content ck-content">
        <h1 class="mt-4 text-center fw-bold">{{$article_det->title}}</h1>
        <p class="m-t-10">{!! $article_det->intro !!}</p>
    </div>
</div>
@endif

<div class="container-fluid m-t-10">
    <div class="row eductrl-editor-content ck-content">
        <p class="m-t-10">{!! $article_det->content !!}</p>
    </div>
</div>
@endsection

@push('after-scripts')
<!-- jQuery -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<!-- Select2 -->
<link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" rel="stylesheet" />
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>
<script>
    $(document).ready(function() {
        $('#select2-search').select2();

        $('#select2-search').on('select2:select', function(e) {
            var query = $(this).val().toLowerCase();
            search(query);
        });

        $('#select2-search').on('input', function(e) {
            var query = $(this).val().toLowerCase();
            search(query);
        });

        function search(query) {
            if (query.length > 2) {
                $('div.module-container').each(function() {
                    var $this = $(this);
                    var title = $this.find('h3').text().toLowerCase();
                    if (title.indexOf(query) === -1) {
                        $this.fadeOut();
                    } else {
                        $this.fadeIn();
                    }
                });
            } else {
                $('div.module-container').fadeIn();
            }
        }
    });
</script>
@endpush

@push('after-styles')
<style>
.eductrl-editor-content {
    padding: 0 25px;
}
.el-card-avatar img {
    max-width: 100%;
    height: auto;
    display: block;
    margin-left: auto;
    margin-right: auto;
}
.el-card-content h3 {
    text-align: center;
}
.img-hover-zoom {
    transition: transform 0.5s ease-out;
}

.img-hover-zoom:hover {
    transform: scale(0.9);
}
</style>
@endpush
