@extends('frontend.layouts.register-login')

@section('content')
<div class="login-register" style="background-image:url(assets/images/background/agent-bg.jpg);">
    <div class="login-box card">
        <div class="card-body">
            {{ html()->form('POST', route('frontend.auth.agent.register.post'))->open() }}
            <h3 class="box-title m-b-20">Agent Sign Up</h3>

            @include('includes.partials.messages')

            <div class="form-group row">
                <div class="col-12 col-sm-6">
                    <input class="form-control" type="text" name="first_name" required="required" placeholder="First Name" maxlength="50">
                </div>
                <div class="col-12 col-sm-6 mt-4 mt-sm-0">
                    <input class="form-control" type="text" name="last_name" required="required" placeholder="Last Name" maxlength="50">
                </div>
            </div>
            <div class="form-group ">
                <div class="col-xs-12">
                    <input class="form-control" type="email" name="email" required="required" placeholder="Email" maxlength="100">
                </div>
            </div>
            <div class="form-group ">
                <div class="col-xs-12">
                    {{-- <input class="form-control" type="text" name="mobile" required="required" placeholder="Mobile" minlength="{{ config('app.USER_MOBILE_MIN_LENGTH') }}" maxlength="{{ config('app.USER_MOBILE_MAX_LENGTH') }}"> --}}
                    <input id="dialcode" class="form-control" placeholder="Mobile No." style="padding-left: 154px !important;" type="tel" name="mobile" minlength="{{ config('app.USER_MOBILE_MIN_LENGTH') }}" maxlength="{{ config('app.USER_MOBILE_MAX_LENGTH') }}" />
                </div>
            </div>
            <div class="form-group">
                <div class="col-xs-12">
                    <input class="form-control" type="password" name="password" required="required" placeholder="Password" maxlength="20">
                </div>
            </div>


            @if(config('access.captcha.registration'))
            <div class="row">
                <div class="col">
                    {!! Captcha::display() !!}
                    {{ html()->hidden('captcha_status', 'true') }}
                </div><!--col-->
            </div><!--row-->
            @endif

            @if(get_site_config('recaptcha_site_key')!="" && get_site_config('recaptcha_secret_key')!="" && get_site_config('agent_signup_captcha')==1)
            <div class="row">
                <div class="col-md-12">
                    <div class="form-group">
                        <div class="g-recaptcha" data-sitekey="{{ get_site_config('recaptcha_site_key') }}"></div>
                        @if ($errors->has('g-recaptcha-response'))
                            <span class="text-danger">{{ $errors->first('g-recaptcha-response') }}</span>
                        @endif
                    </div>  
                </div>
            </div>
            @endif
            <div class="form-group row">
                <div class="col-md-12">
                    <div class="checkbox checkbox-success">
                        <input id="checkbox-signup" name="terms" type="checkbox" required>
                        <label for="checkbox-signup"> I agree to the Terms & Conditions</a></label>
                    </div>
                </div>
            </div>
            <div class="form-group text-center m-t-20">
                <div class="col-xs-12">
                    <button class="btn btn-info btn-lg btn-block text-uppercase btn-themecolor" type="submit">Sign Up</button>
                </div>
            </div>
            <div class="form-group m-b-0">
                <div class="col-sm-12 text-center">
                    <div>Already have an account? <a href="{{route('frontend.auth.agent.login')}}" class="text-info m-l-5 text-themecolor"><b>Sign In</b></a></div>
                </div>
            </div>                        

            {{ html()->form()->close() }}
        </div>
    </div>
</div>

@endsection
<style>
    #g-recaptcha-response {
      display: block !important;
      position: absolute;
      margin: -78px 0 0 0 !important;
      width: 302px !important;
      height: 76px !important;
      z-index: -999999;
      opacity: 0;
    }
</style>
@push('after-scripts')
@if(config('access.captcha.registration'))
{!! Captcha::script() !!}
@endif
<script src="https://www.google.com/recaptcha/api.js" async defer></script>
<script>
    window.addEventListener('load', () => {
        const $recaptcha = document.querySelector('#g-recaptcha-response');
        if ($recaptcha) {
            $recaptcha.setAttribute('required', 'required');
        }
    })
</script>
<script src="{{ asset('assets/dialcode/js/intlTelInput.js')}}"></script>
<script>
    var input = document.querySelector("#dialcode");
    window.intlTelInput(input, {
        // allowDropdown: false,
        // autoInsertDialCode: true,
        // autoPlaceholder: "off",
        // dropdownContainer: document.body,
        excludeCountries: ["ax"],
        // formatOnDisplay: false,
        // geoIpLookup: function(callback) {
        //   fetch("https://ipapi.co/json")
        //     .then(function(res) { return res.json(); })
        //     .then(function(data) { callback(data.country_code); })
        //     .catch(function() { callback("us"); });
        // },
        hiddenInput: "full_number",
        initialCountry: "{{$def_dialcode->code}}",
        // localizedCountries: { 'de': 'Deutschland' },
        // nationalMode: false,
        // onlyCountries: ['us', 'gb', 'ch', 'ca', 'do'],
        placeholderNumberType: "",
        preferredCountries: ['{{$def_dialcode->code}}'],
        separateDialCode: true,
        // showFlags: false,
        utilsScript: "{{ asset('assets/dialcode/js/utils.js') }}"
    });
</script>
@endpush
