@extends('frontend.layouts.register-login')

@section('content')
<div class="login-register vh-100" style="background-image:url(assets/images/background/login-register.jpg);">
    <div class="login-box card">
        <div class="card-body">
            {{ html()->form('POST', route('frontend.auth.login.post'))->open() }}

            <h3 class="box-title m-b-20"> {{ __('labels.frontend.auth.login_box_title') }}</h3>

            @include('includes.partials.messages')

            <div class="row">
                <div class="col">
                    <div class="form-group">
                       
                        {{ html()->label(__('validation.attributes.frontend.email'))->for('email') }}

                        {{ html()->email('email')
                                        ->class('form-control')
                                        ->placeholder(__('validation.attributes.frontend.email'))
                                        ->attribute('maxlength', 191)
                                        ->required() }}
                    </div><!--form-group-->
                </div><!--col-->
            </div><!--row-->

            <div class="row">
                <div class="col">
                    <div class="form-group">
                        {{ html()->label(__('validation.attributes.frontend.password'))->for('password') }}

                        {{ html()->password('password')
                                        ->class('form-control')
                                        ->placeholder(__('validation.attributes.frontend.password'))
                                        ->required() }}
                    </div><!--form-group-->
                </div><!--col-->
            </div><!--row-->

            <div class="row">
                <div class="col">
                    <div class="form-group rmbr-nd-frgt-pass">
                        <div class="checkbox checkbox-primary pull-left p-t-0">
                            <input id="checkbox-signup" type="checkbox" name="remember" value="1">
                            <label for="checkbox-signup">{{ __('labels.frontend.auth.remember_me') }}</label>
                        </div>
                        <a href="{{ route('frontend.auth.password.reset') }}" id="to-recover" class="text-dark pull-right"><!-- <i class="fa fa-lock m-r-5"></i> --> {{ __('labels.frontend.passwords.forgot_password') }}</a>
                    </div><!--form-group-->
                </div><!--col-->
            </div><!--row-->
            
            <div class="form-group text-center m-t-20">
                <div class="col-xs-12">
                    {{-- <button class="btn btn-info btn-lg btn-block text-uppercase waves-effect waves-light bg-theme" type="submit">Log In</button> --}}
                    <button class="btn btn-lg btn-block text-uppercase btn-themecolor" type="submit">{{ __('labels.frontend.auth.login_button') }}</button>
                </div>
            </div>            

            <div class="form-group m-b-0">
                <div class="col-sm-12 text-center">
                    <div class="don-hv-an-acnt">{{ __('auth.dont_have_account') }}<a href="{{route('frontend.auth.register')}}" class="text-info m-l-5 text-themecolor"><b>{{ __('auth.sign_up') }}</b></a></div>
                </div>
            </div>

            {{ html()->form()->close() }}

        </div>
    </div>
</div>
@endsection

@push('after-styles')
    <style>
        @media (max-width: 845px) {
            .don-hv-an-acnt{
                font-size: 14px;
            }

            .rmbr-nd-frgt-pass{
                display: flex;
                flex-direction: column;
                margin-bottom: 0px;
            }
        }
    </style>
@endpush
