@extends('frontend.layouts.register-login')

@section('content')
<div class="login-register" style="background-image:url({{ url('/') }}/assets/images/background/login-register.jpg);">
    <div class="login-box card">
        <div class="card-body">
            {{ html()->form('POST', route('frontend.auth.password.email.post'))->open() }}

            <h3 class="box-title m-b-20">@lang('labels.frontend.passwords.reset_password_box_title')</h3>

            @include('includes.partials.messages')

            @if(session('status'))
            <div class="alert alert-success">
                {{ session('status') }}
            </div>
            @endif

            {{ html()->form('POST', route('frontend.auth.password.email.post'))->open() }}
            <div class="row">
                <div class="col">
                    <div class="form-group">
                        {{ html()->label(__('validation.attributes.frontend.email'))->for('email') }}

                        {{ html()->email('email')
                                        ->class('form-control')
                                        ->placeholder(__('validation.attributes.frontend.email'))
                                        ->attribute('maxlength', 191)
                                        ->required()
                                        ->autofocus() }}
                    </div><!--form-group-->
                </div><!--col-->
            </div><!--row-->

            <div class="row">
                <div class="col">
                    <div class="form-group mb-0 clearfix">
                        {{ form_submit(__('labels.frontend.passwords.send_password_reset_link_button'), 'btn btn-info btn-lg btn-block waves-effect waves-light') }}
                    </div><!--form-group-->
                </div><!--col-->
            </div><!--row-->
            {{ html()->form()->close() }}
        </div><!-- card-body -->
    </div><!-- card -->
</div>
@endsection
