@extends('frontend.layouts.register-login')

@section('content')
<div class="login-register" style="background-image:url(assets/images/background/login-register.jpg);">
    <div class="login-box card">
        <div class="card-body">
            {{-- {{ html()->form('POST', route('frontend.auth.register.post'))->open() }} --}}

        <form class="" action="{{route('frontend.auth.register.post')}}" id="loginform" method="POST">
            @csrf
            <h3 class="box-title m-b-20">{{ucfirst(__('auth.sign_up'))}}</h3>

            @include('includes.partials.messages')
            <input type="hidden" name="branch_id" value="1">
            <div class="form-group form-row">
                <div class="col-12 col-md-6 mb-4 mb-md-0">
                    <input class="form-control" type="text" name="first_name" id="first_name" required="required" placeholder="{{ucfirst(__('validation.attributes.frontend.first_name'))}}*" maxlength="30">
                    <span id="first_name_field" style="display: inline-block; font-size: 13px; color: red; display: none;">First name is required.</span>
                </div>

                <div class="col-12 col-md-6">
                    <input class="form-control" type="text" name="last_name" id="last_name" required="required" placeholder="{{ucfirst(__('validation.attributes.frontend.last_name'))}}*" maxlength="30">
                    <span id="last_name_field" style="display: inline-block; font-size: 13px; color: red; display: none;">Last name is required.</span>
                </div>
            </div>
            <div class="form-group ">
                <div class="col-xs-12">
                    <input class="form-control" type="email" name="email" id="email" required="required" placeholder="{{ucfirst(__('validation.attributes.frontend.email'))}}*" maxlength="60">
                    <span id="email_field" style="display: inline-block; font-size: 13px; color: red; display: none;">Email field is required.</span>
                </div>
            </div>
            <div class="form-group" style="margin-bottom: 12px !important;">
                <div class="col-xs-12">
                    <input id="dialcode" class="form-control" 
                        placeholder="{{ ucfirst(__('labels.frontend.user.profile.mobile')) }}*" 
                        style="padding-left: 154px !important;" 
                        type="tel" name="mobile"
                        minlength="{{ config('app.USER_MOBILE_MIN_LENGTH') }}" 
                        maxlength="{{ config('app.USER_MOBILE_MAX_LENGTH') }}" />
                    <span id="moile_field" style="display: inline-block; font-size: 13px; color: red; display: none;">Mobile field is required.</span>
                </div>
            </div>

            <div class="form-group" style="margin-bottom: 3px !important;">
                <div class="checkbox checkbox-success">
                    <input type="checkbox" id="sameAsMobile" checked>
                    <label for="sameAsMobile">Whatsapp no. is same as above</label>
                </div>
            </div>

            <div class="form-group" id="whatsappField" style="display:none;">
                <div class="col-xs-12">
                    <input id="whatsapp_dialcode" class="form-control" 
                        placeholder="Whatsapp No." 
                        style="padding-left: 154px !important;" 
                        type="tel" name="whatsapp_number"
                        minlength="{{ config('app.USER_MOBILE_MIN_LENGTH') }}" 
                        maxlength="{{ config('app.USER_MOBILE_MAX_LENGTH') }}" />
                </div>
            </div>
            <div class="form-group ">
                <div class="col-xs-12">
                    <input class="form-control" type="password" name="password" id="password" required="required" autocomplete="new-password" placeholder="{{ ucfirst(__('validation.attributes.frontend.password')) }}*" maxlength="20">
                    <span id="password_field" style="display: inline-block; font-size: 13px; color: red; display: none;">Password field is required.</span>
                </div>
            </div>
            @if(get_site_config('module_student_referral'))
            <div class="form-group mb-3 ">
                <div class="col-xs-12">
                    <input class="form-control" type="text" name="referral_code" value="@if(old('referral_code')){{old('referral_code')}}@else{{$refered_by_cookie_name}}@endif" placeholder="@lang('labels.frontend.user.profile.referral_code_optional')" maxlength="10">
                </div>
                @if($refered_by_name)
                <p class=" p-1 mt-1"  style="font-size: 12px">You are referred by <b>{{$refered_by_name}}</b></p>
                @endif
            </div>
            @endif


            @if(config('access.captcha.registration'))
            <div class="row">
                <div class="col">
                    {!! Captcha::display() !!}
                    {{ html()->hidden('captcha_status', 'true') }}
                </div><!--col-->
            </div><!--row-->
            @endif
            @if(get_site_config('recaptcha_site_key')!="" && get_site_config('recaptcha_secret_key')!="" && get_site_config('student_signup_captcha')==1)
            <div class="row">
                <div class="col-md-12">
                    <div class="form-group">
                        <div class="g-recaptcha" data-sitekey="{{ get_site_config('recaptcha_site_key') }}"></div>
                        @if ($errors->has('g-recaptcha-response'))
                            <span class="text-danger">{{ $errors->first('g-recaptcha-response') }}</span>
                        @endif
                    </div>  
                </div>
            </div>
            @endif

            <div class="form-group row mb-1">
                <div class="col-md-12">
                    <div class="checkbox checkbox-success">
                        <input id="checkbox-signup" name="terms" type="checkbox" required>
                        <label for="checkbox-signup">
                            <?php 
                                if(get_site_config('student_signup_terms_page')!=0){
                                    $post = get_post(get_site_config('student_signup_terms_page'));
                                    $termurl = '<a href="'.route('frontend.view-article', $post).'" target="_blank">'.__('labels.frontend.user.profile.terms_and_conditions').'</a>';
                                }else{
                                    $termurl = __('labels.frontend.user.profile.terms_and_conditions');
                                }
                            ?>
                            {{ __('labels.frontend.user.profile.i_agree_to_the') }} {!!$termurl!!}* <br>
                            <span id="terms_and_condition" style="display: inline-block; font-size: 13px; color: red; display: none;">
                                You must agree to {!!$termurl!!} to continue.
                            </span>
                        </label>
                    </div>
                </div>
            </div>
            <div class="form-group text-center  mt-2">
                <div class="col-xs-12">
                    <button class="btn btn-info btn-lg btn-block text-uppercase waves-effect waves-light btn-themecolor" id="sign_up_submit" type="submit">{{ __('auth.sign_up') }}</button>
                </div>
            </div>
            <div class="form-group m-b-0">
                <div class="col-sm-12 text-center">
                    <div>{{ __('auth.already_have_an_account') }}
                        <a href="{{route('frontend.auth.login')}}" class="text-info m-l-5 text-themecolor"><b>{{ __('labels.frontend.auth.login_button') }}</b></a></div>
                </div>
            </div>                        

            {{ html()->form()->close() }}
        </div>
    </div>
</div>

@endsection
<style>
    #g-recaptcha-response {
      display: block !important;
      position: absolute;
      margin: -78px 0 0 0 !important;
      width: 302px !important;
      height: 76px !important;
      z-index: -999999;
      opacity: 0;
    }
</style>
@push('after-scripts')
@if(config('access.captcha.registration'))
{!! Captcha::script() !!}
@endif
<script src="https://www.google.com/recaptcha/api.js" async defer></script>
<script>
    window.addEventListener('load', () => {
        const $recaptcha = document.querySelector('#g-recaptcha-response');
        if ($recaptcha) {
            $recaptcha.setAttribute('required', 'required');
        }
    })
</script>

<script>
    $(document).ready(function () {
        $('#sign_up_submit').click(function (e) { 
            e.preventDefault();
            
            if($("#first_name").val() == ""){
                $("#first_name_field").show();
            } else{
                $("#first_name_field").hide();
            }

            if($("#last_name").val() == ""){
                $("#last_name_field").show();
            } else{
                $("#last_name_field").hide();
            }

            if($("#email").val() == ""){
                $("#email_field").show();
            } else{
                $("#email_field").hide();
            }

            if($("#dialcode").val() == ""){
                $("#moile_field").show();
            } else{
                $("#moile_field").hide();
            }

            if($("#password").val() == ""){
                $("#password_field").show();
            } else{
                $("#password_field").hide();
            }

            if($("#checkbox-signup").prop('checked') != true){
                $("#terms_and_condition").show();
            } else{
                $("#terms_and_condition").hide();
            }

            var input = document.querySelector("#dialcode");
            var whatsapp_input = document.querySelector("#whatsapp_dialcode");
            var iti = window.intlTelInputGlobals.getInstance(input);
            var wp_iti = window.intlTelInputGlobals.getInstance(whatsapp_input);

            if($("#first_name").val() && $("#last_name").val() && $("#email").val() && $("#password").val() && $("#checkbox-signup").prop('checked') == true){
                // Set the full number into the hidden input manually
                var fullNumber = iti.getNumber();
                var WpfullNumber = wp_iti.getNumber();
                $('input[name="full_number"]').val(fullNumber);
                $('input[name="whatsapp_full_number"]').val(WpfullNumber);
                
                $("#loginform").submit();
            }
        });

        function toggleWhatsapp() {
            if ($("#sameAsMobile").is(":checked")) {
                $("#whatsappField").hide();
                $("#whatsapp_dialcode").val(""); // reset optional field
            } else {
                $("#whatsappField").show();
            }
        }

        // Run on page load
        toggleWhatsapp();

        // On checkbox change
        $("#sameAsMobile").change(function () {
            toggleWhatsapp();
        });
    });
</script>

// DIALCODE JS
<script src="{{ asset('assets/dialcode/js/intlTelInput.js')}}"></script>
<script>
    var input = document.querySelector("#dialcode");
    window.intlTelInput(input, {
        // allowDropdown: false,
        // autoInsertDialCode: true,
        // autoPlaceholder: "off",
        // dropdownContainer: document.body,
        excludeCountries: ["ax"],
        // formatOnDisplay: false,
        // geoIpLookup: function(callback) {
        //   fetch("https://ipapi.co/json")
        //     .then(function(res) { return res.json(); })
        //     .then(function(data) { callback(data.country_code); })
        //     .catch(function() { callback("us"); });
        // },
        hiddenInput: "full_number",
        initialCountry: input.dataset.phonecountrycode,
        // localizedCountries: { 'de': 'Deutschland' },
        // nationalMode: false,
        // onlyCountries: ['us', 'gb', 'ch', 'ca', 'do'],
        placeholderNumberType: "",
        preferredCountries: ['IN'],
        separateDialCode: true,
        // showFlags: false,
        utilsScript: "{{ asset('assets/dialcode/js/utils.js') }}"
    });

    var whatsappInput = document.querySelector("#whatsapp_dialcode");
    if (whatsappInput) {
        window.intlTelInput(whatsappInput, {
            excludeCountries: ["ax"],
            hiddenInput: "whatsapp_full_number",
            preferredCountries: ['IN'],
            separateDialCode: true,
            utilsScript: "{{ asset('assets/dialcode/js/utils.js') }}"
        });
    }
</script>

@endpush
