@extends('frontend.layouts.app')
@section('title'){{'Cart'}}@endsection
@section('meta_description'){{"Cart"}}@endsection

@section('public_content')
<div class="ck-content">
    <div class="row new-page-titles">
        <div class="col-md-12 align-self-center " style="text-align: center;margin-bottom: 25px;">
            <h3 class="text-themecolor" style="margin-bottom:10px;">Shopping Cart</h3>
            @include('includes.partials.messages')
        </div>
    </div>
    <div class="new-page-titles">
      <section class="cart-section" style="padding: 0px;">
         <div class="auto-container">
             <?php 
             if (isset($data)) {
                 if (count($data) > 0) { ?>
                     <div class="cart-outer">
                 <div class="table-outer">
                     <table class="cart-table table-border">
                         <thead class="cart-header">
                             <tr>
                                 <th class="prod-column">Product</th>
                                 <th>&nbsp;</th>
                                 <th>Quantity</th>
                                 <th class="price">Price</th>
                                 <th>Total</th>
                                 <th>&nbsp;</th>
                             </tr>
                         </thead>
                         <tbody>
                             <?php 
                             for ($i=0; $i <count($data); $i++) { 
                                 $product_det = $data[$i]['product_data'];
                                 ?>
                                  <tr>
                                     <td  class="prod-column">
                                         <div class="column-box shop-item" style="margin-bottom:0px;text-align: center;">
                                            @if($product_det->type='coaching')
                                            <img src="{{asset('storage/images/'.$imgs[$i]->image)}}"  style="height: 70px" alt="">
                                            @elseif($product_det->type='online_course')
                                            <img src="{{asset('storage/images/'.$imgs[$i]->image)}}"  style="height: 70px" alt="">
                                            @else
                                             <img src="{{asset('storage/products/'.$imgs[$i]->filename)}}"  style="height: 70px" alt="">
                                            @endif
                                         </div>
                                     </td>
                                     <td  class="prod-column">                
                                        <strong>{{$product_det->title}}</strong>
                                     </td>
                                     @if($product_det->type == 'physical')
                                     <td class="qty"><input class="form-control" id="quan<?=$i;?>" onchange="update_quantity(<?=$product_det->id?>,<?=$i;?> )" type="number" value="{{$data[$i]['quantity']}}" name="quantity" style=""></td>
                                     @else
                                     <td class="qty"><input class="form-control" id="quan<?=$i;?>" type="number" value="{{$data[$i]['quantity']}}" name="quantity" disabled></td>
                                     @endif
                                     <?php
                                     if($product_amount[$i]['offer_price']!=0){
                                         $price = $product_amount[$i]['offer_price'];
                                     }else{
                                         $price = $product_amount[$i]['price'];
                                     }
                                     $tot = $price * $data[$i]['quantity'];
                                      ?>
                                     <td class="price">{{config('app.currency_symbol')}}{{number_format($price,2)}}</td>
                                     <td class="sub-total">{{config('app.currency_symbol')}}{{number_format($tot,2)}}</td>
                                         <td class="remove"><a href="{{route('frontend.removeFromCart',[$product_det->id])}}" class=""><span class="fa fa-trash"></span></a></td>
                                 </tr>
                            <?php }
                             ?>
                         </tbody>
                     </table>
                 </div>
                 {{-- <div class="coupon-outer clearfix">
                     <div class="pull-left">
                         <div class="apply-coupon clearfix">
                             <div class="form-group clearfix">
                                 <input type="text" name="coupon-code" value="" placeholder="Enter Coupon Code...">
                             </div>
                             <div class="form-group clearfix">
                                 <button type="button" class="theme-btn btn-style-one checkout-button"><span class="txt">Apply Coupon</span></button>
                             </div>
                         </div>
                     </div>
                 </div>  --}}
                 <div class="row clearfix mt-4">
                     <div class="column col-lg-6 col-md-12 col-sm-12">
                     </div>
                     <div class="column col-lg-6 col-md-12 col-sm-12">
                         <div class="group-title">
                           <h2>Cart Totals</h2>
                         </div>
                         <ul class="totals-table">
                             <li class="clearfix"><span class="col col-title">Cart Subtotal</span><span class="col">{{config('app.currency_symbol')}}{{ number_format($toti,2) }}</span></li>
                             <li class="clearfix"><span class="col col-title">Tax</span><span class="col">0</span></li>
                             <li class="clearfix"><span class="col col-title">Grand Total</span><span class="col">{{config('app.currency_symbol')}}{{ number_format($toti+ $tax,2) }}</span></li>
                         </ul>
                         <div class="padd-top-30 text-right"><button type="submit" class="btn btn-md btn-warning checkout-button" onclick="window.location.href = '{{route('frontend.checkout')}}'"><span class="txt">Proceed to Checkout</span></button></div>
                     </div>
                 </div>
             </div>
                 <?php }
             }else{ ?>
                 <div class="alert alert-danger alert-dismissible fade show" role="alert" style="margin-top:20px;">
                     <p style="margin-bottom: 0px;">Your Cart is Empty!</p>
                     </button>
                 </div>
             <?php }
             ?>
         </div>
     </section>  
    </div>
</div>
@endsection

@push('after-scripts')
<script>
function update_quantity($id, $i){
    $quan = $('#quan'+$i).val();

     $.ajax({
           url: '{{ route('frontend.updateCart') }}',
           method: "get",
           data: {
               id: $id, 
               quantity: $quan
           },
           success: function (response) {
              window.location.reload();
           }
       });
  }
</script>
@endpush