@extends('frontend.layouts.app')
@section('title'){{'Checkout'}}@endsection

@section('public_content')
<div class="row new-page-titles m-5">
    <div class="col-md-12 align-self-center " style="text-align: center;margin-bottom: 25px;">
        <h3 class="new-text-themecolor">Checkout</h3>
        @include('includes.partials.messages')
    </div>
</div>
<div class="row new-page-titles m-5">
    <div class="col-md-12">
    <section class="cart-section" style="padding: 0px;">
        <div class="auto-container">
            <form action="{{route('frontend.place-order')}}" method="POST">
                @csrf
                @if(isset($invoice_id) && !empty($invoice_id))
                <input type="hidden" name="invoice_id" id="invoice_id" value="{{$invoice_id}}">
                @endif
                <input type="hidden" name="product_type" id="product_type" value="{{$type}}">
                <div class="news-block-two">
                    <div class="inner-box">
                        <div class="row">
                            <div class="col-md-7 col-sm-12">
                                <?php
                                if ($userData) { ?>
                                    <div class="lower-content dashboard-box checkout-form" style="margin-top: 0px;    margin-bottom: 5px;">
                                        <!-- News Block Two -->
                                        <div class="news-block-two">
                                            <div class="inner-box">
                                                <div class="row clearfix">
                                                    <!--Form Group-->
                                                    <div class="form-group col-md-6 col-sm-6 col-xs-12">
                                                        <div class="field-label"><strong>Bill To : &nbsp; </strong> <br>
                                                            {{$userData->name}}
                                                            <br>
                                                            @if($userData->address)
                                                            {{$userData->address}}
                                                            <br>
                                                            @endif
                                                            @if($city){{$city->name}}, @endif
                                                            @if(isset($state))
                                                            {{$state->name}},@endif
                                                            @if(isset($country))
                                                            {{$country->title_en}} @endif
                                                            <br>
                                                            @if($userData->zip_code)
                                                            {{$userData->zip_code}} <br>@endif
                                                            Phone : @if($userData->dialcode){{$userData->dialcode}} @endif
                                                            {{$userData->mobile}}
                                                            <br>
                                                            Email : {{$userData->email}}
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        @if($type == "physical")
                                        <h4>Ship To</h4>
                                        <div class="card address_box" id="address_box0" style="padding: 10px;border: 1px solid rgba(0, 0, 0, .125);">
                                            @if($userData->address){{$userData->address}}<br>@endif
                                            @if($city){{$city->name}} <br>@endif
                                            @if(isset($state)){{$state->name}} <br>@endif
                                            @if(isset($country)){{$country->title_en}} <br>
                                            @endif
                                            @if(isset($userData->mobile)) Mobile : {{$userData->mobile}} <br>
                                            <input type="hidden" name="state_id0" id="state_id0" value="{{$userData->state}}">
                                            <input type="hidden" name="country_id0" id="country_id0" value="{{$userData->country}}">
                                            <input type="hidden" name="ad_sel" id="ad_sel" value="">
                                            <button type="button" onclick="selectPaymentAddress(0);" id="set-payment-address-0" class="btn btn-outline-secondary set-payment-address-btn">Deliver Here</button>
                                            @endif
                                        </div>


                                        <?php if (count($userShippingAddress) > 0) { ?>
                                            <input type="hidden" name="address_id" id="payment_address_id" value="" spellcheck="false">
                                            <input type="hidden" name="shipping_to" value="{{$userData->first_name.' '.$userData->last_name}}">
                                            <input type="hidden" id="user_type" value="1" spellcheck="false">
                                            <?php for ($i = 0; $i < count($userShippingAddress); $i++) {  ?>
                                                <div class="card mt-2 address_box" id="address_box<?= $userShippingAddress[$i]->id ?>" style="padding: 10px;">
                                                    @if($userShippingAddress[$i]->address){{$userShippingAddress[$i]->address}}<br>@endif
                                                    @if($cities[$i]){{$cities[$i]->name}} <br>@endif
                                                    @if($states[$i]){{$states[$i]->name}} <br>@endif
                                                    {{$couns[$i]->title_en}} <br>
                                                    Mobile : {{$userShippingAddress[$i]->phone}} <br>
                                                    <input type="hidden" name="ad_sel" id="ad_sel" value="">
                                                    <input type="hidden" name="shipping_state_<?= $userShippingAddress[$i]->id ?>" id="shipping_state_<?= $userShippingAddress[$i]->id ?>" value="{{$userShippingAddress[$i]->state}}">
                                                    <input type="hidden" name="shipping_country_<?= $userShippingAddress[$i]->id ?>" id="shipping_country_<?= $userShippingAddress[$i]->id ?>" value="{{$userShippingAddress[$i]->country}}">
                                                    <button type="button" onclick="selectPaymentAddress(<?= $userShippingAddress[$i]->id ?>);" id="set-payment-address-{{$userShippingAddress[$i]->id}}" class="btn btn-outline-secondary set-payment-address-btn">Deliver Here</button>
                                                </div>
                                        <?php
                                            }
                                        }
                                        ?>

                                        <div class="form-group col-md-12 col-sm-12 col-xs-12 m-4">
                                            <a href="{{route('frontend.user.add_new_address')}}" type="button" class="btn btn-success" style="border-radius: 5px;">Enter a different address</a>
                                        </div>
                                        @endif
                                        <!-- News Block Two -->
                                        <input type="hidden" name="type" id="logintype" value="yes">
                                    </div>

                                <?php } else { ?>
                                    <input type="hidden" name="type" id="logintype" value="no">
                                    <div class="col-md-12">
                                        <div class="lower-content dashboard-box checkout-form" style="margin-top: 0px;">

                                            <div class="mb-4">
                                                <b> Existing Member? </b>
                                                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<button type="button" class="btn btn-themecolor" onclick="window.location.href = '{{ route('frontend.auth.login',['redirectTo'=>'cart']) }}'" style="text-transform: capitalize;border-radius: 2px;padding: 1px 11px;"><span class="txt">Login</span></button>
                                            </div>
                                            <!-- News Block Two -->
                                            <div class="news-block-two">
                                                <div class="inner-box">
                                                    <div class="row clearfix">
                                                        <!--Form Group-->
                                                        <div class="form-group col-md-6 col-sm-6 col-xs-12">
                                                            <input type="text" class="form-control" name="first_name" id="first_name" value="{{old('first_name')}}" placeholder="First Name  *">
                                                            <p id="firstname_err" style="color:red;display: none;margin-bottom:0px;">First Name is required.</p>
                                                        </div>

                                                        <!--Form Group-->
                                                        <div class="form-group col-md-6 col-sm-6 col-xs-12">
                                                            <input type="text" class="form-control" name="last_name" id="last_name" value="{{old('last_name')}}" placeholder="Last Name  *">
                                                            <p id="lastname_err" style="color:red;display: none;margin-bottom:0px;">Last Name is required.</p>
                                                        </div>

                                                        <!--Form Group-->
                                                        <div class="form-group col-md-12 col-sm-12 col-xs-12">
                                                            <input type="text" class="form-control" name="address" id="address" value="{{old('address')}}" placeholder="Address *">
                                                            <p id="address_err" style="color:red;display: none;margin-bottom:0px;">Address is required.</p>
                                                        </div>

                                                        <!--Form Group-->
                                                        <div class="form-group col-md-12 col-sm-12 col-xs-12">
                                                            <select class="form-control form-select" name="country" id="country-dd" onchange="checkPaymentAddress(this.value);">
                                                                <option value="">Country *</option>
                                                                @foreach($countries as $coun)
                                                                <option value="{{$coun->id}}">{{$coun->title_en}}</option>
                                                                @endforeach

                                                            </select>
                                                            <p id="country_err" style="color:red;display: none;margin-bottom:0px;">Country is required.</p>
                                                        </div>

                                                        <!--Form Group-->
                                                        <div class="form-group col-md-6 col-sm-6 col-xs-12">
                                                            <select class="form-control form-select" onchange="checkPaymentState(this.value);" name="state" id="state-dd" style="margin-bottom: 5px;">
                                                                <option value="">State *</option>
                                                            </select>
                                                            <p id="state_err" style="color:red;display: none;margin-bottom:0px;">State is required.</p>

                                                        </div>

                                                        <!--Form Group-->
                                                        <div class="form-group col-md-6 col-sm-6 col-xs-12">
                                                            <select class="form-control form-select" id="city-dd" name="city">
                                                                <option value="">City *</option>
                                                            </select>
                                                            <p id="city_err" style="color:red;display: none;margin-bottom:0px;">City is required.</p>

                                                        </div>

                                                        <div class="form-group col-md-12 col-sm-6 col-xs-12">
                                                            <input type="text" class="form-control" id="zip" name="zipcode" value="{{old('zipcode')}}" placeholder="Zip Code *">
                                                            <p id="zip_err" style="color:red; display: none;">Zip Code is required.</p>

                                                        </div>


                                                        <!--Form Group-->
                                                        <div class="form-group col-md-6 col-sm-6 col-xs-12">
                                                            <input type="text" class="form-control" name="mobile" id="mobile" value="{{old('mobile')}}" placeholder="Mobile No *">
                                                            <p id="mobile_err" style="color:red;display: none;margin-bottom:0px;">Mobile No is required.</p>
                                                        </div>

                                                        <!--Form Group-->
                                                        <div class="form-group col-md-12 col-sm-12 col-xs-12">
                                                            <input type="email" class="form-control" name="email" id="email" value="{{old('email')}}" placeholder="Email * ">
                                                            <p id="email_err" style="color:red;display: none;margin-bottom:0px;">Email is required.</p>
                                                        </div>

                                                        <div class="form-group col-md-12 col-sm-12 col-xs-12">
                                                            <input type="password" class="form-control" name="password" id="password" value="" placeholder="Password * ">
                                                            <p id="password_err" style="color:red;display: none;margin-bottom:0px;">Password is required.</p>
                                                        </div>

                                                        <div class="form-group col-md-12 col-sm-12 col-xs-12">
                                                            <input type="password" class="form-control" name="confirm_password" id="confirmed" value="" placeholder="Confirm Password * ">
                                                            <p id="confirmed_err" style="color:red;display: none;margin-bottom:0px;">Confirm Password is required.</p>
                                                        </div>

                                                    </div>
                                                </div>
                                            </div>
                                            <!-- News Block Two -->
                                        </div>
                                    </div>
                                <?php }
                                ?>

                            </div>
                            <input type="hidden" name="currency_rate" value="1.00" id="currency_rate">
                            <input type="hidden" name="currency" value="{{config('app.currency')}}">
                            <div class="col-md-5 col-sm-12">
                                <div class="lower-content dashboard-box" style="margin-top: 0px;">
                                    <!-- News Block Two -->
                                    <div class="news-block-two">
                                        <div class="inner-box">
                                            <div class="checkout-title">
                                                <h4>Cart Totals</h4>
                                            </div>
                                            <!--Totals Table-->
                                            <ul class="totals-table">
                                                <li class="clearfix" style="display: flex;"><label class="col title">Cart Subtotal</label><label class="col">{{config('app.currency_symbol')}}{{number_format($toti,2)}}</label></li>
                                                <input type="hidden" name="cart_total" value="{{round($toti,2)}}">
                                                <li class="clearfix" style="display: none;" id="shipp">
                                                    <div style="display: flex;">
                                                        <label class="col title">Shipping Cost</label><label class="col">{{config('app.currency_symbol')}}<label id="shipping_cost"></label></label>
                                                    </div>
                                                </li>
                                                <input type="hidden" name="ship_val_ad" id="ship_val_ad" value="">
                                                <li class="clearfix" style="display: flex;"><label class="col title">Tax</label><label class="col total">{{config('app.currency_symbol')}}{{$tax}}</label></li>
                                                <input type="hidden" name="tax" value="{{$tax}}">
                                                <li class="clearfix" style="display: flex;"><label class="col title">Grand Total</label><label class="col total">{{config('app.currency_symbol')}}<label id="totalValue">{{number_format($tax+$toti,2)}}</label> </label></li>
                                                <input type="hidden" name="total" id="total_amount" value="{{round($toti,2)}}">
                                                <input type="hidden" name="total_amount" id="full_total" value="{{round($toti,2)}}">
                                            </ul>

                                            <!--Payment Options-->
                                            <div class="payment-options">
                                                <ul style="list-style:none;">
                                                    @if(get_site_config('payment_razorpay'))
                                                    @if($userData)
                                                    <li>
                                                        <div class="radio-option mb-4">
                                                            <input style="opacity: 1000;position: initial;" type="radio" class="radio-col-blue border form-check-input mt-3" name="payment_type" id="payment-1" value="razorpay" autocomplete="off">
                                                            <label for="payment-1"><strong>Razorpay <img src="{{asset('assets/images/razorpay.png')}}" style="width: 200px;"> </strong></label>
                                                        </div>
                                                    </li>
                                                    @endif
                                                    @endif
                                                    @if(get_site_config('payment_stripe'))
                                                    <li>
                                                        <div class="radio-option mb-4">
                                                            <input style="opacity: 1000;position: initial;" class="radio-col-blue border form-check-input mt-3" type="radio" name="payment_type" id="payment-3" value="stripe">
                                                            <label for="payment-3"><strong>Stripe <img src="{{asset('assets/images/stripe_poweredby.png')}}" style="width: 200px;"> </strong></label>
                                                        </div>
                                                    </li>
                                                    @endif
                                                    @if(get_site_config('payment_paypal'))
                                                    <li>
                                                        <div class="radio-option mb-2">
                                                            <input style="opacity: 1000;position: initial;" class="radio-col-blue border form-check-input mt-3" type="radio" name="payment_type" id="payment-2" value="paypal">
                                                            <label for="payment-2"><strong>PayPal <img src="{{asset('assets/images/paypal_poweredby.png')}}" style="width: 200px;"></strong></label>
                                                        </div>
                                                    </li>
                                                    @endif
                                                    @if(get_site_config('payment_bank'))
                                                    @if($type!='invoice')
                                                    <li style="padding-top: 16px;">
                                                        <div class="radio-option">
                                                            <input style="opacity: 1000;position: initial;" class="radio-col-blue border form-check-input mt-3" type="radio" name="payment_type" id="payment-4" value="bank">
                                                            <label for="payment-4"><strong>Bank Transfer</strong></label>
                                                        </div>
                                                    </li>
                                                    @endif
                                                    @endif

                                                </ul>
                                                <input type="hidden" name="notes" value="{{$notes}}">
                                                <button type="submit" id="order-btn" class="btn btn-warning btn-lg" onclick="return checkform()" style="margin-top:20px;"><span class="txt">Place Order</span></button>
                                                </form>
                                                <div id="razor-div" style="display:none;">
                                                    @if($userData)
                                                    <form action="{{ route('frontend.razorpay.payment') }}" method="POST" >
                                                        @csrf 
                                                        @if(isset($invoice_id) && !empty($invoice_id))
                                                            @php 
                                                                $fromPage = "invoice_payment";
                                                                $bookingId = $invoice_id;
                                                            @endphp

                                                        <input type="hidden" name="invoice_id" id="invoice_id" value="{{$invoice_id}}">
                                                        @else
                                                            @php 
                                                                $fromPage = "product_purchase";
                                                                $bookingId = "";
                                                            @endphp
                                                        @endif
                                                        <input type="hidden" name="product_type" id="product_type" value="{{$type}}">
                                                        <input type="hidden" name="razor_address_id" id="razor_payment_address_id" value="" spellcheck="false">
                                                        <input type="hidden" name="total" id="total_amount" value="{{round($toti,2)}}">
                                                        <input type="hidden" name="total_amount" id="full_total" value="{{round($toti,2)}}">
                                                        <input type="hidden" name="currency_rate" value="1.00" id="currency_rate">
                                                        <input type="hidden" name="currency" value="{{config('app.currency')}}">
                                                        <input type="hidden" name="cart_total" value="{{round($toti,2)}}">
                                                        
                                                        <input type="hidden" name="shipping_to" value="{{$userData->first_name.' '.$userData->last_name}}">
                                                        <script src="https://checkout.razorpay.com/v1/checkout.js"
                                                                data-key="{{ env('RAZOR_KEY') }}"
                                                                data-currency="{{config('app.currency')}}"
                                                                data-amount="{{round($tax+$toti,2)*100}}"
                                                                data-buttontext="Pay & Place Order"
                                                                data-name="{{ env('APP_NAME') }}"
                                                                data-description="{{ env('APP_NAME') }}-Razorpay payment"
                                                                data-image="{{ url('storage/'.get_site_config('email_logo')) }}"
                                                                data-prefill.name="{{$userData->name}}"
                                                                data-prefill.email="{{$userData->email}}"
                                                                data-notes.from="{{$fromPage}}"
                                                                data-notes.bookingId="{{$bookingId}}"
                                                                onclick="return checkform()"
                                                                data-theme.color="#ff7529">
                                                        </script>
                                                    </form>
                                                    @endif
                                                </div>
                                            </div>
                                            <!--End Place Order-->
                                        </div>
                                    </div>
                                    <!-- News Block Two -->
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
           
        </div>
    </section>
    </div>
</div>
@endsection
@push('after-styles')
<style>
    .razorpay-payment-button{
        background: #ffb22b;
        color: #ffffff;
        -webkit-box-shadow: 0 2px 2px 0 rgb(248 194 0 / 14%), 0 3px 1px -2px rgb(248 194 0 / 20%), 0 1px 5px 0 rgb(248 194 0 / 12%);
        box-shadow: 0 2px 2px 0 rgb(248 194 0 / 14%), 0 3px 1px -2px rgb(248 194 0 / 20%), 0 1px 5px 0 rgb(248 194 0 / 12%);
        border: 1px solid #ffb22b;
        -webkit-transition: 0.2s ease-in;
        -o-transition: 0.2s ease-in;
        transition: 0.2s ease-in;
        color: #ffffff;
        padding: 0.75rem 1.5rem;
        font-size: 1.25rem;
        border-radius: 0.3rem;
        cursor: pointer;
        margin-top:20px;
    }
</style>
@endpush

@push('after-scripts')
<script type="text/javascript">
    $(document).ready(function() {

        $('#firstname_err').hide();
        $('#lastname_err').hide();
        $('#address_err').hide();
        $('#country_err').hide();
        $('#state_err').hide();
        $('#city_err').hide();
        $('#zip_err').hide();
        $('#dailcode_err').hide();
        $('#mobile_err').hide();
        $('#email_err').hide();
        $('#password_err').hide();
        $('#confirmed_err').hide();

        $('#country-dd').on('change', function() {
            $("body").addClass("loadingg");
            var idCountry = this.value;
            $("#state-dd").html('');
            $.ajax({
                url: "{{url('api/fetch-states')}}",
                type: "POST",
                data: {
                    country_id: idCountry,
                    _token: '{{csrf_token()}}'
                },
                dataType: 'json',
                success: function(result) {
                    $("body").removeClass("loadingg");
                    $('#state-dd').html('<option value="">Select State</option>');
                    $.each(result.states, function(key, value) {
                        $("#state-dd").append('<option value="' + value.id + '">' + value.name + '</option>');
                    });
                    $('#city-dd').html('<option value="">Select City</option>');
                }
            });
        });
        $('#state-dd').on('change', function() {
            var idState = this.value;
            $("#city-dd").html('');
            $.ajax({
                url: "{{url('api/fetch-cities')}}",
                type: "POST",
                data: {
                    state_id: idState,
                    _token: '{{csrf_token()}}'
                },
                dataType: 'json',
                success: function(res) {
                    $('#city-dd').html('<option value="">Select City</option>');
                    $.each(res.cities, function(key, value) {
                        $("#city-dd").append('<option value="' + value.id + '">' + value.name + '</option>');
                    });
                }
            });
        });

        $('input[type="radio"]').click(function(){
            var radioValue = $(this).attr("value");
            if(radioValue=='razorpay'){
                 $("#order-btn").hide();
                 $("#razor-div").show();
            }else{
                $("#razor-div").hide();
                $("#order-btn").show();
            }
        });

    });

    if ($('#product_type').val() == "physical") {
        function checkPaymentAddress(country_id) {
            var rate = $('#currency_rate').val();
            var total_amount = $('#total_amount').val();
            $.ajax({
                url: "{{route('frontend.fetch-shipping-charges')}}",
                type: "POST",
                data: {
                    country_id: country_id,
                    _token: '{{csrf_token()}}'
                },
                dataType: 'json',
                success: function(res) {
                    console.log(res);
                    $("body").removeClass("loadingg");
                    if (res) {
                        $('#placeOrder').prop('disabled', false);
                        $.each(res.arr, function(i, item) {
                            if (item.shipable == 0) {
                                console.log(item.shipable);
                                // $('#product_tr_'+item.id).addClass('text-danger');
                                // $('#placeOrder').prop('disabled', true);
                                //     $("#print-error-msg").removeClass('d-none');
                                //     $("#print-error-msg").html('Items highlighted cannot be delievered to selected address.');
                                //     $("html, body").animate({ scrollTop: 0 }, "slow");
                            } else {
                                console.log(item.shipable);
                                $('#product_tr_' + item.id).removeClass('text-danger');
                            }
                        })
                        // }else{
                        //$("#print-error-msg").addClass('d-none');
                        //$('#placeOrder').prop('disabled',false);
                        var cart_total = $('#cart_total').val();
                        var ct = parseFloat(res.total_ship).toFixed(2);
                        var num = parseFloat(ct) + parseFloat(total_amount);
                        let updatedValue = num.toFixed(2);
                        $('#shipp').show();
                        $('#shipping_cost').html(parseFloat(res.total_ship).toFixed(2));
                        $('#ship_val_ad').val(parseFloat(res.total_ship).toFixed(2));
                        $('#totalValue').html('');
                        $('#totalValue').html(updatedValue);
                        $('#full_total').val(updatedValue);
                        $('#shipping_tr').removeClass('d-none');
                    }
                }
            });
        }


        function checkPaymentState(state_id) {
            var rate = $('#currency_rate').val();
            var total_amount = $('#total_amount').val();
            $("#print-error-msg").addClass('d-none');
            //$('.payment-address-div').addClass('border-grey');
            //$('.payment-address-div').removeClass('border border-primary');
            //$('.set-payment-address-btn').html("Use this");
            // $('#set-payment-address-'+address_id).html("Using this");
            //$('#payment-address-'+address_id).removeClass('border-grey');
            //$('#payment-address-'+address_id).addClass('border border-primary');
            //$('#payment_address_id').val(address_id);
            var stateid = state_id;
            var ctid = $("#country-dd option:selected").val();
            // var updatedValue = 0;
            $.ajax({
                url: "{{route('frontend.fetch-shipping-charges')}}",
                type: "POST",
                data: {
                    country_id: ctid,
                    state_id: stateid,
                    _token: '{{csrf_token()}}'
                },
                dataType: 'json',
                success: function(res) {
                    console.log(res);
                    $("body").removeClass("loadingg");
                    if (res) {
                        $('#placeOrder').prop('disabled', false);
                        $.each(res.arr, function(i, item) {
                            if (item.shipable == 0) {
                                console.log(item.shipable);
                                // $('#product_tr_'+item.id).addClass('text-danger');
                                // $('#placeOrder').prop('disabled', true);
                                //     $("#print-error-msg").removeClass('d-none');
                                //     $("#print-error-msg").html('Items highlighted cannot be delievered to selected address.');
                                //     $("html, body").animate({ scrollTop: 0 }, "slow");
                            } else {
                                console.log(item.shipable);
                                $('#product_tr_' + item.id).removeClass('text-danger');
                            }
                        })

                        var cart_total = $('#cart_total').val();
                        var ct = parseFloat(res.total_ship).toFixed(2);
                        var num = parseFloat(ct) + parseFloat(total_amount);
                        let updatedValue = num.toFixed(2);
                        $('#shipp').show();
                        $('#shipping_cost').html(parseFloat(res.total_ship).toFixed(2));
                        $('#ship_val_ad').val(res.total_ship);
                        // $('input[name=total]').val('');
                        // $('input[name=total]').val(parseFloat(updatedValue).toFixed(2));
                        $('#totalValue').html('');
                        $('#full_total').val(updatedValue);
                        $('#totalValue').html(updatedValue);
                        $('#shipping_tr').removeClass('d-none');

                    }
                }
            });
        }
    }

    function selectPaymentAddress(address_id) {
        $('.address_box').css("background", "white");
        $("#print-error-msg").addClass('d-none');
        $('.payment-address-div').addClass('border-grey');
        $('.payment-address-div').removeClass('border border-primary');
        $('.set-payment-address-btn').html("Deliver Here");
        $('#set-payment-address-' + address_id).html("Using this");
        $('#payment-address-' + address_id).removeClass('border-grey');
        $('#payment-address-' + address_id).addClass('border border-primary');
        $('#payment_address_id,#razor_payment_address_id').val(address_id);
        var ctid = $('#shipping_country_' + address_id).val();
        var stid = $('#shipping_state_' + address_id).val();
        var total_amount = $('#total_amount').val();
        // alert(state_id);
        $.ajax({
            url: "{{route('frontend.fetch-shipping-charges')}}",
            type: "POST",
            data: {
                country_id: ctid,
                state_id: stid,
                op: "op",
                _token: '{{csrf_token()}}'
            },
            dataType: 'json',
            success: function(res) {
                console.log(res);
                $("body").removeClass("loadingg");
                if (res) {
                    $('#placeOrder').prop('disabled', false);
                    $.each(res.arr, function(i, item) {
                        if (item.shipable == 0) {
                            console.log(item.shipable);
                            // $('#product_tr_'+item.id).addClass('text-danger');
                            // $('#placeOrder').prop('disabled', true);
                            //     $("#print-error-msg").removeClass('d-none');
                            //     $("#print-error-msg").html('Items highlighted cannot be delievered to selected address.');
                            //     $("html, body").animate({ scrollTop: 0 }, "slow");
                        } else {
                            console.log(item.shipable);

                            $('#product_tr_' + item.id).removeClass('text-danger');
                        }

                    })
                    //var cart_total = $('#cart_total').val();
                    var ct = parseFloat(res.total_ship).toFixed(2);
                    var num = parseFloat(ct) + parseFloat(total_amount.replace(",", ""));
                    let updatedValue = num.toFixed(2);

                    // alert(updatedValue);
                    $('#shipp').show();
                    $('#shipping_cost').html(parseFloat(res.total_ship).toFixed(2));
                    $('#ship_val_ad').val(res.total_ship);
                    // $('input[name=total]').val('');
                    // $('input[name=total]').val(parseFloat(updatedValue).toFixed(2));
                    $('#totalValue').html('');
                    $('#full_total').val(updatedValue);
                    $('#ad_sel').val('yes');
                    $('#totalValue').html(updatedValue);
                    $('#shipping_tr').removeClass('d-none');
                    $('#address_box' + address_id).css("background", "beige");
                }
            }
        });
    }

    function checkform() {
        var type = $('#logintype').val();
        if (type == "no") {

            if ($('#first_name').val() == '') {
                $('#firstname_err').show();
                return false
            }

            if ($('#last_name').val() == '') {
                $('#lastname_err').show();
                return false
            }

            if ($('#address').val() == '') {
                $('#address_err').show();
                return false
            }

            if ($('#country-dd').val() == '') {
                $('#country_err').show();
                return false
            }

            if ($('#state-dd').val() == '') {
                $('#state_err').show();
                return false
            }

            if ($('#city-dd').val() == '') {
                $('#city_err').show();
                return false
            }

            if ($('#zip').val() == '') {
                $('#zip_err').show();
                return false
            }

            // if($('#dialcode').val() == '') {
            //     $('#dailcode_err').show();
            //     return false
            // }

            if ($('#mobile').val() == '') {
                $('#mobile_err').show();
                return false
            }

            if ($('#email').val() == '') {
                $('#email_err').show();
                return false
            }

            if ($('#password').val() == '') {
                $('#password_err').show();
                return false
            }

            if ($('#confirmed').val() == '') {
                $('#confirmed_err').show();
                return false;
            }

            //@todo: temporarily commeted, fix
            // if ($('#ship_val_ad').val() == 0 && $('#product_type').val() == "physical") {
            //     alert('One or more items in your order cannot be shipped to the selected address');
            //     return false;
            // }
            return true;
        } else {
            if ($('#ship_val_ad').val() == 0 && $('#product_type').val() == "physical") {

                //@todo:temporarily commented, fix
                // if ($('#ad_sel').val() == "yes") {
                //     alert('One or more items in your order cannot be shipped to the selected address');
                //     return false;
                // }
                alert('Select Shippng Address');
                return false;
            }
            return true;
        }
    }
</script>
@endpush