<!-- Cookie banner ui -->
<div id="cookieConsent" class="cookie-consent-popup">
    <div class="cookie-content">
        <span class="close-btn" id="closeCookie">&times;</span>
        <div class="cookie-text">
            <p class="fw-bold mb-1">We value your privacy</p>
            <p class="cookie-desc">
                We use cookies to enhance your browsing experience, serve personalised ads or content,
                and analyse our traffic. By clicking "Accept All", you consent to our use of cookies.
                <a href="{{url('/page/cookie-policy')}}">Cookie Policy</a>
            </p>
        </div>
        <div class="cookie-actions">
            <button id="acceptAll" class="btn btn-sm btn-primary">Accept All</button>
            <button id="customizeBtn" class="btn btn-sm btn-outline-primary">Customize</button>
            <button id="rejectAll" class="btn btn-sm btn-outline-primary">Reject All</button>
        </div>
    </div>
</div>


<!--  Modal ui -->
<div id="cookieModal" class="cookie-modal">
    <div class="cookie-modal-content">
        <div class="modal-header">
            <h4 class="fw-bold mb-0">Cookies Consent</h4>
            <span class="close-btn" id="closeModal">&times;</span>
        </div>

        <div class="modal-body">
            <p>
                We use cookies to help you navigate efficiently and perform certain functions. You will find detailed
                information about all cookies under each consent category below.
            </p>
            <p>
                The cookies that are categorised as "Necessary" are stored on your browser as they are essential for
                enabling the basic functionalities of the site.
                We also use third-party cookies that help us analyse how you use this website, store your preferences,..
                <span id="moreText" class="d-none">
                    and provide the content and advertisements that are relevant to you. These cookies will only be
                    stored in your browser with your prior consent.
                    You can choose to enable or disable some or all of these cookies but disabling some of them may
                    affect your browsing experience.
                </span>
                <a href="javascript:void(0)" id="toggleMore">Show more</a>
            </p>

            <!-- Cookie options -->
            <div class="cookie-section">
                <label class="cookie-option">
                    <input type="checkbox" checked disabled>
                    <strong>Necessary</strong>
                    <p class="small"> These cookies are essential for the website to function and cannot be switched
                        off.</p>
                </label>
            </div>

            <div class="cookie-section">
                <label class="cookie-option">
                    <input type="checkbox" id="functionalCookies">
                    <strong>Functional (Preferences)</strong>
                    <p class="small">These cookies enable enhanced functionality and personalization.</p>
                </label>
            </div>

            <div class="cookie-section">
                <label class="cookie-option">
                    <input type="checkbox" id="analyticsCookies">
                    <strong>Analytics / Performance</strong>
                    <p class="small">These cookies help us understand how visitors interact with the site.</p>
                </label>
            </div>

            <div class="cookie-section">
                <label class="cookie-option">
                    <input type="checkbox" id="marketingCookies">
                    <strong>Marketing / Advertising</strong>
                    <p class="small">These cookies are used to deliver personalized ads.</p>
                </label>
            </div>
        </div>

        <div class="cookie-actions  mb-5">
            <button class="btn btn-outline-secondary" id="backBtn">Back</button>
            <!-- <button class="btn btn-primary">Accept Essential Cookies</button> -->
            <button class="btn btn-success">Save My Preference</button>
        </div>
    </div>
</div>
