@extends('frontend.layouts.app')

@section('public_content')
<div class="row page-titles wrapper px-5 pt-5" style="box-shadow: rgba(0, 0, 0, 0.2) 0px 5px 5px -3px;">
    <div class="col-md-5 align-self-center">
        <h3 class="text-themecolor">Country Information</h3>
        <ol class="breadcrumb" style="float:left;">
            <?php
            $title = "Country Information";
            $level = count($folder_breadcrumb);
            for ($i = $level - 1; $i >= 0; $i--) {
                echo "<li class=\"breadcrumb-item\"><a href=\"" . route('frontend.view-country', $folder_breadcrumb[$i]['id']) . "\">" . $folder_breadcrumb[$i]['name'] . "</a></li>";
                $title .= " - ".$folder_breadcrumb[$i]['name'];
            }
            ?>
        </ol>
    </div>
</div>

<div class="container-fluid " style="padding-top:30px; min-height: 65vh;">
    <div class="row mb-5">
        @foreach($folders as $folder)
        <div class="col-lg-3 col-md-6">
            <a href="<?php echo route('frontend.view-country', $folder['id']); ?>">
                <div class="card">
                    <img class="card-img-top" src="{{ asset('assets/images/page/info.jpg') }}">
                    <div class="card-body text-center">
                        <h4 class="card-title">{{ $folder['name'] }}</h4>
                        <p class="card-text">Browse Documents</p>
                    </div>
                </div>
            </a>
        </div>
        @endforeach
    </div>

    @if($access_denied)
    <div class="row">
        <div class="col-md-12">
            <div class="alert alert-danger">
                You do not have permission to access this folder. Please contact support.
            </div>
        </div>
    </div>
    @else
        @if(count($docs)>0)
            <div class="row mb-4">
                <div class="col-md-12">
                    <div class="card card-outline-success">
                        <div class="card-header">
                            <h4 class="m-b-0 text-themecolor">Documents</h4>
                        </div>
                        <div class="card-body">
                            @foreach($docs as $doc)
                                <p style="padding:0px 20px 10px 10px;">
                                    <img src="{{ asset('assets/images/page/dwnld.png') }}">
                                    <span style="font-size: 1.2em;font-weight: 600;"><a href="{{ $doc['file'] }}" target="_blank">{{ $doc['title'] }}</a></span>
                                    @if(strlen($doc['description']))
                                    <br />{{ $doc['description'] }}
                                    @endif
                                </p>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        @else
            @if($current_folder > 0)
                <div class="row mb-4">
                    <div class="col-md-12">No documents available in this folder</div>
                </div>
            @endif
        @endif
    @endif

</div>
@endsection

@if($title)
@section('title'){{$title}}@endsection
@endif