<!DOCTYPE html>
@langrtl
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" dir="rtl">
@else
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
@endlangrtl
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    @if(get_site_config('favicon'))
    <link rel="icon" type="image/png" sizes="32x32" href="{{ asset('storage/'.get_site_config('favicon')) }}">
    @endif
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>@yield('title', app_name())</title>
    <meta name="description" content="@yield('meta_description', '')">

    {{-- <link href="{{ asset('assets/plugins/bootstrap/css/bootstrap.min.css') }}" rel="stylesheet"> --}}
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    <link href="{{ asset('assets/plugins/bootstrap-datepicker/bootstrap-datepicker.min.css') }}" rel="stylesheet">
    <link href="{{ asset('assets/plugins/select2/dist/css/select2.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ asset('css/form-embed-style.css') }}" rel="stylesheet">
    <link href="{{asset('assets/DataTables/DataTables-1.12.1/css/dataTables.bootstrap5.css')}}" rel="stylesheet" type="text/css">

    <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
        <script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
        <script src="https://oss.maxcdn.com/libs/respond.js/1.4.2/respond.min.js"></script>
    <![endif]-->
    <style>
    #g-recaptcha-response {
      display: block !important;
      position: absolute;
      margin: -78px 0 0 0 !important;
      width: 302px !important;
      height: 76px !important;
      z-index: -999999;
      opacity: 0;
    }
</style>
</head>
<?php
$themeColor = get_site_config('frontend_theme');
if(!$themeColor){
    $themeColor = 'blue';
}
?>
<link href="{{ asset('css/colors/'.$themeColor.'.css') }}" id="theme" rel="stylesheet">
@if($form_data->title)
@section('title'){{$form_data->title}}@endsection
@endif
<?php
$academic_years = array();
$s_yr = date("Y") + 3;
$e_yr = $s_yr - 60;
for ($i = $s_yr; $i >= $e_yr; $i--) {
    $academic_years[] = $i;
}
?>
<body class="fix-header card-no-border">
   
<div id="main-wrapper">
<div class="new-page-wrapper">
<div class="container-lg mx-auto">
    <main class="inner cover mt-3 mb-4">
        <h2 class="cover-heading fw-bold text-dark">{{$form_data->form_heading}}</h2>
        <p class="lead mt-1">{{$form_data->description}}</p>
    </main>
    <span id="courses_count"></span>
    <div class="row mt-3 card">
        @if(!empty($formItems))
        <?php 
            $mobile_unique = $email_unique = 0;
        ?>
        <div class="col-12 card-body">
            <form action="{{route('form-builder-lead-tracking')}}" method="POST" id="form_builder_form">
            @csrf
                <input type='hidden' name='staff' value='{{$form_data->assign_to}}'>
                <input type='hidden' name='staff_branch' value='{{$form_data->branch}}'>
                <input type='hidden' name='form_id' value='{{$form_data->id}}'>
                <input type='hidden' name='form_type' value='embed'>
            <div class="row">
            @if(!in_array('country_of_citizenship', array_column($formItems, 'input_name')) && in_array('city', array_column($formItems, 'input_name')))
                <input type="hidden" id="country" name="country" value="{{env('USER_DEFAULT_COUNTRY')}}">
            @endif
            @foreach($formItems as $item)
            
                @if($item->input_name == 'name')
                        <div class="col-12">
                            <label class="fw-bold text-dark {{($item->mandatory) ? 'required-field' : ''}}">{{($item->label) ? $item->label : $item->title}}</label>
                            <input type="text" placeholder="{{$item->placeholder}}" class="form-control" name="name" {{($item->mandatory) ? 'required' : ''}}>
                            <small>{{$item->hint}}</small>
                        </div>
                @endif
                @if($item->input_name == 'full_name')
                    
                        <div class="col-6">
                            <label class="fw-bold text-dark {{($item->mandatory) ? 'required-field' : ''}}">First Name</label>
                            <input type="text" placeholder="First Name" class="form-control" name="first_name" {{($item->mandatory) ? 'required' : ''}}>
                        </div>
                        <div class="col-6">
                            <label class="fw-bold text-dark {{($item->mandatory) ? 'required-field' : ''}}">Last Name</label>
                            <input type="text" placeholder="Last Name" class="form-control" name="last_name" {{($item->mandatory) ? 'required' : ''}}>
                        </div>
                    
                @endif
                @if($item->input_name == 'email')
                <?php 
                    $email_present = 1;
                    if($item->unique){
                        $email_unique = 1;
                    ?>
                    <input type='hidden' name='email_unique' value='1'>
                    <?php
                    }else{
                        $email_unique = 0;
                    ?>
                        <input type='hidden' name='email_unique' value='0'>
                    <?php
                    }
                    ?>
                    <div class="col-md-6 col-sm-12 mt-3">
                        <label class="fw-bold text-dark {{($item->mandatory) ? 'required-field' : ''}}">{{($item->label) ? $item->label : $item->title}}</label>
                        <input type="email" id="email" placeholder="{{$item->placeholder}}" class="form-control" name="email" {{($item->mandatory) ? 'required' : ''}}>
                        <small>{{$item->hint}}</small>
                        <p class="error" id="invalid_email"></p>
                    </div>
                @endif
                @if($item->input_name == 'mobile')
                    <?php $mobile_present = 1;
                        if($item->unique){
                            $mobile_unique = 1;
                        ?>
                            <input type='hidden' name='mobile_unique' value='1'>
                        <?php
                        }else{
                            $mobile_unique = 0;
                        ?>
                            <input type='hidden' name='mobile_unique' value='0'>
                        <?php
                        }
                    ?>
                    <div class="col-md-6 col-sm-12 mt-3">
                        <label class="fw-bold text-dark {{($item->mandatory) ? 'required-field' : ''}}">{{($item->label) ? $item->label : $item->title}}</label>
                        
                        <div class="input-group">
                            <div class="input-group-prepend w-20">
                                <select class="form-select form-control" id="dialcode" name="dialcode" style="padding:0.49rem 2rem 0.375rem 0.75rem;" {{($item->mandatory) ? 'required' : ''}}>
                                    @foreach($dialcodes as $dialcode)
                                    <option value="{{$dialcode->dialcode}}">{{$dialcode->code.' +'.$dialcode->dialcode}}</option>
                                    @endforeach
                                </select>
                            </div>
                            <input 
                                type="text" 
                                placeholder="{{$item->placeholder}}" 
                                class="form-control" 
                                onkeypress="return (event.charCode !=8 && event.charCode ==0 || (event.charCode >= 48 && event.charCode <= 57))" 
                                name="mobile"
                                id="mobile"
                                minlength="{{ config('app.USER_MOBILE_MIN_LENGTH') }}" 
                                maxlength="{{ config('app.USER_MOBILE_MAX_LENGTH') }}" 
                                {{($item->mandatory) ? 'required' : ''}}>
                        </div>
                        <small>{{$item->hint}}</small>
                        <p class="error" id="invalid_mobile"></p>
                    </div>
                @endif

                @if($item->input_name == 'whatsapp')
                    <div class="col-md-6 col-sm-12 mt-3">
                        <label class="fw-bold text-dark {{($item->mandatory) ? 'required-field' : ''}}">{{($item->label) ? $item->label : $item->title}}</label>
                        <div class="input-group">
                            <div class="input-group-prepend w-20">
                                <select class="form-select form-control" id="whatsapp_dialcode" name="whatsapp_dialcode" style="padding:0.49rem 2rem 0.375rem 0.75rem;" {{($item->mandatory) ? 'required' : ''}}>
                                    @foreach($dialcodes as $dialcode)
                                    <option value="{{$dialcode->dialcode}}">{{$dialcode->code.' +'.$dialcode->dialcode}}</option>
                                    @endforeach
                                </select>
                            </div>
                            <input type="text" placeholder="{{$item->placeholder}}" id="whatsapp_number" minlength="{{ config('app.USER_MOBILE_MIN_LENGTH') }}" maxlength="{{ config('app.USER_MOBILE_MAX_LENGTH') }}" class="form-control" name="whatsapp" {{($item->mandatory) ? 'required' : ''}}>
                        </div>
                        <small>{{$item->hint}}</small>
                    </div>
                @endif

                @if($item->input_name == 'date_of_birth')
                    <div class="col-md-6 col-sm-12 mt-3">
                        <label class="fw-bold text-dark {{($item->mandatory) ? 'required-field' : ''}}">{{($item->label) ? $item->label : $item->title}}</label>
                        <input type="text" class="form-control mydatepicker" autocomplete="off" id="dateOfBirth" name="date_of_birth" placeholder="{{$item->placeholder}}" {{($item->mandatory) ? 'required' : ''}}>
                        <small>{{$item->hint}}</small>
                    </div>
                @endif

                @if($item->input_name == 'gender')
                    <div class="col-md-6 col-sm-12 mt-3">
                            <label style="margin-bottom: 0.5rem;" class="fw-bold text-dark {{($item->mandatory) ? 'required-field' : ''}}">{{($item->label) ? $item->label : $item->title}}</label>
                            <div>
                            <input type="radio" class="radio-col-blue" name="gender" id="male" value="male" {{($item->mandatory) ? 'required' : ''}}>
                            <label class="custom-control-label" for="male">Male</label>
                            <input type="radio" class="radio-col-blue" name="gender" id="female" value="female" {{($item->mandatory) ? 'required' : ''}}>
                            <label class="custom-control-label" for="female">Female</label>
                            </div>
                        <small>{{$item->hint}}</small>
                    </div>
                @endif
                @if($item->input_name == 'marital_status')
                    <div class="col-md-6 col-sm-12 mt-3">
                            <label style="margin-bottom: 0.5rem;" class="fw-bold text-dark {{($item->mandatory) ? 'required-field' : ''}}">{{($item->label) ? $item->label : $item->title}}</label>
                            <div>
                            <input type="radio" class="radio-col-blue" name="marital_status" id="single" value="Single" {{($item->mandatory) ? 'required' : ''}}>
                            <label class="custom-control-label" for="single">Single</label>
                            <input type="radio" class="radio-col-blue" name="marital_status" id="married" value="Married" {{($item->mandatory) ? 'required' : ''}}>
                            <label class="custom-control-label" for="married">Married</label>
                            </div>
                        <small>{{$item->hint}}</small>
                    </div>
                @endif

                @if($item->input_name == 'country_of_citizenship')
                    <div class="col-md-6 col-sm-12 mt-3">
                            <label style="margin-bottom: 0.5rem;" class="fw-bold text-dark {{($item->mandatory) ? 'required-field' : ''}}">{{($item->label) ? $item->label : $item->title}}</label>
                            <select class="form-select form-control" id="country" name="country_of_citizenship" {{($item->mandatory) ? 'required' : ''}}>
                                <option value="">Select Country</option>
                                @foreach ($country_list as $key => $value)
                                <option value="{{ $key }}">{{ $value }}</option>
                                @endforeach
                            </select>
                        <small>{{$item->hint}}</small>
                    </div>
                @endif
                @if($item->input_name == 'city')
                    <div class="col-md-6 col-sm-12 mt-3">
                            <label style="margin-bottom: 0.5rem;" class="fw-bold text-dark {{($item->mandatory) ? 'required-field' : ''}}">{{($item->label) ? $item->label : $item->title}}</label>
                            <select class="form-control form-select" id="city-dd" name="city" {{($item->mandatory) ? 'required' : ''}}>
                                <option value="">Select City</option>
                            </select>
                        <small>{{$item->hint}}</small>
                    </div>
                @endif

                @if($item->input_name == 'passout_year')
                    <div class="col-md-6 col-sm-12 mt-3">
                            <label style="margin-bottom: 0.5rem;" class="fw-bold text-dark {{($item->mandatory) ? 'required-field' : ''}}">{{($item->label) ? $item->label : $item->title}}</label>
                            <input type="text" placeholder="{{$item->placeholder}}" onkeypress="return (event.charCode !=8 && event.charCode ==0 || (event.charCode >= 48 && event.charCode <= 57))" minlength="4" maxlength="4" class="form-control" id="passout_year" name="passout_year" {{($item->mandatory) ? 'required' : ''}}>
                        <small>{{$item->hint}}</small>
                    </div>
                @endif


                @if($item->input_name == 'visa_refusal')
                {{-- <div class="row"> --}}
                    <div class="col-md-3 col-sm-6 mt-3">
                            <label style="margin-bottom: 0.5rem;" class="fw-bold text-dark {{($item->mandatory) ? 'required-field' : ''}}">{{($item->label) ? $item->label : $item->title}}</label>
                            <div>
                            <input type="radio" class="radio-col-blue" name="visa_refusal" id="no_visa_refusal" value="0" {{($item->mandatory) ? 'required' : ''}}>
                            <label class="custom-control-label" for="no_visa_refusal">No</label>
                            <input type="radio" class="radio-col-blue" name="visa_refusal" id="yes_visa_refusal" value="1" {{($item->mandatory) ? 'required' : ''}}>
                            <label class="custom-control-label" for="yes_visa_refusal">Yes</label>
                            </div>
                        <small>{{$item->hint}}</small>
                    </div>
                    <div class="col-md-3 mt-3" id="select_visa_refusal_country" style="display:none;" >
                            <label class="fw-bold text-dark">Select Country</label>
                            <select class="form-control form-select select2" style="width: 100%" id="visa_refusal_country" name="visa_refusal_country[]" multiple>
                                @foreach ($country_list as $key => $value)
                                <option value="{{ $key }}">{{ $value }}</option>
                                @endforeach
                            </select>
                    </div>
                {{-- </div> --}}
                @endif

                @if($item->input_name == 'currently_studying_course')
                    <div class="col-md-6 col-sm-12 mt-3">
                            <label style="margin-bottom: 0.5rem;" class="fw-bold text-dark {{($item->mandatory) ? 'required-field' : ''}}">{{($item->label) ? $item->label : $item->title}}</label>
                            <input type="text" placeholder="{{$item->placeholder}}" class="form-control" id="current_course" name="current_course" {{($item->mandatory) ? 'required' : ''}}>
                        <small>{{$item->hint}}</small>
                    </div>
                @endif

                @if($item->input_name == 'interested_study_level')
                    <div class="col-md-6 col-sm-12 mt-3">
                            <label style="margin-bottom: 0.5rem;" class="fw-bold text-dark {{($item->mandatory) ? 'required-field' : ''}}">{{($item->label) ? $item->label : $item->title}}</label>
                            <select class="form-control form-select" id="study_level" name="study_level" {{($item->mandatory) ? 'required' : ''}}>
                                <option value="">Select Study Level</option>
                                @foreach(get_study_levels() as $key => $value)
                                <option value="{{$value}}">{{$value}}</option>
                                @endforeach
                            </select>
                        <small>{{$item->hint}}</small>
                    </div>
                @endif

                @if($item->input_name == 'course_interested')
                    <div class="col-md-6 col-sm-12 mt-3">
                            <label style="margin-bottom: 0.5rem;" class="fw-bold text-dark {{($item->mandatory) ? 'required-field' : ''}}">{{($item->label) ? $item->label : $item->title}}</label>
                            <input type="text" placeholder="{{$item->placeholder}}" class="form-control" id="course_interested" name="course_interested" {{($item->mandatory) ? 'required' : ''}}>
                        <small>{{$item->hint}}</small>
                    </div>
                @endif

                @if($item->input_name == 'intake')
                    <div class="col-md-6 col-sm-12 mt-3">
                            <label style="margin-bottom: 0.5rem;" class="fw-bold text-dark {{($item->mandatory) ? 'required-field' : ''}}">{{($item->label) ? $item->label : $item->title}}</label>
                            <select name="intake" class="form-select form-control" {{($item->mandatory) ? 'required' : ''}}>
                                <option value="">Intake</option>
                                <?php $month = date('n'); // current month
                                for ($x = 0; $x < 24; $x++) { ?>
                                <option value="<?php echo date('m Y', mktime(0,0,0,$month + $x,1)); ?>" >
                                <?php echo date('F Y', mktime(0,0,0,$month + $x,1)); ?>
                                <?php } ?></option>
                                </select>
                        <small>{{$item->hint}}</small>
                    </div>
                @endif

                @if($item->input_name == 'country_interested')
                    <div class="col-md-6 col-sm-12 mt-3">
                            <label style="margin-bottom: 0.5rem;" class="fw-bold text-dark {{($item->mandatory) ? 'required-field' : ''}}">{{($item->label) ? $item->label : $item->title}}</label>
                            <select name="country_interested" class="form-control form-select" {{($item->mandatory) ? 'required' : ''}}>
                                <option value="">Select Country</option>
                                @foreach($study_countries as $study_country)
                                    <option value="{{ $study_country->title_en }}">{{ $study_country->title_en }}</option>
                                @endforeach
                            </select>
                        <small>{{$item->hint}}</small>
                    </div>
                @endif

                @if($item->input_name == 'qualification')
                    <div class="col-md-6 col-sm-12 mt-3">
                            <label style="margin-bottom: 0.5rem;" class="fw-bold text-dark {{($item->mandatory) ? 'required-field' : ''}}">{{($item->label) ? $item->label : $item->title}}</label>
                            <select class="form-control form-select" id="qualification" name="qualification" {{($item->mandatory) ? 'required' : ''}}>
                                <option value="">Select Qualification</option>
                                <option value="9th" {{ Request::old('9th') == '9th' ? 'selected' : '' }}>9th
                                </option>
                                <option value="10th" {{ Request::old('10th') == '10th' ? 'selected' : '' }}>10th
                                </option>
                                <option value="11th" {{ Request::old('11th') == '11th' ? 'selected' : '' }}>11th
                                </option>
                                <option value="12th" {{ Request::old('12th') == '12th' ? 'selected' : '' }}>12th
                                </option>
                                <option value="Bachelors" {{ Request::old('qualification') == 'Bachelors' ? 'selected' : '' }}>Bachelors
                                </option>
                                <option value="Masters" {{ Request::old('qualification') == 'Masters' ? 'selected' : '' }}>Masters
                                </option>
                                <option value="Ph.D" {{ Request::old('qualification') == 'Ph.D' ? 'selected' : '' }}>Ph.D
                                </option>                            
                            </select>
                        <small>{{$item->hint}}</small>
                    </div>
                @endif

                @if($item->input_name == 'score')
                    <div class="col-md-6 col-sm-12 mt-3">
                            <label style="margin-bottom: 0.5rem;" class="fw-bold text-dark {{($item->mandatory) ? 'required-field' : ''}}">{{($item->label) ? $item->label : $item->title}}</label>
                            <input type="text" placeholder="{{$item->placeholder}}" class="form-control" id="score" name="score" {{($item->mandatory) ? 'required' : ''}}>
                        <small>{{$item->hint}}</small>
                    </div>
                @endif

                @if($item->input_name == 'academic')

                    {{-- <div class="col-6 mt-3">
                            <label style="margin-bottom: 0.5rem;" class="fw-bold text-dark {{($item->mandatory) ? 'required-field' : ''}}">{{($item->label) ? $item->label : $item->title}}</label>
                            <input type="text" placeholder="{{$item->placeholder}}" class="form-control" id="score" name="score" {{($item->mandatory) ? 'required' : ''}}>
                        <small>{{$item->hint}}</small>
                    </div> --}}
                    <div class="row">
                        <div class="card-body pb-0">
                            <hr>
                            <label style="margin-bottom: 0.5rem;" class="fw-bold text-dark {{($item->mandatory) ? 'required-field' : ''}}">{{($item->label) ? $item->label : $item->title}}</label>
                            <div class="table-responsive mt-0">
                                <table class="table">
                                    <thead>
                                        <tr>
                                            <th>Education Level</th>
                                            <th>Percentage or CGPA</th>
                                            <th>Year of Passing</th>
                                            <th>Specialisation</th>
                                            <th>School\University</th>
                                            <th>University\Board</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @php
                                        $aca_level = array('10', '12', 'Diploma', 'Bachelors', 'Masters', 'Other');
                                        @endphp
                                        @for ($i = 0; $i < count($aca_level); $i++) <tr>
                                            <td>
                                                <?php
                                                echo $aca_level[$i];
                                                if ($aca_level[$i] == '10' || $aca_level[$i] == '12') {
                                                    echo '<sup>th</sup>';
                                                }
                                                ?>
                                            </td>
                                            <td>
                                                <input type="text" name='aca[<?= $aca_level[$i] ?>][percent_cgpa]' class='form-control' value="" />
                                            </td>
                                            <td>
                                                <select name='aca[<?= $aca_level[$i] ?>][pass_year]' class='form-control' style="min-width:80px">
                                                    <option value="">Select</option>
                                                    <?php
                                                    foreach ($academic_years as $year) {
                                                        echo "<option value='$year'>$year</option>";
                                                    }
                                                    ?>
                                                </select>
                                            </td>
                                            <td>
                                                <input type="text" name='aca[<?= $aca_level[$i] ?>][specialization]' class='form-control' value="" />
                                            </td>
                                            <td>
                                                <input type="text" name='aca[<?= $aca_level[$i] ?>][school_college]' class='form-control' value="" />
                                            </td>
                                            <td>
                                                <input type="text" name='aca[<?= $aca_level[$i] ?>][university]' class='form-control' value="" />
                                            </td>
                                            </tr>
                                            @endfor
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                @endif

                @if($item->input_name == 'english_test')
                    {{-- <div class="col-6 mt-3">
                            <label style="margin-bottom: 0.5rem;" class="fw-bold text-dark {{($item->mandatory) ? 'required-field' : ''}}">{{($item->label) ? $item->label : $item->title}}</label>
                            <input type="text" placeholder="{{$item->placeholder}}" class="form-control" id="score" name="score" {{($item->mandatory) ? 'required' : ''}}>
                        <small>{{$item->hint}}</small>
                    </div> --}}
                    <div class="row">
                        <div class="card-body pb-0">
                            <label style="margin-bottom: 0.5rem;" class="fw-bold text-dark {{($item->mandatory) ? 'required-field' : ''}}">{{($item->label) ? $item->label : $item->title}}</label>
                            <div class="table-responsive mt-0">
                                <table class="table">
                                    <thead>
                                        <tr>
                                            <th>Exam</th>
                                            <th>Overall Score</th>
                                            <th>Speaking</th>
                                            <th>Reading</th>
                                            <th>Listening</th>
                                            <th>Writing</th>
                                            <th>Score expiry Date</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @php
                                        $languages = array('IELTS', 'TOEFL', 'PTE');
                                        @endphp
                                        @for ($i = 0; $i < count($languages); $i++) <tr>
                                            <td>{{$languages[$i]}}</td>
                                            
                                            <td>
                                                <input type="text" name='eng[<?= $languages[$i] ?>][overall_score]' class='form-control' value="" />
                                            </td>
                                            <td>
                                                <input type="text" name='eng[<?= $languages[$i] ?>][speaking]' class='form-control' value="" />
                                            </td>
                                            <td>
                                                <input type="text" name='eng[<?= $languages[$i] ?>][reading]' class='form-control' value="" />
                                            </td>
                                            <td>
                                                <input type="text" name='eng[<?= $languages[$i] ?>][listening]' class='form-control' value="" />
                                            </td>
                                            <td>
                                                <input type="text" name='eng[<?= $languages[$i] ?>][writing]' class='form-control' value="" />
                                            </td>
                                            <td>
                                                <input type="text" name='eng[<?= $languages[$i] ?>][expiry_date]' class='form-control mydatepicker' placeholder="dd-mm-yyyy" value="" style="min-width:100px;" />
                                            </td>
                                            </tr>
                                            @endfor
                                    </tbody>
                                </table>
                            </div>
        <!-- -------------//DET------------ -->
        <label style="margin-bottom: 0.5rem;" class="fw-bold text-dark">DET/ACT/SAT</label>
        <div class="table-responsive mt-0">
                                <table class="table">
                                    <thead>
                                        <tr>
                                            <th>Exam</th>
                                            <th>Overall Score</th>
                                            <th>Score expiry Date</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                       <tr>
                                            <td>DET</td>
                                            <td>
                                                <input type="text" name='det_overall_score' class='form-control' value="" />
                                            </td>
                                            <td>
                                                <input type="text" name='det_expiry_date' class='form-control mydatepicker' placeholder="dd-mm-yyyy" style="min-width:100px;" />
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
        </div>
        <!-- -------------//ACT------------ -->
        <div class="table-responsive mt-0">
                                <table class="table">
                                    <thead>
                                        <tr>
                                            <th>Exam</th>
                                            <th>Overall Score</th>
                                            <th>Math</th>
                                            <th>Reading</th>
                                            <th>Writing</th>
                                            <th>Science</th>
                                            <th>English</th>
                                            <th>Score expiry Date</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                       <tr>
                                            <td>ACT</td>
                                            <td>
                                                <input type="text" name='act_overall_score' class='form-control' value="" />
                                            </td>
                                            <td>
                                                <input type="text" name='act_math' class='form-control' value="" />
                                            </td>
                                            <td>
                                                <input type="text" name='act_reading' class='form-control' value="" />
                                            </td>
                                            <td>
                                                <input type="text" name='act_writing' class='form-control' value="" />
                                            </td>
                                            <td>
                                                <input type="text" name='act_science' class='form-control' value="" />
                                            </td>
                                            <td>
                                                <input type="text" name='act_english' class='form-control' value="" />
                                            </td>
                                            <td>
                                                <input type="text" name='act_expiry_date' class='form-control mydatepicker' placeholder="dd-mm-yyyy" style="min-width:100px;" />
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
        </div>
<!-- -------------//SAT------------ -->
<div class="table-responsive mt-0">
                                <table class="table">
                                    <thead>
                                        <tr>
                                            <th>Exam</th>
                                            <th>Overall Score</th>
                                            <th>Math</th>
                                            <th>Reading</th>
                                            <th>Writing</th>
                                            <th>Essay</th>
                                            <th>Score expiry Date</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                       <tr>
                                            <td>SAT</td>
                                            <td>
                                                <input type="text" name='sat_overall_score' class='form-control' value="" />
                                            </td>
                                            <td>
                                                <input type="text" name='sat_math' class='form-control' value="" />
                                            </td>
                                            <td>
                                                <input type="text" name='sat_reading' class='form-control' value="" />
                                            </td>
                                            <td>
                                                <input type="text" name='sat_writing' class='form-control' value="" />
                                            </td>
                                            <td>
                                                <input type="text" name='sat_essay' class='form-control' value="" />
                                            </td>
                                            <td>
                                                <input type="text" name='sat_expiry_date' class='form-control mydatepicker' placeholder="dd-mm-yyyy" style="min-width:100px;" />
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
</div>
{{----------------------- GRE/GMAT ----------------------------------}}
<label style="margin-bottom: 0.5rem;" class="fw-bold text-dark">GRE/GMAT</label>
                        <div class="table-responsive">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th>Exam</th>
                                        <th>Total Score</th>
                                        <th>Verbal Reasoning</th>
                                        <th>Quantitative</th>
                                        <th>Analytical</th>
                                        <th>Integrated</th>
                                        <th>Expiry Date</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>GRE</td>
                                        <td>
                                            <input type="text" name="exam[gre][total_score]" class="form-control" value="" onkeyup='validnum(this.value,"total_gre");' onkeypress="return onlyNumberKey(event)" autocomplete="off"/>
                                            <span id="total_gre_err" class="text-danger d-none" style="font-size: 10px;">GRE Total score range is: 260 to 340</span>
                                        </td>
                                        <td>
                                            <input type="text" name="exam[gre][verbal]" class="form-control" value="" onkeyup='validnum(this.value,"verbal_gre");' onkeypress="return onlyNumberKey(event)" autocomplete="off"/>
                                            <span id="verbal_gre_err" class="text-danger d-none" style="font-size: 10px;">GRE Verbal Reasoning range is: 130 to 170</span>
                                        </td>
                                        <td>
                                            <input type="text" name="exam[gre][quantitative]" class="form-control" value="" onkeyup='validnum(this.value,"quant_gre");' onkeypress="return onlyNumberKey(event)" autocomplete="off"/>
                                            <span id="quant_gre_err" class="text-danger d-none" style="font-size: 10px;">GRE Quantitative range is: 130 to 170</span>
                                        </td>
                                        <td>
                                            <input type="text" name="exam[gre][analytical]" class="form-control" value="" onkeyup='validnum(this.value,"ana_gre");' onkeypress="return onlyNumberKey(event)" autocomplete="off"/>
                                            <span id="ana_gre_err" class="text-danger d-none" style="font-size: 10px;">GRE Analytical score range is: 0 to 6</span>
                                        </td>
                                        <td>
                                            <input type="text" name="exam[gre][integrated]" class="form-control" value="" onkeyup='validnum(this.value,"inte_gre");' onkeypress="return onlyNumberKey(event)" autocomplete="off"/>
                                            <span id="inte_gre_err" class="text-danger d-none" style="font-size: 10px;">GRE Integrated score range is: 260 to 340</span>
                                        </td>
                                        <td>
                                            <input type="text" name="exam[gre][expiry_date]" class="form-control mydatepicker" placeholder="dd-mm-yyyy" style="min-width:120px;" autocomplete="off"/>
                                        </td>

                                    </tr>
                                    <tr>
                                        <td>GMAT</td>
                                        <td>
                                            <input type="text" name="exam[gmat][total_score]" class="form-control" value="" onkeyup='validnum(this.value,"total_gmat");' onkeypress="return onlyNumberKey(event)" autocomplete="off"/>
                                            <span id="total_gmat_err" class="text-danger d-none" style="font-size: 10px;">GMAT Total score range is: 200 to 800</span>
                                        </td>
                                        <td>
                                            <input type="text" name="exam[gmat][verbal]" class="form-control" value="" onkeyup='validnum(this.value,"verbal_gmat");' onkeypress="return onlyNumberKey(event)" autocomplete="off"/>
                                            <span id="verbal_gmat_err" class="text-danger d-none" style="font-size: 10px;">GMAT Verbal Reasoning range is: 0 to 60</span>
                                        </td>
                                        <td>
                                            <input type="text" name="exam[gmat][quantitative]" class="form-control" value="" onkeyup='validnum(this.value,"quant_gmat");' onkeypress="return onlyNumberKey(event)" autocomplete="off"/>
                                            <span id="quant_gmat_err" class="text-danger d-none" style="font-size: 10px;">GMAT Quantitative range is: 0 to 60</span>
                                        </td>
                                        <td>
                                            <input type="text" name="exam[gmat][analytical]" class="form-control" value="" onkeyup='validnum(this.value,"ana_gmat");' onkeypress="return onlyNumberKey(event)" autocomplete="off"/>
                                            <span id="ana_gmat_err" class="text-danger d-none" style="font-size: 10px;">GMAT Analytical score range is: 0 to 6</span>
                                        </td>
                                        <td>
                                            <input type="text" name="exam[gmat][integrated]" class="form-control" value="" onkeyup='validnum(this.value,"inte_gmat");' onkeypress="return onlyNumberKey(event)" autocomplete="off"/>
                                            <span id="inte_gmat_err" class="text-danger d-none" style="font-size: 10px;">GMAT Integrated score range is: 1 to 8</span>
                                        </td>
                                        <td>
                                            <input type="text" name="exam[gmat][expiry_date]" class="form-control mydatepicker" placeholder="dd-mm-yyyy" style="min-width:120px;" autocomplete="off"/>
                                        </td>
                                    </tr>

                                </tbody>
                            </table>
                        </div>
                        </div>
                    </div>
                @endif


                @if($item->input_name == 'experience')
                    <div class="col-md-6 col-sm-12 mt-3">
                            <label style="margin-bottom: 0.5rem;" class="fw-bold text-dark {{($item->mandatory) ? 'required-field' : ''}}">{{($item->label) ? $item->label : $item->title}}</label>
                            <input type="text" placeholder="{{$item->placeholder}}" class="form-control" id="experience" name="experience" {{($item->mandatory) ? 'required' : ''}}>
                        <small>{{$item->hint}}</small>
                    </div>
                @endif

                @if($item->type == 'custom_attr')
                    {{-- <div class="col-6 mt-3">
                            <label style="margin-bottom: 0.5rem;" class="fw-bold text-dark {{($item->mandatory) ? 'required-field' : ''}}">{{($item->label) ? $item->label : $item->title}}</label>
                            <input type="text" placeholder="{{$item->placeholder}}" class="form-control" id="experience" name="experience" {{($item->mandatory) ? 'required' : ''}}>
                        <small>{{$item->hint}}</small>
                    </div> --}}
        {{-- //Custom Attributes --}}
        <?php $custom_attribute = get_attr_data($item->input_name); ?>
            @if($custom_attribute)
            {{-- <hr style="height:1px;"> --}}
            
                    @if($custom_attribute->for_student_mandatory)
                    <?php   $red = "required-field";
                            $mandate = "required"; ?>
                    @else
                    <?php $red="";
                        $mandate = "";?>
                @endif

                    @if($custom_attribute->type == 'input')
                        <div class="col-md-6 col-sm-12 mt-3">
                            <label style="margin-bottom: 0.5rem;" class="fw-bold text-dark {{($item->mandatory) ? 'required-field' : ''}}">{{($item->label) ? $item->label : $item->title}}</label>
                            <input type="@if($custom_attribute->input_datatype == 'number' || $custom_attribute->input_datatype == 'decimal'){{'number'}}@elseif($custom_attribute->input_datatype == 'date' || $custom_attribute->input_datatype == 'year' || $custom_attribute->input_datatype == 'phone'){{'text'}}@else{{$custom_attribute->input_datatype}}@endif" {{ ($custom_attribute->input_datatype == 'decimal')? "step=any" : ''}} 
                            @if($custom_attribute->input_datatype == 'number' || $custom_attribute->input_datatype == 'decimal')
                                {{"min=$custom_attribute->input_min"}} {{"max=$custom_attribute->input_max"}}
                            @elseif($custom_attribute->input_datatype == 'date')
                            {{-- //No min or max added --}}
                            @elseif($custom_attribute->input_datatype == 'year')
                                onkeypress="return (event.charCode !=8 && event.charCode ==0 || (event.charCode >= 48 && event.charCode <= 57))" minlength="4" maxlength="4"
                            @elseif($custom_attribute->input_datatype == 'phone')
                                onkeypress="return (event.charCode !=8 && event.charCode ==0 || (event.charCode >= 48 && event.charCode <= 58) || event.charCode==32 || event.charCode==44 || event.charCode==43 || event.charCode==45 || event.charCode==40 || event.charCode==41)" minlength="10" maxlength="18"
                            @else
                                {{"minLength=$custom_attribute->input_min"}} {{"maxLength=$custom_attribute->input_max"}}
                            @endif
                            placeholder="{{($item->placeholder) ? $item->placeholder : $custom_attribute->placeholder}}" autocomplete="off" class="form-control @if($custom_attribute->input_datatype == 'date') {{'mydatepicker'}}@endif" name="{{$custom_attribute->attr_name}}" value='' {{($item->mandatory) ? 'required' : ''}}>
                        </div>
                    @endif
                    @if($custom_attribute->type == 'textarea')
                        <div class="col-md-6 col-sm-12 mt-3">
                            <label style="margin-bottom: 0.5rem;" class="fw-bold text-dark {{($item->mandatory) ? 'required-field' : ''}}">{{($item->label) ? $item->label : $item->title}}</label>
                                <textarea placeholder="{{($item->placeholder) ? $item->placeholder : $custom_attribute->placeholder}}" {{"minLength=$custom_attribute->input_min"}} {{"maxLength=$custom_attribute->input_max"}} class="form-control" name="{{$custom_attribute->attr_name}}" {{($item->mandatory) ? 'required' : ''}}></textarea>
                        </div>
                    @endif
                    @if($custom_attribute->type == 'select')
                    <?php
                        $is_multi = $select2 = "";
                        $select_vals = explode('|',$custom_attribute->selection_values);
                        if($custom_attribute->select_multiple){
                            $is_multi = "multiple";
                            $select2 = "select2";
                        }
                    ?>
                       <div class="col-md-6 col-sm-12 mt-3">
                                <label style="margin-bottom: 0.5rem;" class="fw-bold text-dark {{($item->mandatory) ? 'required-field' : ''}}">{{($item->label) ? $item->label : $item->title}}</label>
                                <div class="">
                                    <select placeholder="{{$item->placeholder}}" class="form-control form-select {{$select2}}" name="{{$custom_attribute->attr_name}}[]" {{($item->mandatory) ? 'required' : ''}} {{$is_multi}}>
                                        @if(!$is_multi)
                                        <option value="">{{($item->placeholder) ? $item->placeholder : $custom_attribute->placeholder}}</option>
                                        @endif
                                        @foreach($select_vals as $sel_val)
                                        <option {{ (is_array(old("$custom_attribute->attr_name")) && in_array($sel_val, old("$custom_attribute->attr_name"))) ? ' selected' : '' }} value="{{ $sel_val }}">{{ $sel_val }}</option>
                                        @endforeach
                                    </select>
                                </div>
                        </div>
                    @endif
                    @if($custom_attribute->type == 'checkbox')
                    <?php
                        $select_vals = explode('|',$custom_attribute->selection_values);
                    ?>
                        <div class="col-md-6 col-sm-12 mt-3">
                                {{-- <label for="" class="form-label {{$red}}">{{$custom_attribute->label}}</label> --}}
                                <label style="margin-bottom: 0.5rem;" class="fw-bold text-dark {{($item->mandatory) ? 'required-field' : ''}}">{{($item->label) ? $item->label : $item->title}}</label>
                               <div>
                                    @foreach($select_vals as $sel_val)
                                    <label>
                                        <input style="" class="form-check-input {{$custom_attribute->attr_name}}" @if($item->mandatory) onclick='chk_mend("{{$custom_attribute->attr_name}}")' @endif type="checkbox" name="{{$custom_attribute->attr_name}}[]" value="{{$sel_val}}" {{($item->mandatory) ? 'required' : ''}}> {{$sel_val}}
                                    </label>
                                    @endforeach
                               </div>
                        </div>
                    @endif
                    @if($custom_attribute->type == 'radio')
                    <?php
                        $select_vals = explode('|',$custom_attribute->selection_values);
                    ?>
                        <div class="col-md-6 col-sm-12 mt-3">
                            <label style="margin-bottom: 0.5rem;" class="fw-bold text-dark {{($item->mandatory) ? 'required-field' : ''}}">{{($item->label) ? $item->label : $item->title}}</label>
                            <div>
                                @foreach($select_vals as $sel_val)
                                    <input class="radio-col-blue form-check-input {{$custom_attribute->attr_name}}" id="{{$loop->index}}" @if($mandate) onclick='chk_mend("{{$custom_attribute->attr_name}}")' @endif type="radio" name="{{$custom_attribute->attr_name}}[]" value="{{$sel_val}}" {{($item->mandatory) ? 'required' : ''}}>
                                    <label class="custom-control-label" for="{{$loop->index}}">{{$sel_val}}</label>
                                @endforeach
                            </div>
                        </div>
                    @endif
            {{-- <hr style="height:1px;"> --}}
            @endif
            {{-- //Custom Attributes --}}
            @endif
            @if($item->input_name == 'enquiry')
            <div class="col-6 mt-3">
                    <label style="margin-bottom: 0.5rem;" class="fw-bold text-dark {{($item->mandatory) ? 'required-field' : ''}}">{{($item->label) ? $item->label : $item->title}}</label>
                    <textarea placeholder="{{$item->placeholder}}" class="form-control" id="notes" name="notes" {{($item->mandatory) ? 'required' : ''}}></textarea>
                <small>{{$item->hint}}</small>
            </div>
            @endif
            @endforeach
            </div>
            @if(get_site_config('recaptcha_site_key')!="" && get_site_config('recaptcha_secret_key')!="" && get_site_config('form_builder_captcha')==1)
            <div class="row">
                <div class="col-md-12">
                    <div class="form-group">
                        <div class="g-recaptcha" data-sitekey="{{ get_site_config('recaptcha_site_key') }}"></div>
                        @if ($errors->has('g-recaptcha-response'))
                            <span class="text-danger">{{ $errors->first('g-recaptcha-response') }}</span>
                        @endif
                    </div>  
                </div>
            </div>
            @endif
            <div class="row mt-4 border-top">
                <div class="col-md-12 pt-4 mx-auto text-center">
                    <input type="submit" class="btn btn-primary" value="Submit">
                </div>
            </div>
            </form>
        </div>
        @else
            <div class="col-12 card-body">
                <div class="row">
                    <div class="col-12">
                        <h4>Invalid Form</h4>
                    </div>
                </div>
            </div>
        @endif
    </div>
</div>
</div>
</div>
<script src="{{ asset('assets/plugins/jquery/jquery.min.js') }}"></script>
<script src="{{ asset('assets/plugins/bootstrap/js/popper.min.js') }}"></script>
<script src="{{ asset('assets/plugins/bootstrap/js/bootstrap.min.js') }}"></script>
<script src="{{ asset('assets/plugins/bootstrap-datepicker/bootstrap-datepicker.min.js')}}"></script>
<script src="{{ asset('assets/plugins/select2/dist/js/select2.full.min.js') }}" type="text/javascript"></script>
<script src="https://www.google.com/recaptcha/api.js" async defer></script>
<script>
    window.addEventListener('load', () => {
        const $recaptcha = document.querySelector('#g-recaptcha-response');
        if ($recaptcha) {
            $recaptcha.setAttribute('required', 'required');
        }
    })
</script>
<script>
    $(document).ready(function() {
        jQuery('.mydatepicker').datepicker({
                    todayHighlight: true,
                    autoclose: true,
                    format: 'dd-mm-yyyy',
                    zIndexOffset: 100
                });

                $(".select2").select2();
                $(".select2-2").select2({
                    maximumSelectionLength: 4
                });

        $('#country').on('change', function() {
            var idCountry = this.value;
            
            $("#city-dd").html('');
            $.ajax({
                url: "{{url('api/fetch-cities-by-country')}}",
                type: "POST",
                data: {
                    country_id: idCountry,
                    _token: '{{csrf_token()}}'
                },
                dataType: 'json',
                success: function(res) {
                    $('#city-dd').html('<option value="">Select City</option>');
                    $.each(res.cities, function(key, value) {
                        $("#city-dd").append('<option value="' + value.name + '">' + value.name + '</option>');
                        //$("#city-dd").append('<option value="' + value.name + '">' + value.name + '</option>');
                    });
                }
            });
        });
        
        $('#country').trigger('change');
        //$('#state-dd').trigger('change');

        $('#dialcode').change(function(){
            var dialcode = $('#dialcode').val();
            $('#whatsapp_dialcode').val(dialcode);
        });

        $('body').on('click','#yes_visa_refusal',function(){
            $('#visa_refusal_country').attr("required", true);
            $('#select_visa_refusal_country').show();
        });

        $('body').on('click','#no_visa_refusal',function(){
            $('#visa_refusal_country').prop('required', false);
            $('#select_visa_refusal_country').hide();
        });

    });

    @if((isset($email_present) && !empty($email_present) && $email_unique) || (isset($mobile_present) && !empty($mobile_present) && $mobile_unique))
        $(document).ready(function() {
            $('#form_builder_form').submit(function(e){
                $('#invalid_email, #invalid_mobile').text("");
                e.preventDefault();
                @if($mobile_unique)
                const mobile = $('#mobile').val();
                @else
                const mobile = '';
                @endif

                @if($email_unique)
                const email = $('#email').val();
                @else
                const email = '';
                @endif
                
                $.ajax({
                    url: "{{route('validate-email-mobile')}}",
                    type: "POST",
                    data: {
                        mobile: mobile,
                        email: email,
                        _token: '{{csrf_token()}}'
                    },
                    dataType: 'json',
                    success: function (result) {
                        console.log(result);
                        if (result.email_err && result.mobile_err) {
                            $('#invalid_email').text(result.email_err);
                            $('#invalid_email').css("color", "red");
                            $('#invalid_mobile').text(result.mobile_err);
                            $('#invalid_mobile').css("color", "red");
                            $('#mobile').focus();
                            $('#email').focus();
                            return false;
                        }
                        else if(result.email_err) {
                            $('#invalid_email').text(result.email_err);
                            $('#invalid_email').css("color", "red");
                            $('#email').focus();
                            return false;
                        }
                        else if (result.mobile_err) {
                            $('#invalid_mobile').text(result.mobile_err);
                            $('#invalid_mobile').css("color", "red");
                            $('#mobile').focus();
                            return false;
                        }else{
                            $('#invalid_email, #invalid_mobile').text("");
                            e.currentTarget.submit();
                            return true;
                        }
                    }
                });
            });
        });
    @endif

    function chk_mend(elClass) {
    el = document.getElementsByClassName(elClass);
    var atLeastOneChecked = false; //at least one cb is checked
    for (i = 0; i < el.length; i++) {
        if (el[i].checked === true) {
        atLeastOneChecked = true;
        }
    }

    if (atLeastOneChecked === true) {
        for (i = 0; i < el.length; i++) {
        el[i].required = false;
        }
    } else {
        for (i = 0; i < el.length; i++) {
            el[i].required = true;
            }
        }
    }

function onlyNumberKey(evt) {
    // Only ASCII character in that range allowed
    var ASCIICode = (evt.which) ? evt.which : evt.keyCode
    if (ASCIICode > 31 && (ASCIICode < 48 || ASCIICode > 57))
        return false;
    return true;
}

function validnum(num,type) { 
    if(type == "total_gre"){
        if(num < 260 || num > 340) {
            $("#total_gre_err").removeClass('d-none');
            $('#gre_gmat_save').addClass('disabled');
            return false;
        }
        else {
            $("#total_gre_err").addClass('d-none');
            $('#gre_gmat_save').removeClass('disabled');
            return true;
        } 
    }

    if(type == "verbal_gre"){
        if(num < 130 || num > 170) {
            $("#verbal_gre_err").removeClass('d-none');
            $('#gre_gmat_save').addClass('disabled');
            return false;
        }
        else {
            $("#verbal_gre_err").addClass('d-none');
            $('#gre_gmat_save').removeClass('disabled');
            return true;
        } 
    }

    if(type == "quant_gre"){
        if(num < 130 || num > 170) {
            $("#quant_gre_err").removeClass('d-none');
            $('#gre_gmat_save').addClass('disabled');
            return false;
        }
        else {
            $("#quant_gre_err").addClass('d-none');
            $('#gre_gmat_save').removeClass('disabled');
            return true;
        } 
    }

    if(type == "ana_gre"){
        if(num < 0 || num > 6) {
            $("#ana_gre_err").removeClass('d-none');
            $('#gre_gmat_save').addClass('disabled');
            return false;
        }
        else {
            $("#ana_gre_err").addClass('d-none');
            $('#gre_gmat_save').removeClass('disabled');
            return true;
        } 
    }

    if(type == "inte_gre"){
        if(num < 260 || num > 340) {
            $("#inte_gre_err").removeClass('d-none');
            $('#gre_gmat_save').addClass('disabled');
            return false;
        }
        else {
            $("#inte_gre_err").addClass('d-none');
            $('#gre_gmat_save').removeClass('disabled');
            return true;
        } 
    }

    //GMAT
    if(type == "total_gmat"){
        if(num < 200 || num > 800) {
            $("#total_gmat_err").removeClass('d-none');
            $('#gre_gmat_save').addClass('disabled');
            return false;
        }
        else {
            $("#total_gmat_err").addClass('d-none');
            $('#gre_gmat_save').removeClass('disabled');
            return true;
        } 
    }

    if(type == "verbal_gmat"){
        if(num < 0 || num > 60) {
            $("#verbal_gmat_err").removeClass('d-none');
            $('#gre_gmat_save').addClass('disabled');
            return false;
        }
        else {
            $("#verbal_gmat_err").addClass('d-none');
            $('#gre_gmat_save').removeClass('disabled');
            return true;
        } 
    }

    if(type == "quant_gmat"){
        if(num < 0 || num > 60) {
            $("#quant_gmat_err").removeClass('d-none');
            $('#gre_gmat_save').addClass('disabled');
            return false;
        }
        else {
            $("#quant_gmat_err").addClass('d-none');
            $('#gre_gmat_save').removeClass('disabled');
            return true;
        } 
    }

    if(type == "ana_gmat"){
        if(num < 0 || num > 6) {
            $("#ana_gmat_err").removeClass('d-none');
            $('#gre_gmat_save').addClass('disabled');
            return false;
        }
        else {
            $("#ana_gmat_err").addClass('d-none');
            $('#gre_gmat_save').removeClass('disabled');
            return true;
        } 
    }

    if(type == "inte_gmat"){
        if(num < 1 || num > 8) {
            $("#inte_gmat_err").removeClass('d-none');
            $('#gre_gmat_save').addClass('disabled');
            return false;
        }
        else {
            $("#inte_gmat_err").addClass('d-none');
            $('#gre_gmat_save').removeClass('disabled');
            return true;
        } 
    }
    
} 
</script>
</body>
</html>
