@extends('frontend.layouts.app')

@section('content')
    <style>
        a {
            color: #455a64;
        }

        tbody {
            display: block;
            max-height: 200px;
            overflow: auto;
            scrollbar-width: thin;

        }

        thead,
        tbody tr {
            display: table;
            width: 100%;
            table-layout: fixed;
            /* even columns width , fix width of table too*/
        }

        thead {
            width: calc(100% - 1em)
                /* scrollbar is average 1em/16px width, remove it from thead width */
        }

        .card {
            box-shadow: rgba(14, 63, 126, 0.04) 0px 0px 0px 1px, rgb(173, 216, 230) 0px 1px 1px -0.5px, rgba(42, 51, 70, 0.04) 0px 3px 3px -1.5px, rgba(42, 51, 70, 0.04) 0px 6px 6px -3px, rgba(14, 63, 126, 0.04) 0px 12px 12px -6px, rgba(14, 63, 126, 0.04) 0px 24px 24px -12px;
        }

        .create-ticket-btn {
            position: absolute;
            top: 40px;
            right: 10px;
        }

        @media (max-width: 768px) {
            .create-ticket-btn {
                top: 32px;
                right: 5px;
                width: 50%;
            }
        }

        .text-muted {
            font-size: 13px;
        }
    </style>

    <div class="row page-titles px-4 py-2 pb-0 wrapper" style="margin-top: @if (auth()->user() && session()->has('admin_user_id') && session()->has('temp_user_id')) 48px; @endif">
        <div class="col-md-5 align-self-center">
            @if ($logged_in_user->student_type == 'study_abroad' || $logged_in_user->student_type == 'study_abroad_course')
                <h3 class="text-themecolor">@lang('labels.frontend.user.student.student_dashboard')</h3>
            @else
                <h3 class="text-themecolor">@lang('labels.frontend.user.profile.user_dashboard')</h3>
            @endif
        </div>
    </div>
    <div class="container-fluid" style="padding-top: 10px;padding-bottom:50px;">
        <div class="row" style="min-height: 385px">
            <div class="col-lg-6 mb-3">
                <div class="card h-100">
                    {{-- <div class="card-body" style="padding: 25px 25px; border: 1px solid red;">
                        <div class="d-flex no-block">
                            <h4 class="card-title text-themecolor">Course Suggestions<br /><small class="text-muted"> My Course Suggestions</small></h4>
                        </div>
                    </div> --}}
                    <div class="card-body" style="padding: 15px 25px 0px;">
                        <h4 class="card-title text-themecolor mb-2">@lang('labels.frontend.user.student.course_suggestion')<br /><small class="text-muted">
                                @lang('labels.frontend.user.student.my_course_suggestions')</small></h4>


                        <div class="table-responsive w-100">
                            <table class="table table-hover earning-box" style="margin: 0px 0px; padding: 0px 0px;">
                                <thead>
                                    <tr>
                                        <th>@lang('labels.frontend.user.profile.course')</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @if (!count($docData) && !count($data))
                                        <tr>
                                            <td colspan="3">@lang('labels.frontend.user.profile.no_record_round')</td>
                                        </tr>
                                    @endif
                                    @if (count($docData))
                                        <?php $docDataCnt = count($docData); ?>
                                        @foreach ($docData as $item)
                                            <tr>
                                                <td style="width:50px;"><span
                                                        class="avatar bg-pale-primary text-primary  w-10 h-10"><i
                                                            class="uil uil-book-open" style="font-size: 22px;"></i></span>
                                                </td>
                                                <td>
                                                    <p class="fw-medium text-start">
                                                        @if ($item['file_path'])
                                                            <a target="_blank"
                                                                href="{{ $item['file_path'] }}">{{ $item['doc'] }}
                                                            </a>
                                                            <br>
                                                            <small class="text-muted fw-medium">{{ $item['date'] }}</small>
                                                        @endif
                                                    </p>
                                                </td>
                                            </tr>
                                        @endforeach
                                    @endif
                                    @if (count($data))
                                        @foreach ($data as $item)
                                            <tr>
                                                <td style="width: 70px;">

                                                    <span class="avatar bg-primary text-white w-10 h-10"><i
                                                            class="uil uil-book-open" style="font-size: 22px;"></i></span>

                                                </td>
                                                <td class="">
                                                    <div class="">
                                                        @if ($item->course_id)
                                                            <p class="fw-medium">
                                                                <a target="_blank"
                                                                    href="{{ route('frontend.user.course-details', $item->course_id) }}">{{ $item->course_name }}
                                                                </a> <br>
                                                                <small
                                                                    class="text-muted fw-medium">{{ date('d M Y', strtotime($item->created_at)) }}</small>
                                                            </p>
                                                        @else
                                                            <p class="fw-medium">{{ $item->course_name }}</p>
                                                        @endif
                                                    </div>
                                                </td>
                                            </tr>
                                        @endforeach
                                    @endif
                                </tbody>
                            </table>
                        </div>
                        @if (count($docData) && count($data))
                            <div class="text-end m-4">
                                <a href="{{ route('frontend.user.coursesuggestion') }}"
                                    class="btn btn-sm py-1 px-3 btn-themecolor" style="">@lang('strings.backend.general.see_all.notifications')</a>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
            <!-- 2nd Card -->
            <div class="col-lg-6 mb-3">
                <div class="card h-100">
                    {{-- <div class="card-header p-0 m-5 mb-0" style="border: none;">
                        <div class=" d-flex ">
                            <h4 class="card-title text-themecolor">Document Requests <br>
                                <small class="text-muted">Latest Documents Requested</small>
                            </h4>
                        </div>
                    </div> --}}
                    <div class="card-body" style="padding: 15px 25px 0px;">
                        <h4 class="card-title text-themecolor mb-2">@lang('labels.frontend.user.profile.document_requests')<br>
                            <small class="text-muted">@lang('labels.frontend.user.profile.latest_document_requested')</small>
                        </h4>
                        <div class="table-responsive">
                            <table class="table table-hover earning-box  ">
                                <thead>
                                    <tr>
                                        <th>@lang('strings.frontend.general.document')</th>
                                        <th></th>
                                        <th>@lang('labels.backend.access.users.tabs.content.overview.status')</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @if (count($applicationDocRequest))
                                        @foreach ($applicationDocRequest as $docRequest)
                                            <tr>
                                                <td colspan="2">
                                                    <p class="fw-medium">
                                                        <a target="_blank"
                                                            href="{{ route('frontend.user.applications.detail', $docRequest->uni_id) }}">
                                                            {{ $docRequest->title }}
                                                        </a>
                                                    </p>
                                                    <p class="text-muted">University Application
                                                        #{{ $docRequest->appl_id }} <br>
                                                        Date Requested:
                                                        {{ date('d M Y h:i A', strtotime($docRequest->created_at)) }}
                                                    </p>
                                                </td>
                                                <td>
                                                    @if ($docRequest->uploaded_at)
                                                        <span
                                                            class="badge gradient-6 rounded-pill">@lang('labels.frontend.user.profile.uploaded')</span>
                                                    @else
                                                        <span
                                                            class="badge gradient-2 rounded-pill">@lang('labels.frontend.user.profile.pending_upload')</span>
                                                    @endif
                                                </td>
                                            </tr>
                                        @endforeach
                                    @else
                                        <tr>
                                            <td colspan="2">@lang('labels.frontend.user.profile.no_record_round')</td>
                                        </tr>
                                    @endif
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- 3rd Card -->

        <div class="row mt-5" style="min-height:385px;">
            <div class="col-lg-6 mb-3">
                <div class="card h-100">

                    <div class="card-body" style="padding: 15px 25px 0px;">
                        <h4 class="card-title text-themecolor">@lang('labels.frontend.user.student.my_applications')<br /><small
                                class="text-muted">@lang('labels.frontend.user.profile.track_university_aplication')</small></h4>
                        <div class="table-responsive">
                            <table class="table table-hover earning-box mb-0">
                                <thead>
                                    <tr>
                                        <th>@lang('strings.frontend.general.application')</th>
                                        <th></th>
                                        <th>@lang('labels.backend.access.users.tabs.content.overview.status')</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @if (count($applicationData))
                                        @foreach ($applicationData as $approw)
                                            <tr>
                                                <td class="col " colspan="2">

                                                    <img src="{{ asset('assets/images/flags/' . $approw['country_code'] . '.png') }}"
                                                        alt="{{ $approw['country'] }}" class="float-start me-2"
                                                        style="width: 45px;" title="{{ $approw['country'] }}">

                                                    <p class="fw-medium ">{!! $approw['details'] !!}<br>
                                                        <small style="color:grey">{!! $approw['course'] !!}</small>
                                                    </p>
                                                </td>
                                                <!-- <td><span class="badge rounded"
                                                                            style="background-color:{{ $approw['status_color'] }}">{{ $approw['status'] }}</span>
                                                                    </td> -->
                                                @if ($approw['status'] == 'Pending')
                                                    <td><span class="badge gradient-1 rounded">@lang('labels.frontend.user.profile.pending')</span>
                                                    </td>
                                                @else
                                                    <td><span
                                                            class="badge gradient-7 rounded">{{ $approw['status'] }}</span>
                                                    </td>
                                                @endif
                                            </tr>
                                        @endforeach
                                    @else
                                        <tr>
                                            <td colspan="3">@lang('labels.frontend.user.profile.no_record_round')</td>
                                        </tr>
                                    @endif
                                </tbody>
                            </table>
                            @if (count($applicationData))
                                <div class="text-end mt-3">
                                    <a href="{{ route('frontend.user.applications') }}"
                                        class="btn btn-sm btn-themecolor px-3 py-1 me-3 mb-3"
                                        style="">@lang('strings.backend.general.see_all.notifications')</a>
                                </div>
                            @endif
                        </div>

                    </div>
                </div>
            </div>
            <div class="col-lg-6 mb-3">
                <div class="card h-100">
                    {{-- <div class="card-body pb-0 position-relative" style="padding: 25px 25px;">
                        <div class="d-flex no-block">
                            <h4 class="card-title text-themecolor">Fees <br><small class="text-muted">My Invoices</small></h4>
                        </div>
                    </div> --}}
                    <div class="card-body" style="padding: 15px 25px 0px;">
                        <h4 class="card-title text-themecolor mb-2">@lang('labels.frontend.user.student.fees') <br><small
                                class="text-muted">@lang('labels.general.my_invoice')</small></h4>
                        <div class="table-responsive">
                            <table class="table table-hover earning-box ">
                                <thead>
                                    <tr>
                                        <th>@lang('labels.general.invoice') #</th>
                                        <th>@lang('labels.general.amount') ({{ env('APP_CURRENCY_SYMBOL') }})</th>
                                        <th>@lang('labels.backend.access.users.tabs.content.overview.status')</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @if (count($feeData))
                                        @foreach ($feeData as $fee)
                                            <tr>
                                                <td>
                                                    <p class="fw-medium text-dark">{{ $fee->invoice_num }}</p>
                                                </td>
                                                <td>
                                                    <?php
                                                    
                                                    $amt = get_currency_symbol($fee->currency) . $fee->grand_total;
                                                    
                                                    echo $amt;
                                                    ?>
                                                </td>
                                                <td>
                                                    <?php
                                                    if ($fee->status == 'due') {
                                                        echo '<span class="badge gradient-1 rounded">' . ucfirst($fee->status) . '</span>';
                                                    } else {
                                                        echo '<span class="badge gradient-6 rounded">' . ucfirst($fee->status) . '</span>';
                                                    }
                                                    ?>
                                                    {{-- <span class="label label-success">Open</span> --}}
                                                </td>
                                            </tr>
                                        @endforeach
                                    @else
                                        <tr>
                                            <td colspan="3">
                                                @lang('labels.frontend.user.profile.no_record_round')
                                            </td>
                                        </tr>
                                    @endif
                                    {{-- <tr>
                                    <td>
                                        <h6>2</h6><small>
                                    </td>
                                    <td>1400$</td>
                                    <td><span class="label label-warning">On Hold</span></td>
                                </tr>
                                <tr>

                                    <td>
                                        <h6>3</h6>
                                    </td>
                                    <td>1400$</td>
                                    <td><span class="label label-danger">Closed</span></td>
                                </tr> --}}
                                </tbody>
                            </table>
                        </div>
                        @if (count($feeData))
                            <div class="text-end" style="padding-bottom:10px">
                                <a href="{{ route('frontend.user.my-invoices') }}"
                                    class="btn btn-sm btn-themecolor px-3 py-1 me-3 mt-0"
                                    style="">@lang('strings.backend.general.see_all.notifications')</a>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>

        <!-- 5th card -->
        <div class="row mt-5" style="min-height: 385px;">
            <div class="col-lg-6 mb-3">
                <div class="card h-100" style="display: flex; flex-direction: column;">
                    {{-- <div class="card-body pb-0 position-relative" style="padding: 25px 25px;">
                        <div class="d-flex no-block">
                            <h4 class="card-title text-themecolor">Visa / Services <br /><small class="text-muted"> Track Visa and
                                    Other Additional Services
                                </small></h4>
                        </div>
                    </div> --}}
                    <div class="card-body" style="padding: 15px 25px 0px;">
                        <h4 class="card-title text-themecolor mb-2">@lang('labels.frontend.user.student.visa_and_services') <br /><small class="text-muted">
                                @lang('labels.frontend.user.student.track_visa_application')
                            </small></h4>
                        <div class="table-responsive">
                            <table class="table table-hover earning-box">
                                <thead>
                                    <tr>
                                        <th>@lang('strings.frontend.general.application')</th>
                                        <th></th>
                                        <th>@lang('labels.backend.access.users.tabs.content.overview.status')</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @if (count($service_applications))
                                        @foreach ($service_applications as $service_application)
                                            <tr>
                                                <td colspan="2">
                                                    <span class="d-flex">
                                                        <span class="round">
                                                            <img src="{{ asset('assets/images/country/' . get_country_code_by_name(get_country_name($service_application->country)) . '.png') }}"
                                                                alt="{{ get_country_code_by_name(get_country_name($service_application->country)) }}"
                                                                class="shape rounded-circle w-10 h-10"
                                                                title="{{ get_country_name($service_application->country) }}"
                                                                alt="{{ get_country_name($service_application->country) }}">
                                                        </span>
                                                        <span>
                                                            <p class="fw-medium ms-2"><a target="_blank"
                                                                    href="{{ route('frontend.user.service-visa.applications.detail', $service_application->id) }}">
                                                                    @if ($service_application->description)
                                                                        {{ $service_application->description }}
                                                                    @else
                                                                        --
                                                                    @endif
                                                                </a> <br> <small class="text-muted">
                                                                    @if ($service_application->service_id)
                                                                        {{ '(' . get_services($service_application->service_id) . ')' }}
                                                                    @else
                                                                        --
                                                                    @endif
                                                                </small></p>

                                                        </span>
                                                    </span>
                                                </td>
                                                <td>
                                                    {{-- <span class="label label-success">Open</span> --}}
                                                    <!-- @if ($service_application->status)
    <span class="badge rounded"
                                                                                style="background-color: {{ get_service_application_status_color($service_application->status, $service_application->service_id) }}">{{ $service_application->status }}
@else
    --
    @endif -->
                                                    @if ($service_application->status == 'New')
                                                        <span
                                                            class="badge bg-sky rounded">{{ $service_application->status }}</span>
                                                    @elseif($service_application->status == 'Processing')
                                                        <span
                                                            class="badge gradient-7 rounded">{{ $service_application->status }}</span>
                                                    @else
                                                        <span
                                                            class="badge gradient-6 rounded">{{ $service_application->status }}</span>
                                                    @endif
                                                </td>
                                            </tr>
                                        @endforeach
                                    @else
                                        <tr>
                                            <td colspan="3">
                                                @lang('labels.frontend.user.profile.no_record_round')
                                            </td>
                                        </tr>
                                    @endif
                                    {{-- <tr>
                                    <td style="width:50px;"><span class="round round-warning"
                                            style="padding-top:5px;"><i class="fa fa-globe"
                                                style="font-size: 26px;"></i>
                                        </span></td>
                                    <td>
                                        <h6><a href="#">High Education</a></h6><small> (service type) </small>
                                    </td>
                                    <td><span class="label label-warning">On Hold</span></td>
                                </tr>
                                <tr>
                                    <td style="width:50px;"><span class="round round-danger" style="padding-top:5px;"><i
                                                class="fa fa-globe" style="font-size: 26px;"></i>
                                        </span></td>
                                    <td>
                                        <h6><a href="#">Service</a></h6><small>(service type) </small>
                                    </td>
                                    <td><span class="label label-danger">Closed</span></td>
                                </tr> --}}
                                </tbody>
                            </table>
                        </div>
                        @if (count($service_applications))
                            <div class="text-end">
                                <a href="{{ route('frontend.user.service-visa.applications') }}"
                                    class="btn btn-sm btn-themecolor px-3 py-1 me-3 mt-0"
                                    style="">@lang('strings.backend.general.see_all.notifications')</a>
                            </div>
                        @endif
                    </div>
                </div>
            </div>

           

            @if (get_site_config('module_helpdesk'))
            <div class="col-lg-6 mb-3">
                <div class="card h-100" style=" display: flex; flex-direction: column;">
                    {{-- <div class="card"> --}}
                    <div class="card-body pb-0 position-relative d-sm-flex justify-content-sm-between"
                        style="padding: 15px 25px 0px;">
                        <div class="d-flex no-block">
                            <h4 class="card-title text-themecolor">@lang('labels.frontend.user.student.helpdesk')<br /><small
                                    class="text-muted">@lang('strings.frontend.general.start_discussion')</small></h4>
                        </div>
                        <div class="">
                            <a href="{{ route('frontend.user.ticketnew') }}"
                                class="btn btn-gradient btn-sm gradient-1 rounded me-1  mb-md-0"><i
                                    class="uil uil-plus-circle me-2"></i>@lang('labels.frontend.user.profile.create_new_ticket') </a>
                        </div>
                    </div>
                    {{-- <div class="card-body" style="margin: -22px 0px 0px 10px; padding: 0px 10px 0px 0px;"> --}}
                    <div class="card-body" style="margin: 0px 0px 0px 10px; padding: 0px 10px 0px 0px;">
                        <div class="table-responsive">
                            <table class="table table-hover earning-box mb-0">
                                <thead>
                                    <tr>
                                        <th>@lang('labels.frontend.user.profile.ticket')</th>
                                        <th></th>
                                        <th>@lang('labels.backend.access.users.tabs.content.overview.status')</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @if (count($tickets))
                                        @foreach ($tickets as $ticket)
                                            <tr>
                                                <td colspan="2">
                                                    <span class="d-flex">
                                                        <span class="avatar bg-primary text-white w-10 h-10 me-3 p-3"
                                                            style="padding-top:5px;">
                                                            <i class="uil uil-ticket" style="font-size: 26px;"></i>
                                                        </span>
                                                        <span>
                                                            <p class="fw-medium"><a target="_blank"
                                                                    href="{{ route('frontend.user.ticket.detail', $ticket->ticket_id) }}">#{{ $ticket->ticket_id }}
                                                                    {{ $ticket->subject }} <br><small
                                                                        class="text-muted">Last
                                                                        Reply: @if ($ticket->updated_at)
                                                                            {{ date('d M Y, h:i A', strtotime($ticket->updated_at)) }}
                                                                        @endif
                                                                    </small>
                                                                </a></p>

                                                        </span>
                                                    </span>
                                                </td>
                                                <td>
                                                    @if ($ticket->status == 'new')
                                                        <span
                                                            class="badge gradient-7 rounded">@lang('labels.frontend.user.profile.open')</span>
                                                    @elseif($ticket->status == 'customer_reply')
                                                        <span
                                                            class="badge gradient-3 rounded">@lang('labels.frontend.user.profile.you_replied')</span>
                                                    @elseif($ticket->status == 'staff_reply')
                                                        <span
                                                            class="badge gradient-6 rounded">@lang('labels.frontend.user.profile.answered')</span>
                                                    @elseif($ticket->status == 'inprogress')
                                                        <span
                                                            class="badge gradient-4 rounded">@lang('labels.frontend.user.profile.in_progress')</span>
                                                    @else
                                                        <span
                                                            class="badge gradient-1 rounded">@lang('labels.frontend.user.profile.closed')</span>
                                                    @endif
                                                </td>
                                            </tr>
                                        @endforeach
                                    @else
                                        <tr>
                                            <td colspan="3">@lang('labels.frontend.user.profile.no_record_round')</td>
                                        </tr>
                                    @endif
                                </tbody>
                            </table>
                            @if (count($tickets))
                                <div class="text-end mt-3">
                                    <a href="{{ route('frontend.user.tickets') }}"
                                        class="btn btn-sm btn-themecolor px-3 py-1 me-3 mb-3">@lang('strings.backend.general.see_all.notifications')</a>
                                </div>
                            @endif
                        </div>

                    </div>
                </div>
            </div>
        @endif
        </div>
    </div>
    </div>
@endsection
