<style>
    .scroll-sidebar {
        position: relative;
        overflow: hidden;
        height: 100%;
    }

    .sidebar-nav {
        overflow-y: scroll; 
        height: calc(100% - 120px);
        padding: 20px 0;
        scrollbar-width: thin;
        scrollbar-color: #aab7cf transparent;
    }

    #sidebar1 {
        width: 250px;
        background-color: white;
        position: fixed;
        height: 100%;
        top: 0px;
        transition: width 0.3s ease;
        z-index: 10;
        box-shadow: rgba(14, 63, 126, 0.04) 0px 0px 0px 1px, rgb(173, 216, 230) 0px 1px 1px -0.5px, rgba(42, 51, 70, 0.04) 0px 3px 3px -1.5px, rgba(42, 51, 70, 0.04) 0px 6px 6px -3px, rgba(14, 63, 126, 0.04) 0px 12px 12px -6px, rgba(14, 63, 126, 0.04) 0px 24px 24px -12px;
    }

    .sidebar-icon {
        text-decoration: none;
        display: flex;
        align-items: center;
        padding: 8px 14px;
        font-size: 15px;
        color: black;
    }

    .sidebar-icon:hover {
        background-color: #f5f5f5;
    }

    #burger-menu {
        display: none;
        font-size: 30px;
        cursor: pointer;
        padding: 10px;
        position: fixed;
        top: 10px;
        right: 15px;
    }

    @media (max-width: 768px) {
        #sidebar1 {
            width: 0;
            overflow: hidden;
        }

        #burger-menu {
            display: block;
        }

        #sidebar1.active {
            width: 250px;
        }
    }

    .mobile-logo {
        display: none;
    }

    @media only screen and (max-width: 768px) {
        .mobile-logo {
            display: block;
        }

        .sidebar-icon {
            font-size: 14px;
        }

        #txt {
            font-size: 14px;
        }

        .navbar-brand {
            height: 70px;
            margin-top: -5px;
        }
    }

    .sidebar-nav {
        /* box-shadow: rgba(14, 63, 126, 0.04) 0px 0px 0px 1px, rgb(173, 216, 230) 0px 1px 1px -0.5px, rgba(42, 51, 70, 0.04) 0px 3px 3px -1.5px, rgba(42, 51, 70, 0.04) 0px 6px 6px -3px, rgba(14, 63, 126, 0.04) 0px 12px 12px -6px, rgba(14, 63, 126, 0.04) 0px 24px 24px -12px; */

    }

    @media (min-width: 769px) {
        .sidebar-icon {
            font-size: 14px;
        }

        #txt {
            font-size: 14px;
        }
    }
</style>
@if (isset($cms_page) && $cms_page == 1)
    <!-- Check if $cms_page is set and equals 1 -->
    <nav class="navbar navbar-expand-lg center-nav transparent navbar-light py-2" style="z-index: 1">
        <div class="container-fluid flex-md-row flex-nowrap align-items-center">
            <div class="navbar-brand w-100">
                @if (isset($cms_page) && $cms_page == 1)
                    <!-- Start of left sidebar -->
                    <aside class="new-left-sidebar">
                        <!-- Sidebar scroll-->
                        <div class="new-scroll-sidebar">
                            <!-- Sidebar navigation-->
                            <nav class="new-sidebar-nav">
                                <!-- Start of sidebar navigation -->
                                <div class="navbar-collapse offcanvas offcanvas-nav offcanvas-start">
                                    <!-- Offcanvas navigation start -->
                                    <div class="offcanvas-header d-lg-none">
                                        <!-- Header for small devices -->
                                        <h3 class="text-white fs-30 mb-0"></h3>
                                        <button type="button" class="btn-close btn-close-white"
                                            data-bs-dismiss="offcanvas" aria-label="Close"></button>
                                    </div>
                                    <div class="offcanvas-body ms-lg-auto d-flex flex-column h-100">
                                        <!-- Body of offcanvas menu -->
                                        <ul class="navbar-nav"
                                            style="margin-left: 0px;padding-left: 0px;padding-right: 1100px;">
                                            <!-- Navigation links -->
                                            <li class="mobile-dnone" style="padding-top:12px;">
                                                <!-- Logo link -->
                                                <a class="navbar-brand" href="{{ route('index') }}"
                                                    style="margin-right: 40px;">
                                                    <img src="{{ asset('storage/' . get_site_config('website_logo')) }}"
                                                        style="height:{{ get_site_config('website_logo_ht') }}px"
                                                        class="d-inline-block align-top" alt="">
                                                </a>
                                            </li>
                                            <br>
                                        </ul>
                                    </div>
                                    <!-- /.offcanvas-body -->
                                </div>
                                <!-- /.navbar-collapse -->
                                <div class="navbar-other w-100 d-flex ms-auto">
                                    <ul class="navbar-nav flex-row align-items-center ms-auto">
                                        <li class="nav-item mobile-logo" style="padding-right:150px">
                                            <!-- Logo for mobile -->
                                            <a class="navbar-brand" href="{{ route('index') }}">
                                                <img src="{{ asset('storage/' . get_site_config('website_logo')) }}"
                                                    style="height:{{ get_site_config('website_logo_ht') }}px"
                                                    alt="">
                                            </a>
                                        </li>
                                        <li class="nav-item d-lg-none" style="padding: left 10px;0px">
                                            <!-- Hamburger icon for offcanvas menu -->
                                            <button class="hamburger offcanvas-nav-btn"><span></span></button>
                                        </li>
                                    </ul>
                                </div>
                                <!-- /.navbar-other -->
                        </div>
                        <!-- /.offcanvas-nav -->
    </nav>
    <!-- End Sidebar navigation -->
    </div>
    <!-- End Sidebar scroll-->
    </aside>
    <!-- End of left sidebar -->
@endif
</div>
</div>
<!-- /.container -->
</nav>
@else
<!-- If $cms_page is not set or not equal to 1 -->
<aside id="sidebar1" class="">
    <!-- Sidebar scroll-->
    <div class="scroll-sidebar " id="sidebar-content">
        <!-- Profile text and logo container -->
        <div class="profile-text text-center">
            <div class="logo-container" style="padding-bottom:4px; padding-top: 10px;">
                <a class="navbar-brand" href="{{ route('index') }}">
                    <!-- Logo link -->
                    <img src="{{ asset('storage/' . get_site_config('website_logo')) }}" style="height:40px"
                        id="logo" alt="">
                </a>
            </div>
            <div class="user-profile py-1 mb-2" style="border-bottom: 1px solid rgb(237,239,243);">
                <!-- User profile text and welcome message -->
                <span id="txt">{{ __('strings.backend.dashboard.welcome') }}</span>
                @guest
                    <!-- If guest, display guest message -->
                    <span style="margin: 2px 0; color: #000;"><span
                            id="txt">{{ __('strings.backend.dashboard.guest') }}</span></span>
                @else
                    <!-- If authenticated, display user's name -->
                    <span style="margin: 2px 0; color: #000;"><span
                            id="txt">{{ $logged_in_user->name }}</span></span>
                @endguest
            </div>
        </div>
        <!-- End User profile text-->
    </div>
    <!-- End Sidebar scroll-->
</aside>
@endif


@push('before-scripts')
    <script>
        function toggleSidebar() {
            var sidebar = document.getElementById('sidebar1');
            var burgerMenu = document.getElementById('burger-menu');

            sidebar.classList.toggle('active');

            if (sidebar.classList.contains('active')) {
                burgerMenu.innerHTML = '<i class="uil uil-times"></i>';
            } else {
                burgerMenu.innerHTML = '<i class="uil uil-bars"></i>';
            }
        }
    </script>
@endpush
