
@include('includes.partials.frontend-logged-in-as')
@if(isset($cms_page) && $cms_page)
    <!-- If $cms_page variable is set and truth -->
    <header class="wrapper bg-light">
        <div class="bg-theme text-white fw-bold fs-15" style="height: auto!important;">
            <!-- Top section of header -->
            <div class="container d-md-flex flex-row justify-content-between align-items-center topbar_parent">
                <!-- Container for top bar with flexbox layout -->
                <div class="d-flex flex-row align-items-center">
                    @if(get_site_config('contact_phone'))
                        <!-- Display contact phone if configured -->
                        <div class="d-flex flex-row align-items-center me-6 topbar_contact">
                            <div class="icon text-white fs-22 mt-1 me-2"> <i class="uil uil-phone-volume"></i></div>
                            <p class="mb-0"><a
                                    href="tel:{{ get_site_config('contact_phone') }}">{{ get_site_config('contact_phone') }}</a>
                            </p>
                        </div>
                    @endif
                    @if(get_site_config('contact_email'))
                        <!-- Display contact email if configured -->
                        <div class="d-none d-md-flex flex-row align-items-center topbar_email" style="padding-left:20px">
                            <div class="icon text-white fs-22 mt-1 me-2"> <i class="uil uil-message"></i></div>
                            <p class="mb-0 email"><a href="mailto:{{ get_site_config('contact_email') }}"
                                    class="link-white hover">{{ get_site_config('contact_email') }}</a></p>
                        </div>
                    @endif
                </div>
                
                <ul class="navbar-nav d-none d-lg-block ms-auto me-3" style="padding-top:10px;">
                    @include('frontend.includes.partials.lang')
                </ul>
                
                <div class="d-none d-md-flex flex-row align-items-center">
                    @guest
                        <!-- Display login buttons for guests -->
                        <button type="button" class="btn btn-themecolor rounded-1"
                            onclick="document.location='{{ route('frontend.auth.login') }}'"
                            style="border:solid 1px white; width:100%; color:white; height:35px;">
                            <span style="font-size:15px">@lang('labels.backend.access.users.student_login')</span>
                        </button>
                        {{-- @if(get_site_config('home_page_staff_login'))
                            <!-- Display staff login button if configured -->
                            <button type="button" class="btn btn-outline-primary rounded-1"
                                onclick="document.location='{{ route('frontend.auth.staff.login') }}'"
                                style="border:solid 1px white; width:100%;color:white;height:35px;margin-left:10px;">
                                <span
                                    style="font-size:15px">{{ (env('PRODUCT_CODE') == 'TRAINING') ? 'Staff/Trainer' : 'Staff' }}</span>
                            </button>
                        @endif --}}
                        @if(get_site_config('module_shop'))
                            <!-- Display shopping cart icon and count if shopping module enabled -->
                            <a href="{{ route('frontend.cart') }}">
                                <i class="uil uil-shopping-cart" aria-hidden="true"
                                    style="font-size:25px;color:white;padding-left: 50px"></i>
                            </a>
                            <span onclick="window.location.href='{{ route('frontend.cart') }}'"
                                style="position: relative;top: -11px;right: 6px;background: #d83030;border-radius: 60%;padding: 1px 5px;color: #fff;font-weight: bold;font-size: 11px;">
                                {{ count((array) session('cart')) }}
                            </span>
                        @endif
                    @endguest
                    @auth
                        <!-- Display user info and shopping cart if authenticated -->
                        @if(auth()->user()->isAgent())
                        <a class="link-white hover" href="{{ route('admin.agent.dashboard') }}">
                            <span class="icon text-white fs-20 mt-1 me-2"><i class="uil uil-user-md"></i></span>
                            <span class="icon text-white fs-18 mt-1 me-2">{{ $logged_in_user->first_name }}</span>
                        </a>
                        @elseif($logged_in_user->isAdmin() || $logged_in_user->can('view backend'))
                        <a class="link-white hover" href="{{ route('admin.dashboard') }}">
                            <span class="icon text-white fs-20 mt-1 me-2"><i class="uil uil-user-md"></i></span>
                            <span class="icon text-white fs-18 mt-1 me-2">{{ $logged_in_user->first_name }}</span>
                        </a>
                        @else
                        <a class="link-white hover" href="{{ route('frontend.home') }}">
                            <span class="icon text-white fs-20 mt-1 me-2"><i class="uil uil-user-md"></i></span>
                            <span class="icon text-white fs-18 mt-1 me-2">{{ $logged_in_user->first_name }}</span>
                        </a>
                        @endif

                        @if(get_site_config('module_shop'))
                            <!-- Display shopping cart icon and count if shopping module enabled -->
                            <a href="{{ route('frontend.cart') }}">
                                <i class="uil uil-shopping-cart" aria-hidden="true"
                                    style="font-size:25px;color:white;padding-left: 50px"></i>
                            </a>
                            <span onclick="window.location.href='{{ route('frontend.cart') }}'"
                                style="position: relative;top: -11px;right: 5px;background: #d83030;border-radius: 60%;padding: 1px 5px;color: #fff;font-weight: bold;font-size: 11px;">
                                {{ count((array) session('cart')) }}
                            </span>
                        @endif
                    @endauth
                </div>
            </div>
        </div>
        <!-- Include sidebar for this header section -->
        
        @include('frontend.includes.sidebar')
    </header>
@else
    <!-- If $cms_page variable is not set or flase -->

    <header class="wrapper bg-light" style="z-index: 10;position: relative;">
        <div class="bg-theme text-white fw-bold fs-15" style="height: auto!important;">
            <!-- Top section of header -->
            <div class="container d-md-flex flex-row justify-content-between align-items-center topbar_parent">
                <!-- Container for top bar with flexbox layout -->
                <div class="d-none d-md-flex flex-row align-items-center" style="padding-left: 220px">
                    @if(get_site_config('contact_phone'))
                        <!-- Display contact phone if configured -->
                        <div class="d-flex flex-row align-items-center me-6 topbar_contact">
                            <div class="icon text-white fs-22 mt-1 me-2"> <i class="uil uil-phone-volume"></i></div>
                            <p class="mb-0"><a
                                    href="tel:{{ get_site_config('contact_phone') }}">{{ get_site_config('contact_phone') }}</a>
                            </p>
                        </div>
                    @endif
                    @if(get_site_config('contact_email'))
                        <!-- Display contact email if configured -->
                        <div class="d-flex flex-row align-items-center topbar_email" style="padding-left:20px">
                            <div class="icon text-white fs-22 mt-1 me-2"> <i class="uil uil-message"></i></div>
                            <p class="mb-0 email"><a href="mailto:{{ get_site_config('contact_email') }}"
                                    class="link-white hover">{{ get_site_config('contact_email') }}</a></p>
                        </div>
                    @endif
                </div>
                <ul class="navbar-nav d-none d-lg-block ms-auto me-3" style="padding-top:10px;">
                    @include('frontend.includes.partials.lang')
                </ul>
                <div class="d-flex flex-row align-items-center">
                    @guest
                        <!-- Display login buttons for guests -->
                        <button type="button" class="btn btn-outline-primary rounded-1"
                            onclick="document.location='{{ route('frontend.auth.login') }}'"
                            style="border:solid 1px white; width:100%; color:white; height:35px;">
                            <span style="font-size:15px">@lang('labels.backend.access.users.student_login')</span>
                        </button>
                        @if(get_site_config('home_page_staff_login'))
                            <!-- Display staff login button if configured -->
                            <button type="button" class="btn btn-outline-primary rounded-1"
                                onclick="document.location='{{ route('frontend.auth.staff.login') }}'"
                                style="border:solid 1px white; width:100%;color:white;height:35px;margin-left:10px;">
                                <span style="font-size:15px">Staff</span>
                            </button>
                        @endif
                    @endguest
                    <!-- Burger Menu for Mobile View -->
                    <div id="burger-menu" onclick="toggleSidebar()" style="top:0; margin-top: -20px">
                        <i class="uil uil-bars"></i>
                    </div>
                    @auth
                        <!-- Display authenticated user info -->
                        @if ($logged_in_user->isAdmin() || $logged_in_user->can('view backend'))
                            <!-- Display administration button for admins or users with backend access -->
                            <button type="button" class="btn waves-effect new-btn-mdm waves-light btn-danger"
                                onclick="document.location='{{ route('admin.dashboard') }}'"
                                style="padding: 1px 20px; margin-bottom: 2px; margin-right: -50px ">
                                <span >Staff Panel &rarr;</span>
                            </button>
                        @endif
                        <!-- Dropdown menu for authenticated user -->
                        <li class="nav-item dropdown"
                            style="list-style: none; padding-left:10px; padding-right:10px; margin-left:60px">
                            <a class="nav-link dropdown-toggle text-muted mr-4" href="#" role="button"
                                data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                @if($logged_in_user->avatar_location != '')
                                    <!-- Display user avatar if available -->
                                    <img src="{{asset('storage/'.$logged_in_user->avatar_location)}}" width="35px" height="35px"
                                        alt="user" style="border-radius: 50%" />
                                @else
                                    <!-- Default user avatar -->
                                    <img src="{{asset('assets/images/users/studentProfile.png')}}" width="35px" height="35px"
                                        alt="user" style="border-radius: 50%" />
                                @endif
                            </a>
                            <!-- Dropdown menu items -->
                            <ul class="dropdown-menu dropdown-menu-right" aria-labelledby="navbarDropdown">
                                <li>
                                    <!-- User profile section -->
                                    <div class="dropdown-item d-flex align-items-center">
                                        <div class="u-img" style="width: 35px;">
                                            @if($logged_in_user->avatar_location != '')
                                                <!-- Display user avatar if available -->
                                                <img src="{{ asset('storage/' . $logged_in_user->avatar_location) }}" width="35px"
                                                    height="35px" class="rounded-circle" alt="user" />
                                            @else
                                                <!-- Default user avatar -->
                                                <img src="{{ asset('assets/images/users/studentProfile.png') }}" width="35px"
                                                    height="35px" class="rounded-circle" alt="user" />
                                            @endif
                                        </div>
                                        <div class="ms-3">
                                            <!-- Display user's name and email -->
                                            <h5 class="mb-0">{{ $logged_in_user->name }}</h5>
                                            <p class="text-muted mb-0">{{ $logged_in_user->email }}</p>
                                        </div>
                                    </div>
                                </li>
                                <li>
                                    <hr class="dropdown-divider">
                                </li>
                                @if (!($logged_in_user->isAdmin() || $logged_in_user->isTrainer() || $logged_in_user->isAgent()))
                                    <!-- Display 'My Account' link for regular users -->
                                    <li><a class="dropdown-item" href="{{ route('frontend.user.profile') }}"><img
                                                src="{{asset("sbox/assets/img/icons/lineal/user.svg")}}"
                                                class="svg-inject icon-svg icon-svg-sm text-primary me-1" alt=""
                                                style="width:12%" /> My Account</a></li>
                                @endif
                                <!-- Logout link -->
                                <li><a class="dropdown-item" href="{{ route('frontend.auth.logout') }}"><img
                                            src="{{asset("sbox/assets/img/icons/lineal/logout.svg")}}"
                                            class="svg-inject icon-svg icon-svg-sm text-primary me-2" alt=""
                                            style="width:12%;margin-left:-3px" /> Logout</a></li>
                            </ul>
                        </li>
                    @endauth
                </div>
            </div>
            <!-- /.container -->
        </div>
        </div>
        <!-- Include sidebar for this header section -->
        @include('frontend.includes.sidebar')
    </header>
@endif

@push('after-styles')
<style>
    .logo-container {
        margin-left: -160px;
        padding-bottom: 30px;

    }

    @media (min-width: 769px) {
        .logo-container {
            padding-left: 150px;

        }
    }

    .dropdown-menu {
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1), 0 2px 4px rgba(0, 0, 0, 0.1);
        border-radius: 0.5rem;
    }

    .dw-user-box {
        display: flex;
        align-items: center;
        padding: 10px;
    }

    .u-img img {
        border-radius: 50%;
    }

    .u-text {
        margin-left: 10px;
    }
</style>
@endpush