@extends('frontend.layouts.app')

@if($article_det->meta_title)
@section('title'){{$article_det->meta_title}}@endsection
@endif
@if($article_det->meta_description)
@section('meta_description'){{$article_det->meta_description}}@endsection
@endif

@section('public_content')

@if(get_site_config('home_page_slider_enabled'))
<!-- Start hero slider/ Owl Carousel Slider -->
<section class="wrapper bg-dark">
    <div class="swiper-container swiper-hero dots-over swiper-container-0" data-margin="0" data-autoplay="true" data-autoplaytime="7000" data-nav="true" data-dots="true" data-items="1">
        <div class="swiper swiper-initialized swiper-horizontal swiper-pointer-events swiper-backface-hidden">
            <div id="carouselExample" class="carousel slide" data-bs-ride="carousel">
                <div class="carousel-inner border">
                    @foreach($banners as $index => $banner)
                    <div class="carousel-item {{ $index == 0 ? 'active' : '' }}">
                        <div class="swiper-slide bg-overlay bg-overlay-400 bg-dark bg-image swiper-slide-active" 
                            @if(!$banner->button_text && $banner->banner_link) onclick="window.location='{{$banner->banner_link}}'" @endif 
                            data-image-src="{{ asset('storage/'.$banner->banner_file) }}" 
                            style="max-width: 100%; margin: 0 auto; background-image: url('{{ asset('storage/'.$banner->banner_file) }}'); background-size: cover; background-position: center;" 
                            role="group" aria-label="{{ $index + 1 }} / {{ count($banners) }}">
                            <div class="container">
                                <div class="row">
                                    <div class="col-md-10 offset-md-1 col-lg-7 offset-lg-0 col-xl-8 col-xxl-8 text-center text-lg-start justify-content-center align-self-center align-items-start" style="margin-top: 120px !important;">
                                        @if($banner->banner_text)
                                        <h2 class="display-1 fs-56 mb-4 text-white animate__animated animate__slideInDown animate__delay-1s">{!! $banner->banner_text !!}</h2>
                                        @endif
                                        @if($banner->button_text)
                                        <div class="animate__animated animate__slideInUp animate__delay-3s">
                                            <a href="{{ $banner->banner_link }}" class="btn btn-lg btn-outline-white rounded-pill">{{ $banner->button_text }}</a>
                                        </div>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endforeach
                </div>
                <div class="d-flex justify-content-end">
                    <button class="carousel-control-prev" type="button" data-bs-target="#carouselExample" data-bs-slide="prev">
                        <span class="carousel-control-prev-icon" aria-hidden="true" style="margin-right: 120px !important;"></span>
                        <span class="visually-hidden">Previous</span>
                    </button>
                    <button class="carousel-control-next" type="button" data-bs-target="#carouselExample" data-bs-slide="next">
                        <span class="carousel-control-next-icon" aria-hidden="true" style="margin-left: 120px !important;"></span>
                        <span class="visually-hidden">Next</span>
                    </button>
                </div>
            </div>
            <span class="swiper-notification" aria-live="assertive" aria-atomic="true"></span>
        </div>
    </div>
</section>
<!-- End Carousel -->
@endif


<br>
<div class="container py-md-5 my-5">
    <div class="row px-3">
        <div class="col-12">
            <h1 class="display-4 text-center">{{$article_det->title}}</h1>
            <p>{!!$article_det->intro!!}</p>
        </div>
    </div>
    <br><br><br>
    <div class="row rounded mx-3" style="background-image: radial-gradient(circle at 13% 47%, rgba(140, 140, 140,0.03) 0%, rgba(140, 140, 140,0.03) 25%,transparent 25%, transparent 100%),radial-gradient(circle at 28% 63%, rgba(143, 143, 143,0.03) 0%, rgba(143, 143, 143,0.03) 16%,transparent 16%, transparent 100%),radial-gradient(circle at 81% 56%, rgba(65, 65, 65,0.03) 0%, rgba(65, 65, 65,0.03) 12%,transparent 12%, transparent 100%),radial-gradient(circle at 26% 48%, rgba(60, 60, 60,0.03) 0%, rgba(60, 60, 60,0.03) 6%,transparent 6%, transparent 100%),radial-gradient(circle at 97% 17%, rgba(150, 150, 150,0.03) 0%, rgba(150, 150, 150,0.03) 56%,transparent 56%, transparent 100%),radial-gradient(circle at 50% 100%, rgba(25, 25, 25,0.03) 0%, rgba(25, 25, 25,0.03) 36%,transparent 36%, transparent 100%),radial-gradient(circle at 55% 52%, rgba(69, 69, 69,0.03) 0%, rgba(69, 69, 69,0.03) 6%,transparent 6%, transparent 100%),linear-gradient(90deg, rgb(191, 231, 255),rgb(251, 254, 241));">
        <div class="col-md-6" style="padding: 0px !important;" id="second_banner_image">
            {!!get_content_block('homepage_student_intro_banner')!!}
        </div>
        <div class="col-md-6" style="padding: 12px 10px 25px 30px;">
            <h1 class="display-4">{!!get_content_block('homepage_student_intro_heading')!!}</h1>
            <p>{!!get_content_block('homepage_student_intro_content')!!}</p>
            @guest
            <div class="text-start">
                <button class="btn btn-sm btn-themecolor"><a href="{{route('frontend.auth.register')}}" class="text-white">@lang('strings.frontend.general.signup')</a></button>
                <p class="mt-2" style="font-weight: bold;">@lang('labels.frontend.auth.already_registered') ?</p>
                <button class="btn btn-sm btn-themecolor" style="margin-top: -10px;"><a href="{{route('frontend.auth.login')}}" class="text-white">@lang('strings.frontend.general.login')</a></button>
            </div>
            @endguest
        </div>
    </div>
</div>
<br>

<div class="row" style="background-color: rgb(49, 48, 48);  padding-bottom: 50px;">
    <div class="col-md-3">
        <div class="d-flex flex-column ms-5 px-1 mt-3">
            @if(get_site_config('website_logo'))
            <a class="navbar-brand" href="{{ route('index') }}" style="margin-right: 40px; margin-bottom: 15px;">
                <img src="{{ asset('storage/'.get_site_config('website_logo')) }}" style="height: 48px" class="d-inline-block align-top" alt="">
            </a>
            @endif
            @if(get_site_config('contact_phone'))
                <p class="mb-0 mt-2">
                    <a href="tel:{{ get_site_config('contact_phone') }}" class="link-white hover text-white fw-bolder">
                        <i class="uil uil-phone-volume"></i> {{ get_site_config('contact_phone') }}
                    </a>
                </p>
            @endif
            @if(get_site_config('contact_email'))
                <p class="mb-0 email mt-2"><a href="mailto:{{ get_site_config('contact_email') }}"
                    class="link-white hover text-white fw-bolder"><i class="uil uil-message"></i> {{ get_site_config('contact_email') }}</a>
                </p>
            @endif
        </div>
    </div>
    <div class="col-md-5 mx-5 m-md-0">
        <ul class="mt-3 list-unstyled flex-column align-items-center">
            <li class="nav-item py-1">
                <a class="nav-link text-white" href="{{route('index')}}">&nbsp;&nbsp;@lang('navs.general.home')</a>
            </li>
            @if(get_site_config('module_shop'))
                <li class="nav-item py-1"><a class="nav-link text-white" href="{{ route('frontend.shop') }}">&nbsp;&nbsp;Shop</a></li>
            @endif
            @foreach($main_menu_arr as $main_menu_title=>$main_menu_url)
                <li class="nav-item py-1"><a class="nav-link text-white" href="{{$main_menu_url}}">&nbsp;&nbsp;{{$main_menu_title}}</a></li>
            @endforeach
        </ul>
    </div>
    <div class="col-md-4 d-flex justify-content-center align-items-center">
        <div class="d-flex justify-content-center align-items-center  mb-3">
            @if(env('AGENTS_ENABLE'))
            <a href="{{ route('frontend.auth.agent.login') }}" class="btn btn-gradient gradient-7 rounded-pill mx-3" style="padding: 10px 35px;">@lang('strings.frontend.general.agents')</a>
            @endif
            @if(get_site_config('home_page_staff_login'))
            <a href="{{ route('frontend.auth.staff.login') }}" class="btn btn-gradient gradient-7 rounded-pill mx-3" style="padding: 10px 35px;">@lang('menus.backend.access.staff.main')</a>
            @endif
        </div>
    </div>
</div>
{{-- 
@guest
<br>
<div class="new-container-fluid ">
    <div class="row">
        @if(get_site_config('home_page_student_signup'))
        <div class="col-sm-12 col-md-6 @if(get_site_config('home_page_agent_signup') && config('app.agent_enabled')) offset-md-1 @else offset-md-3 @endif">
            <div class="card card-outline-info">
                <div class="card shadow-lg card-border-bottom border-primary">
                    <h4 class="display-4" style="font-size:24px;padding-top:5px;padding-left:25px;">{{ __('strings.frontend.general.students') }}</h4>
                </div>
                <div class="card-body">
                    <p>{{ __('strings.frontend.general.student_login_or_signup') }}</p>
                    <a href="{{route('frontend.auth.login')}}" class="btn btn-gradient gradient-7 rounded-pill">{{ __('strings.frontend.general.login') }}</a>
                    &nbsp;&nbsp;<a href="{{route('frontend.auth.register')}}" class="btn btn-outline-gradient gradient-7 rounded-pill"><span>{{ __('strings.frontend.general.signup') }}</span></a>
                </div>
            </div>
        </div>
        @endif
        @if(get_site_config('home_page_agent_signup') && config('app.agent_enabled'))
        <div class="col-sm-12 @if(get_site_config('home_page_student_signup')) col-md-4 @else col-md-6 offset-md-3 @endif">
            <div class="card card-outline-info">
                <div class="card shadow-lg card-border-bottom border-primary">
                    <h4 class="display-4" style="font-size:24px;padding-top:5px;padding-left:25px;">{{ __('strings.frontend.general.agents') }}</h4>
                </div>
                <div class="card-body">
                    <p>{{ __('strings.frontend.general.agent_panel') }}</p>
                    <a href="{{route('frontend.auth.agent.login')}}" class="btn btn-gradient gradient-7 rounded-pill">{{ __('strings.frontend.general.login') }}</a>
                    &nbsp;&nbsp;<a href="{{route('frontend.auth.agent.register')}}" class="btn btn-outline-gradient gradient-7 rounded-pill"><span>{{ __('strings.frontend.general.signup') }}</span></a>
                </div>
            </div>
        </div>
        @endif
    </div>
</div>
<br><br><br>
@endguest --}}

@endsection

@push('after-styles')
<style>
    .image-style-align-right{
        float: right !important;
        width: 49.4% !important;
        margin-left: 20px;
    }
    p img{
        width: 100% !important;
        border-radius: 10px;
    }
    #second_banner_image p img{
        margin-bottom: -20px;
        height: 100%;
    }
    #second_banner_image p{
        height: 100%;
    }

    input,
    textarea,
    select {
        -webkit-appearance: auto !important;
        -moz-appearance: auto !important;
        appearance: auto !important;
    }
</style>
@endpush

@push('after-scripts')
<script>
document.addEventListener("DOMContentLoaded", function () {
    document.getElementById("closeModal").addEventListener("click", function() {
        document.getElementById("cookieModal").style.display = "none";
    });


    document.getElementById("toggleMore").addEventListener("click", function() {
        const moreText = document.getElementById("moreText");
        if (moreText.classList.contains("d-none")) {
            moreText.classList.remove("d-none");
            this.innerText = "Show less";
        } else {
            moreText.classList.add("d-none");
            this.innerText = "Show more";
        }
    });
});
document.addEventListener("DOMContentLoaded", function () {
  const acceptAllBtn = document.querySelector(".btn-success"); 
  const allCheckboxes = document.querySelectorAll(
    ".cookie-option input[type='checkbox']"
  );

  acceptAllBtn.addEventListener("click", function () {
    allCheckboxes.forEach(cb => {
      cb.checked = true; 
    });
  });
});
</script>
@endpush
