<!DOCTYPE html>
<!-- Root element of the HTML document -->
@langrtl
<!-- If the language is right-to-left -->
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" dir="rtl">
@else
<!-- Otherwise, use the default language direction -->
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
@endlangrtl

<head>
    <!-- Character encoding -->
    <meta charset="utf-8">
    <!-- Compatibility mode for Internet Explorer -->
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <!-- Responsive design for mobile devices -->
    <meta name="viewport" content="width=device-width, initial-scale=1">
    @if(get_site_config('favicon'))
    <!-- Favicon for the website -->
    <link rel="icon" type="image/png" sizes="32x32" href="{{ asset('storage/'.get_site_config('favicon')) }}">
    @endif
    <!-- CSRF token for security -->
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <!-- Page title -->
    <title>@yield('title', app_name())</title>
    <!-- Meta description for the page -->
    <meta name="description" content="@yield('meta_description', '')">
    <!-- Additional meta tags -->
    @yield('meta')

    <!-- Stylesheets to be included before main styles -->
    @stack('before-styles')
    <!-- Main stylesheet -->
    <link rel="stylesheet" href="{{ asset('sbox/assets/css/plugins.css') }}">
    <link rel="stylesheet" href="{{ asset('sbox/assets/css/style.css') }}">
    <link href="{{ asset('assets/plugins/select2/dist/css/select2.min.css') }}" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/css/all.min.css" integrity="sha512-Kc323vGBEqzTmouAECnVceyQqyqdsSiqLQISBL29aUW4U/M7pSPA/gEUZQqv1cwx4OnYxTxve5UMg5GT6L4JJg==" crossorigin="anonymous" referrerpolicy="no-referrer" />


    <link href="{{ asset('assets/plugins/select2/dist/css/select2.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ asset('assets/plugins/bootstrap-datepicker/bootstrap-datepicker.min.css') }}" rel="stylesheet">
    
    {{-- <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    <link href="{{asset('assets/DataTables/DataTables-1.12.1/css/dataTables.bootstrap5.css')}}" rel="stylesheet" type="text/css"> --}}

    <?php
        $themeColor = get_site_config('frontend_theme');
        if(!$themeColor){
            $themeColor = 'blue';
        }
    ?>
    <link href="{{ asset('sbox/css/colors/'.$themeColor.'.css') }}" id="theme" rel="stylesheet">

    <!-- Preload font styles -->
    <link rel="preload" href="{{ asset('sbox/assets/css/fonts/dm.css') }}" as="style" onload="this.rel='stylesheet'">

    <!-- Stylesheets to be included after main styles -->
    @stack('after-styles')
    <link href="{{ asset('assets/dialcode/css/intlTelInput.css')}}" rel="stylesheet">

    <style>
        .cookie-consent-popup {
            position: fixed;
            height: 150px;
            bottom: -400px;
            left: 0;
            width: 100%;
            background: #fff;
            box-shadow: 0 -4px 12px rgba(0, 0, 0, 0.25);
            padding: 16px;
            z-index: 9999;
            transition: bottom 0.6s ease-in-out;
        }

        .cookie-consent-popup.show {
            bottom: 0;
        }

        .cookie-content {
            max-width: 1200px;
            margin-top: 25px !important;
            margin: auto;
            display: flex;
            align-items: center;
            justify-content: space-between;
            gap: 16px;
            position: relative;
            flex-wrap: wrap;
        }

        .cookie-text {
            flex: 1 1 65%;
            min-width: 250px;
        }

        .cookie-text p {
            margin: 0;
            color: #000;
            font-size: 14px;
            line-height: 1.4;
        }

        .cookie-desc {
            display: -webkit-box;
            -webkit-line-clamp: 2;
            -webkit-box-orient: vertical;
            overflow: hidden;
        }

        .cookie-actions {
            flex: 1 1 30%;
            display: flex;
            gap: 8px;
            justify-content: flex-end;
            flex-wrap: wrap;
        }

        .cookie-actions .btn {
            font-size: 13px;
            padding: 6px 12px;
            min-width: auto;
        }

        .cookie-option input[type="checkbox"] {
            display: inline-block !important;
            border: 1px solid #000 !important;
            width: 16px;
            height: 16px;
            margin-top: 3px;
            accent-color: #007bff !important;
            cursor: pointer;
        }

        .cookie-consent-popup .close-btn {
            position: absolute;
            top: -35px;
            right: -4px;
            font-size: 32px !important;
            font-weight: bold;
            color: #000;
            cursor: pointer;
        }

        .cookie-modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.6);
            z-index: 10000;
            justify-content: center;
            align-items: center;
        }

        .cookie-modal-content {
            background: #fff;
            border-radius: 12px;
            max-width: 650px;
            width: 95%;
            padding: 0;
            max-height: 90vh;
            overflow-y: auto;
            box-shadow: 0 8px 20px rgba(0, 0, 0, 0.3);
        }

        .modal-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 16px;
            border-bottom: 1px solid #ddd;
        }

        .modal-header .close-btn {
            font-size: 32px;
            font-weight: bold;
            color: #000;
            cursor: pointer;
        }

        .modal-body {
            padding: 16px;
        }

        .cookie-section {
            border: 1px solid #ddd;
            border-radius: 8px;
            padding: 12px;
            margin-bottom: 10px;
        }

        .cookie-option {
            display: block;
        }

        @media (max-width: 768px) {
            .cookie-content {
                flex-direction: column;
                align-items: flex-start;
            }

            .cookie-actions {
                width: 100%;
                justify-content: flex-start;
            }

            .cookie-actions .btn {
                flex: 1;
            }
        }

        .main-content {
            padding: 20px;
        }

        @media (min-width: 769px) {
            .main-content {
                position: absolute;
                top: 30px;
                left: 240px;
                right: 0;
                bottom: 0;
            }
        }

        @media (max-width: 769px) {
            .main-card{
                /* padding-top: 20px; */
                padding: 0px;
            }
        }
    </style>
</head>

<body class="wrapper bg-soft-primary">
    <!-- Include partials for logged-in users -->
    {{-- @include('includes.partials.logged-in-as') --}}
    
    <!-- Include the topbar -->
    @include('frontend.includes.topbar')
    
    <div class="content-wrapper">
        <!-- Conditional rendering based on CMS(Public) page -->
        @if(isset($cms_page) && $cms_page)
            <div class="new-page-wrapper">
                <div class="main-content-public">
                    @yield('public_content')
                    @if(get_site_config('cookie_consent_banner'))
                        @guest
                            @include('frontend.cookie-consent')
                        @endguest
                    @endif
                    @include('frontend.includes.footer')
                </div>
            </div>
        @else
            <!-- Main content area with specific positioning -->
            <div class="new-page-wrapper main-card">
                <div class="main-content main-card">
                    @yield('content')
                    {{-- @include('frontend.includes.footer') --}}
                </div>
            </div>
        @endif
    </div><!-- #app -->

    <!-- Scripts section -->
    @stack('before-scripts')
    <!-- Plugin scripts -->
    <script src="{{ asset('sbox/assets/js/plugins.js') }}"></script>
    <!-- Theme scripts -->
    <script src="{{ asset('sbox/assets/js/theme.js') }}"></script>
    <!-- jQuery library -->
    <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>    
    <!-- jQuery cookie plugin -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-cookie/1.4.1/jquery.cookie.js"></script>
    <!-- Google reCAPTCHA -->
    <script src="https://www.google.com/recaptcha/api.js?render={{ env('GOOGLE_RECAPTCHA_SITEKEY') }}"></script>


    {{-- Sweet Alert  --}}
    <script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>


    <script src="{{ asset('assets/plugins/jquery/jquery.min.js') }}"></script>
        <!-- Bootstrap tether Core JavaScript -->
        <script src="{{ asset('assets/plugins/bootstrap/js/popper.min.js') }}"></script>
        <script src="{{ asset('assets/plugins/bootstrap/js/bootstrap.min.js') }}"></script>
        <!-- slimscrollbar scrollbar JavaScript -->
        <script src="{{ asset('js/jquery.slimscroll.js') }}"></script>
        <!--Wave Effects -->
        <script src="{{ asset('js/waves.js') }}"></script>
        <!--Menu sidebar -->
        <script src="{{ asset('js/sidebarmenu.js') }}"></script>
        <!--stickey kit -->
        <script src="{{ asset('assets/plugins/sticky-kit-master/dist/sticky-kit.js') }}"></script>
        <script src="{{ asset('assets/plugins/sparkline/jquery.sparkline.min.js') }}"></script>
        <script src="{{ asset('assets/plugins/bootstrap-datepicker/bootstrap-datepicker.min.js')}}"></script>
        <script src="{{ asset('assets/plugins/select2/dist/js/select2.full.min.js') }}" type="text/javascript"></script>
        <!--Custom JavaScript -->
        <script src="{{ asset('js/custom.min.js') }}"></script>
        <script src="{{ asset('js/owl.js')}}"></script>    

    <script>
        $(document).ready(function() {  
            // Datepicker initialization
            jQuery('.mydatepicker').datepicker({
                todayHighlight: true,
                autoclose: true,
                format: 'dd-mm-yyyy',
                zIndexOffset: 100
            });

            // Select2 initialization
            $(".select2").select2();
            $(".select2-2").select2({
                maximumSelectionLength: 4
            });

        });


        /*Main Slideshow*/
        $(".tw-hero-slider").owlCarousel({
            items: 1,
            loop: true,
            autoplay: true,
            nav: true,
            dots: true,
            autoplayTimeout: 6000,
            autoplayHoverPause: false,
            mouseDrag: true,
            smartSpeed: 1000,
            navText: ['<i class="icon icon-left-arrow2">', '<i class="icon icon-right-arrow2">'],
        });

        // COOKIE CONSENT JS CODE STARTS HERE
        function setCookie(name, value, days) {
            let expires = "";
            if (days) {
                const date = new Date();
                date.setTime(date.getTime() + (days*24*60*60*1000));
                expires = "; expires=" + date.toUTCString();
            }
            document.cookie = name + "=" + (value || "")  + expires + "; path=/";
        }

        function getCookie(name) {
            const nameEQ = name + "=";
            const ca = document.cookie.split(';');
            for(let i=0;i < ca.length;i++) {
                let c = ca[i];
                while (c.charAt(0)==' ') c = c.substring(1,c.length);
                if (c.indexOf(nameEQ) == 0) return c.substring(nameEQ.length,c.length);
            }
            return null;
        }

        document.addEventListener("DOMContentLoaded", function() {
            const consentBanner = document.getElementById("cookieConsent");
            const consentModal = document.getElementById("cookieModal");

            // Check existing consent
            if (!getCookie("cookie_consent")) {
                setTimeout(() => consentBanner.classList.add("show"), 2000);
            }

            // Accept All
            document.getElementById("acceptAll").addEventListener("click", function() {
                setCookie("cookie_consent", JSON.stringify({
                    essential: true,
                    functional: true,
                    analytics: true,
                    marketing: true
                }), 365);
                consentBanner.remove();
                location.reload();
            });

            // Reject All
            document.getElementById("rejectAll").addEventListener("click", function() {
                setCookie("cookie_consent", JSON.stringify({
                    essential: true,
                    functional: false,
                    analytics: false,
                    marketing: false
                }), 365);
                consentBanner.remove();
                location.reload();
            });

            // Customize modal
            document.getElementById("customizeBtn").addEventListener("click", function() {
                consentBanner.style.display = "none";
                consentModal.style.display = "flex";
            });

            document.getElementById("backBtn").addEventListener("click", function() {
                consentModal.style.display = "none";
                consentBanner.style.display = "block";
            });

            // Save Preferences
            document.querySelector("#cookieModal .btn-success").addEventListener("click", function() {
                const functional = document.getElementById("functionalCookies").checked;
                const analytics = document.getElementById("analyticsCookies").checked;
                const marketing = document.getElementById("marketingCookies").checked;

                setCookie("cookie_consent", JSON.stringify({
                    essential: true,
                    functional: functional,
                    analytics: analytics,
                    marketing: marketing
                }), 365);

                consentModal.remove();
                location.reload();
            });

            // Close banner (if ❌ clicked → keep showing every 5s until consent)
            document.getElementById("closeCookie").addEventListener("click", function() {
                consentBanner.classList.remove("show");
                setTimeout(() => consentBanner.style.display = "none", 600);
                setTimeout(() => consentBanner.classList.add("show"), 2000); // reappear
            });

        });

    </script>
    @stack('after-scripts')

    @include('includes.partials.ga')
</body>

</html>

