<!DOCTYPE html>
<!-- Root element of the HTML document -->
@langrtl
<!-- If the language is right-to-left -->
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" dir="rtl">
@else
<!-- Otherwise, use the default language direction -->
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
@endlangrtl

<head>
    <!-- Character encoding -->
    <meta charset="utf-8">
    <!-- Compatibility mode for Internet Explorer -->
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <!-- Responsive design for mobile devices -->
    <meta name="viewport" content="width=device-width, initial-scale=1">
    @if(get_site_config('favicon'))
    <!-- Favicon for the website -->
    <link rel="icon" type="image/png" sizes="32x32" href="{{ asset('storage/'.get_site_config('favicon')) }}">
    @endif
    <!-- CSRF token for security -->
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <!-- Page title -->
    <title>@yield('title', app_name())</title>
    <!-- Meta description for the page -->
    <meta name="description" content="@yield('meta_description', '')">
    <!-- Additional meta tags -->
    @yield('meta')

    <!-- Stylesheets to be included before main styles -->
    @stack('before-styles')
    <!-- Main stylesheet -->
    <link rel="stylesheet" href="{{ asset('sbox/assets/css/plugins.css') }}">
    <link rel="stylesheet" href="{{ asset('sbox/assets/css/style.css') }}">
    <link href="{{ asset('assets/dialcode/css/intlTelInput.css')}}" rel="stylesheet">
    <link href="{{ asset('assets/plugins/select2/dist/css/select2.min.css') }}" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/css/all.min.css" integrity="sha512-Kc323vGBEqzTmouAECnVceyQqyqdsSiqLQISBL29aUW4U/M7pSPA/gEUZQqv1cwx4OnYxTxve5UMg5GT6L4JJg==" crossorigin="anonymous" referrerpolicy="no-referrer" />


    <link href="{{ asset('assets/plugins/select2/dist/css/select2.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ asset('assets/plugins/bootstrap-datepicker/bootstrap-datepicker.min.css') }}" rel="stylesheet">

    <?php
        $themeColor = get_site_config('frontend_theme');
        if(!$themeColor){
            $themeColor = 'blue';
        }
    ?>
    <link href="{{ asset('sbox/css/colors/'.$themeColor.'.css') }}" id="theme" rel="stylesheet">

    <!-- Preload font styles -->
    <link rel="preload" href="{{ asset('sbox/assets/css/fonts/dm.css') }}" as="style" onload="this.rel='stylesheet'">

    <!-- Stylesheets to be included after main styles -->
    @stack('after-styles')
    
    <!-- Custom styles for main content -->
    <style>
        .main-content {
            padding: 20px;
        }

        @media (min-width: 769px) {
            .main-content {
                position: absolute;
                top: 30px;
                left: 240px;
                right: 0;
                bottom: 0;
            }
        }

        @media (max-width: 769px) {
            .main-card{
                /* padding-top: 20px; */
                padding: 0px;
            }
        }
    </style>
</head>

<body class="wrapper bg-soft-primary">    
    <!-- Include the topbar -->
    @include('frontend.includes.topbar_error')
    
    <div class="content-wrapper">
        <!-- Conditional rendering based on CMS(Public) page -->
        @if(isset($cms_page) && $cms_page)
            <div class="new-page-wrapper">
                <div class="main-content-public">
                    @yield('public_content')
                    @include('frontend.includes.footer')
                </div>
            </div>
        @else
            <div class="new-page-wrapper main-card">
                <div class="main-content main-card">
                    @yield('content')
                    {{-- @include('frontend.includes.footer') --}}
                </div>
            </div>
        @endif
    </div>
</body>

</html>

