<!DOCTYPE html>
@langrtl
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" dir="rtl">
    @else
    <html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
        @endlangrtl
        <head>
            <meta charset="utf-8">
            <meta http-equiv="X-UA-Compatible" content="IE=edge">
            <meta name="viewport" content="width=device-width, initial-scale=1">
            @if(get_site_config('favicon'))
            <link rel="icon" type="image/png" sizes="32x32" href="{{ asset('storage/'.get_site_config('favicon')) }}">
            @endif
            <meta name="csrf-token" content="{{ csrf_token() }}">
            <title>@yield('title', app_name())</title>
            <meta name="description" content="@yield('meta_description', 'Study Abroad')">
            <meta http-equiv="refresh" content="300">
            @yield('meta')

            @stack('before-styles')

            <!-- Bootstrap Core CSS -->
            <link href="{{ url('/') }}/assets/plugins/bootstrap/css/bootstrap.min.css" rel="stylesheet">
            <link rel="stylesheet" href="{{ url('/') }}/assets/plugins/dropify/dist/css/dropify.min.css">
            <!-- Custom CSS -->
            <link href="{{ url('/') }}/css/style.css" rel="stylesheet">
            <link href="{{ url('/') }}/css/colors/blue.css" id="theme" rel="stylesheet">
            <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
            <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
            <!--[if lt IE 9]>
            <script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
            <script src="https://oss.maxcdn.com/libs/respond.js/1.4.2/respond.min.js"></script>
            <![endif]-->

            <link href="{{ asset('assets/dialcode/css/intlTelInput.css')}}" rel="stylesheet">

            <?php
                $themeColor = get_site_config('frontend_theme');
                if(!$themeColor){
                    $themeColor = 'blue';
                }
            ?>
            <link href="{{ asset('css/colors/'.$themeColor.'.css') }}" id="theme" rel="stylesheet">

            @stack('after-styles')
        </head>
        <body>
            <!-- ============================================================== -->
            <!-- Preloader - style you can find in spinners.css -->
            <!-- ============================================================== -->
            <div class="preloader">
                <svg class="circular" viewBox="25 25 50 50">
                <circle class="path" cx="50" cy="50" r="20" fill="none" stroke-width="2" stroke-miterlimit="10" /> </svg>
            </div>
            <!-- ============================================================== -->
            <!-- Main wrapper - style you can find in pages.scss -->
            <!-- ============================================================== -->
            <section id="wrapper">
                @yield('content')
            </section>

            <!-- Scripts -->
            @stack('before-scripts')

            <script src="{{ url('/') }}/assets/plugins/jquery/jquery.min.js"></script>
            <!-- Bootstrap tether Core JavaScript -->
            <script src="{{ url('/') }}/assets/plugins/bootstrap/js/popper.min.js"></script>

            <script src="{{ url('/') }}/assets/plugins/bootstrap/js/bootstrap.min.js"></script>
            <!-- slimscrollbar scrollbar JavaScript -->
            <script src="{{ url('/') }}/js/jquery.slimscroll.js"></script>
            <!--Wave Effects -->
            <script src="{{ url('/') }}/js/waves.js"></script>
            <!--Menu sidebar -->
            <script src="{{ url('/') }}/js/sidebarmenu.js"></script>
            <!--stickey kit -->
            <script src="{{ url('/') }}/assets/plugins/sticky-kit-master/dist/sticky-kit.min.js"></script>
            <script src="{{ url('/') }}/assets/plugins/sparkline/jquery.sparkline.min.js"></script>
            <!--Custom JavaScript -->
            <script src="{{ url('/') }}/js/custom.min.js"></script>

            @stack('after-scripts')
            @include('includes.partials.ga')
        </body>
    </html>
