@extends('frontend.layouts.app')

@section('content')


<div class="row page-titles p-4 pb-0 wrapper" >
    <div class="col-md-5  align-self-center">
        <h3 class="text-themecolor">{{ __('labels.general.my_invoice') }}</h3>
    </div>
</div>

<!-- ============================================================== -->
<!-- Container fluid  -->
<!-- ============================================================== -->
<div class="container-fluid" style="padding-top:20px">

    <!-- ============================================================== -->
    <!-- Start Page Content -->
    <!-- ============================================================== -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    @include('includes.partials.messages')
                    <div class="d-flex m-b-10">
                        <div></div>
                        {{-- <div class="ml-auto">
                            <a href="{{ route('frontend.user.ticketnew') }}" class="btn btn-info text-white">+ Create New Ticket</a>
                    </div> --}}
                </div>
                <div class="table-responsive">
                    <table id="orders-table" class="table-display w-100">
                        <thead>
                            <tr>
                                <th>id</th>
                                <th>{{ __('labels.general.date') }}</th>
                                <th style="min-width: 80px !important;">{{ __('labels.general.invoice') }} #</th>
                                <th style="min-width: 105px !important;">{{ __('labels.general.amount') }}</th>
                                <th>{{ __('labels.backend.access.users.tabs.content.overview.status') }}</th>
                                <th style="min-width: 200px !important;">{{ __('labels.general.actions') }}</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
</div>
<!-- ============================================================== -->
<!-- End Container fluid  -->
<!-- ============================================================== -->
@endsection
@push('after-styles')
<link href="https://cdn.datatables.net/1.10.23/css/jquery.dataTables.min.css" rel="stylesheet" type="text/css" />
<style>
    .dataTables_wrapper .dataTables_processing {
        background-color: rgba(21, 21, 21, 0.132);
        position: absolute;
        top: 120%;
        left: 50%;
        width: 30%;
        padding: 10px;
        margin-left: -20%;
        margin-top: -25px;
        text-align: center;
        font-size: 1.2em;
    }
    .dataTables_wrapper .dataTables_length select, input {
        border: 1px solid !important;
    }
</style>
@endpush

@push('after-scripts')
<script src="{{ asset('assets/plugins/datatables/jquery.dataTables.min.js') }}"></script>

<script type="text/javascript">
    var key = $('#key').val();
    var status = $('#status').val();
    var datatable = $('#orders-table').DataTable({
        processing: true,
        serverSide: true,
        autoWidth: true,
        responsive: true,
        order: [
            [0, "desc"]
        ],
        ajax: {
            url: '{{route('frontend.user.my-invoices.invoices-list')}}',
            data: function(data) {
                data.key = $('#key').val();
                data.status = $('#status').val();
            }

        },
        columns: [
            {
                data: 'invoice_id',
                name: 'invoice_id'
            },
            {
                data: 'date',
                name: 'date'
            },
            {
                data: 'invoice',
                name: 'invoice'
            },
            {
                data: 'amount',
                name: 'amount'
            },
            {
                data: 'status',
                name: 'status'
            },
            {
                data: 'action',
                name: 'action',
                orderable: false
            }
        ],
        columnDefs: [{
            "targets": 0,
            "visible": false
        }, {
            "targets": 1,
            "className": "text-center",
        }, {
            "targets": 2,
            "className": "text-center",
        }, {
            "targets": 3,
            "className": "text-center",
        }, {
            "targets": 4,
            "className": "text-center",
        },
        {
            "targets": 5,
            "className": "text-center",
        }],
    });
</script>
@endpush