@extends('frontend.layouts.app')

@section('content')

<div class="row page-titles p-4 pb-0 wrapper" >
    <div class="col-md-5  align-self-center">
        <h3 class="text-themecolor">Invoice #{{$invoice->invoice_num}}</h3>
    </div>
</div>
<!-- ============================================================== -->
<!-- Container fluid  -->
<!-- ============================================================== -->
<div class="container-fluid" style="padding-top:20px">

    <!-- ============================================================== -->
    <!-- Start Page Content -->
    <!-- ============================================================== -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body printableArea">
        <!--row-->
        <div class="row" id="no_print" style="float:right;">
            <div class="col-md-12 col-sm-12">
                <div class="text-right">
                <a class="btn btn-sm btn-themecolor" target="_blank" href="{{route('frontend.user.invoice.downloadMyInvoice', $invoice->id)}}"><i class="fa-solid fa-download me-1"></i>Download </a>
                <button onclick="printDiv('printme')" class="btn btn-sm btn-info" type="button"><i class="fa-solid fa-print me-1"></i>Print</button>
                </div>
            </div>
        </div>
        <br><br>
        <div id="printme" class="row mt-2">
            <div class="col-md-12">
                <h3 class="" id="hidden_div" style="display:none;"><b>Invoice #{{$invoice->invoice_num}}</b></h3>
                <div class="d-flex justify-content-between">
                <div class="pull-left">
                    <address>
                        <h5><b>Bill To</b></h5>
                        <p class="">
                            {{get_user_full_name_by_id($invoice->student_id)}} <br />
                            @if($stuData->address_1)
                            Address: {{ $stuData->address_1 }}<br />{{ $stuData->address_2 }} <br />
                            @else
                            Address: N/A<br />
                            @endif
                            Mob: {{$stuData->mobile}} <br />
                            Email: {{$stuData->email}}
                        </p>
                    </address>
                </div>
                <div class="float-right text-left">
                    <address>
                        @if($invoice->business_id)<h5 class="font-bold">{{get_business_details($invoice->business_id)->name}}</h5>
                        <p class="m-l-30">
                            Address: {!!get_business_details($invoice->business_id)->address!!} <br />
                            Ph: {!!get_business_details($invoice->business_id)->phone!!} <br />
                            Email: {!!get_business_details($invoice->business_id)->email!!}<br>
                            @lang('labels.general.taxid'): {!!get_business_details($invoice->business_id)->tax_id!!}<br><br/>
                            Created: {{date('d/m/Y', strtotime($invoice->created_at))}}<br>
                            Due Date: {{date('d/m/Y', strtotime($invoice->due_date))}}
                        </p>@endif
                    </address>
                </div>
            </div>
            </div>
            <div class="col-md-12">
                <div class="table-responsive m-t-40" style="clear: both;">
                    <table class="table table-bordered table-striped">
                        <thead>
                            <tr>
                                <th class="text-center">Sl.No</th>
                                <th>Item & Description</th>
                                <th class="text-right">Amount</th>
                            </tr>
                        </thead>
                        <tbody>
                            @if(count($invoice_items))
                            @php $i = 1; @endphp
                            @foreach($invoice_items as $items)
                                <tr>
                                    <td class="text-center">{{$i}}</td>
                                    <td>{{$items->item}}</td>
                                    <td class="text-right">{{get_currency_symbol($items->currency)}} {{$items->item_amount}}</td>
                                </tr>
                                @php $i += 1; @endphp
                            @endforeach
                            @else
                            <tr><td colspan="4" class="text-center">No Itmes Found!</td></tr>
                            @endif
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="col-md-12">
                
                <div class="row">
                    <div class="m-t-40 col-md-6" style="text-align: left;">
                        <h6><b>Terms & Conditions</b>
                        <p style="font-size: 13px; font-weight:400;">{{$invoice->terms_conditions}}</p>
                    </div>
                    <div class="col-md-6">
                        <div class="pull-right m-t-30 text-right" style="float:right;">
                            <h6><b>Discount :</b> (-) {{get_currency_symbol($invoice->currency)}} {{$invoice->discount}}</h6>
                            @if($invoice && $invoice->tax_type == 'exclusive')
                                @if($invoice->tax1_value!=0)
                                <h6><b>{{$invoice->tax1_name}}({{$invoice->tax1_rate}}%) :</b> {{get_currency_symbol($invoice->currency)}}{{$invoice->tax1_value}}</h6>
                                @endif
                                @if($invoice->tax2_value!=0)
                                <h6><b>{{$invoice->tax2_name}}({{$invoice->tax2_rate}}%) :</b> {{get_currency_symbol($invoice->currency)}}{{$invoice->tax2_value}}</h6>
                                @endif
                            <h6 class="mb-2"><b>Sub Total :</b> {{get_currency_symbol($invoice->currency)}} {{$invoice->grand_total}}</h6>
                            @endif
                            @if($invoice && $invoice->tax_type == 'inclusive')
                            <h6 class="mb-0"><b>Sub Total :</b> {{get_currency_symbol($invoice->currency)}} {{$invoice->grand_total}}</h6>
                                <?php $net_amt = $invoice->grand_total - $invoice->discount - $invoice->total_tax; ?>
                                <p class="m-0 mb-2" style='font-size: 14px !important;'>(<b style='font-size: 14px !important;'>Net Amount:</b> {{get_currency_symbol($invoice->currency).$net_amt}} + {{get_currency_symbol($invoice->currency).$invoice->tax1_value.' '.$invoice->tax1_name.' @'.$invoice->tax1_rate.'%'}} @if($invoice->tax2_name)+ {{get_currency_symbol($invoice->currency).$invoice->tax2_value.' '.$invoice->tax2_name.' @'.$invoice->tax2_rate.'%'}}@endif)</p>
                                
                            @endif
                            <h6><b>Total :</b> {{get_currency_symbol($invoice->currency)}}{{$invoice->grand_total}}</h6>
                            <h6><b>Payment Made :</b> (-) {{get_currency_symbol($invoice->currency)}}{{($total_payment) ? $total_payment : '0'}}</h6>
                            <h6><b>Balance Due :</b> {{get_currency_symbol($invoice->currency)}}{{($total_payment) ? $invoice->grand_total - $total_payment : $invoice->grand_total}}</h6>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-12">
               <div class="clearfix"></div>
                <div class="text-left">
                    <p><b>Transactions</b></p>
                    <div class="table-responsive m-t-10" style="clear: both;">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>Date</th>
                                    <th>Mode</th>
                                    <th>Transaction ID/ Notes</th>
                                    <!-- <th>Staff</th> -->
                                    <th>Amount</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($payments as $payment)
                                <tr>
                                    <td>{{date('d/m/Y', strtotime($payment->payment_date))}}</td>
                                    <td>{{strtoupper($payment->pay_mode)}}</td>
                                    <td>{{$payment->trans_id}}</td>
                                    <!-- <td>{{get_user_full_name_by_id($payment->staff_id)}}</td> -->
                                    <td>{{get_currency_symbol($invoice->currency)}}{{$payment->amount}}</td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>

            </div>
        </div>
    </div>
            </div>
        </div>
    </div>
</div>
<br><br>
<!-- ============================================================== -->
<!-- End Container fluid  -->
<!-- ============================================================== -->
@endsection
@push('after-styles')
<style>
    @media print {
        #no_print {
            display: none !important;
        }
        #hidden_div { 
            display: block !important;
            margin-bottom: 30px;
        }
    }
</style>
@endpush
@push('after-scripts')
<script>
    function printDiv(divName) {
        var printContents = document.getElementById(divName).innerHTML;
        var originalContents = document.body.innerHTML;
        document.body.innerHTML = printContents;
        window.print();
        document.body.innerHTML = originalContents;
    }
</script>
@endpush