@extends('frontend.layouts.app')

@section('content')
<div class="row page-titles wrapper" style="box-shadow: rgba(0, 0, 0, 0.2) 0px 10px 5px -3px;">
    <div class="col-md-5 align-self-center">
        <h3 class="text-themecolor">My Orders</h3>
    </div>
</div>

<!-- ============================================================== -->
<!-- Container fluid  -->
<!-- ============================================================== -->
<div class="container-fluid" style="padding-top:20px">

    <!-- ============================================================== -->
    <!-- Start Page Content -->
    <!-- ============================================================== -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    @include('includes.partials.messages')
                    <div class="d-flex m-b-10">
                        <div></div>
                        {{-- <div class="ml-auto">
                            <a href="{{ route('frontend.user.ticketnew') }}" class="btn btn-info text-white">+ Create New Ticket</a>
                    </div> --}}
                </div>
                <div class="table-responsive">
                    <table id="orders-table" class="table display">
                        <thead>
                            <tr>
                                <th>id</th>
                                <th>Date</th>
                                <th>Order #</th>
                                <!-- <th>Delivery Status</th> -->
                                <th>Amount</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
</div>
<!-- ============================================================== -->
<!-- End Container fluid  -->
<!-- ============================================================== -->
@endsection
@push('after-styles')
<link href="https://cdn.datatables.net/1.10.23/css/jquery.dataTables.min.css" rel="stylesheet" type="text/css" />
<style>
    .dataTables_wrapper .dataTables_processing {
        background-color: rgba(21, 21, 21, 0.132);
        position: absolute;
        top: 120%;
        left: 50%;
        width: 30%;
        padding: 10px;
        margin-left: -20%;
        margin-top: -25px;
        text-align: center;
        font-size: 1.2em;
    }
    .dataTables_wrapper .dataTables_length select, input {
        border: 0 !important;
    }
</style>
@endpush

@push('after-scripts')
<script src="{{ asset('assets/plugins/datatables/jquery.dataTables.min.js') }}"></script>

<script type="text/javascript">
    var key = $('#key').val();
    var status = $('#status').val();
    var datatable = $('#orders-table').DataTable({
        processing: true,
        serverSide: true,
        autoWidth: true,
        responsive: true,
        order: [
            [0, "desc"]
        ],
        ajax: {
            url: '{{route('frontend.user.my-orders.orders-list')}}',
            data: function(data) {
                data.key = $('#key').val();
                data.status = $('#status').val();
            }

        },
        columns: [{
                data: 'id',
                name: 'id'
            },
            {
                data: 'date',
                name: 'date'
            },
            {
                data: 'order_id',
                name: 'order_id'
            },
            {
                data: 'amount',
                name: 'amount'
            },
            {
                data: 'action',
                name: 'action',
                orderable: false
            }
        ],
        columnDefs: [{
            "targets": 0,
            "visible": false
        }, {
            "targets": 1,
            "className": "text-center",
        }, {
            "targets": 2,
            "className": "text-center",
        }, {
            "targets": 3,
            "className": "text-center",
        }, {
            "targets": 4,
            "className": "text-center",
        }],
    });
</script>
@endpush