@extends('frontend.layouts.app')

@section('content')
<div class="row page-titles wrapper" style="box-shadow: rgba(0, 0, 0, 0.2) 0px 10px 5px -3px;">
    <div class="col-md-5 align-self-center">
        <h3 class="text-themecolor">Order #{{$order_det->id}}</h3>
    </div>
</div>

<!-- ============================================================== -->
<!-- Container fluid  -->
<!-- ============================================================== -->
<div class="container-fluid" style="padding-top:20px">

    <!-- ============================================================== -->
    <!-- Start Page Content -->
    <!-- ============================================================== -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="row mt-4">
                    <div class="col-md-12 col-lg-12 col-sm-12" style="display: flex;">
                        <div class="col-md-4 col-lg-4 col-sm-4" style="">
                            <b>{{$user_det->name}}</b>
                            <p>{{$user_det->email}}<br>
                                @if($user_det->dialcode)+{{$user_det->dialcode}}@endif {{$user_det->mobile}}
                                <br>{{$user_det->address}}
                                <br>
                                @if($city){{$city->name}}, @endif @if($state) {{$state->name}}, @endif @if($country){{$country->title_en}}@endif
                            </p>
                        </div>
                        <div class="col-md-4 col-lg-4 col-sm-4"></div>
                        <div class="col-md-4 col-lg-4 col-sm-4" style="text-align: right; float:right;">
                            <b>Order # </b> {{$order_det->id}}<br>
                            <b>Payment Status : </b><span class="label label-info" style="background: #68d3ff;padding: 2px;border-radius: 3px;"><?= ucfirst($order_det->status); ?></span><br>
                            <br>
                            <?php
                            if ($prod_type == 'coaching' || $prod_type == 'online_course') {
                                $sta = "-";
                            }
                            else if ($prod_type->type == 'digital') {
                                $sta = "-";
                            } else {
                                if ($items[0]->status == "customer_recieved") {
                                    $sta = "Customer Recieved";
                                } else {
                                    $sta = $items[0]->status;
                                }
                            }
                            ?>
                            <!-- <b>Delivery Status : </b><span class="label label-info" style="background: #68d3ff;padding: 2px;border-radius: 3px;"><?= ucfirst($sta); ?></span><br> -->
                            <!-- <a data-toggle="modal" data-target="#myModal" class="m-2 btn btn-sm btn-themecolor" style="color: #fff;">Change Delivery Status</a><br> -->
                            <?php
                            $date = strtotime($order_det->created_at);
                            $new_date = date('d-m-Y H:i:s', $date);
                            ?>
                            <b>Order Date : </b> {{$new_date}}
                        </div>
                    </div>
                </div>

                <div class="news-block-two">
                    <div class="row mt-4">
                        <div class="table-responsive col-sm-12">
                            <div class="table-responsive p-3">
                                <table class="table table-bordered table-striped" style="width: 100%" id="topics_">
                                    <thead class="dker">
                                        <th class="attend_data">Product</th>
                                        <!-- <th class="attend_data">Delivery Status</th> -->
                                        <th class="attend_data">Quantity</th>
                                        <th class="attend_data">Price</th>
                                        <th class="attend_data">Total</th>
                                    </thead>
                                    <tbody>
                                        @php
                                        $sub_tot = $shipping_total = $tax_total= 0;
                                        @endphp
                                        <?php
                                        for ($i = 0; $i < count($items_det); $i++) {
                                        ?>
                                            <tr class="odd">
                                                <td>
                                                    <div class="col-md-12 col-lg-12" style="display:flex;padding:0px;">
                                                        <div class="col-md-4 col-lg-3" style="padding:0px;"><img src="{{asset('storage/products/'.$img[$i]->filename)}}" style="width: 100px;"></div>
                                                        <div class="col-md-8 col-lg-9">{{$items_det[$i]->title}}

                                                            @if($items[$i]->status=="shipped" || $items[$i]->status=="customer_received")
                                                            @if($items_det[$i]->has_downloads==1)
                                                            <p class="p-0"><a href="{{URL::to('/digi-prod-download')}}/{{$items[$i]->product_id}}" target="_blank">Download</a> <a href="#" class="text-black" data-toggle="tooltip" data-placement="right" title=""><i class="fa fa-info-circle"></i></a></p>
                                                            @endif
                                                            @endif
                                                        </div>
                                                    </div>
                                                </td>
                                                <?php
                                                if ($items_det[$i]->type == "digital") {
                                                    $sta = '-';
                                                } else {
                                                    if ($items[$i]->status == "customer_recieved") {
                                                        $sta = "Customer Recieved";
                                                    } else {
                                                        $sta = $items[$i]->status;
                                                    }
                                                }
                                                ?>
                                                <!-- <td><?= ucfirst($sta); ?></td> -->
                                                <td>{{$items[$i]->qty}}</td>
                                                <td>{{$currency->symbol}}{{($items_det[$i]->offer_price!=0)?$items_det[$i]->offer_price : $items_det[$i]->price}}</td>
                                                <td>{{$currency->symbol}}{{$items[$i]->qty * (($items_det[$i]->offer_price!=0)?$items_det[$i]->offer_price : $items_det[$i]->price)}}</td>
                                            </tr>
                                            @php
                                            $sub_tot += $items[$i]->price;
                                            $shipping_total += $items[$i]->shipping_cost;
                                            $tax_total += $items[$i]->tax;
                                            @endphp
                                        <?php }
                                        ?>

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-12 col-sm-12 p-x-2 p-y-2 m-y-2">
                        <div class="col-md-4 col-lg-4 col-sm-6 mb-4" style="text-align: right; float:right;">
                            <strong>Sub Total : {{config('app.currency_symbol')}}{{$sub_tot}}&nbsp;&nbsp;&nbsp;&nbsp;</strong><br>
                            <strong>Tax : 0 &nbsp;&nbsp;&nbsp;&nbsp;</strong><br>
                            <strong>Shipping : {{config('app.currency_symbol')}}{{$shipping_total}} &nbsp;&nbsp;&nbsp;&nbsp;</strong><br>
                            <hr style="">
                            <strong>Total : {{config('app.currency_symbol')}}{{$shipping_total+$sub_tot}} &nbsp;&nbsp;&nbsp;&nbsp;<b></b></strong><br>
                        </div>
                        <div class="col-md-8 col-lg-8 col-sm-6">

                            <div class="table-responsive">
                                <h4>Order Activity</h4>
                                <div class="table-responsive">
                                    <table class="table table-bordered" style="width: 100%;border: 1px solid #e5e5e5;">
                                        <thead class="dker">
                                            <th class="attend_data">SL.No</th>
                                            <!-- <th class="attend_data">Product</th> -->
                                            <th style="text-align:center; width:20%;max-width:100px;" class="attend_data">Date</th>
                                            <th class="attend_data">Status Type</th>
                                            <th class="attend_data">Status</th>
                                            <th class="attend_data">Notes</th>
                                        </thead>
                                        <tbody>
                                            <?php
                                            for ($i = 0; $i < count($activities); $i++) {
                                                $date = strtotime($activities[$i]->trans_date);
                                                $new_date = date('d-m-Y', $date);
                                            ?>
                                                <tr>
                                                    <td>{{$i+1}}</td>
                                                    {{--<td>{{$products[$i]->title}}</td>--}}
                                                    <td>{{$new_date}}</td>
                                                    <td>{{$activities[$i]->type}}</td>
                                                    <td>{{$activities[$i]->status}}</td>
                                                    <td>{{$activities[$i]->notes}}</td>
                                                </tr>
                                            <?php }
                                            ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- ============================================================== -->
<!-- End Container fluid  -->
<!-- ============================================================== -->
@endsection
@push ('after-styles')
<style>
</style>
@endpush
@push ('after-scripts')

<script type="text/javascript">

</script>
@endpush