<!DOCTYPE html>
<html>
    <head>
        <title>{{ $agentData->first_name }} Invoice #{{$invoice->id}}</title>
        <style type="text/css">
        @font-face {
                    font-family: 'Roboto';
                    font-style: normal;
                    font-weight: 400;
                    src: local('Roboto Light'), local('Roboto-Light'), url(https://themes.googleusercontent.com/static/fonts/roboto/v9/Pru33qjShpZSmG3z6VYwnT8E0i7KZn-EPnyo3HZu7kw.woff) format('woff');
            }
            body {
                font-family: 'Roboto', sans-serif;
                color: #121212;
                font-style: normal;
                font-size: 14px;
            }
            th {
                font-weight: 600;
                font-style: normal;
            }
            table.bordered td, th {
                font-style: normal;
                border: 1px solid #808080;
                margin:0;
            }
        </style>        
    </head>
<body>
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-md-12">
                <div class="card card-body printableArea" style="">
                    <div class="row">
                        <div class="col-sm-5">
                            <h3 class="card-title mb-0">
                                <table style="width: 100%;">
                                    <tr>
                                        @if(get_agent_business_logo(auth()->user()->id))
                                        <td><img src="{{ asset('storage/'.get_agent_business_logo(auth()->user()->id)) }}" style="height:{{get_site_config('website_logo_ht')}}px">
                                        </td>
                                        @endif
                                        <td>
                                            <address style="font-style: normal;padding-left: 0px; font-size: 12px!important;">
                                                <h3 class="font-bold">{{$agentData->business_name}}</h3>
                                                <p class="text-muted m-l-30">
                                                @php
                                                    $address = "";
                                                    if($agentData){
                                                        if($agentData->address_1){
                                                            $address .= $agentData->address_1.", " ;
                                                        }
                                                        if($agentData->address_2){
                                                            $address .= $agentData->address_2.", " ;
                                                        }
                                                        if($agentData->city){
                                                            $address .= $agentData->city.", ";
                                                        }
                                                        if($agentData->state){
                                                            $address .= get_state_name($agentData->state).", " ;
                                                        }
                                                        if($agentData->country){
                                                            $address = get_country_name($agentData->country).", ";
                                                        }
                                                        if($agentData->post_code){
                                                            $address .= "-". $agentData->post_code ;
                                                        }
                                                    }
                                                @endphp
                                                @if($address)
                                                 Address: {!! $address !!}<br />
                                                @endif
                                                    Ph: {!!($agentData->dialcode) ? $agentData->dialcode.'-'.$agentData->mobile : $agentData->mobile!!} <br/>
                                                    Email: {!!$agentData->email!!}<br>
                                               </p>
                                            </address>
                                        </td>
                                        <td>
                                            <h3 style="float:right;">INVOICE</h3>
                                        </td>
                                    </tr>
                                </table>
                            </h3>
                        </div>
                    </div>
                    <br>
                    <div class="row mt-4">
                        <div class="col-md-4">
                            <div style="float: left">
                                <address>
                                    <h5 style="font-style: normal;"><b>Bill To</b></h5>
                                    <p style="font-style: normal;" class="text-muted m-l-5">
                                        <b>{{get_site_config('invoice_business_name')}}</b>
                                        <br>
                                        Address: {!!get_site_config('invoice_business_address')!!} <br/>
                                        Ph: {!!get_site_config('invoice_business_phone')!!} <br/>
                                        Email: {!!get_site_config('invoice_business_email')!!}<br/>
                                    </p>
                                </address>
                            </div>            
                            <div style="float: right;width:150px;">
                                <address style="font-style: normal;">
                                    <h5 class="font-bold">Invoice #{{$invoice->id}}</h5>
                                    <p class="text-muted m-l-30">
                                        Created: {{date('d/m/Y', strtotime(now()))}}<br>
                                   </p>
                                </address>
                            </div>
                        </div>
                            <div style="clear: both;">
                                <table style="margin-top:30px!important; width: 100%;padding: 0px;" cellspacing="0">
                                    <thead>
                                        <tr>
                                            {{-- <th style="margin: 0px;padding:5px;">Payment ID</th>
                                            <th style="margin: 0px;padding:5px;">Created Date</th> --}}
                                            <th style="text-align: left;padding: 5px;margin: 0px;">Student</th>
                                            <th style="text-align: left;padding: 5px;margin: 0px;">Application</th>
                                            {{-- <th style="text-align: left;padding: 5px;margin: 0px;">Commission Notes</th>
                                            <th style="text-align: left;padding: 5px;margin: 0px;">Commission</th>
                                            <th style="text-align: left;padding: 5px;margin: 0px;">Deduction</th> --}}
                                            <th style="text-align: left;padding: 5px;margin: 0px;">Net Pay</th>
                                            {{-- <th style="text-align: left;padding: 5px;margin: 0px;">Comments</th>
                                            <th style="text-align: left;padding: 5px;margin: 0px;">Date Paid</th> --}}
                                        </tr>
                                    </thead>
                                    <tbody>
                                        {{-- @php $i = 1; @endphp --}}
                                        @if($invoice)
                                        @php $currency = $invoice->currency . " " . get_currency_symbol($invoice->currency); @endphp
                                        <tr>
                                            {{-- <td style="text-align: center;border: 1px solid gray;">{{$invoice->id}}</td>
                                            <td style="text-align: center;border: 1px solid gray;">{{date("d-M-Y", strtotime($invoice->created_at))}}</td> --}}
                                            <td style="text-align: left;padding: 5px;border: 1px solid gray;">{!!get_user_full_name_by_id($invoice->userid) ."<br>".get_user_email_by_id($invoice->userid)!!}</td>
                                            <td style="padding: 5px;border: 1px solid gray;">{!!get_application_id($invoice->appl_id)."<br>".$invoice->university . '<br>' . $invoice->course!!}</td>

                                            {{-- <td style="text-align: left;padding: 5px;border: 1px solid gray;">{!!$invoice->agent_commission_notes!!}</td>

                                            <td style="text-align: left;padding: 5px;border: 1px solid gray;">{!!$currency ."". $invoice->amount;!!}</td>
                                            <td style="text-align: left;padding: 5px;border: 1px solid gray;">{!!$currency ."". $invoice->deduction!!}</td> --}}

                                            <td style="text-align: left;padding: 5px;border: 1px solid gray;">
                                                <span style="font-family: DejaVu Sans; sans-serif;">{{get_currency_by_user_country(\Auth::user()->id)." ".get_currency_symbol(get_currency_by_user_country(\Auth::user()->id))}}</span>{{currency_convert($invoice->net_pay, $invoice->currency, get_currency_by_user_country(\Auth::user()->id))}}</td>

                                            {{-- <td style="text-align: left;padding: 5px;border: 1px solid gray;">{!!$invoice->notes!!}</td>
                                            <td style="text-align: left;padding: 5px;border: 1px solid gray;">{!!get_date_formated($invoice->paid_date)!!}</td> --}}
                                            {{-- @php $i++; @endphp --}}
                                        </tr>
                                        @endif
                                    </tbody>
                                </table>
                            </div>
                        
                        <div class="col-md-12">
                        {{-- <div class="col-md-6" style="font-size: 14px; width:60%;display:inline-block;float:left;">
                            <h4><b>Terms & Conditions</b></h4>
                            <p style="font-size: 13px; font-weight:400;">{{$invoice->terms_conditions}}</p>
                        </div> --}}
                        <div class="col-md-6" style="width:50%;display:inline-block;float:right;">
                           <div style="text-align: right;line-height: 1.5; font-size: 14px;">
                            {{-- <p><b>Discount :</b> (-) <span style="font-family: DejaVu Sans; sans-serif;">{{config('app.currency_symbol')}}</span> {{$invoice->discount}}<br>  
                            @if($invoice->tax1_amount)
                                <b>{{$invoice->tax1_name}} :</b> <span style="font-family: DejaVu Sans; sans-serif;">{{config('app.currency_symbol')}}</span> {{$invoice->tax1_amount}}<br>
                            @endif
                            @if($invoice->tax2_amount)
                                <b>{{$invoice->tax2_name}} :</b> <span style="font-family: DejaVu Sans; sans-serif;">{{config('app.currency_symbol')}}</span> {{$invoice->tax2_amount}}<br>
                            @endif              --}}
                             <b>Total :</b> <span style="font-family: DejaVu Sans; sans-serif;">{{get_currency_symbol(get_currency_by_user_country(\Auth::user()->id))}}</span> {{currency_convert($invoice->net_pay, $invoice->currency, get_currency_by_user_country(\Auth::user()->id))}}<br>
                             {{-- <b>Payment Made :</b> (-) <span style="font-family: DejaVu Sans; sans-serif;">{{config('app.currency_symbol')}}</span> {{($total_payment) ? $total_payment : '0'}}<br>
                             <b>Balance Due :</b> <span style="font-family: DejaVu Sans; sans-serif;">{{config('app.currency_symbol')}}</span> {{($total_payment) ? $invoice->cart_total - $total_payment : $invoice->cart_total}}</p> --}}
                           </div>
                            <br><br>
                        </div>
                        {{-- <div class="col-md-6" style="">
                            <div class="clearfix"></div>
                            <div class="text-left">
                                <div style="clear: both;">
                                    <p><b>Transactions</b></p>
                                <div style="clear: both;">
                                    <table style="width: 100%;padding: 0px;" cellspacing="0">
                                        <thead>
                                            <tr>
                                                <th style="padding: 5px;text-align: left;">Date</th>
                                                <th style="padding: 5px;text-align: left;">Mode</th>
                                                <th style="padding: 5px;text-align: left;">Transaction ID/ Notes</th>
                                                <th style="padding: 5px;text-align: left;">Amount</th>
                                            </tr>
                                        </thead>
                                        @if(count($payments)>0)
                                        <tbody>
                                            @foreach($payments as $payment)
                                            <tr>
                                                <td style="padding: 5px;border: 1px solid gray;">{{date('d/m/Y', strtotime($payment->payment_date))}}</td>
                                                <td style="padding: 5px;border: 1px solid gray;">{{strtoupper(str_replace("_", " ", $payment->pay_mode))}}</td>
                                                <td style="padding: 5px;border: 1px solid gray;">{{$payment->trans_id}}</td>
                                                <td style="padding: 5px;border: 1px solid gray;">{{$payment->amount}}</td>
                                            </tr>
                                            @endforeach
                                        </tbody>
                                        @endif
                                    </table>
                                </div>
                            </div>
                            
                        </div>
                    </div> --}}
                </div>
            </div>
        </div>

        <div class="row mt-4">
            <div class="col"></div>
        </div>
    </div>
</div>
</body>
</html>