@extends('frontend.layouts.app')
@section('title')
{{'Shop-Products'}}
@endsection
@section('meta_description'){{"Shop Page"}}@endsection

@section('public_content')
<div class="ck-content">
  <div class="row page-title about text-center my-4">
        <div class="col-md-12">
            <h2>{{$product_det->title}}</h2>
            <ul class="breadcrumb pl-0 d-flex justify-content-center">
                <li class="breadcrumb-item"><a href="{{ route('index') }}">Home</a></li>
                <li class="breadcrumb-item"><a href="{{ route('frontend.shop') }}">Shop</a></li>
                <li class="breadcrumb-item active">{{$product_det->title}}</li>
            </ul>
        </div>
    </div>
  
  @include('includes.partials.messages')
   <div class="row new-page-titles">
      
      <div class="shoping_box float_left">
        <div class="row">
         <div class="col-lg-5 col-md-5 col-12">
            <div class="sell_slider">
               <div id="carouselExampleIndicators" class="swiper-container dots-over" data-margin="5" data-dots="true" data-nav="true" data-autoheight="true" data-ride="carousel">
                     <div class="swiper-wrapper">
                        <div class="carousel-item active">
                           <img class="d-block" style="max-height:400px;margin:auto;" src="{{asset('storage/products/'.$img->filename)}}" alt="">
                        </div>
                        <?php
                           if (count($additionals) > 0 ) {
                           for ($i=0; $i < count($additionals); $i++) { ?>
                           <div class="carousel-item">
                                 <img class="d-block w-100" src="{{asset('storage/products/'.$additionals[$i]->filename)}}" alt="">
                           </div>
                           <?php }
                           }
                        ?>
                  </div>
                  <!-- <a class="carousel-control-prev" href="#carouselExampleIndicators" role="button" data-slide="prev">
                  <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                  <span class="sr-only">Previous</span>
                  </a>
                  <a class="carousel-control-next" href="#carouselExampleIndicators" role="button" data-slide="next">
                  <span class="carousel-control-next-icon" aria-hidden="true"></span>
                  <span class="sr-only">Next</span>
                  </a> -->
                  <?php
                     if (count($additionals) > 0 ) { ?>
                  <div class="container pt-4 pb-5 small_slider">
                     <div class="row carousel-indicators">
                        <div class="item">
                           <img src="{{asset('storage/products/'.$img->filename)}}" class="img-fluid" alt="img" data-target="#carouselExampleIndicators" data-slide-to="0"/>
                        </div>
                        <?php for ($i=0; $i < count($additionals); $i++) { ?>
                        <div class="item">
                           <img src="{{asset('storage/products/'.$additionals[$i]->filename)}}" class="img-fluid" alt="img" data-target="#carouselExampleIndicators" data-slide-to="<?=$i+1?>"/>
                        </div>
                        <?php } ?>
                     </div>
                  </div>
                  <?php } ?>
            </div>
         </div>
      </div>
        <div class="col-lg-7 col-md-7 col-12">
           <div class="b_product_sell_details_wrapper float_left">
              <div class="bz_product_heading float_left">
                 <h3 class="new-text-themecolor">{{$product_det->title}}</h3>
                 <br/>
                  <?php
                      if($product_offer_price == 0){
                          $price = number_format($product_price,2);
                          $op = 0;
                        }else{
                          $price = number_format($product_offer_price,2);
                          $op = number_format($product_price,2);
                        }

                      if($op != 0){ ?>
                          <h4> {{config('app.currency_symbol')}}{{$price}} <span><del>{{config('app.currency_symbol')}}{{$op}}</del> </span></h4> 
                      <?php }else{ ?>
                         <h4>{{config('app.currency_symbol')}}{{$price}} </h4> 
                  <?php } ?>
                 <p>{{$product_det->short_desc}}</p>
              </div>
              @if($product_det->brand || $product_det->color || $product_det->weight || $product_det->dimension)
              <div class="card">
               <div class="card-header pl-0" id="headingTwo">
                  <h4 class="mb-0">
                      Production Information
                  </h4>
               </div>
                  <div class="card-body">
                     <div class="content_single_product">
                        <div class="row">
                           <div class="col-md-12 col-12">
                              <form>
                                 @if($product_det->brand)
                                 <div class=" row">
                                    <div class="col-md-6 col-12">
                                       <label>Brand</label>
                                    </div>
                                    <div class="col-md-6 col-12">
                                       <label>{{$product_det->brand}}</label>
                                    </div>
                                 </div>
                                 @endif
                                 @if($product_det->color)
                                 <div class=" row">
                                    <div class="col-md-6 col-12">
                                       <label>Color</label>
                                    </div>
                                    <div class="col-md-6 col-12">
                                       <label>{{$product_det->color}}</label>
                                    </div>
                                 </div>
                                 @endif
                                 @if($product_det->weight)
                                 <div class="row">
                                    <div class="col-md-6 col-12">
                                       <label>Weight</label>
                                    </div>
                                    <div class="col-md-6 col-12">
                                       <label>{{$product_det->weight}}</label>
                                    </div>
                                 </div>
                                 @endif
                                 @if($product_det->dimension)
                                 <div class="row">
                                    <div class="col-md-6 col-12">
                                       <label>Dimension</label>
                                    </div>
                                    <div class="col-md-6 col-12">
                                       <label>{{$product_det->dimension}}</label>
                                    </div>
                                 </div>
                                 @endif
                              </form>
                           </div>
                        </div>
                     </div>
                  </div>
            </div>
            @endif
              {{-- <div class="color_code float_left">
                 <p>Categories: <span><a href="#">wine</a></span></p>
              </div> --}}
              <br>
              <div class="number_pluse float_left">
                 {{-- <input type="number" value="1"> --}}
                 <a href = '{{route('frontend.addToCart',[$product_det->id,'product'])}}' class="btn btn-md btn-themecolor ml-0">Add To Cart</a>
              </div>
              {{-- <div class="share_icon float_left">
                 <p>Share:</p>
                 <ul>
                    <li>
                       <a href="#"><i class="fab fa-facebook-f"></i></a>
                       <a href="#"><i class="fab fa-twitter"></i></a>
                       <a href="#"><i class="fab fa-instagram"></i></a>
                       <a href="#"><i class="fab fa-youtube"></i></a>
                    </li>
                 </ul>
              </div> --}}
             
           </div>
           
        </div>
        
     </div>
     @if($product_det->details)
     <div class="card mt-5">
        <div class="card-header pl-0" id="headingTwo">
           <h4 class="mb-0">
              Product Details
           </h4>
        </div>
           <div class="card-body">
              <div class="content_single_product">
                 <div class="row">
                    <div class="col-md-12 col-12">
                       <form>
                          <div class="form-group row">
                             <div class="col-md-12 col-12">
                             {!!$product_det->details!!}
                             </div>
                          </div>
                       </form>
                    </div>
                 </div>
              </div>
           </div>
     </div>
     @endif
     </div>
     {{-- <div class="bz_single_product_accordian_main_wrapper bz_leather_accordian float_left">
      <div class="container custom_container">
         <div class="row">
            <div class="col-lg-12 col-md-12 col-12">
               <div class="checkout_form">
                  <div class="accordion" id="accordionExample">
                     <div class="card checkout_accord">
                        <div class="card-header accord_header" id="headingOne">
                           <h2 class="mb-0">
                              <button type="button" class="btn btn-link" data-toggle="collapse" data-target="#collapseOne"><span><i class="fas fa-angle-down"></i></span> Description</button>									
                           </h2>
                        </div>
                        <div id="collapseOne" class="collapse show" aria-labelledby="headingOne" data-parent="#accordionExample">
                           <div class="card-body">
                              <div class="content_single_product">
                                 <p>{!! $product_det->details !!}</p>
                              </div>
                              <div class="row">
                                 <div class="col-md-8 col-12">
                                    <div class="content_single_product">
                                       <p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exer-citation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>
                                       <ul class="nots">
                                          <li> <span><i class="fas fa-check"></i></span> Lorem Ipsum is simply dummy text.</li>
                                          <li> <span><i class="fas fa-check"></i></span> It is a long established fact that a reader.</li>
                                          <li> <span><i class="fas fa-check"></i></span> There are many variations of passages of Lorem.</li>
                                          <li> <span><i class="fas fa-check"></i></span> The standard chunk of Lorem Ipsum.</li>
                                          <li> <span><i class="fas fa-check"></i></span> Lorem Ipsum comes from sections.</li>
                                       </ul>
                                    </div>
                                 </div>
                              </div>
                              <div class="row">
                                 <div class="col-md-4 col-12">
                                    <div class="img_box">
                                       <div class="product_icon">
                                          <a href="#">
                                          <i class="fa fa-star"></i>
                                          </a>
                                          <p>Dedicated Service</p>
                                       </div>
                                       <div class="text_product">
                                          <p>Consult our specialists for help with an order, customization, or design advice</p>
                                       </div>
                                    </div>
                                 </div>
                                 <div class="col-md-4 col-12">
                                    <div class="img_box">
                                       <div class="product_icon">
                                          <a href="#">
                                          <i class="fa fa-share"></i>
                                          </a>
                                          <p>Free Returns</p>
                                       </div>
                                       <div class="text_product">
                                          <p>Consult our specialists for help with an order, customization, or design advice</p>
                                       </div>
                                    </div>
                                 </div>
                                 <div class="col-md-4 col-12">
                                    <div class="img_box">
                                       <div class="product_icon">
                                          <a href="#"><i class="fa fa-share"></i></a>
                                          <p>International Shipping</p>
                                       </div>
                                       <div class="text_product">
                                          <p>Consult our specialists for help with an order, customization, or design advice</p>
                                       </div>
                                    </div>
                                 </div>
                              </div>
                              <div class="row">
                                 <div class="col-md-12 col-12">
                                    <div class="full_details">
                                       <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam,
                                          quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum
                                          dolore eu fugiat nulla pariatur. Excepteur sint occaecat.
                                       </p>
                                    </div>
                                 </div>
                              </div>
                           </div>
                        </div>
                     </div>
                     <div class="card checkout_accord">
                        <div class="card-header accord_header" id="headingTwo">
                           <h2 class="mb-0">
                              <button type="button" class="btn btn-link collapsed" data-toggle="collapse" data-target="#collapseTwo"><span><i class="fas fa-angle-down"></i></span> Production Information </button>
                           </h2>
                        </div>
                        <div id="collapseTwo" class="collapse" aria-labelledby="headingTwo" data-parent="#accordionExample">
                           <div class="card-body">
                              <div class="content_single_product">
                                 <div class="row">
                                    <div class="col-md-12 col-12">
                                       <form>
                                          @if($product_det->brand)<li><span>@lang('marketplace-product-details.Brand') :</span> {{$product_det->brand}}</li>@endif
                                          @if($product_det->brand)
                                          <div class="form-group row">
                                             <div class="col-md-6 col-12">
                                                <label>@lang('marketplace-product-details.Brand') </label>
                                             </div>
                                             <div class="col-md-6 col-12">
                                                <label>{{$product_det->brand}}</label>
                                             </div>
                                          </div>
                                          @endif

                                          <div class="form-group row">
                                             <div class="col-md-6 col-12">
                                                <label>Brand Owner</label>
                                             </div>
                                             <div class="col-md-6 col-12">
                                                <label>Diageo</label>
                                             </div>
                                          </div>
                                       </form>
                                    </div>
                                 </div>
                              </div>
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
   </div> --}}
    </div>
</div>
@endsection

@push('after-scripts')
<script>

</script>
@endpush