@extends('frontend.layouts.app')

@section('title') {{'Shop-Products'}} @endsection
@section('meta_description') {{"Shop Page"}} @endsection
<style>
    .shop-item .card:hover {
        transform: translateY(-10px);
        box-shadow: rgba(0, 0, 0, 0.2) 0px 8px 24px;
    }
</style>

@section('public_content')
<div class="container ck-content">
    <div class="row page-title about text-center my-4">
        <div class="col-md-12">
            <h2>{{$category->title}}</h2>
            <ul class="breadcrumb pl-0 d-flex justify-content-center">
                <li class="breadcrumb-item"><a href="{{ route('index') }}">Home</a></li>
                <li class="breadcrumb-item"><a href="{{ route('frontend.shop') }}">Shop</a></li>
                <li class="breadcrumb-item active">{{$category->title}}</li>
            </ul>
        </div>
    </div>
    
    @if(count($subcat) > 0)
        <div class="new-page-titles our-shop mb-4">
            <div class="items-sorting border-bottom-0">
                <div class="results-column col-12 mb-3">
                    <div class="range-slider-one" id="category-collapses">
                        @foreach($subcat as $cat)
                            <a href="{{route('frontend.shop-products',[$cat->slug])}}" class="btn btn-sm btn-warning mb-2">{{$cat->title}}</a>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    @endif

    @if (count($prods) > 0)
        <div class="row clearfix mb-4">
            <div class="col-lg-11 col-md-6 col-sm-12">
                <h5 class="float-left">Showing {{count($prods)}} of {{count($total_items)}} results</h5>
            </div>
            <div class="col-lg-1 col-md-6 col-sm-12 text-right">
                <a href="{{ url()->previous() }}" class="btn btn-themecolor"><i class="uil uil-arrow-left"></i></a>   
            </div>
        </div>
        
        <div class="row clearfix" style="display: flex; flex-wrap: wrap; justify-content: space-around;">
            @foreach($prods as $index => $prod)
                <div class="col-lg-3 col-md-6 col-sm-12 shop-item mb-4" onclick="location.href='{{route('frontend.shop-product-details',[$prod->slug])}}';">
                    <div class="card h-100" style="box-shadow: rgba(136, 165, 191, 0.48) 6px 2px 16px 0px, rgba(255, 255, 255, 0.8) -6px -2px 16px 0px; border-radius: 15px; overflow: hidden; transition: transform 0.3s, box-shadow 0.3s;">
                        <img src="{{asset('storage/products/'.$imgs[$index]->filename)}}" class="card-img-top" alt="{{$prod->title}}" style="height: 200px; object-fit: cover; width: 100%; transition: transform 0.3s;">
                        <div class="card-body" style="height: 150px;">
                            <h6 class="card-title text-truncate">{{$prod->title}}</h6>
                            <div class="card-text">
                                @if($product_amounts[$index]['offer_price'] == 0)
                                    <h6 class="font-weight-bold">{{config('app.currency_symbol')}} {{number_format($product_amounts[$index]['price'], 2)}}</h6>
                                @else
                                    <b><strike class="text-muted">{{config('app.currency_symbol')}} {{number_format($product_amounts[$index]['price'], 2)}}</strike></b>
                                    <h6 class="font-weight-bold">{{config('app.currency_symbol')}} {{number_format($product_amounts[$index]['offer_price'], 2)}}</h6>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            @endforeach
            
            <div class="col-12">
                {{$prods->links()}}
            </div>
        </div>
    @else
        <div class="col-12">
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <p class="mb-0">No products in this category</p> 
            </div>
        </div>
    @endif
</div>
@endsection

@push('after-scripts')
<script>
    $(document).ready(function() {
        $('#select2-search').select2();
    });
</script>
@endpush
