@extends('frontend.layouts.app')
@section('title') {{'Shop'}} @endsection
@section('meta_description'){{"Shop Page"}}@endsection

@section('public_content')
<div class="content container">
    <div class="row page-title about py-5">
        <div class="col-12 text-center mb-4">
            <h2 class="display-4">Shop</h2>
        </div>
    </div>

    <div class="group">
        <svg class="icon" id="icon" aria-hidden="true" viewBox="0 0 24 24"><g><path d="M21.53 20.47l-3.66-3.66C19.195 15.24 20 13.214 20 11c0-4.97-4.03-9-9-9s-9 4.03-9 9 4.03 9 9 9c2.215 0 4.24-.804 5.808-2.13l3.66 3.66c.147.146.34.22.53.22s.385-.073.53-.22c.295-.293.295-.767.002-1.06zM3.5 11c0-4.135 3.365-7.5 7.5-7.5s7.5 3.365 7.5 7.5-3.365 7.5-7.5 7.5-7.5-3.365-7.5-7.5z"></path></g></svg>
        <input placeholder="Search" type="search" class="input">
    </div>

    <div class="row new-page-titles">
        @foreach($categories as $category)
        <div class="col-lg-3 col-md-4 col-sm-6 mb-4">
            <div class="card h-100 border-1" onclick="location.href='{{route('frontend.shop-products',[$category->slug])}}';" style="cursor:pointer;box-shadow: rgba(0, 0, 0, 0.1) 0px 10px 50px;">
                <figure class="overlay overlay-1 hover-scale rounded">
                    <div class="image">
                        @if($category->photo)
                            <img src="{{asset('storage/categories/'.$category->photo)}}" class="card-img-top" alt="{{$category->title}}" style="height: 200px; object-fit: cover;">
                        @else
                            <img src="{{asset('assets/images/default-category.png')}}" class="card-img-top" alt="{{$category->title}}" style="height: 200px; object-fit: cover;">
                        @endif               
                    </div>
                </figure>
                <div class="card-body text-center">
                    <h5 class="card-title mb-0">
                        <a class="text-dark" style="font-size: 18px;">{{$category->title}}</a>
                    </h5>
                </div>
            </div>
        </div>
        @endforeach
    </div>

</div>

@endsection

@push('after-scripts')
<script>
    $(document).ready(function() {
        $('#select2-search').select2();
    });
</script>
@endpush

@push('after-styles')
<style>
    .group {
    display: flex;
    line-height: 28px;
    align-items: center;
    position: relative;
    max-width: 100%;
    padding-bottom: 50px;
    }

    .input {
    width: 100%;
    height: 40px;
    line-height: 28px;
    padding: 0 1rem;
    padding-left: 2.5rem;
    border: 2px solid transparent;
    border-radius: 8px;
    outline: none;
    background-color: white;
    color: #0d0c22;
    transition: .3s ease;
    }

    .input::placeholder {
    color: black;
    }

    .input:focus, input:hover {
    outline: none;
    border-color: rgba(234,76,137,0.4);
    background-color: #fff;
    box-shadow: 0 0 0 4px rgb(234 76 137 / 10%);
    }

    #icon {
    position: absolute;
    left: 1rem;
    fill: #9e9ea7;
    width: 1rem;
    height: 1rem;
    }
    .new-page-titles {
    display: flex;
    flex-wrap: wrap;
    justify-content: space-between;
}

    .card {
        transition: transform 0.3s, box-shadow 0.3s;
    }

    .card:hover {
        transform: translateY(-10px);
        box-shadow: rgba(0, 0, 0, 0.2) 0px 20px 50px;
    }

    .overlay .image img {
        border-radius: 0.25rem;
        transition: transform 0.3s;
    }

    .overlay:hover .image img {
        transform: scale(1.05);
    }

    .card-body .card-title a {
        text-decoration: none;
        transition: color 0.3s;
    }

    .card-body .card-title a:hover {
        color: #007bff;
    }


</style>
@endpush
