@push('after-styles')
<link rel="stylesheet" href="{{ asset('assets/plugins/dropify/dist/css/dropify.min.css') }}">
<link rel="stylesheet" href="{{ asset('assets/plugins/dropzone-master/dist/dropzone.css') }}">
@endpush

@extends('frontend.layouts.app')

@section('content')
<div class="row page-titles">
    <div class="col-md-5 align-self-center">
        <h3 class="text-themecolor">Messages</h3>
    </div>
</div>

<!-- ============================================================== -->
<!-- Container fluid  -->
<!-- ============================================================== -->
<div class="container-fluid">

    <!-- ============================================================== -->
    <!-- Start Page Content -->
    <!-- ============================================================== -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">                
                    @include('includes.partials.messages')

                    @foreach($messages as $message)
                    <h3>{{$message->title}} | {{$message->branch_name}} | {{$message->days}} | {{$message->start_hour}}:{{$message->start_min}} - {{$message->end_hour}}:{{$message->end_min}}</h3>
                    @endforeach

                    <!-- Nav tabs -->
                    <ul class="nav nav-tabs" role="tablist">
                        <li class="nav-item"> <a class="nav-link active" data-toggle="tab" href="#group" role="tab"><span class="hidden-sm-up" style="font-size: 0.8em;">Group Broadcast</span> <span class="hidden-xs-down">Group Broadcast</span></a> </li>
                        <li class="nav-item"> <a class="nav-link" data-toggle="tab" href="#private" role="tab"><span class="hidden-sm-up" style="font-size: 0.8em;">Private Message</span> <span class="hidden-xs-down">1-to-1 Messages</span></a> </li>
                    </ul>


                    <!-- Tab panes -->
                    <div class="tab-content tabcontent-border">
                        <div class="tab-pane active" id="group" role="tabpanel">

                            <div class="row">
                                <div class="col-12">
                                    <div class="card m-b-0">
                                        <div class="chat-main-box">
                                            <div class="chat-rbox" id="broadcast" style="overflow-y:scroll; height:400px;">
                                                <ul class="chat-list p-20" id="chatgroup">
                                                </ul>
                                            </div>
                                            <div class="b-t b-l" style="padding: 5px;">
                                                <div class="row">
                                                    <div style="width: 70%; margin-left: 15px;">
                                                        <textarea id="message" class="form-control b-0" name ="message" rows="2" cols="90" placeholder="Type your message here"></textarea>
                                                    </div>
                                                    <input type="hidden" name="trainerid" id="trainerid" value="{{$userid}}">
                                                    @foreach($messages as $message)
                                                    <input type="hidden" name="batchid" id="batchid" value="{{$message->id}}">
                                                    @endforeach
                                                    <div style="margin-left: auto;margin-right: 15px;">
                                                        <button type="button" id="sends" class="btn btn-info btn-circle btn-sm"><i class="fa fa-paper-plane-o"></i></button>
                                                    </div>
                                                </div>
                                                <div>
                                                    <div class="col-8">
                                                        <input type="checkbox" id="Convert" class="checks" name="Convert" value="1"/>
                                                        <label for="Convert">Send SMS also</label> 
                                                        <input type="checkbox" id="Convert" class="checks" name="Convert" value="0"/>
                                                        <label for="Convert" hidden>Send SMS also</label>    
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="tab-pane" id="private" role="tabpanel" style="background-color: #edf4f8;"> 

                            <div class="row">
                                <div class="col-12">
                                    <div class="card m-b-0">
                                        <div class="chat-main-box">
                                            <div class="chat-left-aside">
                                                <div class="open-panel"><i class="ti-angle-right"></i></div>
                                                <div class="chat-left-inner">
                                                    <h3 class="p-20" style="text-align: center;">Students</h3>
                                                    <ul class="chatonline style-none ">

                                                        <li>
                                                            @foreach($student as $students)
                                                            <a class="check" id="{{$students->id}}" href="javascript:void(0)" 
                                                               rel="{{route('frontend.user.privatemsg.store',$students->id)}}" rels="{{route('frontend.user.privatemsg.get',$students->id)}}"><center>{{$students->first_name}}</center>
                                                            </a>
                                                            @endforeach 
                                                        </li>

                                                        <li class="p-20"></li>
                                                    </ul>
                                                </div>
                                            </div>
                                            <div class="chat-right-aside" style="border-width: ">
                                                <div class="chat-rbox" id="private" style="overflow-y:scroll; height:400px;">
                                                    <ul class="chat-list p-20" id="privatechat">
                                                    </ul>
                                                </div>
                                                <div class="b-t b-l" style="padding: 5px;">
                                                    <div class="row">
                                                        <div style="width: 70%; margin-left: 15px;">
                                                            <textarea id="privatemessage" class="form-control b-0" name ="privatemessage" rows="2" cols="90" placeholder="Type your message here"></textarea>
                                                        </div>
                                                        <div style="margin-left: auto;margin-right: 15px;">
                                                            <button type="button" id="sendprivate" class="btn btn-info btn-circle btn-sm"><i class="fa fa-paper-plane-o"></i></button>
                                                        </div>
                                                    </div>
                                                    <div>
                                                        <div class="col-8">
                                                            <input type="checkbox" id="checkboxs" class="system" name="checkboxs" value="1"/>
                                                            <label for="checkboxs">Send SMS also</label> 
                                                            <input type="checkbox" id="checkboxs" class="system" name="checkboxs" value="0"/>
                                                            <label for="checkboxs" hidden>Send SMS also</label>
                                                        </div>

                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>                    
            </div>
        </div>
    </div>

    <!-- ============================================================== -->
    <!-- End Container fluid  -->
    <!-- ============================================================== -->                    
    @endsection 


    @push('after-scripts')
    <script type="text/javascript">
      $('.check').on("click", function(e){
      $('.check').removeClass("active");
      $(this).addClass("active");
      });
      $('.open-panel').on("click", function(e){
      if ($('.chat-left-aside').hasClass("open-pnl"))
      {
      $('.chat-left-aside').removeClass("open-pnl");
      $('.ti-angle-right').removeClass("ti-angle-left");
      }
      else
      {
      $('.chat-left-aside').addClass("open-pnl");
      $('.ti-angle-right').addClass("ti-angle-left");
      }
      });
      var $last_chat_id = 0;
      $('.check').click(function(e)
      {
      e.preventDefault();
      document.getElementById('privatechat').innerHTML = '';
      displayChat();
      $last_chat_id = 0;
      });
      function displayChat() {
      var targetUrl = $('.check.active').attr('rels');
      //  setInterval(function() {
      $.ajax({
      url: targetUrl,
              type: 'get',
              dataType: 'json',
              success: function(privatechat)
              {
              var $len = privatechat.length;
              for (var i = $len - 1; i >= 0; i--)
              {
              $message = privatechat[i].message;
              //$date = privatechat[i].created_at; 
              $dates = privatechat[i].date;
              $first_name = privatechat[i].first_name;
              $sender = privatechat[i].sender;
              $msg_id = privatechat[i].id;
              if ($msg_id <= $last_chat_id)
              {
              continue;
              }
              else
              {
              if ($sender == {{$userid}})
                      document.getElementById('privatechat').innerHTML += '<li class="reverse" style="margin-top:10px;"><div class="chat-content"><h5>' + $first_name + '</h5><div class="box bg-light-inverse">' + $message + '</div></div><div class="chat-time" style="margin-right:10px; width:105px; text-align:right;">' + $dates + '</div></li>';
              else
                      document.getElementById('privatechat').innerHTML += '<li style="margin-top:10px;"><div class="chat-content"><h5>' + $first_name + '</h5><div class="box bg-light-info">' + $message + '</div></div><div class="chat-time" style="margin-left:10px; width:105px; text-align:left;">' + $dates + '</div></li>';
              $last_chat_id = $msg_id;
              var $text = $('#private');
              $text.scrollTop($text[0].scrollHeight);
              }

              }

              },
      });
      }

      setInterval(function(){
      if ($('.check.active').length != 0)
              displayChat();
      }, 5000);
      $("#privatemessage").keypress(function(event) {
      if (event.which == 13)
      {
      event.preventDefault();
      document.getElementById("sendprivate").click();
      }});
      $(document).ready(function() {

      $('#sendprivate').click(function(event)
      {
      event.preventDefault();
      var targetUrl = $('.check.active').attr('rel');
      var id = $('.check.active').attr('id');
      event.preventDefault();
      var privatemessage = $('#privatemessage').val();
      $('#privatemessage').val('');
      var batchid = $('#batchid').val();
      var sendsms = [];
      $('.system').each(function(){
      if ($(this).is(":checked"))
      {
      sendsms.push($(this).val());
      }
      });
      sendsms = sendsms.toString();
      $.ajax({
      url:targetUrl,
              method:"POST",
              data:{
              "_token": "{{ csrf_token() }}",
                      privatemessage:privatemessage,
                      batchid:batchid,
                      sendsms:sendsms,
              },
              dataType:"json",
              success:function(response)
              {
              document.getElementById(id).click();
              },
      });
      });
      });
      $("#message").keypress(function(event) {
      if (event.which == 13)
      {
      event.preventDefault();
      document.getElementById("sends").click();
      }

      });
      $(document).ready(function()
      {
      $('#sends').click(function()
      {
      event.preventDefault();
      var message = $('#message').val();
      $('#message').val('');
      var trainerid = $('#trainerid').val();
      var batchid = $('#batchid').val();
      var sendsms = [];
      $('.checks').each(function(){
      if ($(this).is(":checked"))
      {
      sendsms.push($(this).val());
      }
      });
      sendsms = sendsms.toString();
      $.ajax({
      url: '{{route("frontend.user.trainerchat.group.save")}}',
              method:"POST",
              data:{
              "_token": "{{ csrf_token() }}",
                      message:message,
                      trainerid:trainerid,
                      batchid:batchid,
                      sendsms:sendsms,
              },
              dataType:"json",
              success:function(response)
              {
              displayFromDatabase();
              },
      });
      });
      });
      $(document).ready(function () {
      displayFromDatabase();
      });
      var $last_msg_id = 0;
      function displayFromDatabase()
      {

      $.ajax({
      url: '{{route("frontend.user.classannouncements.get",$message->id)}}',
              type: 'get',
              dataType: 'json',
              success: function(groupchat)
              {
              var $len = groupchat.length;
              for (var i = $len - 1; i >= 0; i--)
              {
              $message = groupchat[i].message;
              $date = groupchat[i].created_at;
              $first_name = groupchat[i].first_name;
              $msg_id = groupchat[i].id;
              if ($msg_id <= $last_msg_id)
              {
              continue;
              }
              else
              {
              document.getElementById('chatgroup').innerHTML += '<li class="" style="margin-top:10px;"><div class="chat-content"><h5>' + $first_name + '</h5><div class="box bg-light-info">' + $message + '</div></div><div class="chat-time" style="margin-right:10px; width:105px; text-align:right;">' + $date + '</div></li>';
              $last_msg_id = $msg_id;
              }
              }
              var $text = $('#broadcast');
              $text.scrollTop($text[0].scrollHeight);
              //console.log($msg_id, $last_msg_id)

              },
      });
      }

    </script>
    @endpush 
