@extends('frontend.layouts.app')

@section('content')
<div class="row page-titles">
    <div class="col-md-5 align-self-center">
        <h3 class="text-themecolor">Track University Applications</h3>
    </div>
</div>

<!-- ============================================================== -->
<!-- Container fluid  -->
<!-- ============================================================== -->
<div class="container-fluid">

    <!-- ============================================================== -->
    <!-- Start Page Content -->
    <!-- ============================================================== -->
    <div class="row">
        <div class="col-12">
            <div class="card card-outline-info">
                <div class="card-header">
                    <h4 class="m-b-0 text-white">University Applications</h4>
                </div>
                <div class="card-body">                
                    @include('includes.partials.messages')
                    <div class="row m-b-10 border-bottom" style="font-size:1em;font-weight: bold;">
                        <div class="col-md-2 col-sm-12">
                            ID
                        </div>
                        <div class="col-md-4 col-sm-12">
                            Details
                        </div>
                        <div class="col-md-2 col-sm-12">
                            Status
                        </div>
                        <div class="col-md-2 col-sm-12">
                        </div>                        
                    </div>

                    @if (count($data))
                    @foreach ($data as $row)
                    <div class="row m-b-10 p-b-10 border-bottom">
                        <div class="col-md-2 col-sm-12">
                            {{ $row['appl_id'] }}
                        </div>
                        <div class="col-md-4 col-sm-12">
                            <span style="font-weight: bold;">{{ $row['country'] }}</span><br />
                        </div>   
                        <div class="col-md-2 col-sm-12">
                            {{ $row['status'] }}<br />
                        </div>                            
                        <div class="col-md-2 col-sm-12">
                            <button onclick="document.location ='{{ route('frontend.user.applications.detail', $row['id']) }}'" type="button" class="btn btn-secondary btn-rounded">Details <i class="fa fa-arrow-right"></i></button>
                        </div>                                
                    </div><!--row-->    
                    @endforeach
                    @else
                    <div class="row m-b-10">
                        <div class="col-md-12">
                            No University Applications Found   
                        </div>
                    </div>
                    @endif
                </div>
            </div>
        </div>
       
    </div>
</div>
<!-- ============================================================== -->
<!-- End Container fluid  -->
<!-- ============================================================== -->                    
@endsection