@extends('frontend.layouts.app')
@section('title'){{'Apply for Overseas'}}@endsection

<?php
$countries = get_study_countries();
?>
@section('content')
<div class="row page-titles">
    <div class="col-md-8 align-self-center">
        <h3 class="text-themecolor">Apply for Overseas</h3>
    </div>
</div>

<!-- ============================================================== -->
<!-- Container fluid  -->
<!-- ============================================================== -->
<div class="container-fluid">

    <!-- ============================================================== -->
    <!-- Start Page Content -->
    <!-- ============================================================== -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    @include('includes.partials.messages')
                    <!-- Nav tabs -->
                    <ul class="nav nav-tabs customtab2" role="tablist">
                        <li class="nav-item"> <a class="nav-link" href="{{route('frontend.user.studyabroad.profile')}}" role="tab"><span class="hidden-sm-up"><i class="ti-user"></i></span> <span class="hidden-xs-down">Profile</span></a> </li>
                        <li class="nav-item"> <a class="nav-link active" href="{{route('frontend.user.abroad_job.preference')}}" role="tab"><span class="hidden-sm-up"><i class="ti-book"></i></span> <span class="hidden-xs-down">Abroad Job Preferences</span></a> </li>
                        <li class="nav-item"> <a class="nav-link" href="{{route('frontend.user.abroad_job.documents')}}" role="tab"><span class="hidden-sm-up"><i class="ti-folder"></i></span> <span class="hidden-xs-down">Documents Upload</span></a> </li>
                    </ul>
                    <!-- Tab panes -->
                    <div class="tab-content">
                        <div class="tab-pane active" id="course" role="tabpanel">
                            <div class="p-t-20">
                                @if($profile_pending)
                                <div class="alert alert-danger" role="alert">
                                    Your must complete your profile details before you can fill this form.
                                </div>
                                @endif
                                @if(!$profile_pending && !$can_edit)
                                <div class="alert alert-success" role="alert">
                                    Your have completed this step.
                                </div>
                                @endif

                                <h6 class="card-subtitle">Choose Country preferences.</h6>
                                <form method="post" action="{{route('frontend.user.abroad_job.preference.save')}}">
                                    @csrf

                                    <div class="row m-t-20">
                                        <div class="col-md-12">
                                            <div class="card card-outline-info">
                                                <div class="card-header">
                                                    <h4 class="m-b-0 text-white">Country Details</h4>
                                                </div>
                                                <div class="card-body">
                                                    <div class="table-responsive">
                                                        <table>
                                                            <thead>
                                                                <tr>
                                                                    <th>Country</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>

                                                                @php
                                                                $i = 0;
                                                                @endphp

                                                                @foreach ($abroad_jobprefs as $abroad_jobpref)
                                                                <tr>
                                                                    <td style="padding:4px">
                                                                        <select class="form-control form-select" name="abroad_job[<?= $i ?>][country]" @if($i==0) required @endif>
                                                                            <option value=""></option>
                                                                            @foreach($countries as $country)
                                                                            <option value="{{$country}}" @if($country==$abroad_jobpref->country) selected @endif>{{$country}}</option>
                                                                            @endforeach
                                                                        </select>
                                                                    </td>
                                                                </tr>
                                                                @php
                                                                $i++;
                                                                @endphp
                                                                @endforeach

                                                                @for($j = $i; $j < 2; $j++) 
                                                                <tr>
                                                                    <td style="padding:4px">
                                                                        <select class="form-control" name="abroad_job[<?= $j ?>][country]" @if($j==0) required @endif>
                                                                            <option value=""></option>
                                                                            @foreach($countries as $country)
                                                                            <option value="{{$country}}">{{$country}}</option>
                                                                            @endforeach
                                                                        </select>
                                                                    </td>
                                                                </tr>
                                                                @endfor
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>

                                        </div>
                                    </div>
                                    <div class="mt-4 text-center">
                                        <button @if(!$can_edit) type="button" class="btn btn-secondary" style="cursor:no-drop;" disabled @else type="submit" class="btn btn-themecolor" @endif>Save & Continue</button>
                                    </div>

                                </form>
                            </div>
                        </div>


                    </div>

                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('after-scripts')
<script>
    $(document).ready(function() {
 
    });
</script>
@endpush