@extends('frontend.layouts.app')
@section('title'){{'Apply for Overseas'}}@endsection

<?php
$maxfilesize = config('app.doc_single_max_size') * 1024 * 1024;
$max_sop_files = config('app.max_sop_files');
$max_lor_files = config('app.max_lor_files');
$max_experience_files = config('app.max_experience_files');
$max_other_files = config('app.max_other_files');

$lor_files_left = $max_lor_files - get_lor_count(\Auth::user()->id);
$exp_files_left = $max_experience_files - get_exp_count(\Auth::user()->id);
$other_files_left = $max_other_files - get_other_count(\Auth::user()->id);
?>

@section('content')
<div class="row page-titles">
    <div class="col-md-8 align-self-center">
        <h3 class="text-themecolor">Apply for Overseas</h3>
    </div>
</div>

<!-- ============================================================== -->
<!-- Container fluid  -->
<!-- ============================================================== -->
<div class="container-fluid">

    <!-- ============================================================== -->
    <!-- Start Page Content -->
    <!-- ============================================================== -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    @include('includes.partials.messages')
                    <!-- Nav tabs -->
                    <ul class="nav nav-tabs customtab2" role="tablist">
                        <li class="nav-item"> <a class="nav-link" href="{{route('frontend.user.studyabroad.profile')}}" role="tab"><span class="hidden-sm-up"><i class="ti-user"></i></span> <span class="hidden-xs-down">Profile</span></a> </li>
                        <li class="nav-item"> <a class="nav-link" href="{{route('frontend.user.abroad_job.preference')}}" role="tab"><span class="hidden-sm-up"><i class="ti-book"></i></span> <span class="hidden-xs-down">Abroad Job Preferences</span></a> </li>
                        <li class="nav-item"> <a class="nav-link active" href="{{route('frontend.user.visa.documents')}}" role="tab"><span class="hidden-sm-up"><i class="ti-folder"></i></span> <span class="hidden-xs-down">Documents Upload</span></a> </li>
                    </ul>
                    <!-- Tab panes -->
                    <div class="tab-content">

                        <div class="tab-pane active" id="docs" role="tabpanel">
                            <div class="p-t-20">
                                @if($coursepref_pending)
                                <div class="alert alert-danger" role="alert">
                                    You must complete your profile & course preferences details before you can upload documents.
                                </div>
                                @endif
                                <!-- <h3>Academic Certificates & Other Documents</h3> -->
                                <p class="text-danger">Each individual file size must not exceed {{config('app.doc_single_max_size')}} MB. All semester merged file size must not exceed {{config('app.doc_allsem_max_size')}} MB.</p>
                                <h3>Academic, Language Certificates</h3>
                                <h6 class="card-subtitle">The following documents must be in pdf format. <img src="{{url('assets/images/icon/pdf-icon.png')}}" style="height:32px;"></h6>
                                <!-- <h6 class="card-subtitle">Upload academic certificates, SOP, CV & exerience documents.</h6> -->
                                @if(get_site_config('student_tenth_certificate'))
                                <div class="row">
                                    <div class="card card-outline-info col-md-6">
                                        <div class="card-header">
                                            <h4 class="m-b-0 text-white">10th Certificate</h4>
                                        </div>
                                        <div class="card-body">
                                            <div class="row">
                                                <div class="col-sm-12 col-md-12 p-b-20">
                                                    @if($class10)
                                                    <div>Uploaded File: <a class="small" href="<?php echo url('storage/' . $class10) ?>" target="_blank"><?php echo substr($class10, 5); ?></a></div>
                                                    <label>Replace File</label>
                                                    @endif
                                                    <form action="" method="post" enctype="multipart/form-data">
                                                        <input type="file" name="class10" id="file_tenth" class="form-control file_edu" accept=".pdf">
                                                        <span class="text-danger input-err"></span>
                                                    </form>
                                                    <span style="display:none;font-weight: 700;padding-left:0px!important;" id="tenth_loading" class="text-success p-3 loding"><b>Uploading...</b></span>

                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="card card-outline-info col-md-6">
                                        <div class="card-header">
                                            <h4 class="m-b-0 text-white">10th Marks Sheet/Transcript</h4>
                                        </div>
                                        <div class="card-body">
                                            <div class="row">
                                                <div class="col-sm-12 col-md-12 p-b-20">
                                                    @if($class10_marks_sheet)
                                                    <div>Uploaded File: <a class="small" href="<?php echo url('storage/' . $class10_marks_sheet) ?>" target="_blank"><?php echo substr($class10_marks_sheet, 5); ?></a></div>
                                                    <label>Replace File</label>
                                                    @endif
                                                    <form action="" method="post" enctype="multipart/form-data">
                                                        <input type="file" name="class10_marks_sheet" id="file_tenthMarkSheet" class="form-control file_edu" accept=".pdf">
                                                        <span class="text-danger input-err"></span>
                                                    </form>
                                                    <span style="display:none;font-weight: 700;padding-left:0px!important;" id="tenth_marksheet_loading" class="text-success p-3 loding"><b>Uploading...</b></span>

                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                @endif

                                @if(get_site_config('student_twelth_certificate'))
                                <div class="row">
                                    <div class="card card-outline-info col-md-6">
                                        <div class="card-header">
                                            <h4 class="m-b-0 text-white">12th Certificate</h4>
                                        </div>
                                        <div class="card-body">
                                            <div class="row">
                                                <div class="col-sm-12 col-md-12 p-b-20">
                                                    @if($class12)
                                                    <div>Uploaded File: <a class="small" href="<?php echo url('storage/' . $class12) ?>" target="_blank"><?php echo substr($class12, 5); ?></a></div>
                                                    <label>Replace File</label>
                                                    @endif
                                                    <form action="" method="post" enctype="multipart/form-data">
                                                        <input type="file" name="class12" id="input-file-now" class="form-control file_edu" accept=".pdf">
                                                        <span class="text-danger input-err"></span>
                                                    </form>
                                                    <span style="display:none;font-weight: 700;padding-left:0px!important;" id="tenth_marksheet_loading" class="text-success p-3 loding"><b>Uploading...</b></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card card-outline-info col-md-6">
                                        <div class="card-header">
                                            <h4 class="m-b-0 text-white">12th Marks Sheet/Transcript</h4>
                                        </div>
                                        <div class="card-body">
                                            <div class="row">
                                                <div class="col-sm-12 col-md-12 p-b-20">
                                                    @if($class12_marks_sheet)
                                                    <div>Uploaded File: <a class="small" href="<?php echo url('storage/' . $class12_marks_sheet) ?>" target="_blank"><?php echo substr($class12_marks_sheet, 5); ?></a></div>
                                                    <label>Replace File</label>
                                                    @endif

                                                    <form action="" method="post" enctype="multipart/form-data">
                                                        <input type="file" name="class12_marks_sheet" id="input-file-now" class="form-control file_edu" accept=".pdf">
                                                        <span class="text-danger input-err"></span>
                                                    </form>
                                                    <span style="display:none;font-weight: 700;padding-left:0px!important;" id="tenth_marksheet_loading" class="text-success p-3 loding"><b>Uploading...</b></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                @endif

                                @if(get_site_config('student_diploma'))
                                <div class="row">
                                    <div class="card card-outline-info col-md-6">
                                        <div class="card-header">
                                            <h4 class="m-b-0 text-white">Diploma Certificate</h4>
                                        </div>
                                        <div class="card-body">
                                            <div class="row">
                                                <div class="col-sm-12 col-md-12 p-b-20">
                                                    @if($diploma)
                                                    <div>Uploaded File: <a class="small" href="<?php echo url('storage/' . $diploma) ?>" target="_blank"><?php echo substr($diploma, 5); ?></a></div>
                                                    <label>Replace File</label>
                                                    @endif

                                                    <form action="" method="post" enctype="multipart/form-data">
                                                        <input type="file" name="diploma" id="input-file-now" class="form-control file_edu" accept=".pdf">
                                                        <span class="text-danger input-err"></span>
                                                    </form>
                                                    <span style="display:none;font-weight: 700;padding-left:0px!important;" id="tenth_marksheet_loading" class="text-success p-3 loding"><b>Uploading...</b></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card card-outline-info col-md-6">
                                        <div class="card-header">
                                            <h4 class="m-b-0 text-white">Diploma Marks Sheet/Transcript</h4>
                                        </div>
                                        <div class="card-body">
                                            <div class="row">
                                                <div class="col-sm-12 col-md-12 p-b-20">
                                                    @if($diploma_marks_sheet)
                                                    <div>Uploaded File: <a class="small" href="<?php echo url('storage/' . $diploma_marks_sheet) ?>" target="_blank"><?php echo substr($diploma_marks_sheet, 5); ?></a></div>
                                                    <label>Replace File</label>
                                                    @endif
                                                    <form action="" method="post" enctype="multipart/form-data">
                                                        <input type="file" name="diploma_marks_sheet" id="input-file-now" class="form-control file_edu" accept=".pdf">
                                                        <span class="text-danger input-err"></span>
                                                    </form>
                                                    <span style="display:none;font-weight: 700;padding-left:0px!important;" id="tenth_marksheet_loading" class="text-success p-3 loding"><b>Uploading...</b></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                @endif

                                @if(get_site_config('student_degree_completion'))
                                <div class="row">
                                    <div class="card card-outline-info col-md-6">
                                        <div class="card-header">
                                            <h4 class="m-b-0 text-white">Bachelors Certificate</h4>
                                        </div>
                                        <div class="card-body">
                                            <div class="row">
                                                <div class="col-sm-12 col-md-12 p-b-20">
                                                    @if($grad_degree)
                                                    <div>Uploaded File: <a class="small" href="<?php echo url('storage/' . $grad_degree) ?>" target="_blank"><?php echo substr($grad_degree, 5); ?></a></div>
                                                    <label>Replace File</label>
                                                    @endif
                                                    <form action="" method="post" enctype="multipart/form-data">
                                                        <input type="file" name="grad_degree" id="input-file-now" class="form-control file_edu" accept=".pdf">
                                                        <span class="text-danger input-err"></span>
                                                    </form>
                                                    <span style="display:none;font-weight: 700;padding-left:0px!important;" id="tenth_marksheet_loading" class="text-success p-3 loding"><b>Uploading...</b></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card card-outline-info col-md-6">
                                        <div class="card-header">
                                            <h4 class="m-b-0 text-white">Bachelors Marks Sheet/Transcripts</h4>
                                        </div>
                                        <div class="card-body">
                                            <div class="row">
                                                <div class="col-sm-12 col-md-12 p-b-20">
                                                    @if($grad_transcripts)
                                                    <div>Uploaded File: <a class="small" href="<?php echo url('storage/' . $grad_transcripts) ?>" target="_blank"><?php echo substr($grad_transcripts, 5); ?></a></div>
                                                    <label>Replace File</label>
                                                    @endif
                                                    <form action="" method="post" enctype="multipart/form-data">
                                                        <input type="file" name="grad_transcripts" id="input-file-now" class="form-control file_edu" accept=".pdf">
                                                        <span class="text-danger input-err"></span>
                                                    </form>
                                                    <span style="display:none;font-weight: 700;padding-left:0px!important;" id="tenth_marksheet_loading" class="text-success p-3 loding"><b>Uploading...</b></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                @endif

                                @if(get_site_config('student_bachelors'))
                                <div class="row">
                                    <div class="card card-outline-info col-md-12">
                                        <div class="card-header">
                                            <h4 class="m-b-0 text-white">Bachelors All Semesters Marks Sheet/Transcripts (Single PDF)</h4>
                                        </div>
                                        <div class="card-body">
                                            <div class="row">
                                                <div class="col-sm-12 col-md-6 p-b-20">
                                                    @if($grad_all_sem)
                                                    <div>Uploaded File: <a class="small" href="<?php echo url('storage/' . $grad_all_sem) ?>" target="_blank"><?php echo substr($grad_all_sem, 5); ?></a></div>
                                                    <label>Replace File</label>
                                                    @endif
                                                    <form action="" method="post" enctype="multipart/form-data">
                                                        <input type="file" name="grad_all_sem" id="input-file-now" class="form-control file_edu" accept=".pdf">
                                                        <span class="text-danger input-err"></span>
                                                    </form>
                                                    <span style="display:none;font-weight: 700;padding-left:0px!important;" id="tenth_marksheet_loading" class="text-success p-3 loding"><b>Uploading...</b></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                @endif

                                @if(get_site_config('student_masters_completion'))
                                <div class="row">
                                    <div class="card card-outline-info col-md-6">
                                        <div class="card-header">
                                            <h4 class="m-b-0 text-white">Masters Certificate</h4>
                                        </div>
                                        <div class="card-body">
                                            <div class="row">
                                                <div class="col-sm-12 col-md-12 p-b-20">
                                                    @if($pg_degree)
                                                    <div>Uploaded File: <a class="small" href="<?php echo url('storage/' . $pg_degree) ?>" target="_blank"><?php echo substr($pg_degree, 5); ?></a></div>
                                                    <label>Replace File</label>
                                                    @endif
                                                    <form action="" method="post" enctype="multipart/form-data">
                                                        <input type="file" name="pg_degree" id="input-file-now" class="form-control file_edu" accept=".pdf">
                                                        <span class="text-danger input-err"></span>
                                                    </form>
                                                    <span style="display:none;font-weight: 700;padding-left:0px!important;" id="tenth_marksheet_loading" class="text-success p-3 loding"><b>Uploading...</b></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card card-outline-info col-md-6">
                                        <div class="card-header">
                                            <h4 class="m-b-0 text-white">Masters Marks Sheet/Transcripts</h4>
                                        </div>
                                        <div class="card-body">
                                            <div class="row">
                                                <div class="col-sm-12 col-md-12 p-b-20">
                                                    @if($pg_transcripts)
                                                    <div>Uploaded File: <a class="small" href="<?php echo url('storage/' . $pg_transcripts) ?>" target="_blank"><?php echo substr($pg_transcripts, 5); ?></a></div>
                                                    <label>Replace File</label>
                                                    @endif
                                                    <form action="" method="post" enctype="multipart/form-data">
                                                        <input type="file" name="pg_transcripts" id="input-file-now" class="form-control file_edu" accept=".pdf">
                                                        <span class="text-danger input-err"></span>
                                                    </form>
                                                    <span style="display:none;font-weight: 700;padding-left:0px!important;" id="tenth_marksheet_loading" class="text-success p-3 loding"><b>Uploading...</b></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                @endif

                                @if(get_site_config('student_masters_all_semesters'))
                                <div class="row">
                                    <div class="card card-outline-info col-md-12">
                                        <div class="card-header">
                                            <h4 class="m-b-0 text-white">Masters All Semesters Marks Sheet/Transcripts (Single PDF)</h4>
                                        </div>
                                        <div class="card-body">
                                            <div class="row">
                                                <div class="col-sm-12 col-md-6 p-b-20">
                                                    @if($pg_all_sem)
                                                    <div>Uploaded File: <a class="small" href="<?php echo url('storage/' . $pg_all_sem) ?>" target="_blank"><?php echo substr($pg_all_sem, 5); ?></a></div><label>Replace File</label>
                                                    @endif
                                                    <form action="" method="post" enctype="multipart/form-data">
                                                        <input type="file" name="pg_all_sem" id="input-file-now" class="form-control file_edu" accept=".pdf">
                                                        <span class="text-danger input-err"></span>
                                                    </form>
                                                    <span style="display:none;font-weight: 700;padding-left:0px!important;" id="tenth_marksheet_loading" class="text-success p-3 loding"><b>Uploading...</b></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                @endif
                            </div>
                        </div>
                        <h3>Tests/English Certificates</h3>
                        <h6 class="card-subtitle">Upload all applicable certificates. The documents must be in pdf format. <img src="{{url('assets/images/icon/pdf-icon.png')}}" style="height:32px;"></h6>
                        <div class="row">
                            <div class="card card-outline-info col-md-6">
                                <div class="card-header">
                                    <h4 class="m-b-0 text-white">IELTS</h4>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-sm-12 col-md-12 p-b-20">
                                            @if($lang_ielts)
                                            <div>Uploaded File: <a class="small" href="<?php echo url('storage/' . $lang_ielts) ?>" target="_blank"><?php echo substr($lang_ielts, 5); ?></a></div><label>Replace File</label>
                                            @endif
                                            <form action="" method="post" enctype="multipart/form-data">
                                                <input type="file" name="lang_ielts" id="input-file-now" class="form-control file_edu" accept=".pdf">
                                                <span class="text-danger input-err"></span>
                                            </form>
                                            <span style="display:none;font-weight: 700;padding-left:0px!important;" id="tenth_marksheet_loading" class="text-success p-3 loding"><b>Uploading...</b></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="card card-outline-info col-md-6">
                                <div class="card-header">
                                    <h4 class="m-b-0 text-white">PTE</h4>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-sm-12 col-md-12 p-b-20">
                                            @if($lang_pte)
                                            <div>Uploaded File: <a class="small" href="<?php echo url('storage/' . $lang_pte) ?>" target="_blank"><?php echo substr($lang_pte, 5); ?></a></div><label>Replace File</label>
                                            @endif
                                            <form action="" method="post" enctype="multipart/form-data">
                                                <input type="file" name="lang_pte" id="input-file-now" class="form-control file_edu" accept=".pdf">
                                                <span class="text-danger input-err"></span>
                                            </form>
                                            <span style="display:none;font-weight: 700;padding-left:0px!important;" id="tenth_marksheet_loading" class="text-success p-3 loding"><b>Uploading...</b></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="card card-outline-info col-md-6">
                                <div class="card-header">
                                    <h4 class="m-b-0 text-white">GRE</h4>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-sm-12 col-md-12 p-b-20">
                                            @if($gre)
                                            <div>Uploaded File: <a class="small" href="<?php echo url('storage/' . $gre) ?>" target="_blank"><?php echo substr($gre, 5); ?></a></div><label>Replace File</label>
                                            @endif
                                            <form action="" method="post" enctype="multipart/form-data">
                                                <input type="file" name="gre" id="input-file-now" class="form-control file_edu" accept=".pdf">
                                                <span class="text-danger input-err"></span>
                                            </form>
                                            <span style="display:none;font-weight: 700;padding-left:0px!important;" id="tenth_marksheet_loading" class="text-success p-3 loding"><b>Uploading...</b></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="card card-outline-info col-md-6">
                                <div class="card-header">
                                    <h4 class="m-b-0 text-white">GMAT</h4>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-sm-12 col-md-12 p-b-20">
                                            @if($gmat)
                                            <div>Uploaded File: <a class="small" href="<?php echo url('storage/' . $gmat) ?>" target="_blank"><?php echo substr($gmat, 5); ?></a></div><label>Replace File</label>
                                            @endif
                                            <form action="" method="post" enctype="multipart/form-data">
                                                <input type="file" name="gmat" id="input-file-now" class="form-control file_edu" accept=".pdf">
                                                <span class="text-danger input-err"></span>
                                            </form>
                                            <span style="display:none;font-weight: 700;padding-left:0px!important;" id="tenth_marksheet_loading" class="text-success p-3 loding"><b>Uploading...</b></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <h3>CV, Passport, SOP, LOR, Experience Letters</h3>
                        <div class="row">
                            <div class="card card-outline-info m-t-10 col-md-12">
                                <div class="card-header">
                                    <h4 class="m-b-0 text-white">CV</h4>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-12">
                                            @if(get_site_config('sample_cv'))
                                            <a class="btn btn-secondary btn-xs" href="{{url('storage/'.get_site_config('sample_cv'))}}" target="_blank">Download Sample CV <i class="fa fa-download"></i></a><br>
                                            @endif
                                            <br />
                                            @if($cv)
                                            <div>Uploaded File: <a class="small" href="<?php echo url('storage/' . $cv) ?>" target="_blank"><?php echo substr($cv, 5); ?></a></div><label>Replace File</label>
                                            @endif
                                        </div>
                                        <div class="col-6">
                                            <form action="" method="post" enctype="multipart/form-data">
                                                <input class="form-control" id="file_cv" accept=".doc,.docx" type="file" name="file">
                                                <span class="text-danger input-err"></span>
                                            </form>
                                            <span style="display:none;font-weight: 700;padding-left:0px!important;" id="cv_loading" class="text-success p-3"><b>Uploading...</b></span>
                                            <span id="cv-file-input-error" class="text-danger"></span>
                                            <h6 class="card-subtitle mt-2" style="margin-bottom:2px;">This document must be in Word format(.docx, .doc) <img src="{{url('assets/images/icon/word-icon.png')}}" style="height:28px;"></h6>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="card card-outline-info m-t-30">
                            <div class="card-header">
                                <h4 class="m-b-0 text-white">SOP</h4>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-12">
                                        @if(get_site_config('sample_sop'))
                                        <label>If you want to know how to write an SOP, download the sample SOP.</label>
                                        <a class="btn btn-secondary btn-xs" href="{{url('storage/'.get_site_config('sample_sop'))}}" target="_blank">Download Sample SOP <i class="fa fa-download"></i></a>
                                        @endif
                                        <br />
                                        @if(count($sops)>0)
                                        <div class="row">
                                            <div class="col-12">
                                                Uploaded Files:<br>
                                                <span id="ref_sop">
                                                    @foreach($sops as $sop)
                                                    <a class="small" href="<?php echo url('storage/' . $sop->file) ?>" target="_blank"><?php echo substr($sop->file, 5); ?></a>
                                                    <br>
                                                    @endforeach
                                                </span>
                                            </div>
                                        </div>
                                        @endif
                                        <div class="row">
                                            <div class="col-12">
                                                <form action="" method="post" enctype="multipart/form-data">
                                                    <input class="form-control" id="file_sop" accept=".doc,.docx" type="file" name="file">
                                                </form>
                                                <span style="display:none;" id="sop_loading" class="text-success p-3"><b>Uploading...</b></span>
                                                <span id="sop-file-input-error" class="text-danger"></span>
                                                <h6 class="card-subtitle mt-2" style="margin-bottom:2px;">This document must be in Word format(.docx, .doc) <img src="{{url('assets/images/icon/word-icon.png')}}" style="height:28px;"></h6>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="card card-outline-info col-md-6">
                                <div class="card-header">
                                    <h4 class="m-b-0 text-white">Letter of Recommendation (LOR)</h4>
                                </div>
                                <div class="card-body">
                                    @if(count($lors)>0)
                                    <div class="row">
                                        <div class="col-12">
                                            Uploaded Files:<br>
                                            <span id="ref_lor">
                                                @foreach($lors as $lor)
                                                <a class="small" href="<?php echo url('storage/' . $lor->file) ?>" target="_blank"><?php echo substr($lor->file, 5); ?></a>
                                                <a title="delete document" data-lor="{{$lor->id}}" href="javascript:void(0)" class="cross del-lor-btn ml-1"></a>
                                                <br>
                                                @endforeach
                                            </span>
                                        </div>
                                    </div>
                                    @endif
                                    <div class="row">
                                        <div class="col-12">
                                            <form action="" method="post" enctype="multipart/form-data">
                                                <input type="file" id="file_lor" class="form-control" name="file_lor[]" multiple accept="application/pdf">
                                            </form>
                                            <span style="display:none;" id="lor_loading" class="text-success p-3"><b>Uploading...</b></span>
                                            <span id="lor-file-input-error" class="text-danger"></span>
                                        </div>
                                        <div class="col-12">
                                            <h6 class="card-subtitle mt-2 mb-0"><img src="{{url('assets/images/icon/pdf-icon.png')}}" style="height:24px;"></h6>
                                            <small>Maximum <?= $max_lor_files ?> files.</small>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="card card-outline-info col-md-6">
                                <div class="card-header">
                                    <h4 class="m-b-0 text-white">Experience Certificates</h4>
                                </div>
                                <div class="card-body">
                                    @if(count($experience)>0)
                                    <div class="row">
                                        <div class="col-12">
                                            Uploaded Files:<br>
                                            @foreach($experience as $exp)
                                            <a class="small" href="<?php echo url('storage/' . $exp->file) ?>" target="_blank"><?php echo substr($exp->file, 5); ?></a>
                                            <a title="delete document" data-exp="{{$exp->id}}" href="javascript:void(0)" class="cross del-exp-btn ml-1"></a>
                                            <br>
                                            @endforeach
                                        </div>
                                    </div>
                                    @endif
                                    <div class="row">
                                        <div class="col-12">
                                            <form action="" method="post" enctype="multipart/form-data">
                                                <input class="form-control" type="file" id="file_exp" name="file_exp[]" multiple accept="application/pdf">
                                            </form>
                                            <span style="display:none;" id="file_exp_loading" class="text-success p-3"><b>Uploading...</b></span>
                                            <span id="file-exp-file-input-error" class="text-danger"></span>
                                        </div>
                                        <div class="col-12">
                                            <h6 class="card-subtitle mt-2 mb-0"><img src="{{url('assets/images/icon/pdf-icon.png')}}" style="height:24px;"></h6>
                                            <small>Maximum <?= $max_experience_files ?> files.</small>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>

                        <div class="row">
                            <div class="card card-outline-info col-md-6">
                                <div class="card-header">
                                    <h4 class="m-b-0 text-white">Passport</h4>
                                </div>
                                <div class="card-body">
                                    <div class="row p-t-10">
                                        <div class="col-12">
                                            @if($passport)
                                            <div>Uploaded File: <a class="small" href="<?php echo url('storage/' . $passport) ?>" target="_blank"><?php echo substr($passport, 5); ?></a></div><label>Replace File</label>
                                            @endif
                                        </div>
                                        <div class="col-12">
                                            <form action="" method="post" enctype="multipart/form-data">
                                                <input class="form-control" id="file_passport" accept=".pdf" type="file" name="file">
                                                <span class="text-danger input-err"></span>
                                            </form>
                                            <span style="display:none;font-weight: 700;padding-left:0px!important;" id="passport_loading" class="text-success p-3"><b>Uploading...</b></span>
                                            <span id="passport-file-input-error" class="text-danger"></span>
                                        </div>
                                        <div class="col-12">
                                            <h6 class="card-subtitle mt-2 mb-0"><img src="{{url('assets/images/icon/pdf-icon.png')}}" style="height:24px;"></h6>
                                        </div>
                                    </div>

                                </div>
                            </div>
                            <div class="card card-outline-info col-md-6">
                                <div class="card-header">
                                    <h4 class="m-b-0 text-white">Other Certificates</h4>
                                </div>
                                <div class="card-body">
                                    <div class="row p-t-10">
                                        <div class="col-12">
                                            @if(count($otherdocs))
                                            Uploaded Files:<br>
                                            @foreach($otherdocs as $otherdoc)
                                            <a class="small" href="<?php echo url('storage/' . $otherdoc->file) ?>" target="_blank"><?php echo substr($otherdoc->file, 5); ?></a>
                                            <a title="delete document" data-other="{{$otherdoc->id}}" href="javascript:void(0)" class="cross del-other-btn ml-1"></a>
                                            <br>
                                            @endforeach
                                            @endif

                                            <form action="" method="post" enctype="multipart/form-data">
                                                <input class="form-control" type="file" id="file_other" name="file_other[]" multiple accept="application/pdf">
                                            </form>
                                            <span style="display:none;" id="file_other_loading" class="text-success p-3"><b>Uploading...</b></span>
                                            <span id="file-other-file-input-error" class="text-danger"></span>

                                            <h6 class="card-subtitle mt-2 mb-0"><img src="{{url('assets/images/icon/pdf-icon.png')}}" style="height:24px;"></h6>
                                            <small>Maximum <?= $max_other_files ?> files.</small>

                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>

                        <form id="submitApplForm" method="post" action="{{route('frontend.user.visa.documents.submitapplication')}}">
                            @csrf
                            <input type="hidden" name="terms" value="1">

                            <div class="mt-4 text-center">
                                @if($can_edit)
                                <button type="button" class="btn btn-themecolor" id="submitBtn">Submit Application</button>
                                @else
                                <button type="button" class="btn btn-secondary" style="cursor:no-drop;" disabled>Submit Application</button>
                                @if(!$coursepref_pending && $logged_in_user->application_submit_date)
                                <div><span class="badge badge-success">You have submitted application on {{date("j M, Y")}}</span></div>
                                @endif
                                @endif
                            </div>
                        </form>
                    </div>
                </div>

            </div>

        </div>
    </div>
</div>
</div>
</div>
@endsection

@push('after-styles')
<!-- <link rel="stylesheet" href="{{ asset('assets/plugins/dropzone-master/dist/dropzone.css') }}"> -->
<link href="{{ asset('assets/plugins/toast-master/css/jquery.toast.css') }}" rel="stylesheet">
<link href="{{ asset('assets/plugins/sweetalert/sweetalert.css') }}" rel="stylesheet" type="text/css">
<style>
    .cross {
        display: inline-block;
        box-sizing: border-box;
        width: 12px;
        height: 12px;
        border-width: 3px;
        border-style: solid;
        border-color: red;
        border-radius: 100%;
        background: -webkit-linear-gradient(-45deg, transparent 0%, transparent 46%, white 46%, white 56%, transparent 56%, transparent 100%), -webkit-linear-gradient(45deg, transparent 0%, transparent 46%, white 46%, white 56%, transparent 56%, transparent 100%);
        background-color: red;
        transition: all 0.3s ease;
    }
</style>
@endpush
@push('after-scripts')
<!-- <script src="{{ asset('assets/plugins/dropzone-master/dist/dropzone.js') }}"></script> -->
<script src="{{ asset('assets/plugins/toast-master/js/jquery.toast.js') }}"></script>
<script src="{{ asset('assets/plugins/sweetalert/sweetalert.min.js') }}"></script>
<script>
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });

    $('.file_edu').change(function(e) {
        e.preventDefault();
        $(this).closest('div').find('.loding').show();
        var formData = new FormData();
        var file = $(this).prop('files')[0];
        var type = $(this).attr('name');
        formData.append('type', type);
        formData.append('file', file);
        $(this).closest('div').find('.input-err').text('');
        $.ajax({
            type: 'POST',
            url: "{{ route('frontend.user.studyabroad.documents.save') }}",
            data: formData,
            contentType: false,
            processData: false,
            context: this,
            success: function(data) {
                $(this).closest('div').find('.loding').hide();
                if (data.res == 'success') {
                    $(this).val('');
                    console.log(data);
                    $.toast({
                        heading: 'Success',
                        text: data.message,
                        position: 'top-right',
                        loaderBg: '#ff6849',
                        icon: 'success',
                        hideAfter: 1000,
                        stack: 6
                    });
                    location.reload();
                } else {
                    $(this).closest('div').find('.loding').hide();
                    $(this).closest('div').find('.input-err').text(data.message);
                }
            },
            error: function(response) {
                $(this).closest('div').find('.loding').hide();
                $(this).closest('div').find('.input-err').text(response.responseJSON.message);
            }
        });
    });

    $('#file_cv').change(function(e) {
        e.preventDefault();
        $('#cv_loading').show();
        var formData = new FormData();
        var file = $('#file_cv').prop('files')[0];
        formData.append('file', file);
        $('#cv-file-input-error').text('');
        $.ajax({
            type: 'POST',
            url: "{{ route('frontend.user.studyabroad.documents.cv.upload') }}",
            data: formData,
            contentType: false,
            processData: false,
            success: function(data) {
                $('#cv_loading').hide();
                if (data == 'success') {
                    $('#file_cv').val('');
                    console.log(data);
                    $.toast({
                        heading: 'Success',
                        text: 'CV has been uploaded successfully',
                        position: 'top-right',
                        loaderBg: '#ff6849',
                        icon: 'success',
                        hideAfter: 1000,
                        stack: 6
                    });
                    location.reload();
                }
            },
            error: function(response) {
                $('#cv_loading').hide();
                $('#cv-file-input-error').text(response.responseJSON.message);
            }
        });
    });

    $('#file_passport').change(function(e) {
        e.preventDefault();
        $('#passport_loading').show();
        var formData = new FormData();
        var file = $('#file_passport').prop('files')[0];
        formData.append('file', file);
        $('#passport-file-input-error').text('');
        $.ajax({
            type: 'POST',
            url: "{{ route('frontend.user.studyabroad.documents.passport.upload') }}",
            data: formData,
            contentType: false,
            processData: false,
            success: function(data) {
                $('#passport_loading').hide();
                if (data == 'success') {
                    $('#file_passport').val('');
                    console.log(data);
                    $.toast({
                        heading: 'Success',
                        text: 'Passport has been uploaded successfully',
                        position: 'top-right',
                        loaderBg: '#ff6849',
                        icon: 'success',
                        hideAfter: 1000,
                        stack: 6
                    });
                    location.reload();
                }
            },
            error: function(response) {
                $('#passport_loading').hide();
                $('#passport-file-input-error').text(response.responseJSON.message);
            }
        });
    });

    $('#file_lor').change(function(e) {
        e.preventDefault();
        $('#lor_loading').show();

        var formData = new FormData();

        var files = $('#file_lor')[0].files;
        console.log(files.length);
        var files_left = <?= $lor_files_left ?>;

        if (files.length > files_left) {
            $('#lor_loading').hide();
            if (files_left == 0) {
                $.toast({
                    heading: 'Warning',
                    text: 'You cannot upload more documents.',
                    position: 'top-right',
                    loaderBg: '#ff6849',
                    icon: 'warning',
                    hideAfter: 4000,
                    stack: 6
                });
            } else {
                $.toast({
                    heading: 'Warning',
                    text: 'You cannot upload more than ' + files_left + ' documents.',
                    position: 'top-right',
                    loaderBg: '#ff6849',
                    icon: 'warning',
                    hideAfter: 4000,
                    stack: 6
                });
            }
        } else {

            for (var i = 0; i < files.length; i++) {
                formData.append("files[]", files[i], files[i]['name']);
            }

            $('#lor-file-input-error').text('');
            $.ajax({
                type: 'POST',
                url: "{{ route('frontend.user.studyabroad.documents.lor.upload') }}",
                data: formData,
                contentType: false,
                processData: false,
                success: function(data) {
                    $('#lor_loading').hide();
                    if (data == 'success') {
                        $('#file_lor').val('');
                        console.log(data);
                        $.toast({
                            heading: 'Success',
                            text: 'LOR has been uploaded successfully',
                            position: 'top-right',
                            loaderBg: '#ff6849',
                            icon: 'success',
                            hideAfter: 1000,
                            stack: 6
                        });
                        location.reload();
                        // $("#ref_lor").load(location.href + " #ref_lor");
                    }
                    if (data == 'error') {
                        $('#file_lor').val('');
                        console.log(data);
                        $('#lor-file-input-error').text('Something went wrong');
                    }
                },
                error: function(response) {
                    $('#lor_loading').hide();
                    $('#lor-file-input-error').text(response.responseJSON.message);
                }
            });
        }
    });

    $('#file_exp').change(function(e) {
        e.preventDefault();
        $('#file_exp_loading').show();

        var formData = new FormData();

        var files = $('#file_exp')[0].files;
        console.log(files.length);

        var exp_files_left = <?= $exp_files_left ?>;

        if (files.length > exp_files_left) {
            $('#file_exp_loading').hide();
            if (exp_files_left == 0) {
                $.toast({
                    heading: 'Warning',
                    text: 'You cannot upload more documents.',
                    position: 'top-right',
                    loaderBg: '#ff6849',
                    icon: 'warning',
                    hideAfter: 4000,
                    stack: 6
                });
            } else {
                $.toast({
                    heading: 'Warning',
                    text: 'You cannot upload more than ' + exp_files_left + ' documents.',
                    position: 'top-right',
                    loaderBg: '#ff6849',
                    icon: 'warning',
                    hideAfter: 4000,
                    stack: 6
                });
            }
        } else {
            for (var i = 0; i < files.length; i++) {
                formData.append("files[]", files[i], files[i]['name']);
            }
            $('#file-exp-file-input-error').text('');
            $.ajax({
                type: 'POST',
                url: "{{ route('frontend.user.studyabroad.documents.experience.upload') }}",
                data: formData,
                contentType: false,
                processData: false,
                success: function(data) {
                    $('#file_exp_loading').hide();
                    if (data == 'success') {
                        $('#file_exp').val('');
                        console.log(data);
                        $.toast({
                            heading: 'Success',
                            text: 'Work Experience Letter has been uploaded successfully',
                            position: 'top-right',
                            loaderBg: '#ff6849',
                            icon: 'success',
                            hideAfter: 1000,
                            stack: 6
                        });
                        location.reload();
                    }
                    if (data == 'error') {
                        $('#file_exp').val('');
                        console.log(data);
                        $('#file-exp-file-input-error').text('Something went wrong');
                    }
                },
                error: function(response) {
                    $('#file_exp_loading').hide();
                    $('#file-exp-file-input-error').text(response.responseJSON.message);
                }
            });
        }
    });


    $('#file_other').change(function(e) {
        e.preventDefault();
        $('#file_other_loading').show();

        var formData = new FormData();

        var files = $('#file_other')[0].files;
        console.log(files.length);

        var other_files_left = <?= $other_files_left ?>;

        if (files.length > other_files_left) {
            $('#file_other_loading').hide();
            if (other_files_left == 0) {
                $.toast({
                    heading: 'Warning',
                    text: 'You cannot upload more documents.',
                    position: 'top-right',
                    loaderBg: '#ff6849',
                    icon: 'warning',
                    hideAfter: 4000,
                    stack: 6
                });
            } else {
                $.toast({
                    heading: 'Warning',
                    text: 'You cannot upload more than ' + other_files_left + ' documents.',
                    position: 'top-right',
                    loaderBg: '#ff6849',
                    icon: 'warning',
                    hideAfter: 4000,
                    stack: 6
                });
            }
        } else {
            for (var i = 0; i < files.length; i++) {
                formData.append("files[]", files[i], files[i]['name']);
            }
            $('#file-other-file-input-error').text('');
            $.ajax({
                type: 'POST',
                url: "{{ route('frontend.user.studyabroad.documents.other.upload') }}",
                data: formData,
                contentType: false,
                processData: false,
                success: function(data) {
                    $('#file_other_loading').hide();
                    if (data == 'success') {
                        $('#file_other').val('');
                        console.log(data);
                        $.toast({
                            heading: 'Success',
                            text: 'Other Certificate has been uploaded successfully',
                            position: 'top-right',
                            loaderBg: '#ff6849',
                            icon: 'success',
                            hideAfter: 1000,
                            stack: 6
                        });
                        location.reload();
                    }
                    if (data == 'error') {
                        $('#file_other').val('');
                        console.log(data);
                        $('#file-other-file-input-error').text('Something went wrong');
                    }
                },
                error: function(response) {
                    $('#file_other_loading').hide();
                    $('#file-other-file-input-error').text(response.responseJSON.message);
                }
            });
        }
    });
    

    $('#file_sop').change(function(e) {
        e.preventDefault();
        $('#sop_loading').show();
        var formData = new FormData();
        var file = $('#file_sop').prop('files')[0];
        formData.append('file', file);
        formData.append('course_pref_id', 0);
        $('#sop-file-input-error').text('');
        $.ajax({
            type: 'POST',
            url: "{{ route('frontend.user.studyabroad.documents.sop.upload') }}",
            data: formData,
            contentType: false,
            processData: false,
            success: function(data) {
                $('#sop_loading').hide();
                if (data == 'success') {
                    $('#file_sop').val('');
                    console.log(data);
                    $.toast({
                        heading: 'Success',
                        text: 'SOP has been uploaded successfully',
                        position: 'top-right',
                        loaderBg: '#ff6849',
                        icon: 'success',
                        hideAfter: 1000,
                        stack: 6
                    });
                    location.reload();
                }
            },
            error: function(response) {
                $('#sop_loading').hide();
                $('#sop-file-input-error').text(response.responseJSON.message);
            }
        });
    });



    $(".del-lor-btn").on("click", function() {
        var lor_id = $(this).data('lor');
        swal({
            title: "Are you sure?",
            text: "Do you want to delete?",
            type: "warning",
            showCancelButton: true,
            confirmButtonColor: "#DD6B55",
            confirmButtonText: "Yes, delete it!",
            closeOnConfirm: true
        }, function() {
            $.ajax({
                url: "{{route('frontend.user.studyabroad.documents.lor.delete')}}",
                type: "POST",
                data: {
                    lor_id: lor_id,
                    _token: '{{csrf_token()}}'
                },
                context: this,
                success: function(result) {
                    $.toast({
                        heading: 'Deleted',
                        text: result.message,
                        position: 'top-right',
                        loaderBg: '#ff6849',
                        icon: 'success',
                        hideAfter: 1000,
                        stack: 6
                    });
                    location.reload();
                    // $("#ref_lor").load(location.href + " #ref_lor");
                }
            });
        });

    });

    $(".del-exp-btn").on("click", function() {
        var exp_id = $(this).data('exp');
        swal({
            title: "Are you sure?",
            text: "Do you want to delete?",
            type: "warning",
            showCancelButton: true,
            confirmButtonColor: "#DD6B55",
            confirmButtonText: "Yes, delete it!",
            closeOnConfirm: true
        }, function() {
            $.ajax({
                url: "{{route('frontend.user.studyabroad.documents.exp.delete')}}",
                type: "POST",
                data: {
                    exp_id: exp_id,
                    _token: '{{csrf_token()}}'
                },
                context: this,
                success: function(result) {
                    $.toast({
                        heading: 'Deleted',
                        text: result.message,
                        position: 'top-right',
                        loaderBg: '#ff6849',
                        icon: 'success',
                        hideAfter: 1000,
                        stack: 6
                    });
                    location.reload();
                    // $("#ref_lor").load(location.href + " #ref_lor");
                }
            });
        });
    });
    $(".del-other-btn").on("click", function() {
        var other_id = $(this).data('other');
        swal({
            title: "Are you sure?",
            text: "Do you want to delete?",
            type: "warning",
            showCancelButton: true,
            confirmButtonColor: "#DD6B55",
            confirmButtonText: "Yes, delete it!",
            closeOnConfirm: true
        }, function() {
            $.ajax({
                url: "{{route('frontend.user.studyabroad.documents.other.delete')}}",
                type: "POST",
                data: {
                    other_id: other_id,
                    _token: '{{csrf_token()}}'
                },
                context: this,
                success: function(result) {
                    $.toast({
                        heading: 'Deleted',
                        text: result.message,
                        position: 'top-right',
                        loaderBg: '#ff6849',
                        icon: 'success',
                        hideAfter: 1000,
                        stack: 6
                    });
                    location.reload();
                    // $("#ref_lor").load(location.href + " #ref_lor");
                }
            });
        });
    });


    $(document).ready(function() {
        $("#submitBtn").click(function() {
            // if (!$('#terms').prop("checked")) {
            //     alert("You must accept the terms & conditions to proceed!");
            // } else {
                $("#submitApplForm").submit();
            //}
        });
    });
</script>
@endpush